/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.InvalidUserDataException;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Path
implements Comparable<Path> {
    private static final Comparator<String> STRING_COMPARATOR = GUtil.caseInsensitive();
    private final String[] segments;
    private final boolean absolute;
    private final String fullPath;
    public static final Path ROOT = new Path(":");

    private Path(String path) {
        this(StringUtils.split((String)path, (String)":"), path.startsWith(":"), path.length() > 1 && path.endsWith(":") ? path.substring(0, path.length() - 1) : path);
    }

    private Path(String[] segments, boolean absolute) {
        this(segments, absolute, Path.createFullPath(segments, absolute));
    }

    private Path(String[] segments, boolean absolute, String fullPath) {
        this.segments = segments;
        this.absolute = absolute;
        this.fullPath = fullPath;
    }

    public static Path path(String path) {
        return path.equals(":") ? ROOT : new Path(path);
    }

    public String toString() {
        return this.getPath();
    }

    public String getPath() {
        return this.fullPath;
    }

    private static String createFullPath(String[] segments, boolean absolute) {
        StringBuilder path = new StringBuilder();
        if (absolute) {
            path.append(":");
        }
        for (int i = 0; i < segments.length; ++i) {
            if (i > 0) {
                path.append(":");
            }
            String segment = segments[i];
            path.append(segment);
        }
        return path.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Path other = (Path)obj;
        return Arrays.equals(this.segments, other.segments);
    }

    public int hashCode() {
        return Arrays.hashCode(this.segments);
    }

    @Override
    public int compareTo(Path other) {
        if (this.absolute && !other.absolute) {
            return 1;
        }
        if (!this.absolute && other.absolute) {
            return -1;
        }
        for (int i = 0; i < Math.min(this.segments.length, other.segments.length); ++i) {
            int diff = STRING_COMPARATOR.compare(this.segments[i], other.segments[i]);
            if (diff == 0) continue;
            return diff;
        }
        int lenDiff = this.segments.length - other.segments.length;
        if (lenDiff > 0) {
            return 1;
        }
        if (lenDiff < 0) {
            return -1;
        }
        return 0;
    }

    public Path getParent() {
        if (this.segments.length == 0) {
            return null;
        }
        if (this.segments.length == 1) {
            return this.absolute ? ROOT : null;
        }
        String[] parentPath = new String[this.segments.length - 1];
        System.arraycopy(this.segments, 0, parentPath, 0, parentPath.length);
        return new Path(parentPath, this.absolute);
    }

    public String getName() {
        if (this.segments.length == 0) {
            return null;
        }
        return this.segments[this.segments.length - 1];
    }

    public Path child(String name) {
        String[] childSegments = new String[this.segments.length + 1];
        System.arraycopy(this.segments, 0, childSegments, 0, this.segments.length);
        childSegments[this.segments.length] = name;
        return new Path(childSegments, this.absolute);
    }

    public Path resolve(String path) {
        return new Path(this.absolutePath(path));
    }

    public String absolutePath(String path) {
        if (!this.isAbsolutePath(path)) {
            return this.fullPath.equals(":") ? this.fullPath + path : this.fullPath + ":" + path;
        }
        return path;
    }

    public String relativePath(String path) {
        if (this.fullPath.equals(":")) {
            if (path.startsWith(this.fullPath) && path.length() > this.fullPath.length()) {
                return path.substring(1);
            }
            return path;
        }
        if (path.startsWith(this.fullPath) && path.length() > this.fullPath.length() + 1 && path.charAt(this.fullPath.length()) == ':') {
            return path.substring(this.fullPath.length() + 1);
        }
        return path;
    }

    private boolean isAbsolutePath(String path) {
        if (!GUtil.isTrue((Object)path)) {
            throw new InvalidUserDataException("A path must be specified!");
        }
        return path.startsWith(":");
    }
}

