/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.repository.internal;

import org.gradle.api.Action;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.AuthenticationContainer;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.credentials.Credentials;
import org.gradle.api.internal.artifacts.DependencyResolutionServices;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.internal.artifacts.repositories.AuthenticationSupportedInternal;
import org.gradle.plugin.repository.MavenPluginRepository;
import org.gradle.plugin.repository.internal.AbstractArtifactPluginRepository;

class DefaultMavenPluginRepository
extends AbstractArtifactPluginRepository
implements MavenPluginRepository {
    private static final String MAVEN = "maven";

    public DefaultMavenPluginRepository(FileResolver fileResolver, DependencyResolutionServices dependencyResolutionServices, VersionSelectorScheme versionSelectorScheme, AuthenticationSupportedInternal delegate) {
        super(MAVEN, fileResolver, dependencyResolutionServices, versionSelectorScheme, delegate);
    }

    @Override
    protected ArtifactRepository internalCreateArtifactRepository(RepositoryHandler repositoryHandler) {
        return repositoryHandler.maven((Action)new Action<MavenArtifactRepository>(){

            public void execute(MavenArtifactRepository mavenArtifactRepository) {
                mavenArtifactRepository.setName(DefaultMavenPluginRepository.this.getArtifactRepositoryName());
                mavenArtifactRepository.setUrl((Object)DefaultMavenPluginRepository.this.getUrl());
                Credentials credentials = DefaultMavenPluginRepository.this.authenticationSupport().getConfiguredCredentials();
                if (credentials != null) {
                    ((AuthenticationSupportedInternal)mavenArtifactRepository).setConfiguredCredentials(credentials);
                    mavenArtifactRepository.authentication((Action)new Action<AuthenticationContainer>(){

                        public void execute(AuthenticationContainer authenticationContainer) {
                            authenticationContainer.addAll(DefaultMavenPluginRepository.this.authenticationSupport().getConfiguredAuthentication());
                        }
                    });
                }
            }
        });
    }
}

