/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.gui;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.logging.TextAreaListener;
import ch.ehi.basics.view.BrowserControl;
import ch.ehi.basics.view.FileChooser;
import ch.ehi.basics.view.GenericFileFilter;
import ch.interlis.ili2c.config.Configuration;
import ch.interlis.ili2c.config.FileEntry;
import ch.interlis.ili2c.config.PersistenceService;
import ch.interlis.ili2c.gui.AboutDialog;
import ch.interlis.ili2c.gui.FileEntriesAdapter;
import ch.interlis.ili2c.gui.FileEntryRenderer;
import ch.interlis.ili2c.gui.UserSettings;
import ch.interlis.ili2c.metamodel.TransferDescription;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class Main {
    private UserSettings settings;
    static final String CHECKPANEL = "Check/Generate";
    TextAreaListener errlistener = null;
    JFrame frame;
    JPanel cards;
    Container checkPane;
    Container comparePane;
    FileEntriesAdapter inputFileList;
    JList inputFileListUi;
    JTextField outputFileUi;
    JRadioButton warnButton;
    JRadioButton errButton;
    JComboBox outputKind;
    JTextArea errOutput;
    JPopupMenu errPopup;
    JButton runButton;
    JCheckBox autoCompleteCB;
    FileChooser fc;
    JLabel fileLabel = new JLabel("Filename");
    Configuration config = new Configuration();
    File ilcFile = null;

    public boolean showDialog() {
        this.run();
        return true;
    }

    public void run() {
        this.frame = new JFrame();
        this.updateTitle();
        this.checkPane = this.buildCheckPane();
        Container runPane = this.buildRunPane();
        this.frame.getRootPane().setDefaultButton(this.runButton);
        JSplitPane splitPane = new JSplitPane(0, this.checkPane, runPane);
        Container contentPane = this.frame.getContentPane();
        contentPane.add((Component)splitPane, "Center");
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Main.this.settings.save();
                System.exit(0);
            }
        });
        this.buildMenu();
        this.updateUi();
        this.errlistener = new TextAreaListener();
        this.errlistener.setOutputArea(this.errOutput);
        EhiLogger.getInstance().addListener(this.errlistener);
        this.frame.setSize(508, 490);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private void runCompiler() {
        TransferDescription td = ch.interlis.ili2c.Main.runCompiler(this.config);
        DateFormat dateFormatter = DateFormat.getDateTimeInstance(3, 3, Locale.getDefault());
        Date today = new Date();
        String dateOut = dateFormatter.format(today);
        String failed = td == null ? "failed" : "done";
        this.errOutput.append("--- compiler run " + failed + " " + dateOut + "\n");
    }

    private void updateTitle() {
        if (this.ilcFile != null) {
            this.frame.setTitle("ili2c - " + this.ilcFile.getAbsolutePath());
        } else {
            this.frame.setTitle("ili2c");
        }
    }

    private void buildMenu() {
        JMenuBar menuBar = new JMenuBar();
        this.frame.setJMenuBar(menuBar);
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("New");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Main.this.setConfig(new Configuration());
                Main.this.ilcFile = null;
                Main.this.updateTitle();
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("Open...");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Main.this.fc.resetChoosableFileFilters();
                Main.this.fc.setFileSelectionMode(0);
                Main.this.fc.addChoosableFileFilter(new GenericFileFilter("INTERLIS-compiler configuration (*.ilc)", "ilc"));
                Main.this.fc.setCurrentDirectory(new File(Main.this.settings.getWorkingDirectory()));
                int returnVal = Main.this.fc.showOpenDialog(Main.this.frame);
                if (returnVal == 0) {
                    Main.this.settings.setWorkingDirectory(Main.this.fc.getCurrentDirectory().getAbsolutePath());
                    File file = Main.this.fc.getSelectedFile();
                    try {
                        Configuration c = PersistenceService.readConfig(file.getAbsolutePath());
                        Main.this.setConfig(c);
                        Main.this.ilcFile = file;
                        Main.this.updateTitle();
                    }
                    catch (FileNotFoundException ex) {
                        JOptionPane.showMessageDialog(Main.this.frame, ex.getLocalizedMessage(), "ili2c error", 0);
                    }
                    catch (IOException ex) {
                        JOptionPane.showMessageDialog(Main.this.frame, ex.getLocalizedMessage(), "ili2c error", 0);
                    }
                }
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("Save");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Main.this.updateConfigFromUi();
                if (Main.this.ilcFile == null) {
                    Main.this.saveAs();
                } else {
                    try {
                        PersistenceService.writeConfig(Main.this.ilcFile.getAbsolutePath(), Main.this.config);
                    }
                    catch (IOException ex) {
                        JOptionPane.showMessageDialog(Main.this.frame, ex.getLocalizedMessage(), "ili2c error", 0);
                    }
                }
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("Save as...");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Main.this.updateConfigFromUi();
                Main.this.saveAs();
            }
        });
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Exit");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        menu.add(menuItem);
        menu = new JMenu("Help");
        menu.setMnemonic(72);
        menuBar.add(menu);
        menuItem = new JMenuItem("ili2c Help...");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int start;
                String classpath = System.getProperty("java.class.path");
                int index = classpath.toLowerCase().indexOf("ili2c.jar");
                String ili2cHome = index > (start = classpath.lastIndexOf(File.pathSeparator, index) + 1) ? classpath.substring(start, index - 1) : System.getProperty("user.dir");
                BrowserControl.displayURL("file://" + ili2cHome + "/doc/index.html");
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("About...");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AboutDialog dlg = new AboutDialog(Main.this.frame);
                dlg.show();
            }
        });
        menu.add(menuItem);
    }

    void setConfig(Configuration config) {
        this.config = config;
        this.inputFileList.setModel(config);
        this.updateUi();
    }

    void updateUi() {
        int kind = this.config.getOutputKind();
        this.outputKind.setSelectedIndex(kind - 1);
        if (kind == 1) {
            this.outputFileUi.setEditable(false);
        } else {
            this.outputFileUi.setEditable(true);
            this.outputFileUi.setText(this.config.getOutputFile());
        }
        if (this.config.isGenerateWarnings()) {
            this.warnButton.setSelected(true);
        } else {
            this.errButton.setSelected(true);
        }
        this.autoCompleteCB.setSelected(this.config.isAutoCompleteModelList());
    }

    void updateConfigFromUi() {
        this.config.setOutputFile(this.outputFileUi.getText());
    }

    void saveAs() {
        this.fc.resetChoosableFileFilters();
        this.fc.setFileSelectionMode(0);
        this.fc.addChoosableFileFilter(new GenericFileFilter("INTERLIS-compiler configuration (*.ilc)", "ilc"));
        this.fc.setCurrentDirectory(new File(this.settings.getWorkingDirectory()));
        int returnVal = this.fc.showSaveDialog(this.frame);
        if (returnVal == 0) {
            this.settings.setWorkingDirectory(this.fc.getCurrentDirectory().getAbsolutePath());
            File file = this.fc.getSelectedFile();
            try {
                PersistenceService.writeConfig(file.getAbsolutePath(), this.config);
                this.ilcFile = file;
                this.updateTitle();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this.frame, ex.getLocalizedMessage(), "ili2c error", 0);
            }
        }
    }

    public Container buildRunPane() {
        GridBagConstraints cnstr = null;
        JPanel compilerPane = new JPanel();
        compilerPane.setLayout(new GridBagLayout());
        cnstr = new GridBagConstraints();
        cnstr.gridy = 0;
        cnstr.anchor = 18;
        cnstr.gridwidth = 2;
        JLabel logLabel = new JLabel("Compiler messages");
        compilerPane.add((Component)logLabel, cnstr);
        cnstr.gridwidth = 1;
        this.errOutput = new JTextArea();
        this.errPopup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Clear message log");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Main.this.errOutput.setText("");
            }
        });
        this.errPopup.add(menuItem);
        MouseAdapter popupListener = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    Main.this.errPopup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        };
        this.errOutput.addMouseListener(popupListener);
        JScrollPane errScroller = new JScrollPane(this.errOutput);
        errScroller.setPreferredSize(new Dimension(250, 80));
        errScroller.setMinimumSize(new Dimension(250, 80));
        ++cnstr.gridy;
        cnstr.fill = 1;
        cnstr.weightx = 1.0;
        cnstr.weighty = 1.0;
        compilerPane.add((Component)errScroller, cnstr);
        JPanel buttonPane = new JPanel();
        this.runButton = new JButton("Run compiler");
        this.runButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int n;
                File outfile;
                Main.this.updateConfigFromUi();
                if (Main.this.config.getOutputKind() != 1 && !"-".equals(Main.this.config.getOutputFile()) && (outfile = new File(Main.this.config.getOutputFile())).exists() && (n = Main.this.config.getOutputKind() == 5 || Main.this.config.getOutputKind() == 6 ? JOptionPane.showConfirmDialog(Main.this.frame, "Overwrite files in " + outfile.getAbsolutePath() + "?", "ili2c", 0) : JOptionPane.showConfirmDialog(Main.this.frame, "Overwrite file " + outfile.getAbsolutePath() + "?", "ili2c", 0)) == 1) {
                    return;
                }
                Main.this.runCompiler();
            }
        });
        this.runButton.setMnemonic(82);
        buttonPane.setLayout(new BoxLayout(buttonPane, 1));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        buttonPane.add(this.runButton);
        JButton clrmsgButton = new JButton("Clear message log");
        clrmsgButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Main.this.errOutput.setText("");
            }
        });
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(clrmsgButton);
        cnstr.fill = 0;
        cnstr.weightx = 0.0;
        cnstr.weighty = 0.0;
        cnstr.gridx = 1;
        compilerPane.add((Component)buttonPane, cnstr);
        return compilerPane;
    }

    public Container buildCheckPane() {
        GridBagConstraints cnstr = null;
        JPanel inputPane = new JPanel();
        inputPane.setLayout(new GridBagLayout());
        cnstr = new GridBagConstraints();
        cnstr.gridy = 0;
        cnstr.anchor = 18;
        cnstr.gridwidth = 2;
        this.autoCompleteCB = new JCheckBox("auto complete fileset");
        this.autoCompleteCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Main.this.config.setAutoCompleteModelList(Main.this.autoCompleteCB.isSelected());
            }
        });
        inputPane.add((Component)this.autoCompleteCB, cnstr);
        ++cnstr.gridy;
        cnstr.gridwidth = 2;
        JLabel label = new JLabel("Files");
        inputPane.add((Component)label, cnstr);
        cnstr.gridwidth = 1;
        this.inputFileList = new FileEntriesAdapter(this.config);
        this.inputFileListUi = new JList(this.inputFileList);
        this.inputFileListUi.setCellRenderer(new FileEntryRenderer());
        JScrollPane listScroller = new JScrollPane(this.inputFileListUi);
        listScroller.setPreferredSize(new Dimension(250, 80));
        listScroller.setMinimumSize(new Dimension(250, 80));
        ++cnstr.gridy;
        cnstr.fill = 1;
        cnstr.weightx = 1.0;
        cnstr.weighty = 1.0;
        inputPane.add((Component)listScroller, cnstr);
        cnstr.fill = 0;
        cnstr.weightx = 0.0;
        cnstr.weighty = 0.0;
        cnstr.gridx = 1;
        inputPane.add((Component)this.buildInputFilesButtonPane(), cnstr);
        cnstr.gridx = 0;
        JPanel outputPane = new JPanel();
        outputPane.setLayout(new GridBagLayout());
        cnstr = new GridBagConstraints();
        cnstr.gridy = 0;
        cnstr.anchor = 18;
        label = new JLabel("Kind of output");
        outputPane.add((Component)label, cnstr);
        String[] comboBoxItems = new String[]{"Generate no output", "Generate an INTERLIS 1 model", "Generate an INTERLIS 2 model", "Generate an XML-Schema", "Generate an ILI1 FMT-Description", "Generate a GML-Schema"};
        JPanel cbp = new JPanel();
        this.outputKind = new JComboBox<String>(comboBoxItems);
        this.outputKind.setEditable(false);
        this.outputKind.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int kind = Main.this.outputKind.getSelectedIndex() + 1;
                Main.this.outputFileUi.setEditable(true);
                Main.this.fileLabel.setText("Filename");
                if (kind == 1) {
                    Main.this.outputFileUi.setEditable(false);
                } else if (kind == 6) {
                    Main.this.outputFileUi.setEditable(true);
                    Main.this.fileLabel.setText("Output directory");
                }
                Main.this.config.setOutputKind(kind);
            }
        });
        cbp.add(this.outputKind);
        ++cnstr.gridy;
        outputPane.add((Component)cbp, cnstr);
        ++cnstr.gridy;
        outputPane.add((Component)this.fileLabel, cnstr);
        JPanel x = new JPanel();
        this.outputFileUi = new JTextField();
        this.outputFileUi.setColumns(30);
        x.add(this.outputFileUi);
        JButton browseButton = new JButton("Browse...");
        browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int returnVal;
                boolean useDir = false;
                Main.this.fc.setFileSelectionMode(0);
                Main.this.fc.resetChoosableFileFilters();
                if (Main.this.config.getOutputKind() == 4) {
                    Main.this.fc.addChoosableFileFilter(GenericFileFilter.createXmlSchemaFilter());
                } else if (Main.this.config.getOutputKind() == 5) {
                    Main.this.fc.addChoosableFileFilter(new GenericFileFilter("ILI1 Format (*.fmt)", "fmt"));
                } else if (Main.this.config.getOutputKind() == 7) {
                    Main.this.fc.addChoosableFileFilter(GenericFileFilter.createXmlFilter());
                } else if (Main.this.config.getOutputKind() == 6) {
                    useDir = true;
                } else {
                    Main.this.fc.addChoosableFileFilter(new GenericFileFilter("INTERLIS models (*.ili)", "ili"));
                }
                Main.this.fc.setCurrentDirectory(new File(Main.this.settings.getWorkingDirectory()));
                if (Main.this.config.getSizeFileEntry() > 0) {
                    String name = new File(Main.this.config.getFileEntry(Main.this.config.getSizeFileEntry() - 1).getFilename()).getName();
                    int i = name.lastIndexOf(46);
                    if (i >= 0 && i < name.length()) {
                        name = name.substring(0, i);
                    }
                    Main.this.fc.setSelectedFile(new File(Main.this.settings.getWorkingDirectory(), name));
                }
                if ((returnVal = useDir ? Main.this.fc.showOutputDirDialog(Main.this.frame) : Main.this.fc.showSaveDialog(Main.this.frame)) == 0) {
                    Main.this.settings.setWorkingDirectory(Main.this.fc.getCurrentDirectory().getAbsolutePath());
                    File file = Main.this.fc.getSelectedFile();
                    Main.this.outputFileUi.setText(file.getAbsolutePath());
                }
            }
        });
        x.add(browseButton);
        ++cnstr.gridy;
        outputPane.add((Component)x, cnstr);
        this.warnButton = new JRadioButton("Report errors and warnings");
        this.warnButton.setSelected(true);
        this.warnButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Main.this.warnButton.isSelected()) {
                    Main.this.config.setGenerateWarnings(true);
                }
            }
        });
        this.errButton = new JRadioButton("Report only errors");
        this.errButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Main.this.errButton.isSelected()) {
                    Main.this.config.setGenerateWarnings(false);
                }
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(this.warnButton);
        group.add(this.errButton);
        ++cnstr.gridy;
        outputPane.add((Component)this.warnButton, cnstr);
        ++cnstr.gridy;
        outputPane.add((Component)this.errButton, cnstr);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("Input", inputPane);
        tabbedPane.addTab("Output", outputPane);
        tabbedPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        return tabbedPane;
    }

    public Container buildInputFilesButtonPane() {
        JPanel filesButtonPane = new JPanel();
        JButton addIliFileButton = new JButton("Add Model (.ili)...");
        addIliFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Main.this.fc.resetChoosableFileFilters();
                Main.this.fc.addChoosableFileFilter(new GenericFileFilter("INTERLIS models (*.ili)", "ili"));
                Main.this.fc.setCurrentDirectory(new File(Main.this.settings.getWorkingDirectory()));
                int returnVal = Main.this.fc.showOpenDialog(Main.this.frame);
                if (returnVal == 0) {
                    Main.this.settings.setWorkingDirectory(Main.this.fc.getCurrentDirectory().getAbsolutePath());
                    File file = Main.this.fc.getSelectedFile();
                    FileEntry entry = new FileEntry(file.getAbsolutePath(), 1);
                    Main.this.inputFileList.addElement(entry);
                }
            }
        });
        JButton removeFileButton = new JButton("Remove");
        removeFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int[] idxv = Main.this.inputFileListUi.getSelectedIndices();
                if (idxv.length > 0) {
                    for (int i = idxv.length - 1; i >= 0; --i) {
                        Main.this.inputFileList.remove(idxv[i]);
                    }
                    if (Main.this.inputFileList.getSize() > 0) {
                        if (idxv[0] < Main.this.inputFileList.getSize()) {
                            Main.this.inputFileListUi.setSelectedIndex(idxv[0]);
                        } else {
                            Main.this.inputFileListUi.setSelectedIndex(Main.this.inputFileList.getSize() - 1);
                        }
                    }
                }
            }
        });
        JButton moveFileUpButton = new JButton("Move up");
        moveFileUpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int idx = Main.this.inputFileListUi.getSelectedIndex();
                if (idx > 0) {
                    FileEntry elt = Main.this.inputFileList.remove(idx);
                    Main.this.inputFileList.add(idx - 1, elt);
                    Main.this.inputFileListUi.setSelectedIndex(idx - 1);
                }
            }
        });
        JButton moveFileDownButton = new JButton("Move down");
        moveFileDownButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int idx = Main.this.inputFileListUi.getSelectedIndex();
                if (idx != -1 && idx + 1 < Main.this.inputFileList.getSize()) {
                    FileEntry elt = Main.this.inputFileList.remove(idx);
                    Main.this.inputFileList.add(idx + 1, elt);
                    Main.this.inputFileListUi.setSelectedIndex(idx + 1);
                }
            }
        });
        filesButtonPane.setLayout(new BoxLayout(filesButtonPane, 1));
        filesButtonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        filesButtonPane.add(addIliFileButton);
        filesButtonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        filesButtonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        filesButtonPane.add(removeFileButton);
        filesButtonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        filesButtonPane.add(moveFileUpButton);
        filesButtonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        filesButtonPane.add(moveFileDownButton);
        return filesButtonPane;
    }

    public Main() {
        this.fc = new FileChooser();
        this.config.setAutoCompleteModelList(true);
    }

    public static void main(String[] args) {
        Main instance = new Main();
        instance.settings = UserSettings.load();
        instance.run();
    }
}

