/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.BaseType;
import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import ch.interlis.ili2c.metamodel.Type;

public class TextType
extends BaseType {
    protected int maxLength;
    private boolean normalized = true;

    public TextType() {
        this.maxLength = -1;
    }

    public TextType(int maxLength) {
        if (maxLength < 0) {
            throw new IllegalArgumentException(rsrc.getString("err_textLenNegative"));
        }
        if (maxLength == 0) {
            throw new IllegalArgumentException(rsrc.getString("err_textType_lenZero"));
        }
        this.maxLength = maxLength;
    }

    public String toString() {
        String kw;
        String string = kw = this.normalized ? "TEXT" : "MTEXT";
        if (this.maxLength != -1) {
            return String.valueOf(kw) + "*" + Integer.toString(this.maxLength);
        }
        return kw;
    }

    public boolean isAbstract() {
        return false;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    void checkTypeExtension(Type wantToExtend) {
        if (wantToExtend == null || (wantToExtend = wantToExtend.resolveAliases()) == null) {
            return;
        }
        if (!(wantToExtend instanceof TextType)) {
            throw new Ili2cSemanticException(rsrc.getString("err_textType_ExtOther"));
        }
        TextType general = (TextType)wantToExtend;
        if (general.maxLength != -1) {
            if (this.maxLength == -1) {
                throw new Ili2cSemanticException(TextType.formatMessage("err_textType_longerExtShorter", this.toString(), general.toString()));
            }
            if (this.maxLength > general.maxLength) {
                throw new Ili2cSemanticException(TextType.formatMessage("err_textType_longerExtShorter", this.toString(), general.toString()));
            }
        }
        if (general.normalized != this.normalized) {
            throw new Ili2cSemanticException(TextType.formatMessage("err_textType_kindMismatch", this.toString(), general.toString()));
        }
    }

    public boolean isNormalized() {
        return this.normalized;
    }

    public void setNormalized(boolean b) {
        this.normalized = b;
    }
}

