/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javajs.util.DF;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.c.CBK;
import org.jmol.c.STR;
import org.jmol.script.SV;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.JC;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.Viewer;

public class GlobalSettings {
    private final Viewer vwr;
    Map<String, Object> htNonbooleanParameterValues;
    Map<String, Boolean> htBooleanParameterFlags;
    Map<String, Boolean> htPropertyFlagsRemoved;
    Map<String, SV> htUserVariables = new Hashtable<String, SV>();
    Map<String, String> databases;
    int zDepth = 0;
    int zShadePower = 3;
    int zSlab = 50;
    boolean slabByMolecule = false;
    boolean slabByAtom = false;
    boolean allowEmbeddedScripts = true;
    public boolean appendNew = true;
    String appletProxy = "";
    boolean applySymmetryToBonds = false;
    String atomTypes = "";
    boolean autoBond = true;
    boolean axesOrientationRasmol = false;
    short bondRadiusMilliAngstroms = (short)150;
    float bondTolerance = 0.45f;
    String defaultDirectory = "";
    boolean defaultStructureDSSP = true;
    final P3 ptDefaultLattice = new P3();
    public String defaultLoadScript = "";
    public String defaultLoadFilter = "";
    public String defaultDropScript = "zap; load SYNC \"%FILE\";if (%ALLOWCARTOONS && _loadScript == '' && defaultLoadScript == '' && _filetype == 'Pdb') {if ({(protein or nucleic)&*/1.1} && {*/1.1}[1].groupindex != {*/1.1}[0].groupindex){select protein or nucleic;cartoons only;}if ({visible && cartoons > 0}){color structure}else{wireframe -0.1};if (!{visible}){spacefill 23%};select *}";
    boolean forceAutoBond = false;
    boolean fractionalRelative = true;
    char inlineNewlineChar = (char)124;
    String loadFormat;
    String pdbLoadFormat;
    String pdbLoadFormat0;
    String pdbLoadLigandFormat;
    String nmrUrlFormat;
    String nmrPredictFormat;
    String smilesUrlFormat;
    String nihResolverFormat;
    String pubChemFormat;
    String edsUrlFormat = "http://eds.bmc.uu.se/eds/dfs/%c2%c3/%file/%file.omap";
    String edsUrlFormatDiff = "http://eds.bmc.uu.se/eds/dfs/%c2%c3/%file/%file_diff.omap";
    String edsUrlCutoff = "http://eds.bmc.uu.se/eds/dfs/%c2%c3/%file/%file.sfdat";
    float minBondDistance = 0.4f;
    int minPixelSelRadius = 6;
    boolean pdbAddHydrogens = false;
    boolean pdbGetHeader = false;
    boolean pdbSequential = false;
    int percentVdwAtom = 23;
    int smallMoleculeMaxAtoms = 40000;
    boolean smartAromatic = true;
    boolean zeroBasedXyzRasmol = false;
    boolean legacyAutoBonding = false;
    public boolean legacyHAddition = false;
    public boolean legacyJavaFloat = false;
    boolean jmolInJSpecView = true;
    boolean modulateOccupancy = true;
    boolean allowRotateSelected = false;
    boolean allowMoveAtoms = false;
    boolean solventOn = false;
    String defaultAngleLabel = "%VALUE %UNITS";
    String defaultDistanceLabel = "%VALUE %UNITS";
    String defaultTorsionLabel = "%VALUE %UNITS";
    boolean justifyMeasurements = false;
    boolean measureAllModels = false;
    int minimizationSteps = 100;
    boolean minimizationRefresh = true;
    boolean minimizationSilent = false;
    float minimizationCriterion = 0.001f;
    boolean antialiasDisplay = false;
    boolean antialiasImages = true;
    boolean imageState = true;
    boolean antialiasTranslucent = true;
    boolean displayCellParameters = true;
    boolean dotsSelectedOnly = false;
    boolean dotSurface = true;
    int dotDensity = 3;
    int dotScale = 1;
    int meshScale = 1;
    boolean greyscaleRendering = false;
    boolean isosurfaceKey = false;
    boolean isosurfacePropertySmoothing = true;
    int isosurfacePropertySmoothingPower = 7;
    int platformSpeed = 10;
    public int repaintWaitMs = 1000;
    boolean showHiddenSelectionHalos = false;
    boolean showKeyStrokes = true;
    boolean showMeasurements = true;
    public boolean showTiming = false;
    boolean zoomLarge = true;
    boolean zoomHeight = false;
    String backgroundImageFileName;
    boolean partialDots = false;
    boolean bondModeOr = false;
    boolean hbondsBackbone = false;
    float hbondsAngleMinimum = 90.0f;
    float hbondsDistanceMaximum = 3.25f;
    boolean hbondsRasmol = true;
    boolean hbondsSolid = false;
    public byte modeMultipleBond = (byte)2;
    boolean showHydrogens = true;
    boolean showMultipleBonds = true;
    boolean ssbondsBackbone = false;
    float multipleBondSpacing = -1.0f;
    float multipleBondRadiusFactor = 0.0f;
    boolean multipleBondBananas = false;
    boolean nboCharges = true;
    boolean cartoonBaseEdges = false;
    boolean cartoonRockets = false;
    float cartoonBlockHeight = 0.5f;
    boolean cartoonBlocks = false;
    boolean cartoonSteps = false;
    boolean cartoonFancy = false;
    boolean cartoonLadders = false;
    boolean cartoonRibose = false;
    boolean chainCaseSensitive = false;
    int hermiteLevel = 0;
    boolean highResolutionFlag = false;
    public boolean rangeSelected = false;
    boolean rasmolHydrogenSetting = true;
    boolean rasmolHeteroSetting = true;
    int ribbonAspectRatio = 16;
    boolean ribbonBorder = false;
    boolean rocketBarrels = false;
    float sheetSmoothing = 1.0f;
    boolean traceAlpha = true;
    boolean translucent = true;
    boolean twistedSheets = false;
    boolean allowGestures = false;
    boolean allowModelkit = true;
    boolean allowMultiTouch = true;
    boolean allowKeyStrokes = false;
    boolean hiddenLinesDashed = false;
    int animationFps = 10;
    boolean atomPicking = true;
    boolean autoFps = false;
    public int axesMode = 603979809;
    float axesScale = 2.0f;
    float axesOffset = 0.0f;
    float starWidth = 0.05f;
    boolean bondPicking = false;
    String dataSeparator = "~~~";
    boolean debugScript = false;
    float defaultDrawArrowScale = 0.5f;
    String defaultLabelXYZ = "%a";
    String defaultLabelPDB = "%m%r";
    float defaultTranslucent = 0.5f;
    int delayMaximumMs = 0;
    float dipoleScale = 1.0f;
    float drawFontSize = 14.0f;
    boolean disablePopupMenu = false;
    boolean dragSelected = false;
    boolean drawHover = false;
    boolean drawPicking = false;
    boolean dsspCalcHydrogen = true;
    public String energyUnits = "kJ";
    float exportScale = 0.0f;
    String helpPath = "http://chemapps.stolaf.edu/jmol/docs/index.htm";
    boolean fontScaling = false;
    boolean fontCaching = true;
    String forceField = "MMFF";
    int helixStep = 1;
    boolean hideNameInPopup = false;
    int hoverDelayMs = 500;
    float loadAtomDataTolerance = 0.01f;
    public boolean logCommands = false;
    public boolean logGestures = false;
    public String measureDistanceUnits = "nanometers";
    boolean measurementLabels = true;
    boolean messageStyleChime = false;
    boolean monitorEnergy = false;
    public float modulationScale = 1.0f;
    boolean multiProcessor = true;
    float particleRadius = 20.0f;
    int pickingSpinRate = 10;
    String pickLabel = "";
    float pointGroupDistanceTolerance = 0.2f;
    float pointGroupLinearTolerance = 8.0f;
    public boolean preserveState = true;
    String propertyColorScheme = "roygb";
    String quaternionFrame = "p";
    boolean saveProteinStructureState = true;
    boolean showModVecs = false;
    boolean showUnitCellDetails = true;
    float solventProbeRadius = 1.2f;
    int scriptDelay = 0;
    boolean selectAllModels = true;
    boolean statusReporting = true;
    int strandCountForStrands = 5;
    int strandCountForMeshRibbon = 7;
    int strutSpacing = 6;
    float strutLengthMaximum = 7.0f;
    float strutDefaultRadius = 0.3f;
    boolean strutsMultiple = false;
    boolean useMinimizationThread = true;
    boolean useNumberLocalization = true;
    public boolean useScriptQueue = true;
    public boolean waitForMoveTo = true;
    float vectorScale = 1.0f;
    boolean vectorSymmetry = false;
    boolean vectorsCentered = false;
    int vectorTrail = 0;
    float vibrationPeriod = 1.0f;
    float vibrationScale = 1.0f;
    boolean wireframeRotation = false;
    boolean hideNavigationPoint = false;
    boolean navigationMode = false;
    boolean navigationPeriodic = false;
    float navigationSpeed = 5.0f;
    boolean showNavigationPointAlways = false;
    String stereoState = null;
    boolean modelKitMode = false;
    int[] objColors = new int[7];
    boolean[] objStateOn = new boolean[7];
    int[] objMad10 = new int[7];
    boolean ellipsoidAxes = false;
    boolean ellipsoidDots = false;
    boolean ellipsoidArcs = false;
    boolean ellipsoidArrows = false;
    boolean ellipsoidFill = false;
    boolean ellipsoidBall = true;
    int ellipsoidDotCount = 200;
    float ellipsoidAxisDiameter = 0.02f;
    boolean testFlag1 = false;
    boolean testFlag2 = false;
    boolean testFlag3 = false;
    boolean testFlag4 = false;
    Map<STR, float[]> structureList = new Hashtable<STR, float[]>();
    boolean haveSetStructureList;
    private String[] userDatabases;
    public int bondingVersion;
    private static final String unreportedProperties = (";ambientpercent;animationfps;antialiasdisplay;antialiasimages;antialiastranslucent;appendnew;axescolor;axesposition;axesmolecular;axesorientationrasmol;axesunitcell;axeswindow;axis1color;axis2color;axis3color;backgroundcolor;backgroundmodel;bondsymmetryatoms;boundboxcolor;cameradepth;bondingversion;contextdepthmax;debug;debugscript;defaultlatttice;defaults;defaultdropscript;diffusepercent;;exportdrivers;exportscale;_filecaching;_filecache;fontcaching;fontscaling;forcefield;language;jmolinjspecview;legacyautobonding;legacyhaddition;legacyjavafloat;loglevel;logfile;loggestures;logcommands;measurestylechime;loadformat;loadligandformat;smilesurlformat;pubchemformat;nihresolverformat;edsurlformat;edsurlcutoff;multiprocessor;navigationmode;;pathforallfiles;perspectivedepth;phongexponent;perspectivemodel;platformspeed;preservestate;refreshing;repaintwaitms;rotationradius;selectallmodels;showaxes;showaxis1;showaxis2;showaxis3;showboundbox;showfrank;showtiming;showunitcell;slabenabled;slab;slabrange;depth;zshade;zshadepower;specular;specularexponent;specularpercent;celshading;celshadingpower;specularpower;stateversion;statusreporting;stereo;stereostate;vibrationperiod;unitcellcolor;visualrange;windowcentered;zerobasedxyzrasmol;zoomenabled;mousedragfactor;mousewheelfactor;scriptqueue;scriptreportinglevel;syncscript;syncmouse;syncstereo;defaultdirectory;currentlocalpath;defaultdirectorylocal;ambient;bonds;colorrasmol;diffuse;fractionalrelative;frank;hetero;hidenotselected;hoverlabel;hydrogen;languagetranslation;measurementunits;navigationdepth;navigationslab;picking;pickingstyle;propertycolorschemeoverload;radius;rgbblue;rgbgreen;rgbred;scaleangstromsperinch;selectionhalos;showscript;showselections;solvent;strandcount;spinx;spiny;spinz;spinfps;navx;navy;navz;navfps;" + CBK.getNameList() + ";undo;atompicking;drawpicking;bondpicking;pickspinrate;picklabel" + ";modelkitmode;allowgestures;allowkeystrokes;allowmultitouch;allowmodelkit" + ";dodrop;hovered;historylevel;imagestate;iskiosk;useminimizationthread" + ";showkeystrokes;saveproteinstructurestate;testflag1;testflag2;testflag3;testflag4" + ";").toLowerCase();

    GlobalSettings(Viewer vwr, GlobalSettings g, boolean clearUserVariables) {
        this.structureList.put(STR.TURN, new float[]{30.0f, 90.0f, -15.0f, 95.0f});
        this.structureList.put(STR.SHEET, new float[]{-180.0f, -10.0f, 70.0f, 180.0f, -180.0f, -45.0f, -180.0f, -130.0f, 140.0f, 180.0f, 90.0f, 180.0f});
        this.structureList.put(STR.HELIX, new float[]{-160.0f, 0.0f, -100.0f, 45.0f});
        this.bondingVersion = 0;
        this.vwr = vwr;
        this.htNonbooleanParameterValues = new Hashtable<String, Object>();
        this.htBooleanParameterFlags = new Hashtable<String, Boolean>();
        this.htPropertyFlagsRemoved = new Hashtable<String, Boolean>();
        if (g != null) {
            if (!clearUserVariables) {
                this.htUserVariables = g.htUserVariables;
            }
            this.debugScript = g.debugScript;
            this.disablePopupMenu = g.disablePopupMenu;
            this.messageStyleChime = g.messageStyleChime;
            this.defaultDirectory = g.defaultDirectory;
            this.allowGestures = g.allowGestures;
            this.allowModelkit = g.allowModelkit;
            this.allowMultiTouch = g.allowMultiTouch;
            this.allowKeyStrokes = g.allowKeyStrokes;
            this.legacyAutoBonding = g.legacyAutoBonding;
            this.legacyHAddition = g.legacyHAddition;
            this.legacyJavaFloat = g.legacyJavaFloat;
            this.bondingVersion = g.bondingVersion;
            this.platformSpeed = g.platformSpeed;
            this.useScriptQueue = g.useScriptQueue;
            this.databases = g.databases;
            this.showTiming = g.showTiming;
            this.wireframeRotation = g.wireframeRotation;
            this.testFlag1 = g.testFlag1;
            this.testFlag2 = g.testFlag2;
            this.testFlag3 = g.testFlag3;
            this.testFlag4 = g.testFlag4;
        }
        if (this.databases == null) {
            this.databases = new Hashtable<String, String>();
            this.getDataBaseList(JC.databases);
            this.getDataBaseList(this.userDatabases);
        }
        this.loadFormat = this.pdbLoadFormat = this.databases.get("pdb");
        this.pdbLoadFormat0 = this.databases.get("pdb0");
        this.pdbLoadLigandFormat = this.databases.get("ligand");
        this.nmrUrlFormat = this.databases.get("nmr");
        this.nmrPredictFormat = this.databases.get("nmrdb");
        this.smilesUrlFormat = this.databases.get("nci") + "/file?format=sdf&get3d=true";
        this.nihResolverFormat = this.databases.get("nci");
        this.pubChemFormat = this.databases.get("pubchem");
        for (CBK item : CBK.values()) {
            this.resetValue(item.name() + "Callback", g);
        }
        this.setF("cameraDepth", 3.0f);
        this.setI("contextDepthMax", 100);
        this.setI("depth", 0);
        this.setF("gestureSwipeFactor", 1.0f);
        this.setB("hideNotSelected", false);
        this.setI("historyLevel", 0);
        this.setO("hoverLabel", "");
        this.setB("isKiosk", vwr.isKiosk());
        this.setO("logFile", vwr.getLogFileName());
        this.setI("logLevel", Logger.getLogLevel());
        this.setF("mouseWheelFactor", 1.15f);
        this.setF("mouseDragFactor", 1.0f);
        this.setI("navFps", 10);
        this.setI("navigationDepth", 0);
        this.setI("navigationSlab", 0);
        this.setI("navX", 0);
        this.setI("navY", 0);
        this.setI("navZ", 0);
        this.setO("pathForAllFiles", "");
        this.setB("perspectiveDepth", true);
        this.setI("perspectiveModel", 11);
        this.setO("picking", "identify");
        this.setO("pickingStyle", "toggle");
        this.setB("refreshing", true);
        this.setI("rotationRadius", 0);
        this.setI("scaleAngstromsPerInch", 0);
        this.setI("scriptReportingLevel", 0);
        this.setB("selectionHalos", false);
        this.setB("showaxes", false);
        this.setB("showboundbox", false);
        this.setB("showfrank", false);
        this.setB("showUnitcell", false);
        this.setI("slab", 100);
        this.setB("slabEnabled", false);
        this.setF("slabrange", 0.0f);
        this.setI("spinX", 0);
        this.setI("spinY", 30);
        this.setI("spinZ", 0);
        this.setI("spinFps", 30);
        this.setF("visualRange", 5.0f);
        this.setI("stereoDegrees", -5);
        this.setB("syncScript", vwr.sm.syncingScripts);
        this.setB("syncMouse", vwr.sm.syncingMouse);
        this.setB("syncStereo", vwr.sm.stereoSync);
        this.setB("windowCentered", true);
        this.setB("zoomEnabled", true);
        this.setI("_version", JC.versionInt);
        this.setO("_versionDate", Viewer.getJmolVersion());
        this.setB("axesWindow", true);
        this.setB("axesMolecular", false);
        this.setB("axesPosition", false);
        this.setB("axesUnitcell", false);
        this.setI("backgroundModel", 0);
        this.setB("colorRasmol", false);
        this.setO("currentLocalPath", "");
        this.setO("defaultLattice", "{0 0 0}");
        this.setO("defaultColorScheme", "Jmol");
        this.setO("defaultDirectoryLocal", "");
        this.setO("defaults", "Jmol");
        this.setO("defaultVDW", "Jmol");
        this.setO("exportDrivers", "Idtf;Maya;Povray;Vrml;X3d;Stl;Tachyon;Obj");
        this.setI("propertyAtomNumberColumnCount", 0);
        this.setI("propertyAtomNumberField", 0);
        this.setI("propertyDataColumnCount", 0);
        this.setI("propertyDataField", 0);
        this.setB("undo", true);
        this.setB("allowEmbeddedScripts", this.allowEmbeddedScripts);
        this.setB("allowGestures", this.allowGestures);
        this.setB("allowKeyStrokes", this.allowKeyStrokes);
        this.setB("allowModelkit", this.allowModelkit);
        this.setB("allowMultiTouch", this.allowMultiTouch);
        this.setB("allowRotateSelected", this.allowRotateSelected);
        this.setB("allowMoveAtoms", this.allowMoveAtoms);
        this.setI("animationFps", this.animationFps);
        this.setB("antialiasImages", this.antialiasImages);
        this.setB("antialiasDisplay", this.antialiasDisplay);
        this.setB("antialiasTranslucent", this.antialiasTranslucent);
        this.setB("appendNew", this.appendNew);
        this.setO("appletProxy", this.appletProxy);
        this.setB("applySymmetryToBonds", this.applySymmetryToBonds);
        this.setB("atomPicking", this.atomPicking);
        this.setO("atomTypes", this.atomTypes);
        this.setB("autoBond", this.autoBond);
        this.setB("autoFps", this.autoFps);
        this.setI("axesMode", this.axesMode == 0x24000020 ? 2 : (this.axesMode == 603979804 ? 1 : 0));
        this.setF("axesScale", this.axesScale);
        this.setF("axesOffset", this.axesOffset);
        this.setB("axesOrientationRasmol", this.axesOrientationRasmol);
        this.setF("cartoonBlockHeight", this.cartoonBlockHeight);
        this.setB("cartoonBlocks", this.cartoonBlocks);
        this.setB("cartoonSteps", this.cartoonSteps);
        this.setB("bondModeOr", this.bondModeOr);
        this.setB("bondPicking", this.bondPicking);
        this.setI("bondRadiusMilliAngstroms", this.bondRadiusMilliAngstroms);
        this.setF("bondTolerance", this.bondTolerance);
        this.setB("cartoonBaseEdges", this.cartoonBaseEdges);
        this.setB("cartoonFancy", this.cartoonFancy);
        this.setB("cartoonLadders", this.cartoonLadders);
        this.setB("cartoonLadders", this.cartoonRibose);
        this.setB("cartoonRockets", this.cartoonRockets);
        this.setB("chainCaseSensitive", this.chainCaseSensitive);
        this.setI("bondingVersion", this.bondingVersion);
        this.setO("dataSeparator", this.dataSeparator);
        this.setB("debugScript", this.debugScript);
        this.setO("defaultAngleLabel", this.defaultAngleLabel);
        this.setF("defaultDrawArrowScale", this.defaultDrawArrowScale);
        this.setO("defaultDirectory", this.defaultDirectory);
        this.setO("defaultDistanceLabel", this.defaultDistanceLabel);
        this.setO("defaultDropScript", this.defaultDropScript);
        this.setO("defaultLabelPDB", this.defaultLabelPDB);
        this.setO("defaultLabelXYZ", this.defaultLabelXYZ);
        this.setO("defaultLoadFilter", this.defaultLoadFilter);
        this.setO("defaultLoadScript", this.defaultLoadScript);
        this.setB("defaultStructureDSSP", this.defaultStructureDSSP);
        this.setO("defaultTorsionLabel", this.defaultTorsionLabel);
        this.setF("defaultTranslucent", this.defaultTranslucent);
        this.setI("delayMaximumMs", this.delayMaximumMs);
        this.setF("dipoleScale", this.dipoleScale);
        this.setB("disablePopupMenu", this.disablePopupMenu);
        this.setB("displayCellParameters", this.displayCellParameters);
        this.setI("dotDensity", this.dotDensity);
        this.setI("dotScale", this.dotScale);
        this.setB("dotsSelectedOnly", this.dotsSelectedOnly);
        this.setB("dotSurface", this.dotSurface);
        this.setB("dragSelected", this.dragSelected);
        this.setB("drawHover", this.drawHover);
        this.setF("drawFontSize", this.drawFontSize);
        this.setB("drawPicking", this.drawPicking);
        this.setB("dsspCalculateHydrogenAlways", this.dsspCalcHydrogen);
        this.setO("edsUrlFormat", this.edsUrlFormat);
        this.setO("edsUrlFormatDiff", this.edsUrlFormatDiff);
        this.setO("edsUrlCutoff", this.edsUrlCutoff);
        this.setB("ellipsoidArcs", this.ellipsoidArcs);
        this.setB("ellipsoidArrows", this.ellipsoidArrows);
        this.setB("ellipsoidAxes", this.ellipsoidAxes);
        this.setF("ellipsoidAxisDiameter", this.ellipsoidAxisDiameter);
        this.setB("ellipsoidBall", this.ellipsoidBall);
        this.setI("ellipsoidDotCount", this.ellipsoidDotCount);
        this.setB("ellipsoidDots", this.ellipsoidDots);
        this.setB("ellipsoidFill", this.ellipsoidFill);
        this.setO("energyUnits", this.energyUnits);
        this.setF("exportScale", this.exportScale);
        this.setB("fontScaling", this.fontScaling);
        this.setB("fontCaching", this.fontCaching);
        this.setB("forceAutoBond", this.forceAutoBond);
        this.setO("forceField", this.forceField);
        this.setB("fractionalRelative", this.fractionalRelative);
        this.setF("particleRadius", this.particleRadius);
        this.setB("greyscaleRendering", this.greyscaleRendering);
        this.setF("hbondsAngleMinimum", this.hbondsAngleMinimum);
        this.setF("hbondsDistanceMaximum", this.hbondsDistanceMaximum);
        this.setB("hbondsBackbone", this.hbondsBackbone);
        this.setB("hbondsRasmol", this.hbondsRasmol);
        this.setB("hbondsSolid", this.hbondsSolid);
        this.setI("helixStep", this.helixStep);
        this.setO("helpPath", this.helpPath);
        this.setI("hermiteLevel", this.hermiteLevel);
        this.setB("hideNameInPopup", this.hideNameInPopup);
        this.setB("hideNavigationPoint", this.hideNavigationPoint);
        this.setB("hiddenLinesDashed", this.hiddenLinesDashed);
        this.setB("highResolution", this.highResolutionFlag);
        this.setF("hoverDelay", (float)this.hoverDelayMs / 1000.0f);
        this.setB("imageState", this.imageState);
        this.setB("isosurfaceKey", this.isosurfaceKey);
        this.setB("isosurfacePropertySmoothing", this.isosurfacePropertySmoothing);
        this.setI("isosurfacePropertySmoothingPower", this.isosurfacePropertySmoothingPower);
        this.setB("jmolInJSpecView", this.jmolInJSpecView);
        this.setB("justifyMeasurements", this.justifyMeasurements);
        this.setB("legacyAutoBonding", this.legacyAutoBonding);
        this.setB("legacyHAddition", this.legacyHAddition);
        this.setB("legacyJavaFloat", this.legacyJavaFloat);
        this.setF("loadAtomDataTolerance", this.loadAtomDataTolerance);
        this.setO("loadFormat", this.loadFormat);
        this.setO("loadLigandFormat", this.pdbLoadLigandFormat);
        this.setB("logCommands", this.logCommands);
        this.setB("logGestures", this.logGestures);
        this.setB("measureAllModels", this.measureAllModels);
        this.setB("measurementLabels", this.measurementLabels);
        this.setO("measurementUnits", this.measureDistanceUnits);
        this.setI("meshScale", this.meshScale);
        this.setB("messageStyleChime", this.messageStyleChime);
        this.setF("minBondDistance", this.minBondDistance);
        this.setI("minPixelSelRadius", this.minPixelSelRadius);
        this.setI("minimizationSteps", this.minimizationSteps);
        this.setB("minimizationRefresh", this.minimizationRefresh);
        this.setB("minimizationSilent", this.minimizationSilent);
        this.setF("minimizationCriterion", this.minimizationCriterion);
        this.setB("modelKitMode", this.modelKitMode);
        this.setF("modulationScale", this.modulationScale);
        this.setB("monitorEnergy", this.monitorEnergy);
        this.setF("multipleBondRadiusFactor", this.multipleBondRadiusFactor);
        this.setB("multipleBondBananas", this.multipleBondBananas);
        this.setF("multipleBondSpacing", this.multipleBondSpacing);
        this.setB("multiProcessor", this.multiProcessor && Viewer.nProcessors > 1);
        this.setB("navigationMode", this.navigationMode);
        this.setB("navigationPeriodic", this.navigationPeriodic);
        this.setF("navigationSpeed", this.navigationSpeed);
        this.setB("nboCharges", this.nboCharges);
        this.setO("nmrPredictFormat", this.nmrPredictFormat);
        this.setO("nmrUrlFormat", this.nmrUrlFormat);
        this.setB("partialDots", this.partialDots);
        this.setB("pdbAddHydrogens", this.pdbAddHydrogens);
        this.setB("pdbGetHeader", this.pdbGetHeader);
        this.setB("pdbSequential", this.pdbSequential);
        this.setI("percentVdwAtom", this.percentVdwAtom);
        this.setI("pickingSpinRate", this.pickingSpinRate);
        this.setO("pickLabel", this.pickLabel);
        this.setI("platformSpeed", this.platformSpeed);
        this.setF("pointGroupLinearTolerance", this.pointGroupLinearTolerance);
        this.setF("pointGroupDistanceTolerance", this.pointGroupDistanceTolerance);
        this.setB("preserveState", this.preserveState);
        this.setO("propertyColorScheme", this.propertyColorScheme);
        this.setO("quaternionFrame", this.quaternionFrame);
        this.setB("rangeSelected", this.rangeSelected);
        this.setI("repaintWaitMs", this.repaintWaitMs);
        this.setI("ribbonAspectRatio", this.ribbonAspectRatio);
        this.setB("ribbonBorder", this.ribbonBorder);
        this.setB("rocketBarrels", this.rocketBarrels);
        this.setB("saveProteinStructureState", this.saveProteinStructureState);
        this.setB("scriptqueue", this.useScriptQueue);
        this.setB("selectAllModels", this.selectAllModels);
        this.setB("selectHetero", this.rasmolHeteroSetting);
        this.setB("selectHydrogen", this.rasmolHydrogenSetting);
        this.setF("sheetSmoothing", this.sheetSmoothing);
        this.setB("showHiddenSelectionHalos", this.showHiddenSelectionHalos);
        this.setB("showHydrogens", this.showHydrogens);
        this.setB("showKeyStrokes", this.showKeyStrokes);
        this.setB("showMeasurements", this.showMeasurements);
        this.setB("showModulationVectors", this.showModVecs);
        this.setB("showMultipleBonds", this.showMultipleBonds);
        this.setB("showNavigationPointAlways", this.showNavigationPointAlways);
        this.setI("showScript", this.scriptDelay);
        this.setB("showtiming", this.showTiming);
        this.setB("slabByMolecule", this.slabByMolecule);
        this.setB("slabByAtom", this.slabByAtom);
        this.setB("smartAromatic", this.smartAromatic);
        this.setI("smallMoleculeMaxAtoms", this.smallMoleculeMaxAtoms);
        this.setO("smilesUrlFormat", this.smilesUrlFormat);
        this.setO("nihResolverFormat", this.nihResolverFormat);
        this.setO("pubChemFormat", this.pubChemFormat);
        this.setB("showUnitCellDetails", this.showUnitCellDetails);
        this.setB("solventProbe", this.solventOn);
        this.setF("solventProbeRadius", this.solventProbeRadius);
        this.setB("ssbondsBackbone", this.ssbondsBackbone);
        this.setF("starWidth", this.starWidth);
        this.setB("statusReporting", this.statusReporting);
        this.setI("strandCount", this.strandCountForStrands);
        this.setI("strandCountForStrands", this.strandCountForStrands);
        this.setI("strandCountForMeshRibbon", this.strandCountForMeshRibbon);
        this.setF("strutDefaultRadius", this.strutDefaultRadius);
        this.setF("strutLengthMaximum", this.strutLengthMaximum);
        this.setI("strutSpacing", this.strutSpacing);
        this.setB("strutsMultiple", this.strutsMultiple);
        this.setB("testFlag1", this.testFlag1);
        this.setB("testFlag2", this.testFlag2);
        this.setB("testFlag3", this.testFlag3);
        this.setB("testFlag4", this.testFlag4);
        this.setB("traceAlpha", this.traceAlpha);
        this.setB("translucent", this.translucent);
        this.setB("twistedSheets", this.twistedSheets);
        this.setB("useMinimizationThread", this.useMinimizationThread);
        this.setB("useNumberLocalization", this.useNumberLocalization);
        this.setB("vectorsCentered", this.vectorsCentered);
        this.setF("vectorScale", this.vectorScale);
        this.setB("vectorSymmetry", this.vectorSymmetry);
        this.setI("vectorTrail", this.vectorTrail);
        this.setF("vibrationPeriod", this.vibrationPeriod);
        this.setF("vibrationScale", this.vibrationScale);
        this.setB("waitForMoveTo", this.waitForMoveTo);
        this.setB("wireframeRotation", this.wireframeRotation);
        this.setI("zDepth", this.zDepth);
        this.setB("zeroBasedXyzRasmol", this.zeroBasedXyzRasmol);
        this.setB("zoomHeight", this.zoomHeight);
        this.setB("zoomLarge", this.zoomLarge);
        this.setI("zShadePower", this.zShadePower);
        this.setI("zSlab", this.zSlab);
    }

    void clear() {
        Iterator<String> e = this.htUserVariables.keySet().iterator();
        while (e.hasNext()) {
            String key = e.next();
            if (key.charAt(0) != '@' && !key.startsWith("site_")) continue;
            e.remove();
        }
        this.vwr.setPicked(-1);
        this.setI("_atomhovered", -1);
        this.setO("_pickinfo", "");
        this.setB("selectionhalos", false);
        this.setB("hidenotselected", false);
        this.measurementLabels = true;
        this.setB("measurementlabels", true);
        this.drawHover = false;
        this.setB("drawHover", false);
        this.vwr.stm.saveScene("DELETE", null);
    }

    void setUnits(String units) {
        String mu = this.measureDistanceUnits;
        String eu = this.energyUnits;
        if (units.equalsIgnoreCase("angstroms")) {
            this.measureDistanceUnits = "angstroms";
        } else if (units.equalsIgnoreCase("nanometers") || units.equalsIgnoreCase("nm")) {
            this.measureDistanceUnits = "nanometers";
        } else if (units.equalsIgnoreCase("picometers") || units.equalsIgnoreCase("pm")) {
            this.measureDistanceUnits = "picometers";
        } else if (units.equalsIgnoreCase("bohr") || units.equalsIgnoreCase("au")) {
            this.measureDistanceUnits = "au";
        } else if (units.equalsIgnoreCase("vanderwaals") || units.equalsIgnoreCase("vdw")) {
            this.measureDistanceUnits = "vdw";
        } else if (units.toLowerCase().endsWith("hz") || units.toLowerCase().endsWith("khz")) {
            this.measureDistanceUnits = units.toLowerCase();
        } else if (units.equalsIgnoreCase("kj")) {
            this.energyUnits = "kJ";
        } else if (units.equalsIgnoreCase("kcal")) {
            this.energyUnits = "kcal";
        }
        if (!mu.equalsIgnoreCase(this.measureDistanceUnits)) {
            this.setO("measurementUnits", this.measureDistanceUnits);
        } else if (!eu.equalsIgnoreCase(this.energyUnits)) {
            this.setO("energyUnits", this.energyUnits);
        }
    }

    boolean isJmolVariable(String key) {
        return key.charAt(0) == '_' || this.htNonbooleanParameterValues.containsKey(key = key.toLowerCase()) || this.htBooleanParameterFlags.containsKey(key) || unreportedProperties.indexOf(";" + key + ";") >= 0;
    }

    private void resetValue(String name, GlobalSettings g) {
        this.setO(name, g == null ? "" : (String)g.getParameter(name, true));
    }

    public void setB(String name, boolean value) {
        if (this.htNonbooleanParameterValues.containsKey(name = name.toLowerCase())) {
            return;
        }
        this.htBooleanParameterFlags.put(name, value ? Boolean.TRUE : Boolean.FALSE);
    }

    void setI(String name, int value) {
        if (value != Integer.MAX_VALUE) {
            this.setO(name, value);
        }
    }

    public void setF(String name, float value) {
        if (!Float.isNaN(value)) {
            this.setO(name, Float.valueOf(value));
        }
    }

    void setO(String name, Object value) {
        name = name.toLowerCase();
        if (value == null || this.htBooleanParameterFlags.containsKey(name)) {
            return;
        }
        this.htNonbooleanParameterValues.put(name, value);
    }

    public void removeParam(String key) {
        if (this.htBooleanParameterFlags.containsKey(key = key.toLowerCase())) {
            this.htBooleanParameterFlags.remove(key);
            if (!this.htPropertyFlagsRemoved.containsKey(key)) {
                this.htPropertyFlagsRemoved.put(key, Boolean.FALSE);
            }
            return;
        }
        if (this.htNonbooleanParameterValues.containsKey(key)) {
            this.htNonbooleanParameterValues.remove(key);
        }
    }

    public SV setUserVariable(String key, SV var) {
        if (var != null) {
            key = key.toLowerCase();
            this.htUserVariables.put(key, var.setName(key));
        }
        return var;
    }

    void unsetUserVariable(String key) {
        if (key.equals("all") || key.equals("variables")) {
            this.htUserVariables.clear();
            Logger.info("all user-defined variables deleted");
        } else if (this.htUserVariables.containsKey(key)) {
            Logger.info("variable " + key + " deleted");
            this.htUserVariables.remove(key);
        }
    }

    void removeUserVariable(String key) {
        this.htUserVariables.remove(key);
    }

    SV getUserVariable(String name) {
        if (name == null) {
            return null;
        }
        name = name.toLowerCase();
        return this.htUserVariables.get(name);
    }

    String getParameterEscaped(String name, int nMax) {
        if (this.htNonbooleanParameterValues.containsKey(name = name.toLowerCase())) {
            Object v = this.htNonbooleanParameterValues.get(name);
            return StateManager.varClip(name, Escape.e(v), nMax);
        }
        if (this.htBooleanParameterFlags.containsKey(name)) {
            return this.htBooleanParameterFlags.get(name).toString();
        }
        if (this.htUserVariables.containsKey(name)) {
            return this.htUserVariables.get(name).escape();
        }
        if (this.htPropertyFlagsRemoved.containsKey(name)) {
            return "false";
        }
        return "<not defined>";
    }

    Object getParameter(String name, boolean nullAsString) {
        Object v = this.getParam(name, false);
        return v == null && nullAsString ? "" : v;
    }

    public SV getAndSetNewVariable(String name, boolean doSet) {
        Object v;
        if (name == null || name.length() == 0) {
            name = "x";
        }
        return (v = this.getParam(name, true)) == null && doSet && name.charAt(0) != '_' ? this.setUserVariable(name, SV.newV(4, "")) : SV.getVariable(v);
    }

    Object getParam(String name, boolean asVariable) {
        if ((name = name.toLowerCase()).equals("_memory")) {
            float bTotal = 0.0f;
            float bFree = 0.0f;
            Runtime runtime = Runtime.getRuntime();
            bTotal = (float)runtime.totalMemory() / 1000000.0f;
            bFree = (float)runtime.freeMemory() / 1000000.0f;
            String value = DF.formatDecimal(bTotal - bFree, 1) + "/" + DF.formatDecimal(bTotal, 1);
            this.htNonbooleanParameterValues.put("_memory", value);
        }
        if (this.htNonbooleanParameterValues.containsKey(name)) {
            return this.htNonbooleanParameterValues.get(name);
        }
        if (this.htBooleanParameterFlags.containsKey(name)) {
            return this.htBooleanParameterFlags.get(name);
        }
        if (this.htPropertyFlagsRemoved.containsKey(name)) {
            return Boolean.FALSE;
        }
        if (this.htUserVariables.containsKey(name)) {
            SV v = this.htUserVariables.get(name);
            return asVariable ? v : SV.oValue(v);
        }
        return null;
    }

    public String getVariableList() {
        return StateManager.getVariableList(this.htUserVariables, 0, true, false);
    }

    public void setStructureList(float[] list, STR type) {
        this.haveSetStructureList = true;
        this.structureList.put(type, list);
    }

    public Map<STR, float[]> getStructureList() {
        return this.structureList;
    }

    String resolveDataBase(String database, String id, String format) {
        int n;
        if (format == null) {
            format = this.databases.get(database.toLowerCase());
            if (format == null) {
                return null;
            }
            int pt = id.indexOf("/");
            if (pt < 0) {
                if (database.equals("pubchem")) {
                    id = "name/" + id;
                } else if (database.equals("nci")) {
                    id = id + "/file?format=sdf&get3d=true";
                }
            }
            if (format.startsWith("'")) {
                pt = id.indexOf(".");
                int n2 = n = pt > 0 ? PT.parseInt(id.substring(pt + 1)) : 0;
                if (pt > 0) {
                    id = id.substring(0, pt);
                }
                format = PT.rep(format, "%n", "" + n);
            }
        } else if (id.indexOf(".") >= 0 && format.indexOf("%FILE.") >= 0) {
            format = format.substring(0, format.indexOf("%FILE"));
        }
        if (format.indexOf("%c") >= 0) {
            n = id.length();
            for (int i = 1; i <= n; ++i) {
                if (format.indexOf("%c" + i) < 0) continue;
                format = PT.rep(format, "%c" + i, id.substring(i - 1, i).toLowerCase());
            }
        }
        return format.indexOf("%FILE") >= 0 ? PT.rep(format, "%FILE", id) : (format.indexOf("%file") >= 0 ? PT.rep(format, "%file", id.toLowerCase()) : format + id);
    }

    public String[] fixSurfaceFileNameVariables(String id) {
        boolean isDiff = id.startsWith("=");
        if (isDiff) {
            id = id.substring(1);
        }
        String server = this.resolveDataBase(null, id, isDiff ? this.edsUrlFormatDiff : this.edsUrlFormat);
        String strCutoff = this.resolveDataBase(null, id, this.edsUrlCutoff);
        return new String[]{server, strCutoff, isDiff ? "diff" : null};
    }

    static boolean doReportProperty(String name) {
        return name.charAt(0) != '_' && unreportedProperties.indexOf(";" + name + ";") < 0;
    }

    private void getDataBaseList(String[] list) {
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.length; i += 2) {
            this.databases.put(list[i].toLowerCase(), list[i + 1]);
        }
    }

    Object getAllVariables() {
        Hashtable<String, Object> map = new Hashtable<String, Object>();
        map.putAll(this.htBooleanParameterFlags);
        map.putAll(this.htNonbooleanParameterValues);
        map.putAll(this.htUserVariables);
        return map;
    }

    String getLoadState(Map<String, Object> htParams) {
        SB str = new SB();
        this.app(str, "set allowEmbeddedScripts false");
        if (this.allowEmbeddedScripts) {
            this.setB("allowEmbeddedScripts", true);
        }
        this.app(str, "set appendNew " + this.appendNew);
        this.app(str, "set appletProxy " + PT.esc(this.appletProxy));
        this.app(str, "set applySymmetryToBonds " + this.applySymmetryToBonds);
        if (this.atomTypes.length() > 0) {
            this.app(str, "set atomTypes " + PT.esc(this.atomTypes));
        }
        this.app(str, "set autoBond " + this.autoBond);
        if (this.axesOrientationRasmol) {
            this.app(str, "set axesOrientationRasmol true");
        }
        this.app(str, "set bondRadiusMilliAngstroms " + this.bondRadiusMilliAngstroms);
        this.app(str, "set bondTolerance " + this.bondTolerance);
        this.app(str, "set defaultLattice " + Escape.eP(this.ptDefaultLattice));
        this.app(str, "set defaultLoadFilter " + PT.esc(this.defaultLoadFilter));
        this.app(str, "set defaultLoadScript \"\"");
        if (this.defaultLoadScript.length() > 0) {
            this.setO("defaultLoadScript", this.defaultLoadScript);
        }
        this.app(str, "set defaultStructureDssp " + this.defaultStructureDSSP);
        String sMode = this.vwr.getDefaultVdwNameOrData(Integer.MIN_VALUE, null, null);
        this.app(str, "set defaultVDW " + sMode);
        if (sMode.equals("User")) {
            this.app(str, this.vwr.getDefaultVdwNameOrData(Integer.MAX_VALUE, null, null));
        }
        this.app(str, "set forceAutoBond " + this.forceAutoBond);
        this.app(str, "#set defaultDirectory " + PT.esc(this.defaultDirectory));
        this.app(str, "#set loadFormat " + PT.esc(this.loadFormat));
        this.app(str, "#set loadLigandFormat " + PT.esc(this.pdbLoadLigandFormat));
        this.app(str, "#set smilesUrlFormat " + PT.esc(this.smilesUrlFormat));
        this.app(str, "#set nihResolverFormat " + PT.esc(this.nihResolverFormat));
        this.app(str, "#set pubChemFormat " + PT.esc(this.pubChemFormat));
        this.app(str, "#set edsUrlFormat " + PT.esc(this.edsUrlFormat));
        this.app(str, "#set edsUrlFormatDiff " + PT.esc(this.edsUrlFormatDiff));
        this.app(str, "#set edsUrlCutoff " + PT.esc(this.edsUrlCutoff));
        this.app(str, "set bondingVersion " + this.bondingVersion);
        this.app(str, "set legacyAutoBonding " + this.legacyAutoBonding);
        this.app(str, "set legacyAutoBonding " + this.legacyAutoBonding);
        this.app(str, "set legacyHAddition " + this.legacyHAddition);
        this.app(str, "set legacyJavaFloat " + this.legacyJavaFloat);
        this.app(str, "set minBondDistance " + this.minBondDistance);
        this.app(str, "set minimizationCriterion  " + this.minimizationCriterion);
        this.app(str, "set minimizationSteps  " + this.minimizationSteps);
        this.app(str, "set multipleBondBananas false");
        this.app(str, "set pdbAddHydrogens " + (htParams != null && htParams.get("pdbNoHydrogens") != Boolean.TRUE ? this.pdbAddHydrogens : false));
        this.app(str, "set pdbGetHeader " + this.pdbGetHeader);
        this.app(str, "set pdbSequential " + this.pdbSequential);
        this.app(str, "set percentVdwAtom " + this.percentVdwAtom);
        this.app(str, "set smallMoleculeMaxAtoms " + this.smallMoleculeMaxAtoms);
        this.app(str, "set smartAromatic " + this.smartAromatic);
        if (this.zeroBasedXyzRasmol) {
            this.app(str, "set zeroBasedXyzRasmol true");
        }
        return str.toString();
    }

    private void app(SB s, String cmd) {
        if (cmd.length() == 0) {
            return;
        }
        s.append("  ").append(cmd).append(";\n");
    }
}

