/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.text.NumberFormat;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.projection.ProjectionPreference;
import org.openstreetmap.josm.tools.I18n;

public class SystemOfMeasurement {
    public static final SystemOfMeasurement METRIC = new SystemOfMeasurement(1.0, "m", 1000.0, "km", "km/h", 3.6, 10000.0, "ha");
    public static final SystemOfMeasurement CHINESE = new SystemOfMeasurement(0.3333333333333333, "\u5e02\u5c3a", 500.0, "\u5e02\u91cc", "km/h", 3.6, 666.6666666666666, "\u4ea9");
    public static final SystemOfMeasurement IMPERIAL = new SystemOfMeasurement(0.3048, "ft", 1609.344, "mi", "mph", 2.23694, 4046.86, "ac");
    public static final SystemOfMeasurement NAUTICAL_MILE = new SystemOfMeasurement(185.2, "kbl", 1852.0, "NM", "kn", 1.94384);
    public static final Map<String, SystemOfMeasurement> ALL_SYSTEMS;
    private static final CopyOnWriteArrayList<SoMChangeListener> somChangeListeners;
    public final double aValue;
    public final double bValue;
    public final String aName;
    public final String bName;
    public final double speedValue;
    public final String speedName;
    public final double areaCustomValue;
    public final String areaCustomName;

    public static void removeSoMChangeListener(SoMChangeListener soMChangeListener) {
        somChangeListeners.remove(soMChangeListener);
    }

    public static void addSoMChangeListener(SoMChangeListener soMChangeListener) {
        if (soMChangeListener != null) {
            somChangeListeners.addIfAbsent(soMChangeListener);
        }
    }

    protected static void fireSoMChanged(String string, String string2) {
        for (SoMChangeListener soMChangeListener : somChangeListeners) {
            soMChangeListener.systemOfMeasurementChanged(string, string2);
        }
    }

    public static SystemOfMeasurement getSystemOfMeasurement() {
        return Optional.ofNullable(ALL_SYSTEMS.get(ProjectionPreference.PROP_SYSTEM_OF_MEASUREMENT.get())).orElse(METRIC);
    }

    public static void setSystemOfMeasurement(String string) {
        if (!ALL_SYSTEMS.containsKey(string)) {
            throw new IllegalArgumentException("Invalid system of measurement: " + string);
        }
        String string2 = ProjectionPreference.PROP_SYSTEM_OF_MEASUREMENT.get();
        if (ProjectionPreference.PROP_SYSTEM_OF_MEASUREMENT.put(string)) {
            SystemOfMeasurement.fireSoMChanged(string2, string);
        }
    }

    public SystemOfMeasurement(double d, String string, double d2, String string2, String string3, double d3) {
        this(d, string, d2, string2, string3, d3, -1.0, null);
    }

    public SystemOfMeasurement(double d, String string, double d2, String string2, String string3, double d3, double d4, String string4) {
        this.aValue = d;
        this.aName = string;
        this.bValue = d2;
        this.bName = string2;
        this.speedValue = d3;
        this.speedName = string3;
        this.areaCustomValue = d4;
        this.areaCustomName = string4;
    }

    public String getDistText(double d) {
        return this.getDistText(d, null, 0.01);
    }

    public String getDistText(double d, NumberFormat numberFormat, double d2) {
        double d3 = d / this.aValue;
        if (d3 > this.bValue / this.aValue && !Main.pref.getBoolean("system_of_measurement.use_only_lower_unit", false)) {
            return SystemOfMeasurement.formatText(d / this.bValue, this.bName, numberFormat);
        }
        if (d3 < d2) {
            return "< " + SystemOfMeasurement.formatText(d2, this.aName, numberFormat);
        }
        return SystemOfMeasurement.formatText(d3, this.aName, numberFormat);
    }

    public String getAreaText(double d) {
        return this.getAreaText(d, null, 0.01);
    }

    public String getAreaText(double d, NumberFormat numberFormat, double d2) {
        double d3 = d / (this.aValue * this.aValue);
        boolean bl = Main.pref.getBoolean("system_of_measurement.use_only_lower_unit", false);
        boolean bl2 = Main.pref.getBoolean("system_of_measurement.use_only_custom_area_unit", false);
        if (!bl && this.areaCustomValue > 0.0 && d3 > this.areaCustomValue / (this.aValue * this.aValue) && d3 < this.bValue * this.bValue / (this.aValue * this.aValue) || bl2) {
            return SystemOfMeasurement.formatText(d / this.areaCustomValue, this.areaCustomName, numberFormat);
        }
        if (!bl && d3 >= this.bValue * this.bValue / (this.aValue * this.aValue)) {
            return SystemOfMeasurement.formatText(d / (this.bValue * this.bValue), this.bName + '\u00b2', numberFormat);
        }
        if (d3 < d2) {
            return "< " + SystemOfMeasurement.formatText(d2, this.aName + '\u00b2', numberFormat);
        }
        return SystemOfMeasurement.formatText(d3, this.aName + '\u00b2', numberFormat);
    }

    private static String formatText(double d, String string, NumberFormat numberFormat) {
        if (numberFormat != null) {
            return numberFormat.format(d) + ' ' + string;
        }
        return String.format(Locale.US, d < 9.999999 ? "%.2f %s" : "%.1f %s", d, string);
    }

    static {
        LinkedHashMap<String, SystemOfMeasurement> linkedHashMap = new LinkedHashMap<String, SystemOfMeasurement>();
        linkedHashMap.put(I18n.marktr("Metric"), METRIC);
        linkedHashMap.put(I18n.marktr("Chinese"), CHINESE);
        linkedHashMap.put(I18n.marktr("Imperial"), IMPERIAL);
        linkedHashMap.put(I18n.marktr("Nautical Mile"), NAUTICAL_MILE);
        ALL_SYSTEMS = Collections.unmodifiableMap(linkedHashMap);
        somChangeListeners = new CopyOnWriteArrayList();
    }

    @FunctionalInterface
    public static interface SoMChangeListener {
        public void systemOfMeasurementChanged(String var1, String var2);
    }
}

