/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair.tags;

import java.awt.Adjustable;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.conflict.pair.AbstractMergePanel;
import org.openstreetmap.josm.gui.conflict.pair.IConflictResolver;
import org.openstreetmap.josm.gui.conflict.pair.MergeDecisionType;
import org.openstreetmap.josm.gui.conflict.pair.tags.MergedTableCellRenderer;
import org.openstreetmap.josm.gui.conflict.pair.tags.MineTableCellRenderer;
import org.openstreetmap.josm.gui.conflict.pair.tags.TagMergeModel;
import org.openstreetmap.josm.gui.conflict.pair.tags.TagMergeTableCellRenderer;
import org.openstreetmap.josm.gui.conflict.pair.tags.TheirTableCellRenderer;
import org.openstreetmap.josm.gui.tagging.TagTableColumnModelBuilder;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class TagMerger
extends AbstractMergePanel
implements IConflictResolver {
    private static final String[] KEY_VALUE = new String[]{I18n.tr("Key", new Object[0]), I18n.tr("Value", new Object[0])};
    private final TagMergeModel model = new TagMergeModel();
    private final JTable mineTable = this.generateTable(new MineTableCellRenderer());
    private final JTable mergedTable = this.generateTable(new MergedTableCellRenderer());
    private final JTable theirTable = this.generateTable(new TheirTableCellRenderer());

    public TagMerger() {
        this.mineTable.setName("table.my");
        this.theirTable.setName("table.their");
        this.mergedTable.setName("table.merged");
        DoubleClickAdapter doubleClickAdapter = new DoubleClickAdapter();
        this.mineTable.addMouseListener(doubleClickAdapter);
        this.theirTable.addMouseListener(doubleClickAdapter);
        this.buildRows();
    }

    private JTable generateTable(TagMergeTableCellRenderer tagMergeTableCellRenderer) {
        return new JTable(this.model, new TagTableColumnModelBuilder(tagMergeTableCellRenderer, KEY_VALUE).build());
    }

    @Override
    protected List<? extends AbstractMergePanel.MergeRow> getRows() {
        return Arrays.asList(new AbstractMergePanel.TitleRow(), new TagTableRow(), new UndecidedRow());
    }

    public TagMergeModel getModel() {
        return this.model;
    }

    private void selectNextConflict(int ... nArray) {
        int n = nArray[0];
        for (int n2 : nArray) {
            if (n2 <= n) continue;
            n = n2;
        }
        int n3 = this.model.getFirstUndecided(n + 1);
        if (n3 == -1) {
            n3 = this.model.getFirstUndecided(0);
        }
        this.mineTable.getSelectionModel().setSelectionInterval(n3, n3);
        this.theirTable.getSelectionModel().setSelectionInterval(n3, n3);
    }

    @Override
    public void deletePrimitive(boolean bl) {
        MergeDecisionType mergeDecisionType = bl ? MergeDecisionType.KEEP_MINE : MergeDecisionType.UNDECIDED;
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            this.model.decide(i, mergeDecisionType);
        }
    }

    @Override
    public void populate(Conflict<? extends OsmPrimitive> conflict) {
        this.model.populate(conflict.getMy(), conflict.getTheir());
        for (JTable jTable : new JTable[]{this.mineTable, this.theirTable}) {
            int n = jTable.getRowCount() > 0 ? 0 : -1;
            jTable.getSelectionModel().setSelectionInterval(n, n);
        }
    }

    @Override
    public void decideRemaining(MergeDecisionType mergeDecisionType) {
        this.model.decideRemaining(mergeDecisionType);
    }

    class UndecideAction
    extends AbstractAction
    implements ListSelectionListener {
        UndecideAction() {
            ImageIcon imageIcon = ImageProvider.get("dialogs/conflict", "tagundecide");
            if (imageIcon != null) {
                this.putValue("SmallIcon", imageIcon);
                this.putValue("Name", "");
            } else {
                this.putValue("Name", I18n.tr("Undecide", new Object[0]));
            }
            this.putValue("ShortDescription", I18n.tr("Mark the selected tags as undecided", new Object[0]));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = TagMerger.this.mergedTable.getSelectedRows();
            if (nArray.length == 0) {
                return;
            }
            TagMerger.this.model.decide(nArray, MergeDecisionType.UNDECIDED);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(TagMerger.this.mergedTable.getSelectedRowCount() > 0);
        }
    }

    class DoubleClickAdapter
    extends MouseAdapter {
        DoubleClickAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            MergeDecisionType mergeDecisionType;
            JTable jTable;
            if (mouseEvent.getClickCount() != 2) {
                return;
            }
            if (mouseEvent.getSource() == TagMerger.this.mineTable) {
                jTable = TagMerger.this.mineTable;
                mergeDecisionType = MergeDecisionType.KEEP_MINE;
            } else if (mouseEvent.getSource() == TagMerger.this.theirTable) {
                jTable = TagMerger.this.theirTable;
                mergeDecisionType = MergeDecisionType.KEEP_THEIR;
            } else if (mouseEvent.getSource() == TagMerger.this.mergedTable) {
                jTable = TagMerger.this.mergedTable;
                mergeDecisionType = MergeDecisionType.UNDECIDED;
            } else {
                return;
            }
            int n = jTable.rowAtPoint(mouseEvent.getPoint());
            TagMerger.this.model.decide(n, mergeDecisionType);
        }
    }

    static class AdjustmentSynchronizer
    implements AdjustmentListener {
        private final Set<Adjustable> synchronizedAdjustables = new HashSet<Adjustable>();

        AdjustmentSynchronizer() {
        }

        public void synchronizeAdjustment(Adjustable adjustable) {
            if (adjustable == null) {
                return;
            }
            if (this.synchronizedAdjustables.contains(adjustable)) {
                return;
            }
            this.synchronizedAdjustables.add(adjustable);
            adjustable.addAdjustmentListener(this);
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            for (Adjustable adjustable : this.synchronizedAdjustables) {
                if (adjustable == adjustmentEvent.getAdjustable()) continue;
                adjustable.setValue(adjustmentEvent.getValue());
            }
        }
    }

    class KeepTheirAction
    extends AbstractAction
    implements ListSelectionListener {
        KeepTheirAction() {
            ImageIcon imageIcon = ImageProvider.get("dialogs/conflict", "tagkeeptheir");
            if (imageIcon != null) {
                this.putValue("SmallIcon", imageIcon);
                this.putValue("Name", "");
            } else {
                this.putValue("Name", ">");
            }
            this.putValue("ShortDescription", I18n.tr("Keep the selected key/value pairs from the server dataset", new Object[0]));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = TagMerger.this.theirTable.getSelectedRows();
            if (nArray.length == 0) {
                return;
            }
            TagMerger.this.model.decide(nArray, MergeDecisionType.KEEP_THEIR);
            TagMerger.this.selectNextConflict(nArray);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(TagMerger.this.theirTable.getSelectedRowCount() > 0);
        }
    }

    class KeepMineAction
    extends AbstractAction
    implements ListSelectionListener {
        KeepMineAction() {
            ImageIcon imageIcon = ImageProvider.get("dialogs/conflict", "tagkeepmine");
            if (imageIcon != null) {
                this.putValue("SmallIcon", imageIcon);
                this.putValue("Name", "");
            } else {
                this.putValue("Name", ">");
            }
            this.putValue("ShortDescription", I18n.tr("Keep the selected key/value pairs from the local dataset", new Object[0]));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = TagMerger.this.mineTable.getSelectedRows();
            if (nArray.length == 0) {
                return;
            }
            TagMerger.this.model.decide(nArray, MergeDecisionType.KEEP_MINE);
            TagMerger.this.selectNextConflict(nArray);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(TagMerger.this.mineTable.getSelectedRowCount() > 0);
        }
    }

    private final class UndecidedRow
    extends AbstractMergePanel.AbstractUndecideRow {
        private UndecidedRow() {
        }

        @Override
        protected AbstractAction createAction() {
            UndecideAction undecideAction = new UndecideAction();
            TagMerger.this.mergedTable.getSelectionModel().addListSelectionListener(undecideAction);
            return undecideAction;
        }

        @Override
        protected String getButtonName() {
            return "button.undecide";
        }
    }

    private final class TagTableRow
    extends AbstractMergePanel.MergeRow {
        private final AdjustmentSynchronizer adjustmentSynchronizer = new AdjustmentSynchronizer();

        private TagTableRow() {
        }

        JScrollPane embeddInScrollPane(JTable jTable) {
            JScrollPane jScrollPane = new JScrollPane(jTable);
            this.adjustmentSynchronizer.synchronizeAdjustment(jScrollPane.getVerticalScrollBar());
            return jScrollPane;
        }

        @Override
        protected JComponent mineField() {
            return this.embeddInScrollPane(TagMerger.this.mineTable);
        }

        @Override
        protected JComponent mineButton() {
            KeepMineAction keepMineAction = new KeepMineAction();
            TagMerger.this.mineTable.getSelectionModel().addListSelectionListener(keepMineAction);
            JButton jButton = new JButton(keepMineAction);
            jButton.setName("button.keepmine");
            return jButton;
        }

        @Override
        protected JComponent merged() {
            return this.embeddInScrollPane(TagMerger.this.mergedTable);
        }

        @Override
        protected JComponent theirsButton() {
            KeepTheirAction keepTheirAction = new KeepTheirAction();
            TagMerger.this.theirTable.getSelectionModel().addListSelectionListener(keepTheirAction);
            JButton jButton = new JButton(keepTheirAction);
            jButton.setName("button.keeptheir");
            return jButton;
        }

        @Override
        protected JComponent theirsField() {
            return this.embeddInScrollPane(TagMerger.this.theirTable);
        }

        @Override
        protected void addConstraints(GBC gBC, int n) {
            super.addConstraints(gBC, n);
            gBC.weighty = 1.0;
        }
    }
}

