/*
 * Decompiled with CFR 0.152.
 */
package com.mentorgen.tools.profile.output;

import com.mentorgen.tools.profile.Controller;
import com.mentorgen.tools.profile.output.Math;
import com.mentorgen.tools.profile.runtime.Frame;
import java.io.PrintWriter;

final class FrameDump {
    private static final String NEW_LINE = System.getProperty("line.separator");

    FrameDump() {
    }

    static void dump(PrintWriter printWriter, Frame frame, int n) {
        if (Controller._compactThreadDepth) {
            if (!frame.hasChildren()) {
                return;
            }
            boolean bl = false;
            for (Frame frame2 : frame.childIterator()) {
                if (FrameDump.belowThreshold(frame2) && !frame2.hasChildren()) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return;
            }
        }
        printWriter.print("+------------------------------");
        printWriter.print(NEW_LINE);
        printWriter.print("| Thread: ");
        printWriter.print(frame.getThreadId());
        if (n > 1) {
            printWriter.print(" (interaction #");
            printWriter.print(n);
            printWriter.print(")");
        }
        printWriter.print(NEW_LINE);
        printWriter.print("+------------------------------");
        printWriter.print(NEW_LINE);
        printWriter.print("              Time            Percent    ");
        printWriter.print(NEW_LINE);
        printWriter.print("       ----------------- ---------------");
        printWriter.print(NEW_LINE);
        printWriter.print(" Count    Total      Net   Total     Net  Location");
        printWriter.print(NEW_LINE);
        printWriter.print(" =====    =====      ===   =====     ===  =========");
        printWriter.print(NEW_LINE);
        long l = frame._metrics.getTotalTime();
        FrameDump.dump(printWriter, 0, frame, l);
    }

    private static void dump(PrintWriter printWriter, int n, Frame frame, double d) {
        double d2;
        long l = frame._metrics.getTotalTime();
        long l2 = frame.netTime();
        printWriter.printf("%6d ", frame._metrics.getCount());
        printWriter.printf("%8.1f ", Math.nanoToMilli(l));
        printWriter.printf("%8.1f ", Math.nanoToMilli(l2));
        if (l > 0L) {
            d2 = Math.toPercent(l, d);
            printWriter.printf("%7.1f ", d2);
        } else {
            printWriter.print("        ");
        }
        if (l2 > 0L && d > 0.0) {
            d2 = Math.toPercent(l2, d);
            if (d2 > 0.1) {
                printWriter.printf("%7.1f ", d2);
            } else {
                printWriter.print("        ");
            }
        } else {
            printWriter.print("        ");
        }
        printWriter.print(" ");
        for (int i = 0; i < n; ++i) {
            printWriter.print("| ");
        }
        printWriter.print("+--");
        printWriter.print(frame.getInvertedName());
        printWriter.print(NEW_LINE);
        if (Controller._threadDepth != -1 && n == Controller._threadDepth - 1) {
            return;
        }
        for (Frame frame2 : frame.childIterator()) {
            if (FrameDump.belowThreshold(frame2)) continue;
            FrameDump.dump(printWriter, n + 1, frame2, d);
        }
    }

    private static boolean belowThreshold(Frame frame) {
        return Controller._compactThreadDepth && frame._metrics.getTotalTime() < (long)(Controller._compactThreadThreshold * 1000000);
    }
}

