/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.tower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForTypeAliasObject;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.resolve.scopes.SyntheticConstructorsProvider;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u00022\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u001a\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\t\u001a\u0012\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r*\u00020\tH\u0002\u001a\u001e\u0010\u000f\u001a\u0004\u0018\u00010\t*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a*\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\r*\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a\"\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\r*\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a$\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\r*\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\u00a8\u0006\u001c"}, d2={"canHaveCallableConstructors", "", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getCanHaveCallableConstructors", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;)Z", "Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;)Z", "getClassWithConstructors", "classifier", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "getFakeDescriptorForObject", "Lorg/jetbrains/kotlin/resolve/calls/util/FakeCallableDescriptorForObject;", "getCallableConstructors", "", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getClassifierFromMeAndSuperclasses", "Lorg/jetbrains/kotlin/types/KotlinType;", "name", "Lorg/jetbrains/kotlin/name/Name;", "location", "Lorg/jetbrains/kotlin/incremental/components/LookupLocation;", "getContributedFunctionsAndConstructors", "Lorg/jetbrains/kotlin/resolve/scopes/ResolutionScope;", "syntheticConstructorsProvider", "Lorg/jetbrains/kotlin/resolve/scopes/SyntheticConstructorsProvider;", "getContributedObjectVariables", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "getInnerConstructors", "kotlin-compiler"})
public final class TowerLevelsKt {
    private static final ClassifierDescriptor getClassifierFromMeAndSuperclasses(@NotNull KotlinType $receiver, Name name, LookupLocation location2) {
        KotlinType superclass = $receiver;
        while (superclass != null) {
            ClassifierDescriptor classifierDescriptor = superclass.getMemberScope().getContributedClassifier(name, location2);
            if (classifierDescriptor != null) {
                ClassifierDescriptor classifierDescriptor2;
                ClassifierDescriptor it = classifierDescriptor2 = classifierDescriptor;
                return it;
            }
            superclass = TypeUtilsKt.getImmediateSuperclassNotAny(superclass);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static final Collection<FunctionDescriptor> getInnerConstructors(@Nullable KotlinType $receiver, Name name, LookupLocation location2) {
        Collection collection;
        KotlinType kotlinType = $receiver;
        ClassDescriptor classifierDescriptor = TowerLevelsKt.getClassWithConstructors(kotlinType != null ? TowerLevelsKt.getClassifierFromMeAndSuperclasses(kotlinType, name, location2) : null);
        Object object = classifierDescriptor;
        if (object != null && (object = object.getConstructors()) != null) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)object;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                ClassConstructorDescriptor it = (ClassConstructorDescriptor)element$iv$iv;
                if (!(it.getDispatchReceiverParameter() != null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            collection = (List)destination$iv$iv;
        } else {
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }

    private static final Collection<FunctionDescriptor> getContributedFunctionsAndConstructors(@NotNull ResolutionScope $receiver, Name name, LookupLocation location2, SyntheticConstructorsProvider syntheticConstructorsProvider) {
        ArrayList<FunctionDescriptor> result2 = new ArrayList<FunctionDescriptor>($receiver.getContributedFunctions(name, location2));
        ClassifierDescriptor classifier = $receiver.getContributedClassifier(name, location2);
        if (classifier != null) {
            FunctionDescriptor it;
            Iterable $receiver$iv = TowerLevelsKt.getCallableConstructors(classifier);
            for (Object element$iv : $receiver$iv) {
                it = (FunctionDescriptor)element$iv;
                if (!(it.getDispatchReceiverParameter() == null)) continue;
                ((Collection)result2).add(element$iv);
            }
            $receiver$iv = syntheticConstructorsProvider.getSyntheticConstructors(classifier, location2);
            for (Object element$iv : $receiver$iv) {
                it = (FunctionDescriptor)element$iv;
                if (!(it.getDispatchReceiverParameter() == null)) continue;
                ((Collection)result2).add(element$iv);
            }
        }
        return CollectionsKt.toList((Iterable)result2);
    }

    private static final Collection<FunctionDescriptor> getCallableConstructors(@NotNull ClassifierDescriptor $receiver) {
        Collection<ClassConstructorDescriptor> collection;
        ClassifierDescriptor classifierDescriptor = $receiver;
        if (classifierDescriptor instanceof TypeAliasDescriptor) {
            collection = TowerLevelsKt.getCanHaveCallableConstructors((TypeAliasDescriptor)$receiver) ? ((TypeAliasDescriptor)$receiver).getConstructors() : (Collection)CollectionsKt.emptyList();
        } else if (classifierDescriptor instanceof ClassDescriptor) {
            if (TowerLevelsKt.getCanHaveCallableConstructors((ClassDescriptor)$receiver)) {
                Collection<ClassConstructorDescriptor> collection2 = ((ClassDescriptor)$receiver).getConstructors();
                collection = collection2;
                Intrinsics.checkExpressionValueIsNotNull(collection2, "constructors");
            } else {
                collection = CollectionsKt.emptyList();
            }
        } else {
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }

    private static final Collection<VariableDescriptor> getContributedObjectVariables(@NotNull ResolutionScope $receiver, Name name, LookupLocation location2) {
        FakeCallableDescriptorForObject objectDescriptor = TowerLevelsKt.getFakeDescriptorForObject($receiver.getContributedClassifier(name, location2));
        return CollectionsKt.listOfNotNull(objectDescriptor);
    }

    @Nullable
    public static final FakeCallableDescriptorForObject getFakeDescriptorForObject(@Nullable ClassifierDescriptor classifier) {
        FakeCallableDescriptorForObject fakeCallableDescriptorForObject;
        ClassifierDescriptor classifierDescriptor = classifier;
        if (classifierDescriptor instanceof TypeAliasDescriptor) {
            ClassDescriptor classDescriptor;
            ClassDescriptor classDescriptor2;
            ClassDescriptor classDescriptor3 = ((TypeAliasDescriptor)classifier).getClassDescriptor();
            fakeCallableDescriptorForObject = classDescriptor3 != null ? (DescriptorUtilsKt.getHasClassValueDescriptor(classDescriptor2 = (classDescriptor = classDescriptor3)) ? new FakeCallableDescriptorForTypeAliasObject((TypeAliasDescriptor)classifier) : null) : null;
        } else {
            fakeCallableDescriptorForObject = classifierDescriptor instanceof ClassDescriptor ? (DescriptorUtilsKt.getHasClassValueDescriptor((ClassDescriptor)classifier) ? new FakeCallableDescriptorForObject((ClassDescriptor)classifier) : null) : null;
        }
        return fakeCallableDescriptorForObject;
    }

    private static final ClassDescriptor getClassWithConstructors(ClassifierDescriptor classifier) {
        return !(classifier instanceof ClassDescriptor) || !TowerLevelsKt.getCanHaveCallableConstructors((ClassDescriptor)classifier) ? null : (ClassDescriptor)classifier;
    }

    private static final boolean getCanHaveCallableConstructors(@NotNull ClassDescriptor $receiver) {
        return !ErrorUtils.isError($receiver) && !$receiver.getKind().isSingleton();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getCanHaveCallableConstructors(@NotNull TypeAliasDescriptor $receiver) {
        if ($receiver.getClassDescriptor() == null) return false;
        if (ErrorUtils.isError($receiver.getClassDescriptor())) return false;
        ClassDescriptor classDescriptor = $receiver.getClassDescriptor();
        if (classDescriptor == null) {
            Intrinsics.throwNpe();
        }
        if (!TowerLevelsKt.getCanHaveCallableConstructors(classDescriptor)) return false;
        return true;
    }

    @NotNull
    public static final /* synthetic */ Collection access$getInnerConstructors(@Nullable KotlinType $receiver, @NotNull Name name, @NotNull LookupLocation location2) {
        return TowerLevelsKt.getInnerConstructors($receiver, name, location2);
    }

    @NotNull
    public static final /* synthetic */ Collection access$getContributedObjectVariables(@NotNull ResolutionScope $receiver, @NotNull Name name, @NotNull LookupLocation location2) {
        return TowerLevelsKt.getContributedObjectVariables($receiver, name, location2);
    }

    @NotNull
    public static final /* synthetic */ Collection access$getContributedFunctionsAndConstructors(@NotNull ResolutionScope $receiver, @NotNull Name name, @NotNull LookupLocation location2, @NotNull SyntheticConstructorsProvider syntheticConstructorsProvider) {
        return TowerLevelsKt.getContributedFunctionsAndConstructors($receiver, name, location2, syntheticConstructorsProvider);
    }
}

