/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.ResultCache;
import org.languagetool.RuleMatchListener;
import org.languagetool.gui.Configuration;
import org.languagetool.language.LanguageIdentifier;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.RuleMatch;
import org.languagetool.server.HTTPServerConfig;
import org.languagetool.server.ServerTools;
import org.languagetool.server.TextTooLongException;
import org.languagetool.tools.Tools;

abstract class TextChecker {
    protected static final int CONTEXT_SIZE = 40;
    protected final HTTPServerConfig config;
    private static final String ENCODING = "UTF-8";
    private static final int CACHE_STATS_PRINT = 500;
    private final Map<String, Integer> languageCheckCounts = new HashMap<String, Integer>();
    private final boolean internalServer;
    private final LanguageIdentifier identifier;
    private final ExecutorService executorService;
    private final ResultCache cache;

    protected abstract void setHeaders(HttpExchange var1);

    protected abstract String getResponse(String var1, Language var2, Language var3, List<RuleMatch> var4, boolean var5);

    @NotNull
    protected abstract List<String> getPreferredVariants(Map<String, String> var1);

    protected abstract Language getLanguage(String var1, Map<String, String> var2, List<String> var3);

    protected abstract boolean getLanguageAutoDetect(Map<String, String> var1);

    @NotNull
    protected abstract List<String> getEnabledRuleIds(Map<String, String> var1);

    @NotNull
    protected abstract List<String> getDisabledRuleIds(Map<String, String> var1);

    TextChecker(HTTPServerConfig config, boolean internalServer) {
        this.config = config;
        this.internalServer = internalServer;
        this.identifier = new LanguageIdentifier();
        this.executorService = Executors.newCachedThreadPool();
        this.cache = config.getCacheSize() > 0 ? new ResultCache(config.getCacheSize()) : null;
    }

    void shutdownNow() {
        this.executorService.shutdownNow();
    }

    void checkText(final String text, HttpExchange httpExchange, Map<String, String> parameters) throws Exception {
        List<RuleMatch> matches;
        this.checkParams(parameters);
        long timeStart = System.currentTimeMillis();
        if (text.length() > this.config.maxTextLength) {
            throw new TextTooLongException("Your text exceeds this server's limit of " + this.config.maxTextLength + " characters (it's " + text.length() + " characters). Please submit a shorter text.");
        }
        boolean autoDetectLanguage = this.getLanguageAutoDetect(parameters);
        List<String> preferredVariants = this.getPreferredVariants(parameters);
        final Language lang = this.getLanguage(text, parameters, preferredVariants);
        String motherTongueParam = parameters.get("motherTongue");
        final Language motherTongue = motherTongueParam != null ? Languages.getLanguageForShortCode(motherTongueParam) : null;
        boolean useEnabledOnly = "yes".equals(parameters.get("enabledOnly")) || "true".equals(parameters.get("enabledOnly"));
        List<String> enabledRules = this.getEnabledRuleIds(parameters);
        List<String> disabledRules = this.getDisabledRuleIds(parameters);
        List<CategoryId> enabledCategories = this.getCategoryIds("enabledCategories", parameters);
        List<CategoryId> disabledCategories = this.getCategoryIds("disabledCategories", parameters);
        if ((disabledRules.size() > 0 || disabledCategories.size() > 0) && useEnabledOnly) {
            throw new IllegalArgumentException("You cannot specify disabled rules or categories using enabledOnly=true");
        }
        if (enabledRules.size() == 0 && enabledCategories.size() == 0 && useEnabledOnly) {
            throw new IllegalArgumentException("You must specify enabled rules or categories when using enabledOnly=true");
        }
        boolean useQuerySettings = enabledRules.size() > 0 || disabledRules.size() > 0 || enabledCategories.size() > 0 || disabledCategories.size() > 0;
        boolean allowIncompleteResults = "true".equals(parameters.get("allowIncompleteResults"));
        final QueryParams params = new QueryParams(enabledRules, disabledRules, enabledCategories, disabledCategories, useEnabledOnly, useQuerySettings, allowIncompleteResults);
        final List ruleMatchesSoFar = Collections.synchronizedList(new ArrayList());
        Future<List<RuleMatch>> future = this.executorService.submit(new Callable<List<RuleMatch>>(){

            @Override
            public List<RuleMatch> call() throws Exception {
                return TextChecker.this.getRuleMatches(text, lang, motherTongue, params, f -> ruleMatchesSoFar.add(f));
            }
        });
        boolean incompleteResult = false;
        if (this.config.maxCheckTimeMillis < 0L) {
            matches = future.get();
        } else {
            try {
                matches = future.get(this.config.maxCheckTimeMillis, TimeUnit.MILLISECONDS);
            }
            catch (ExecutionException e) {
                if (e.getCause() != null && e.getCause() instanceof OutOfMemoryError) {
                    throw (OutOfMemoryError)e.getCause();
                }
                throw e;
            }
            catch (TimeoutException e) {
                boolean cancelled = future.cancel(true);
                Path loadFile = Paths.get("/proc/loadavg", new String[0]);
                String loadInfo = loadFile.toFile().exists() ? Files.readAllLines(loadFile).toString() : "(unknown)";
                String message = "Text checking took longer than allowed maximum of " + this.config.maxCheckTimeMillis + " milliseconds (cancelled: " + cancelled + ", language: " + lang.getShortCodeWithCountryAndVariant() + ", " + text.length() + " characters of text, system load: " + loadInfo + ")";
                if (params.allowIncompleteResults) {
                    ServerTools.print(message + " - returning " + ruleMatchesSoFar.size() + " matches found so far");
                    matches = new ArrayList<RuleMatch>(ruleMatchesSoFar);
                    incompleteResult = true;
                }
                throw new RuntimeException(message, e);
            }
        }
        this.setHeaders(httpExchange);
        String response = this.getResponse(text, lang, motherTongue, matches, incompleteResult);
        String messageSent = "sent";
        String languageMessage = lang.getShortCodeWithCountryAndVariant();
        String referrer = httpExchange.getRequestHeaders().getFirst("Referer");
        try {
            httpExchange.sendResponseHeaders(200, response.getBytes(ENCODING).length);
            httpExchange.getResponseBody().write(response.getBytes(ENCODING));
        }
        catch (IOException exception) {
            messageSent = "notSent: " + exception.getMessage();
        }
        if (motherTongue != null) {
            languageMessage = languageMessage + " (mother tongue: " + motherTongue.getShortCodeWithCountryAndVariant() + ")";
        }
        if (autoDetectLanguage) {
            languageMessage = languageMessage + "[auto]";
        }
        String agent = parameters.get("useragent") != null ? parameters.get("useragent") : "-";
        Integer count = this.languageCheckCounts.get(lang.getShortCodeWithCountryAndVariant());
        if (count == null) {
            count = 1;
        } else {
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
        }
        this.languageCheckCounts.put(lang.getShortCodeWithCountryAndVariant(), count);
        ServerTools.print("Check done: " + text.length() + " chars, " + languageMessage + ", #" + count + ", " + referrer + ", " + matches.size() + " matches, " + (System.currentTimeMillis() - timeStart) + "ms, agent:" + agent + ", " + messageSent);
    }

    protected void checkParams(Map<String, String> parameters) {
        if (parameters.get("text") == null) {
            throw new IllegalArgumentException("Missing 'text' parameter");
        }
    }

    private List<RuleMatch> getRuleMatches(String text, Language lang, Language motherTongue, QueryParams params, RuleMatchListener listener) throws Exception {
        if (this.cache != null && this.cache.requestCount() % 500.0 == 0.0) {
            String hitPercentage = String.format(Locale.ENGLISH, "%.2f", this.cache.hitRate() * 100.0);
            ServerTools.print("Cache stats: " + hitPercentage + "% hit rate");
        }
        JLanguageTool lt = this.getLanguageToolInstance(lang, motherTongue, params);
        return lt.check(text, listener);
    }

    @NotNull
    private List<CategoryId> getCategoryIds(String paramName, Map<String, String> parameters) {
        List<String> stringIds = this.getCommaSeparatedStrings(paramName, parameters);
        ArrayList<CategoryId> ids = new ArrayList<CategoryId>();
        for (String stringId : stringIds) {
            ids.add(new CategoryId(stringId));
        }
        return ids;
    }

    @NotNull
    protected List<String> getCommaSeparatedStrings(String paramName, Map<String, String> parameters) {
        String disabledParam = parameters.get(paramName);
        ArrayList<String> result = new ArrayList<String>();
        if (disabledParam != null) {
            result.addAll(Arrays.asList(disabledParam.split(",")));
        }
        return result;
    }

    Language detectLanguageOfString(String text, String fallbackLanguage, List<String> preferredVariants) {
        Language lang = this.identifier.detectLanguage(text);
        if (lang == null) {
            lang = Languages.getLanguageForShortCode(fallbackLanguage != null ? fallbackLanguage : "en");
        }
        if (preferredVariants.size() > 0) {
            for (String preferredVariant : preferredVariants) {
                if (!preferredVariant.contains("-")) {
                    throw new IllegalArgumentException("Invalid format for 'preferredVariants', expected a dash as in 'en-GB': '" + preferredVariant + "'");
                }
                String preferredVariantLang = preferredVariant.split("-")[0];
                if (!preferredVariantLang.equals(lang.getShortCode()) || (lang = Languages.getLanguageForShortCode(preferredVariant)) != null) continue;
                throw new IllegalArgumentException("Invalid 'preferredVariants', no such language/variant found: '" + preferredVariant + "'");
            }
        } else if (lang.getDefaultLanguageVariant() != null) {
            lang = lang.getDefaultLanguageVariant();
        }
        return lang;
    }

    private JLanguageTool getLanguageToolInstance(Language lang, Language motherTongue, QueryParams params) throws Exception {
        JLanguageTool lt = new JLanguageTool(lang, motherTongue, this.cache);
        if (this.config.getLanguageModelDir() != null) {
            lt.activateLanguageModelRules(this.config.getLanguageModelDir());
        }
        if (params.useQuerySettings) {
            Tools.selectRules(lt, new HashSet<CategoryId>(params.disabledCategories), new HashSet<CategoryId>(params.enabledCategories), new HashSet<String>(params.disabledRules), new HashSet<String>(params.enabledRules), params.useEnabledOnly);
        } else if (this.config.getRulesConfigFile() != null) {
            this.configureFromRulesFile(lt, lang);
        } else {
            this.configureFromGUI(lt, lang);
        }
        return lt;
    }

    private void configureFromRulesFile(JLanguageTool langTool, Language lang) throws IOException {
        ServerTools.print("Using options configured in " + this.config.getRulesConfigFile());
        if (this.config.getRulesConfigFile() == null) {
            throw new RuntimeException("config.getRulesConfigFile() is null");
        }
        org.languagetool.gui.Tools.configureFromRules(langTool, new Configuration(this.config.getRulesConfigFile().getParentFile(), this.config.getRulesConfigFile().getName(), lang));
    }

    private void configureFromGUI(JLanguageTool langTool, Language lang) throws IOException {
        Configuration config = new Configuration(lang);
        if (this.internalServer && config.getUseGUIConfig()) {
            ServerTools.print("Using options configured in the GUI");
            org.languagetool.gui.Tools.configureFromRules(langTool, config);
        }
    }

    private static class QueryParams {
        final List<String> enabledRules;
        final List<String> disabledRules;
        final List<CategoryId> enabledCategories;
        final List<CategoryId> disabledCategories;
        final boolean useEnabledOnly;
        final boolean useQuerySettings;
        final boolean allowIncompleteResults;

        QueryParams(List<String> enabledRules, List<String> disabledRules, List<CategoryId> enabledCategories, List<CategoryId> disabledCategories, boolean useEnabledOnly, boolean useQuerySettings, boolean allowIncompleteResults) {
            this.enabledRules = enabledRules;
            this.disabledRules = disabledRules;
            this.enabledCategories = enabledCategories;
            this.disabledCategories = disabledCategories;
            this.useEnabledOnly = useEnabledOnly;
            this.useQuerySettings = useQuerySettings;
            this.allowIncompleteResults = allowIncompleteResults;
        }
    }
}

