/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.utils.DisplayUtils;

public abstract class AbstractDialog
extends JDialog {
    private static final long serialVersionUID = -3951504408180103696L;
    protected AbstractDialog thisDialog = null;

    public AbstractDialog() throws HeadlessException {
        this.initialize();
    }

    public AbstractDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initialize();
    }

    public AbstractDialog(Window window, boolean bl) {
        super(window, Dialog.ModalityType.APPLICATION_MODAL);
        this.setModal(bl);
        this.initialize();
    }

    private void initialize() {
        this.setVisible(false);
        this.setIconImages(DisplayUtils.getZapIconImages());
        this.setDefaultCloseOperation(2);
        if (Model.getSingleton().getOptionsParam().getViewParam().getWmUiHandlingOption() == 0) {
            this.setSize(300, 200);
        }
        this.setTitle("OWASP ZAP");
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction abstractAction = new AbstractAction(){
            private static final long serialVersionUID = 3516424501887406165L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractDialog.this.dispatchEvent(new WindowEvent(AbstractDialog.this, 201));
            }
        };
        this.getRootPane().getInputMap(2).put(keyStroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", abstractAction);
    }

    public void centreDialog() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        dimension2.height = Math.min(dimension2.height, dimension.height);
        dimension2.width = Math.min(dimension2.width, dimension.width);
        Rectangle rectangle = View.getSingleton().getMainFrame().getBounds();
        int n = rectangle.x + (rectangle.width - dimension2.width) / 2;
        int n2 = rectangle.y + (rectangle.height - dimension2.height) / 2;
        this.setLocation(n, n2);
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl && Model.getSingleton().getOptionsParam().getViewParam().getWmUiHandlingOption() == 0) {
            this.centreDialog();
        }
        super.setVisible(bl);
    }
}

