/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.security;

import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.Date;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.parosproxy.paros.security.MissingRootCertificateException;
import org.parosproxy.paros.security.SslCertificateService;

public final class SslCertificateServiceImpl
implements SslCertificateService {
    private X509Certificate caCert = null;
    private PublicKey caPubKey = null;
    private PrivateKey caPrivKey = null;
    private final AtomicLong serial;
    private static final SslCertificateService singleton = new SslCertificateServiceImpl();

    private SslCertificateServiceImpl() {
        Security.addProvider((Provider)new BouncyCastleProvider());
        Random random = new Random();
        random.setSeed(System.currentTimeMillis());
        long l = (long)random.nextInt() << 32 | (long)random.nextInt() & 0xFFFFFFFFL;
        this.serial = new AtomicLong(l &= 0xFFFFFFFFFFFFL);
    }

    @Override
    public synchronized void initializeRootCA(KeyStore keyStore) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException {
        if (keyStore == null) {
            this.caCert = null;
            this.caPrivKey = null;
            this.caPubKey = null;
        } else {
            this.caCert = (X509Certificate)keyStore.getCertificate("owasp_zap_root_ca");
            this.caPrivKey = (RSAPrivateKey)keyStore.getKey("owasp_zap_root_ca", SslCertificateService.PASSPHRASE);
            this.caPubKey = this.caCert.getPublicKey();
        }
    }

    @Override
    public KeyStore createCertForHost(String string) throws NoSuchAlgorithmException, InvalidKeyException, CertificateException, NoSuchProviderException, SignatureException, KeyStoreException, IOException, UnrecoverableKeyException {
        ContentSigner contentSigner;
        if (string == null) {
            throw new IllegalArgumentException("Error, 'hostname' is not allowed to be null!");
        }
        if (this.caCert == null || this.caPrivKey == null || this.caPubKey == null) {
            throw new MissingRootCertificateException(this.getClass() + " wasn't initialized! Got to options 'Dynamic SSL Certs' and create one.");
        }
        KeyPair keyPair = this.createKeyPair();
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        X500NameBuilder x500NameBuilder = new X500NameBuilder(BCStyle.INSTANCE);
        x500NameBuilder.addRDN(BCStyle.CN, string);
        x500NameBuilder.addRDN(BCStyle.OU, "Zed Attack Proxy Project");
        x500NameBuilder.addRDN(BCStyle.O, "OWASP");
        x500NameBuilder.addRDN(BCStyle.C, "xx");
        x500NameBuilder.addRDN(BCStyle.EmailAddress, "owasp-zed-attack-proxy@lists.owasp.org");
        JcaX509v3CertificateBuilder jcaX509v3CertificateBuilder = new JcaX509v3CertificateBuilder(new X509CertificateHolder(this.caCert.getEncoded()).getSubject(), BigInteger.valueOf(this.serial.getAndIncrement()), new Date(System.currentTimeMillis() - 2592000000L), new Date(System.currentTimeMillis() + 259200000000L), x500NameBuilder.build(), publicKey);
        jcaX509v3CertificateBuilder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)new SubjectKeyIdentifier(publicKey.getEncoded()));
        jcaX509v3CertificateBuilder.addExtension(Extension.basicConstraints, false, (ASN1Encodable)new BasicConstraints(false));
        jcaX509v3CertificateBuilder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)new GeneralNames(new GeneralName(2, string)));
        try {
            contentSigner = new JcaContentSignerBuilder("SHA256WithRSAEncryption").setProvider("BC").build(this.caPrivKey);
        }
        catch (OperatorCreationException operatorCreationException) {
            throw new CertificateException(operatorCreationException);
        }
        X509Certificate x509Certificate = new JcaX509CertificateConverter().setProvider("BC").getCertificate(jcaX509v3CertificateBuilder.build(contentSigner));
        x509Certificate.checkValidity(new Date());
        x509Certificate.verify(this.caPubKey);
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, null);
        Certificate[] certificateArray = new Certificate[2];
        certificateArray[1] = this.caCert;
        certificateArray[0] = x509Certificate;
        keyStore.setKeyEntry("owasp_zap_root_ca", privateKey, PASSPHRASE, certificateArray);
        return keyStore;
    }

    private KeyPair createKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        secureRandom.setSeed(Long.toString(System.currentTimeMillis()).getBytes());
        keyPairGenerator.initialize(2048, secureRandom);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        return keyPair;
    }

    public static SslCertificateService getService() {
        return singleton;
    }
}

