/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.db.sql;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.security.InvalidParameterException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.db.Database;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.DatabaseListener;
import org.parosproxy.paros.db.DatabaseServer;
import org.parosproxy.paros.db.DatabaseUnsupportedException;
import org.zaproxy.zap.db.sql.SqlDatabaseServer;
import org.zaproxy.zap.db.sql.SqlPreparedStatementWrapper;
import org.zaproxy.zap.utils.Stats;

public class DbSQL
implements DatabaseListener {
    private static final int MAX_SET_SIZE = 10;
    private static Properties dbProperties = null;
    private static Properties sqlProperties = null;
    private static String dbType = null;
    private static DbSQL singleton = null;
    private static SqlDatabaseServer dbServer = null;
    private static final Logger logger = Logger.getLogger(DbSQL.class);
    private Map<String, StatementPool> stmtPool = new HashMap<String, StatementPool>();

    public static DbSQL getSingleton() {
        if (singleton == null) {
            singleton = new DbSQL();
        }
        return singleton;
    }

    protected String getDbUser() {
        if (dbProperties == null) {
            throw new IllegalStateException("Database not initialised");
        }
        return dbProperties.getProperty("db.user");
    }

    protected String getDbPassword() {
        if (dbProperties == null) {
            throw new IllegalStateException("Database not initialised");
        }
        return dbProperties.getProperty("db.password");
    }

    protected String getDbUrl() {
        if (dbProperties == null) {
            throw new IllegalStateException("Database not initialised");
        }
        return dbProperties.getProperty("db.url");
    }

    public static String getDbType() {
        return dbType;
    }

    public synchronized Database initDatabase() throws IllegalStateException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Throwable throwable;
        if (dbProperties != null) {
            throw new IllegalStateException("Database already initialised");
        }
        File file = new File(Constant.getZapHome() + File.separator + "db", "db.properties");
        if (!file.exists()) {
            file = new File(Constant.getZapInstall() + File.separator + "db", "db.properties");
        }
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        dbProperties = new Properties();
        Object object = new FileReader(file);
        Class<?> clazz = null;
        try {
            dbProperties.load((Reader)object);
        }
        catch (Throwable throwable2) {
            clazz = throwable2;
            throw throwable2;
        }
        finally {
            if (object != null) {
                if (clazz != null) {
                    try {
                        ((Reader)object).close();
                    }
                    catch (Throwable throwable3) {
                        ((Throwable)((Object)clazz)).addSuppressed(throwable3);
                    }
                } else {
                    ((Reader)object).close();
                }
            }
        }
        dbType = dbProperties.getProperty("db.type");
        sqlProperties = new Properties();
        object = new File(Constant.getZapInstall() + File.separator + "db", dbType + ".properties");
        try {
            clazz = new FileReader((File)object);
            throwable = null;
            try {
                sqlProperties.load((Reader)((Object)clazz));
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (clazz != null) {
                    if (throwable != null) {
                        try {
                            ((Reader)((Object)clazz)).close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        ((Reader)((Object)clazz)).close();
                    }
                }
            }
        }
        catch (Exception exception) {
            logger.error((Object)("No SQL properties file for db type " + ((File)object).getAbsolutePath()));
            throw new FileNotFoundException(((File)object).getAbsolutePath());
        }
        Class.forName(dbProperties.getProperty("db.driver"));
        clazz = Class.forName(dbProperties.getProperty("db.class"));
        throwable = clazz.newInstance();
        if (!(throwable instanceof Database)) {
            throw new InvalidParameterException("db.class is not an instance of Database: " + throwable.getClass().getCanonicalName());
        }
        return (Database)((Object)throwable);
    }

    public static void addSqlProperties(InputStream inputStream) throws IOException {
        sqlProperties.load(inputStream);
    }

    public static String getSQL(String string) {
        String string2 = sqlProperties.getProperty(string);
        if (string2 != null) {
            string2 = string2.trim();
        }
        return string2;
    }

    public static String getSQL(String string, Object ... objectArray) {
        String string2 = MessageFormat.format(DbSQL.getSQL(string), objectArray);
        if (string2 != null) {
            string2 = string2.trim();
        }
        return string2;
    }

    public static void setSetValues(PreparedStatement preparedStatement, int n, String ... stringArray) throws SQLException {
        int n2;
        if (stringArray.length > 10) {
            throw new InvalidParameterException("Set size exceeded maximun of 10");
        }
        for (n2 = n; n2 < stringArray.length; ++n2) {
            preparedStatement.setString(n2, stringArray[n2]);
        }
        while (n2 < 10) {
            preparedStatement.setNull(n2, 12);
            ++n2;
        }
    }

    public static void setSetValues(PreparedStatement preparedStatement, int n, int ... nArray) throws SQLException {
        int n2;
        if (nArray.length > 10) {
            throw new InvalidParameterException("Set size exceeded maximun of 10");
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            preparedStatement.setInt(n + n2, nArray[n2]);
        }
        while (n2 < 10) {
            preparedStatement.setNull(n + n2, 4);
            ++n2;
        }
    }

    @Override
    public void databaseOpen(DatabaseServer databaseServer) throws DatabaseException, DatabaseUnsupportedException {
        dbServer = (SqlDatabaseServer)databaseServer;
        for (Map.Entry<String, StatementPool> entry : this.stmtPool.entrySet()) {
            entry.getValue().clear();
        }
        Stats.clear("sqldb.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SqlPreparedStatementWrapper getPreparedStatement(String string) throws SQLException {
        Stats.incCounter("sqldb." + string + ".calls");
        StatementPool statementPool = this.stmtPool.get(string);
        if (statementPool == null) {
            DbSQL dbSQL = this;
            synchronized (dbSQL) {
                if (!this.stmtPool.containsKey(string)) {
                    this.stmtPool.put(string, new StatementPool());
                }
            }
            statementPool = this.stmtPool.get(string);
        }
        return statementPool.getPreparedStatement(string);
    }

    public void releasePreparedStatement(SqlPreparedStatementWrapper sqlPreparedStatementWrapper) {
        if (sqlPreparedStatementWrapper != null) {
            Stats.incCounter("sqldb." + sqlPreparedStatementWrapper.getKey() + ".time", sqlPreparedStatementWrapper.getTimeTaken());
            this.stmtPool.get(sqlPreparedStatementWrapper.getKey()).releasePreparedStatement(sqlPreparedStatementWrapper);
        }
    }

    private class StatementPool {
        private static final int MAX_FREE_POOL_SIZE = 5;
        private Deque<PreparedStatement> inUsePool = new ConcurrentLinkedDeque<PreparedStatement>();
        private Deque<PreparedStatement> freePool = new ConcurrentLinkedDeque<PreparedStatement>();

        private StatementPool() {
        }

        public SqlPreparedStatementWrapper getPreparedStatement(String string) throws SQLException {
            PreparedStatement preparedStatement = this.freePool.pollFirst();
            if (preparedStatement == null) {
                preparedStatement = dbServer.getNewConnection().prepareStatement(DbSQL.getSQL(string));
                Stats.incCounter("sqldb.conn.openned");
            }
            this.inUsePool.add(preparedStatement);
            Stats.setHighwaterMark("sqldb." + string + ".pool", this.inUsePool.size());
            return new SqlPreparedStatementWrapper(string, preparedStatement);
        }

        public void releasePreparedStatement(SqlPreparedStatementWrapper sqlPreparedStatementWrapper) {
            if (this.inUsePool.remove(sqlPreparedStatementWrapper.getPs())) {
                if (this.freePool.size() < 5) {
                    this.freePool.add(sqlPreparedStatementWrapper.getPs());
                } else {
                    try {
                        sqlPreparedStatementWrapper.close();
                        Stats.incCounter("sqldb.conn.closed");
                    }
                    catch (SQLException sQLException) {
                        logger.error((Object)"Error closing prepared statement", (Throwable)sQLException);
                    }
                }
            } else {
                logger.error((Object)"Releasing prepared statement not in a pool", (Throwable)new InvalidParameterException());
            }
        }

        public void clear() {
            Iterator<PreparedStatement> iterator = this.inUsePool.iterator();
            while (iterator.hasNext()) {
                try {
                    iterator.next().close();
                }
                catch (SQLException sQLException) {}
            }
            this.inUsePool.clear();
            iterator = this.freePool.iterator();
            while (iterator.hasNext()) {
                try {
                    iterator.next().close();
                }
                catch (SQLException sQLException) {}
            }
            this.freePool.clear();
        }
    }
}

