/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.brk.impl.http;

import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.brk.BreakpointManagementInterface;
import org.zaproxy.zap.extension.httppanel.Message;

public class HttpBreakpointManagementDaemonImpl
implements BreakpointManagementInterface {
    private boolean breakRequest;
    private boolean breakResponse;
    private boolean request;
    private HttpMessage msg;
    private boolean step;
    private boolean stepping;
    private boolean drop;

    @Override
    public boolean isBreakRequest() {
        return this.breakRequest;
    }

    @Override
    public boolean isBreakResponse() {
        return this.breakResponse;
    }

    @Override
    public boolean isBreakAll() {
        return this.breakRequest && this.breakResponse;
    }

    @Override
    public void breakpointHit() {
    }

    @Override
    public boolean isHoldMessage(Message message) {
        HttpMessage httpMessage;
        if (this.step) {
            this.step = false;
            return false;
        }
        if (this.stepping) {
            return true;
        }
        if (this.drop) {
            return false;
        }
        return message instanceof HttpMessage && ((httpMessage = (HttpMessage)message).getResponseHeader().isEmpty() ? this.isBreakRequest() : this.isBreakResponse());
    }

    @Override
    public boolean isStepping() {
        return this.stepping;
    }

    @Override
    public boolean isToBeDropped() {
        if (this.drop) {
            this.drop = false;
            return true;
        }
        return false;
    }

    @Override
    public void setMessage(Message message, boolean bl) {
        if (message instanceof HttpMessage) {
            switch (Control.getSingleton().getMode()) {
                case safe: {
                    throw new IllegalStateException("Not allowed in safe mode");
                }
                case protect: {
                    if (message.isInScope()) break;
                    throw new IllegalStateException("Not allowed in protected mode for out of scope message");
                }
                case standard: {
                    break;
                }
            }
            HttpMessage httpMessage = (HttpMessage)message;
            if (this.msg == null) {
                this.msg = httpMessage;
                this.request = bl;
            } else if (bl) {
                this.msg.setRequestHeader(httpMessage.getRequestHeader());
                this.msg.setRequestBody(httpMessage.getRequestBody());
            } else {
                this.msg.setResponseHeader(httpMessage.getResponseHeader());
                this.msg.setResponseBody(httpMessage.getResponseBody());
            }
        } else {
            throw new IllegalArgumentException("Not an HttpMessage");
        }
    }

    @Override
    public boolean isRequest() {
        return this.request;
    }

    @Override
    public Message getMessage() {
        return this.msg;
    }

    @Override
    public void saveMessage(boolean bl) {
    }

    @Override
    public void clearAndDisableRequest() {
        this.msg = null;
    }

    @Override
    public void clearAndDisableResponse() {
        this.msg = null;
    }

    @Override
    public void init() {
    }

    @Override
    public void reset() {
    }

    @Override
    public void sessionModeChanged(Control.Mode mode) {
        this.breakRequest = false;
        this.breakResponse = false;
        this.msg = null;
        this.step = false;
        this.stepping = false;
        this.drop = false;
    }

    @Override
    public void setBreakAllRequests(boolean bl) {
        this.breakRequest = bl;
    }

    @Override
    public void setBreakAllResponses(boolean bl) {
        this.breakResponse = bl;
    }

    @Override
    public void setBreakAll(boolean bl) {
        this.setBreakAllRequests(bl);
        this.setBreakAllResponses(bl);
    }

    @Override
    public void step() {
        this.step = true;
        this.stepping = true;
    }

    @Override
    public void cont() {
        this.setBreakAllRequests(false);
        this.setBreakAllResponses(false);
        this.step = false;
        this.stepping = false;
    }

    @Override
    public void drop() {
        this.drop = true;
    }

    @Override
    public void breakpointDisplayed() {
    }
}

