/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.option;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.zaproxy.zap.utils.LocaleUtils;
import org.zaproxy.zap.view.ViewLocale;

public class OptionsLocalePanel
extends AbstractParamPanel {
    private static final long serialVersionUID = 1L;
    private JPanel panelMisc = null;
    private JComboBox<ViewLocale> localeSelect = null;
    private JLabel localeLabel = null;
    private JLabel localeChangeLabel = null;

    public OptionsLocalePanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setName(Constant.messages.getString("view.options.title"));
        this.add((Component)this.getPanelMisc(), this.getPanelMisc().getName());
    }

    private JPanel getPanelMisc() {
        if (this.panelMisc == null) {
            this.panelMisc = new JPanel();
            this.panelMisc.setLayout(new GridBagLayout());
            this.panelMisc.setSize(114, 132);
            this.panelMisc.setName(Constant.messages.getString("view.options.misc.title"));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.ipadx = 0;
            gridBagConstraints2.ipady = 0;
            gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints2.anchor = 18;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.ipadx = 0;
            gridBagConstraints3.ipady = 0;
            gridBagConstraints3.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints3.anchor = 18;
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 2;
            gridBagConstraints4.ipadx = 0;
            gridBagConstraints4.ipady = 0;
            gridBagConstraints4.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints4.anchor = 18;
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.weighty = 1.0;
            gridBagConstraints4.gridwidth = 2;
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.gridy = 3;
            gridBagConstraints5.ipadx = 0;
            gridBagConstraints5.ipady = 0;
            gridBagConstraints5.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints5.anchor = 18;
            gridBagConstraints5.fill = 2;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.weighty = 1.0;
            this.localeLabel = new JLabel(Constant.messages.getString("locale.options.label.language"));
            this.localeChangeLabel = new JLabel(Constant.messages.getString("locale.options.label.change"));
            this.panelMisc.add((Component)this.localeLabel, gridBagConstraints2);
            this.panelMisc.add(this.getLocaleSelect(), gridBagConstraints3);
            this.panelMisc.add((Component)this.localeChangeLabel, gridBagConstraints4);
            this.panelMisc.add((Component)new JLabel(), gridBagConstraints5);
        }
        return this.panelMisc;
    }

    private JComboBox<ViewLocale> getLocaleSelect() {
        if (this.localeSelect == null) {
            this.localeSelect = new JComboBox();
            for (ViewLocale viewLocale : LocaleUtils.getAvailableViewLocales()) {
                this.localeSelect.addItem(viewLocale);
            }
            this.localeSelect.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ViewLocale viewLocale = (ViewLocale)OptionsLocalePanel.this.localeSelect.getSelectedItem();
                    if (viewLocale != null) {
                        Constant.setLocale(viewLocale.getLocale());
                        OptionsLocalePanel.this.localeLabel.setText(Constant.messages.getString("locale.options.label.language"));
                        OptionsLocalePanel.this.localeChangeLabel.setText(Constant.messages.getString("locale.options.label.change"));
                    }
                }
            });
        }
        return this.localeSelect;
    }

    @Override
    public void initParam(Object object) {
    }

    @Override
    public void saveParam(Object object) throws Exception {
        OptionsParam optionsParam = (OptionsParam)object;
        ViewLocale viewLocale = (ViewLocale)this.localeSelect.getSelectedItem();
        if (viewLocale != null) {
            optionsParam.getViewParam().setLocale(viewLocale.getLocale());
        }
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.locale";
    }
}

