/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.storedscripts;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.script.StoredScriptSource;

public class GetStoredScriptResponse
extends ActionResponse
implements ToXContent {
    private StoredScriptSource source;

    GetStoredScriptResponse() {
    }

    GetStoredScriptResponse(StoredScriptSource source) {
        this.source = source;
    }

    public StoredScriptSource getSource() {
        return this.source;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.source.toXContent(builder, params);
        return builder;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.source = in.readBoolean() ? (in.getVersion().onOrAfter(Version.V_5_3_0) ? new StoredScriptSource(in) : new StoredScriptSource(in.readString())) : null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.source == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            if (out.getVersion().onOrAfter(Version.V_5_3_0)) {
                this.source.writeTo(out);
            } else {
                out.writeString(this.source.getCode());
            }
        }
    }
}

