/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.util.Map;
import java.util.Random;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.Interface;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.jvxl.readers.AtomDataReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.quantum.MOCalculation;
import org.jmol.quantum.NciCalculation;
import org.jmol.quantum.QS;
import org.jmol.quantum.QuantumCalculation;
import org.jmol.quantum.QuantumPlaneCalculation;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

class IsoMOReader
extends AtomDataReader {
    private Random random;
    private P3[] points;
    private V3 vTemp;
    private QuantumCalculation q;
    private Lst<Map<String, Object>> mos;
    private boolean isNci;
    private float[] coef;
    private int[][] dfCoefMaps;
    private float[] linearCombination;
    private float[][] coefs;
    private boolean isElectronDensityCalc;
    private final float[] vDist = new float[3];
    private boolean qSetupDone;

    IsoMOReader() {
    }

    @Override
    void init(SurfaceGenerator sg) {
        this.initADR(sg);
        boolean bl = this.isNci = this.params.qmOrbitalType == 3;
        if (this.isNci) {
            this.hasColorData = true;
            this.isXLowToHigh = true;
            this.precalculateVoxelData = false;
            this.params.insideOut = !this.params.insideOut;
        }
    }

    @Override
    protected void setup(boolean isMapData) {
        String className;
        this.mos = (Lst)this.params.moData.get("mos");
        this.linearCombination = this.params.qm_moLinearCombination;
        Map mo = this.mos != null && this.linearCombination == null ? (Map)this.mos.get(this.params.qm_moNumber - 1) : null;
        boolean haveVolumeData = this.params.moData.containsKey("haveVolumeData");
        if (haveVolumeData && mo != null) {
            this.params.volumeData = (VolumeData)mo.get("volumeData");
        }
        this.setup2();
        this.doAddHydrogens = false;
        this.getAtoms(this.params.bsSelected, this.doAddHydrogens, !this.isNci, this.isNci, this.isNci, false, false, this.params.qm_marginAngstroms, this.isNci ? null : this.params.modelInvRotation);
        if (this.isNci) {
            className = "quantum.NciCalculation";
            this.setHeader("NCI (promolecular)", "see NCIPLOT: A Program for Plotting Noncovalent Interaction Regions, Julia Contreras-Garcia, et al., J. of Chemical Theory and Computation, 2011, 7, 625-632");
        } else {
            className = "quantum.MOCalculation";
            this.setHeader("MO", "calculation type: " + this.params.moData.get("calculationType"));
        }
        this.setRanges(this.params.qm_ptsPerAngstrom, this.params.qm_gridMax, 0.0f);
        if (haveVolumeData) {
            int i = this.params.title.length;
            while (--i >= 0) {
                this.fixTitleLine(i, mo);
            }
        } else {
            this.q = (QuantumCalculation)Interface.getOption((String)className, (Viewer)((Viewer)this.sg.atomDataServer), (String)"file");
            if (this.isNci) {
                this.qpc = (QuantumPlaneCalculation)this.q;
            } else if (this.linearCombination == null) {
                int i = this.params.title.length;
                while (--i >= 0) {
                    this.fixTitleLine(i, mo);
                }
                this.coef = (float[])mo.get("coefficients");
                this.dfCoefMaps = (int[][])mo.get("dfCoefMaps");
            } else {
                int i;
                this.coefs = AU.newFloat2((int)this.mos.size());
                for (i = 1; i < this.linearCombination.length; i += 2) {
                    int j = (int)this.linearCombination[i];
                    if (j > this.mos.size() || j < 1) {
                        return;
                    }
                    this.coefs[j - 1] = (float[])((Map)this.mos.get(j - 1)).get("coefficients");
                }
                i = this.params.title.length;
                while (--i >= 0) {
                    this.fixTitleLine(i, null);
                }
            }
            this.isElectronDensityCalc = this.coef == null && this.linearCombination == null && !this.isNci;
        }
        this.volumeData.sr = null;
        if (isMapData && !this.isElectronDensityCalc && !haveVolumeData) {
            this.volumeData.doIterate = false;
            this.voxelData = new float[1][1][1];
            this.volumeData.setVoxelDataAsArray(this.voxelData);
            this.volumeData.sr = this;
            this.points = new P3[1];
            this.points[0] = new P3();
            if (!this.setupCalculation()) {
                this.q = null;
            }
        } else if (this.params.psi_monteCarloCount > 0) {
            this.vertexDataOnly = true;
            this.random = new Random(this.params.randomSeed);
        }
    }

    @Override
    protected boolean readVolumeParameters(boolean isMapData) {
        this.setup(isMapData);
        if (this.volumeData.sr == null) {
            this.initializeVolumetricData();
        }
        return true;
    }

    private void fixTitleLine(int iLine, Map<String, Object> mo) {
        String nboType;
        if (this.params.title == null) {
            return;
        }
        String line = this.params.title[iLine];
        if (line.indexOf(" MO ") >= 0 && (nboType = (String)this.params.moData.get("nboType")) != null) {
            line = PT.rep((String)line, (String)" MO ", (String)(" " + nboType + " "));
        }
        if (line.indexOf("%M") >= 0) {
            line = this.params.title[iLine] = PT.formatStringS((String)line, (String)"M", (String)this.atomData.modelName);
        }
        if (line.indexOf("%F") >= 0) {
            line = this.params.title[iLine] = PT.formatStringS((String)line, (String)"F", (String)PT.rep((String)this.params.fileName, (String)"DROP_", (String)""));
        }
        int pt = line.indexOf("%");
        if (line.length() == 0 || pt < 0) {
            return;
        }
        int rep = 0;
        if (line.indexOf("%I") >= 0) {
            line = PT.formatStringS((String)line, (String)"I", (String)(this.params.qm_moLinearCombination == null ? "" + this.params.qm_moNumber : QS.getMOString((float[])this.params.qm_moLinearCombination)));
        }
        if (line.indexOf("%N") >= 0) {
            line = PT.formatStringS((String)line, (String)"N", (String)("" + this.params.qmOrbitalCount));
        }
        Float energy = null;
        if (mo == null) {
            for (int i = 0; i < this.linearCombination.length; i += 2) {
                if (this.linearCombination[i] == 0.0f) continue;
                mo = (Map)this.mos.get((int)this.linearCombination[i + 1] - 1);
                Float e = (Float)mo.get("energy");
                if (energy == null) {
                    if (e != null) {
                        energy = e;
                        continue;
                    }
                } else {
                    if (energy.equals(e)) continue;
                    energy = null;
                }
                break;
            }
        } else if (mo.containsKey("energy")) {
            energy = (Float)mo.get("energy");
        }
        if (line.indexOf("%E") >= 0) {
            line = PT.formatStringS((String)line, (String)"E", (String)(energy != null && ++rep != 0 ? "" + energy : ""));
        }
        if (line.indexOf("%U") >= 0) {
            line = PT.formatStringS((String)line, (String)"U", (String)(energy != null && this.params.moData.containsKey("energyUnits") && ++rep != 0 ? (String)this.params.moData.get("energyUnits") : ""));
        }
        if (line.indexOf("%S") >= 0) {
            line = PT.formatStringS((String)line, (String)"S", (String)(mo != null && mo.containsKey("symmetry") && ++rep != 0 ? "" + mo.get("symmetry") : ""));
        }
        if (line.indexOf("%O") >= 0) {
            float o;
            Float obj = mo == null ? null : (Float)mo.get("occupancy");
            float f = o = obj == null ? 0.0f : obj.floatValue();
            line = PT.formatStringS((String)line, (String)"O", (String)(obj != null && ++rep != 0 ? (o == (float)((int)o) ? "" + (int)o : PT.formatF((float)o, (int)0, (int)4, (boolean)false, (boolean)false)) : ""));
        }
        if (line.indexOf("%T") >= 0) {
            line = PT.formatStringS((String)line, (String)"T", (String)(mo != null && mo.containsKey("type") && ++rep != 0 ? "" + mo.get("type") : ""));
        }
        if (line.equals("string")) {
            this.params.title[iLine] = "";
            return;
        }
        boolean isOptional = line.indexOf("?") == 0;
        this.params.title[iLine] = !isOptional ? line : (rep > 0 && !line.trim().endsWith("=") ? line.substring(1) : "");
    }

    @Override
    protected void readSurfaceData(boolean isMapData) throws Exception {
        if (this.volumeData.sr != null) {
            return;
        }
        if (this.params.psi_monteCarloCount <= 0) {
            this.readSurfaceDataVDR(isMapData);
            return;
        }
        if (this.points != null) {
            return;
        }
        this.points = new P3[1000];
        for (int j = 0; j < 1000; ++j) {
            this.points[j] = new P3();
        }
        if (this.params.thePlane != null) {
            this.vTemp = new V3();
        }
        for (int i = 0; i < 3; ++i) {
            this.vDist[i] = this.volumeData.volumetricVectorLengths[i] * (float)this.volumeData.voxelCounts[i];
        }
        this.voxelData = new float[1000][1][1];
        this.volumeData.setVoxelDataAsArray(this.voxelData);
        this.getValues();
        float f = 0.0f;
        for (int j = 0; j < 1000; ++j) {
            float f2;
            float value = Math.abs(this.voxelData[j][0][0]);
            if (!(f2 > f)) continue;
            f = value;
        }
        if (f < 1.0E-4f) {
            return;
        }
        int i = 0;
        block3: while (i < this.params.psi_monteCarloCount) {
            this.getValues();
            for (int j = 0; j < 1000; ++j) {
                float value = this.voxelData[j][0][0];
                float absValue = Math.abs(value);
                if (absValue <= this.getRnd(f)) continue;
                this.addVC((T3)this.points[j], value, 0, false);
                if (++i == this.params.psi_monteCarloCount) continue block3;
            }
        }
    }

    @Override
    protected void postProcessVertices() {
    }

    private void getValues() {
        for (int j = 0; j < 1000; ++j) {
            this.voxelData[j][0][0] = 0.0f;
            this.points[j].set(this.volumeData.volumetricOrigin.x + this.getRnd(this.vDist[0]), this.volumeData.volumetricOrigin.y + this.getRnd(this.vDist[1]), this.volumeData.volumetricOrigin.z + this.getRnd(this.vDist[2]));
            if (this.params.thePlane == null) continue;
            Measure.getPlaneProjection((P3)this.points[j], (P4)this.params.thePlane, (P3)this.points[j], (V3)this.vTemp);
        }
        this.createOrbital();
    }

    @Override
    public float getValueAtPoint(T3 pt, boolean getSource) {
        return this.q == null ? 0.0f : this.q.processPt(pt);
    }

    private float getRnd(float f) {
        return this.random.nextFloat() * f;
    }

    @Override
    protected void generateCube() {
        if (this.params.volumeData != null) {
            return;
        }
        this.newVoxelDataCube();
        this.createOrbital();
    }

    protected void createOrbital() {
        boolean isMonteCarlo;
        boolean bl = isMonteCarlo = this.params.psi_monteCarloCount > 0;
        if (this.isElectronDensityCalc) {
            if (this.mos == null || isMonteCarlo) {
                return;
            }
            int i = this.params.qm_moNumber;
            while (--i >= 0) {
                Logger.info((String)(" generating isosurface data for MO " + (i + 1)));
                Map mo = (Map)this.mos.get(i);
                this.coef = (float[])mo.get("coefficients");
                this.dfCoefMaps = (int[][])mo.get("dfCoefMaps");
                if (!this.setupCalculation()) {
                    return;
                }
                this.q.createCube();
            }
        } else {
            if (!isMonteCarlo) {
                Logger.info((String)("generating isosurface data for MO using cutoff " + this.params.cutoff));
            }
            if (!this.setupCalculation()) {
                return;
            }
            this.q.createCube();
            this.jvxlData.integration = this.q.getIntegration();
        }
    }

    @Override
    public float[] getPlane(int x) {
        if (!this.qSetupDone) {
            this.setupCalculation();
        }
        return this.getPlaneSR(x);
    }

    private boolean setupCalculation() {
        this.qSetupDone = true;
        switch (this.params.qmOrbitalType) {
            case 5: {
                break;
            }
            case 1: {
                return ((MOCalculation)this.q).setupCalculation(this.volumeData, this.bsMySelected, (String)this.params.moData.get("calculationType"), (T3[])this.atomData.xyz, this.atomData.atoms, this.atomData.firstAtomIndex, (Lst)this.params.moData.get("shells"), (float[][])this.params.moData.get("gaussians"), this.dfCoefMaps, null, this.coef, this.linearCombination, this.params.isSquaredLinear, this.coefs, this.params.moData.get("isNormalized") == null, (T3[])this.points);
            }
            case 2: {
                return ((MOCalculation)this.q).setupCalculation(this.volumeData, this.bsMySelected, (String)this.params.moData.get("calculationType"), (T3[])this.atomData.xyz, this.atomData.atoms, this.atomData.firstAtomIndex, null, (float[][])null, (int[][])null, this.params.moData.get("slaters"), this.coef, this.linearCombination, this.params.isSquaredLinear, this.coefs, true, (T3[])this.points);
            }
            case 3: {
                return ((NciCalculation)this.q).setupCalculation(this.volumeData, this.bsMySelected, this.params.bsSolvent, this.atomData.bsMolecules, (T3[])this.atomData.atoms, this.atomData.firstAtomIndex, true, (T3[])this.points, this.params.parameters, this.params.testFlags);
            }
        }
        return false;
    }

    @Override
    protected float getSurfacePointAndFraction(float cutoff, boolean isCutoffAbsolute, float valueA, float valueB, T3 pointA, V3 edgeVector, int x, int y, int z, int vA, int vB, float[] fReturn, T3 ptReturn) {
        float zero = this.getSPF(cutoff, isCutoffAbsolute, valueA, valueB, pointA, edgeVector, x, y, z, vA, vB, fReturn, ptReturn);
        if (this.q != null && !Float.isNaN(zero)) {
            zero = this.q.processPt(ptReturn);
            if (this.params.isSquared) {
                zero *= zero;
            }
        }
        return zero;
    }
}

