/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;

public class InvalidVirtualFileAccessException
extends RuntimeException {
    public InvalidVirtualFileAccessException(VirtualFile file2) {
        super(InvalidVirtualFileAccessException.composeMessage(file2));
    }

    private static String composeMessage(VirtualFile file2) {
        String url = file2.getUrl();
        String message = "Accessing invalid virtual file: " + url;
        try {
            VirtualFile found = VirtualFileManager.getInstance().findFileByUrl(url);
            message = message + "; original:" + InvalidVirtualFileAccessException.hashCode(file2) + "; found:" + InvalidVirtualFileAccessException.hashCode(found);
        }
        catch (Throwable t) {
            message = message + "; lookup failed: " + t.getMessage();
        }
        return message;
    }

    private static String hashCode(Object o) {
        return o != null ? String.valueOf(o.hashCode()) : "-";
    }
}

