/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.stubs.KotlinImportDirectiveStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinImportDirectiveStubImpl;

public class KtImportDirectiveElementType
extends KtStubElementType<KotlinImportDirectiveStub, KtImportDirective> {
    public KtImportDirectiveElementType(@NotNull @NonNls String debugName) {
        if (debugName == null) {
            KtImportDirectiveElementType.$$$reportNull$$$0(0);
        }
        super(debugName, KtImportDirective.class, KotlinImportDirectiveStub.class);
    }

    @Override
    public KotlinImportDirectiveStub createStub(@NotNull KtImportDirective psi, StubElement parentStub) {
        FqName importedFqName;
        if (psi == null) {
            KtImportDirectiveElementType.$$$reportNull$$$0(1);
        }
        StringRef fqName2 = StringRef.fromString((importedFqName = psi.getImportedFqName()) == null ? null : importedFqName.asString());
        StringRef aliasName = StringRef.fromString(psi.getAliasName());
        return new KotlinImportDirectiveStubImpl(parentStub, psi.isAllUnder(), fqName2, aliasName, psi.isValidImport());
    }

    @Override
    public void serialize(@NotNull KotlinImportDirectiveStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            KtImportDirectiveElementType.$$$reportNull$$$0(2);
        }
        if (dataStream == null) {
            KtImportDirectiveElementType.$$$reportNull$$$0(3);
        }
        dataStream.writeBoolean(stub.isAllUnder());
        FqName importedFqName = stub.getImportedFqName();
        dataStream.writeName(importedFqName != null ? importedFqName.asString() : null);
        dataStream.writeName(stub.getAliasName());
        dataStream.writeBoolean(stub.isValid());
    }

    @Override
    @NotNull
    public KotlinImportDirectiveStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            KtImportDirectiveElementType.$$$reportNull$$$0(4);
        }
        boolean isAllUnder = dataStream.readBoolean();
        StringRef importedName = dataStream.readName();
        StringRef aliasName = dataStream.readName();
        boolean isValid = dataStream.readBoolean();
        KotlinImportDirectiveStubImpl kotlinImportDirectiveStubImpl = new KotlinImportDirectiveStubImpl(parentStub, isAllUnder, importedName, aliasName, isValid);
        if (kotlinImportDirectiveStubImpl == null) {
            KtImportDirectiveElementType.$$$reportNull$$$0(5);
        }
        return kotlinImportDirectiveStubImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/psi/stubs/elements/KtImportDirectiveElementType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/psi/stubs/elements/KtImportDirectiveElementType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createStub";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

