/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.testingUtils;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.CRC32;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.com.intellij.util.Processor;
import org.jetbrains.kotlin.incremental.LocalFileKotlinClass;
import org.jetbrains.kotlin.incremental.testingUtils.ClassFilesComparisonKt;
import org.jetbrains.kotlin.incremental.testingUtils.ClassFilesComparisonKt$WhenMappings;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.protobuf.ExtensionRegistry;
import org.jetbrains.kotlin.protobuf.ExtensionRegistryLite;
import org.jetbrains.kotlin.serialization.DebugProtoBuf;
import org.jetbrains.kotlin.serialization.jvm.BitEncoding;
import org.jetbrains.kotlin.serialization.jvm.DebugJvmProtoBuf;
import org.jetbrains.kotlin.utils.Printer;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.util.TraceClassVisitor;
import org.junit.Assert;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0001\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0005H\u0002\u001a\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002\u001a\u001e\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00052\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0012H\u0002\u001a\b\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\f\u0010\u0015\u001a\u00020\t*\u00020\u0005H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"DUMP_ALL", "", "assertEqualDirectories", "", "expected", "Ljava/io/File;", "actual", "forgiveExtraFiles", "classFileToString", "", "classFile", "fileToStringRepresentation", "file", "getAllRelativePaths", "", "dir", "getDirectoryString", "interestingPaths", "", "getExtensionRegistry", "Lorg/jetbrains/kotlin/protobuf/ExtensionRegistry;", "checksumString", "kotlin-build-common"})
public final class ClassFilesComparisonKt {
    private static final boolean DUMP_ALL = Intrinsics.areEqual((Object)System.getProperty("comparison.dump.all"), (Object)"true");

    /*
     * WARNING - void declaration
     */
    public static final void assertEqualDirectories(@NotNull File expected, @NotNull File actual, boolean forgiveExtraFiles) {
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)expected, (String)"expected");
        Intrinsics.checkParameterIsNotNull((Object)actual, (String)"actual");
        Set<String> pathsInExpected = ClassFilesComparisonKt.getAllRelativePaths(expected);
        Set<String> pathsInActual = ClassFilesComparisonKt.getAllRelativePaths(actual);
        Set commonPaths = CollectionsKt.intersect((Iterable)pathsInExpected, (Iterable)pathsInActual);
        Iterable iterable = commonPaths;
        void var7_7 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            String it = (String)element$iv$iv;
            if (!(DUMP_ALL || !Arrays.equals(FilesKt.readBytes((File)new File(expected, it)), FilesKt.readBytes((File)new File(actual, it))))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List changedPaths = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
        String expectedString = ClassFilesComparisonKt.getDirectoryString(expected, changedPaths);
        String actualString = ClassFilesComparisonKt.getDirectoryString(actual, changedPaths);
        if (DUMP_ALL) {
            Assert.assertEquals((Object)expectedString, (Object)(actualString + " "));
        }
        if (forgiveExtraFiles && changedPaths.isEmpty()) {
            List expectedListingLines = CollectionsKt.toList((Iterable)StringsKt.split$default((CharSequence)expectedString, (char[])new char[]{'\n'}, (boolean)false, (int)0, (int)6, null));
            List actualListingLines = CollectionsKt.toList((Iterable)StringsKt.split$default((CharSequence)actualString, (char[])new char[]{'\n'}, (boolean)false, (int)0, (int)6, null));
            if (actualListingLines.containsAll(expectedListingLines)) {
                return;
            }
        }
        Assert.assertEquals((Object)expectedString, (Object)actualString);
    }

    private static final String checksumString(@NotNull File $receiver) {
        CRC32 crc32 = new CRC32();
        crc32.update(FilesKt.readBytes((File)$receiver));
        String string = Long.toHexString(crc32.getValue());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.Long.toHexString(crc32.value)");
        return string;
    }

    private static final String getDirectoryString(File dir, List<String> interestingPaths) {
        StringBuilder buf = new StringBuilder();
        Printer p = new Printer((Appendable)buf);
        Function1<File, Unit> addDirContent$ = new Function1<File, Unit>(p){
            final /* synthetic */ Printer $p;

            public final void invoke(@NotNull File dir) {
                Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
                this.$p.pushIndent();
                File[] listFiles = dir.listFiles();
                Assert.assertNotNull((String)(dir + " does not exist"), (Object)listFiles);
                if (listFiles == null) {
                    Intrinsics.throwNpe();
                }
                List children2 = ArraysKt.sortedWith((Object[])listFiles, (Comparator)ComparisonsKt.compareBy((Function1[])new Function1[]{getDirectoryString.children.1.INSTANCE, getDirectoryString.children.2.INSTANCE}));
                for (File child : children2) {
                    if (child.isDirectory()) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        String[] stringArray = child.list();
                        boolean bl = stringArray != null ? !((objectArray2 = (objectArray = (Object[])stringArray)).length == 0) : false;
                        if (!bl) continue;
                        this.$p.println(new Object[]{child.getName()});
                        File file = child;
                        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"child");
                        this.invoke(file);
                        continue;
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)this.$p.println(new Object[]{child.getName(), " ", ClassFilesComparisonKt.access$checksumString(child)}), (String)"p.println(child.name, \" \", child.checksumString())");
                }
                this.$p.popIndent();
            }
            {
                this.$p = printer;
                super(1);
            }
        };
        p.println(new Object[]{"."});
        addDirContent$.invoke(dir);
        for (String path : interestingPaths) {
            p.println(new Object[]{"================", path, "================"});
            p.println(new Object[]{ClassFilesComparisonKt.fileToStringRepresentation(new File(dir, path))});
            p.println(new Object[0]);
            p.println(new Object[0]);
        }
        String string = buf.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"buf.toString()");
        return string;
    }

    private static final Set<String> getAllRelativePaths(File dir) {
        HashSet result = new HashSet();
        FileUtil.processFilesRecursively((File)dir, (Processor)((Processor)new Processor<File>(result, dir){
            final /* synthetic */ HashSet $result;
            final /* synthetic */ File $dir;

            public final boolean process(File it) {
                File file = it;
                if (file == null) {
                    Intrinsics.throwNpe();
                }
                if (file.isFile()) {
                    String string = FileUtil.getRelativePath((File)this.$dir, (File)it);
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    this.$result.add(string);
                }
                return true;
            }
            {
                this.$result = hashSet;
                this.$dir = file;
            }
        }));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String classFileToString(File classFile) {
        String[] annotationDataEncoded;
        KotlinClassHeader classHeader;
        StringWriter out = new StringWriter();
        TraceClassVisitor traceVisitor = new TraceClassVisitor(new PrintWriter(out));
        new ClassReader(FilesKt.readBytes((File)classFile)).accept((ClassVisitor)traceVisitor, 0);
        LocalFileKotlinClass localFileKotlinClass = LocalFileKotlinClass.Companion.create(classFile);
        KotlinClassHeader kotlinClassHeader = classHeader = localFileKotlinClass != null ? localFileKotlinClass.getClassHeader() : null;
        Object object = annotationDataEncoded = kotlinClassHeader != null ? kotlinClassHeader.getData() : null;
        if (annotationDataEncoded != null) {
            Closeable closeable = new ByteArrayInputStream(BitEncoding.decodeBytes((String[])annotationDataEncoded));
            boolean bl = false;
            try {
                ByteArrayInputStream input = (ByteArrayInputStream)closeable;
                out.write("\n" + "------ string table types proto -----" + "\n" + DebugJvmProtoBuf.StringTableTypes.parseDelimitedFrom(input));
                if (!classHeader.getMetadataVersion().isCompatible()) {
                    String string = "Incompatible class (" + classHeader + "): " + classFile;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                switch (ClassFilesComparisonKt$WhenMappings.$EnumSwitchMapping$0[classHeader.getKind().ordinal()]) {
                    case 1: {
                        out.write("\n" + "------ file facade proto -----" + "\n" + DebugProtoBuf.Package.parseFrom(input, (ExtensionRegistryLite)ClassFilesComparisonKt.getExtensionRegistry()));
                        break;
                    }
                    case 2: {
                        out.write("\n" + "------ class proto -----" + "\n" + DebugProtoBuf.Class.parseFrom(input, (ExtensionRegistryLite)ClassFilesComparisonKt.getExtensionRegistry()));
                        break;
                    }
                    case 3: {
                        out.write("\n" + "------ multi-file part proto -----" + "\n" + DebugProtoBuf.Package.parseFrom(input, (ExtensionRegistryLite)ClassFilesComparisonKt.getExtensionRegistry()));
                        break;
                    }
                    default: {
                        throw (Throwable)new IllegalStateException();
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Exception exception) {
                bl = true;
                try {
                    closeable.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw (Throwable)exception;
            }
            finally {
                if (!bl) {
                    closeable.close();
                }
            }
        }
        String string = out.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"out.toString()");
        return string;
    }

    private static final ExtensionRegistry getExtensionRegistry() {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.newInstance();
        if (extensionRegistry == null) {
            Intrinsics.throwNpe();
        }
        ExtensionRegistry registry = extensionRegistry;
        DebugJvmProtoBuf.registerAllExtensions(registry);
        return registry;
    }

    private static final String fileToStringRepresentation(File file) {
        return StringsKt.endsWith$default((String)file.getName(), (String)".class", (boolean)false, (int)2, null) ? ClassFilesComparisonKt.classFileToString(file) : FilesKt.readText$default((File)file, null, (int)1, null);
    }

    @NotNull
    public static final /* synthetic */ String access$checksumString(@NotNull File $receiver) {
        return ClassFilesComparisonKt.checksumString($receiver);
    }
}

