/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ruleconfig;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.zaproxy.zap.extension.ruleconfig.OptionsRuleConfigPanel;
import org.zaproxy.zap.extension.ruleconfig.RuleConfig;
import org.zaproxy.zap.extension.ruleconfig.RuleConfigAPI;
import org.zaproxy.zap.extension.ruleconfig.RuleConfigParam;

public class ExtensionRuleConfig
extends ExtensionAdaptor {
    public static final String NAME = "ExtensionRuleConfig";
    private OptionsRuleConfigPanel optionsRuleConfigPanel;
    private RuleConfigParam ruleConfigParam;

    public ExtensionRuleConfig() {
        super(NAME);
    }

    public void addRuleconfig(RuleConfig ruleConfig) {
        this.getRuleConfigParam().addRuleConfig(ruleConfig);
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        extensionHook.addOptionsParamSet(this.getRuleConfigParam());
        if (extensionHook.getView() != null) {
            extensionHook.getHookView().addOptionPanel(this.getOptionsRuleConfigPanel());
        }
        extensionHook.addApiImplementor(new RuleConfigAPI(this));
    }

    public RuleConfigParam getRuleConfigParam() {
        if (this.ruleConfigParam == null) {
            this.ruleConfigParam = new RuleConfigParam();
        }
        return this.ruleConfigParam;
    }

    public List<RuleConfig> getAllRuleConfigs() {
        return this.getRuleConfigParam().getAllRuleConfigs();
    }

    public RuleConfig getRuleConfig(String string) {
        RuleConfig ruleConfig = this.getRuleConfigParam().getRuleConfig(string);
        if (ruleConfig != null) {
            return ruleConfig.clone();
        }
        return null;
    }

    public void setRuleConfigValue(String string, String string2) {
        this.getRuleConfigParam().setRuleConfigValue(string, string2);
    }

    public void resetRuleConfigValue(String string) {
        this.getRuleConfigParam().resetRuleConfigValue(string);
    }

    public void resetAllRuleConfigValues() {
        this.getRuleConfigParam().resetAllRuleConfigValues();
    }

    private OptionsRuleConfigPanel getOptionsRuleConfigPanel() {
        if (this.optionsRuleConfigPanel == null) {
            this.optionsRuleConfigPanel = new OptionsRuleConfigPanel(this);
        }
        return this.optionsRuleConfigPanel;
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("ruleconfig.desc");
    }

    @Override
    public URL getURL() {
        try {
            return new URL("http://www.owasp.org/index.php/ZAP");
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    public boolean supportsDb(String string) {
        return true;
    }
}

