/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal.toolchain;

import java.io.File;
import java.util.Set;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.play.internal.javascript.GoogleClosureCompiler;
import org.gradle.play.internal.javascript.JavaScriptCompileSpec;
import org.gradle.play.internal.platform.PlayMajorVersion;
import org.gradle.play.internal.routes.RoutesCompileSpec;
import org.gradle.play.internal.routes.RoutesCompiler;
import org.gradle.play.internal.routes.RoutesCompilerFactory;
import org.gradle.play.internal.run.PlayApplicationRunner;
import org.gradle.play.internal.run.PlayApplicationRunnerFactory;
import org.gradle.play.internal.spec.PlayCompileSpec;
import org.gradle.play.internal.toolchain.DaemonPlayCompiler;
import org.gradle.play.internal.toolchain.PlayToolProvider;
import org.gradle.play.internal.twirl.TwirlCompileSpec;
import org.gradle.play.internal.twirl.TwirlCompiler;
import org.gradle.play.internal.twirl.TwirlCompilerFactory;
import org.gradle.play.platform.PlayPlatform;
import org.gradle.process.internal.worker.WorkerProcessFactory;
import org.gradle.util.TreeVisitor;
import org.gradle.workers.internal.WorkerDaemonFactory;
import org.gradle.workers.internal.WorkerDaemonManager;

class DefaultPlayToolProvider
implements PlayToolProvider {
    private final FileResolver fileResolver;
    private final WorkerDaemonManager compilerDaemonManager;
    private final PlayPlatform targetPlatform;
    private WorkerProcessFactory workerProcessBuilderFactory;
    private final Set<File> twirlClasspath;
    private final Set<File> routesClasspath;
    private final Set<File> javaScriptClasspath;

    public DefaultPlayToolProvider(FileResolver fileResolver, WorkerDaemonManager compilerDaemonManager, WorkerProcessFactory workerProcessBuilderFactory, PlayPlatform targetPlatform, Set<File> twirlClasspath, Set<File> routesClasspath, Set<File> javaScriptClasspath) {
        this.fileResolver = fileResolver;
        this.compilerDaemonManager = compilerDaemonManager;
        this.workerProcessBuilderFactory = workerProcessBuilderFactory;
        this.targetPlatform = targetPlatform;
        this.twirlClasspath = twirlClasspath;
        this.routesClasspath = routesClasspath;
        this.javaScriptClasspath = javaScriptClasspath;
        PlayMajorVersion.forPlatform(targetPlatform);
    }

    public <T extends CompileSpec> Compiler<T> newCompiler(Class<T> spec) {
        if (TwirlCompileSpec.class.isAssignableFrom(spec)) {
            TwirlCompiler twirlCompiler = TwirlCompilerFactory.create(this.targetPlatform);
            return this.cast((Compiler<? extends PlayCompileSpec>)new DaemonPlayCompiler<TwirlCompileSpec>(this.fileResolver.resolve((Object)"."), twirlCompiler, (WorkerDaemonFactory)this.compilerDaemonManager, this.twirlClasspath, twirlCompiler.getClassLoaderPackages()));
        }
        if (RoutesCompileSpec.class.isAssignableFrom(spec)) {
            RoutesCompiler routesCompiler = RoutesCompilerFactory.create(this.targetPlatform);
            return this.cast((Compiler<? extends PlayCompileSpec>)new DaemonPlayCompiler<RoutesCompileSpec>(this.fileResolver.resolve((Object)"."), routesCompiler, (WorkerDaemonFactory)this.compilerDaemonManager, this.routesClasspath, routesCompiler.getClassLoaderPackages()));
        }
        if (JavaScriptCompileSpec.class.isAssignableFrom(spec)) {
            GoogleClosureCompiler javaScriptCompiler = new GoogleClosureCompiler();
            return this.cast((Compiler<? extends PlayCompileSpec>)new DaemonPlayCompiler<JavaScriptCompileSpec>(this.fileResolver.resolve((Object)"."), javaScriptCompiler, (WorkerDaemonFactory)this.compilerDaemonManager, this.javaScriptClasspath, javaScriptCompiler.getClassLoaderPackages()));
        }
        throw new IllegalArgumentException(String.format("Cannot create Compiler for unsupported CompileSpec type '%s'", spec.getSimpleName()));
    }

    public <T> T get(Class<T> toolType) {
        if (PlayApplicationRunner.class.isAssignableFrom(toolType)) {
            return toolType.cast(PlayApplicationRunnerFactory.create(this.targetPlatform, this.workerProcessBuilderFactory));
        }
        throw new IllegalArgumentException(String.format("Don't know how to provide tool of type %s.", toolType.getSimpleName()));
    }

    private <T extends CompileSpec> Compiler<T> cast(Compiler<? extends PlayCompileSpec> raw) {
        Compiler<? extends PlayCompileSpec> converted = raw;
        return converted;
    }

    public boolean isAvailable() {
        return true;
    }

    public void explain(TreeVisitor<? super String> visitor) {
    }
}

