/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.jar;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarArchive;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarClasspathSnapshotData;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshot;

public class JarClasspathSnapshot {
    private final Map<File, JarSnapshot> jarSnapshots;
    private final JarClasspathSnapshotData data;

    public JarClasspathSnapshot(Map<File, JarSnapshot> jarSnapshots, JarClasspathSnapshotData data) {
        this.jarSnapshots = jarSnapshots;
        this.data = data;
    }

    public JarSnapshot getSnapshot(JarArchive jarArchive) {
        return this.jarSnapshots.get(jarArchive.file);
    }

    public boolean isAnyClassDuplicated(Set<String> classNames) {
        boolean noCommonElements = Collections.disjoint(this.data.getDuplicateClasses(), classNames);
        return !noCommonElements;
    }

    public JarClasspathSnapshotData getData() {
        return this.data;
    }

    public boolean isAnyClassDuplicated(JarArchive jarArchive) {
        JarSnapshot snapshot = this.getSnapshot(jarArchive);
        return this.isAnyClassDuplicated(snapshot.getClasses());
    }

    public void forEachSnapshot(Action<? super JarSnapshot> action) {
        for (JarSnapshot jarSnapshot : this.jarSnapshots.values()) {
            action.execute((Object)jarSnapshot);
        }
    }
}

