/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class RemoteLocation {
    private static final Log log = LogFactory.getLog(RemoteLocation.class);
    private static final Pattern SERVER_COLON_PORT = Pattern.compile("(\\S+)\\s*:\\s*(\\d+)");
    private final String host;
    private final int port;

    public RemoteLocation(String string, int n) {
        this.host = string;
        this.port = n;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof RemoteLocation)) {
            return false;
        }
        RemoteLocation remoteLocation = (RemoteLocation)object;
        if (this.host == null) {
            return remoteLocation.host == null && this.port == remoteLocation.port;
        }
        return this.host.equals(remoteLocation.host) && this.port == remoteLocation.port;
    }

    public int hashCode() {
        return this.host == null ? this.port : this.host.hashCode() ^ this.port;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.host != null) {
            stringBuilder.append(this.host);
        }
        stringBuilder.append(':').append(this.port);
        return stringBuilder.toString();
    }

    public static RemoteLocation parseServerAndPort(String string) {
        Matcher matcher = SERVER_COLON_PORT.matcher(string);
        if (matcher.find() && matcher.groupCount() == 2) {
            RemoteLocation remoteLocation = new RemoteLocation(matcher.group(1), Integer.parseInt(matcher.group(2)));
            return remoteLocation;
        }
        log.error("Invalid server descriptor: " + string);
        return null;
    }
}

