/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.base;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import writer2latex.api.ContentEntry;
import writer2latex.api.ConverterResult;
import writer2latex.api.MetaData;
import writer2latex.api.OutputFile;

public class ConverterResultImpl
implements ConverterResult {
    private List<OutputFile> files;
    private List<ContentEntry> content;
    private ContentEntry titlePageFile;
    private ContentEntry textFile;
    private ContentEntry tocFile;
    private ContentEntry lofFile;
    private ContentEntry lotFile;
    private ContentEntry indexFile;
    private ContentEntry bibliographyFile;
    private ContentEntry coverFile;
    private ContentEntry coverImageFile;
    private MetaData metaData = null;
    private int nMasterCount;

    public ConverterResultImpl() {
        this.reset();
    }

    public void reset() {
        this.files = new Vector<OutputFile>();
        this.content = new Vector<ContentEntry>();
        this.titlePageFile = null;
        this.textFile = null;
        this.tocFile = null;
        this.lofFile = null;
        this.lotFile = null;
        this.indexFile = null;
        this.bibliographyFile = null;
        this.coverImageFile = null;
        this.metaData = null;
        this.nMasterCount = 0;
    }

    public void addDocument(OutputFile file) {
        if (file.isMasterDocument()) {
            this.files.add(this.nMasterCount++, file);
        } else {
            this.files.add(file);
        }
    }

    @Override
    public OutputFile getMasterDocument() {
        return this.files.size() > 0 ? this.files.get(0) : null;
    }

    @Override
    public Iterator<OutputFile> iterator() {
        return this.files.iterator();
    }

    public void addContentEntry(ContentEntry entry) {
        this.content.add(entry);
    }

    @Override
    public List<ContentEntry> getContent() {
        return Collections.unmodifiableList(this.content);
    }

    public void setTitlePageFile(ContentEntry entry) {
        this.titlePageFile = entry;
    }

    @Override
    public ContentEntry getTitlePageFile() {
        return this.titlePageFile;
    }

    public void setTextFile(ContentEntry entry) {
        this.textFile = entry;
    }

    @Override
    public ContentEntry getTextFile() {
        return this.textFile;
    }

    public void setTocFile(ContentEntry entry) {
        this.tocFile = entry;
    }

    @Override
    public ContentEntry getTocFile() {
        return this.tocFile;
    }

    public void setLofFile(ContentEntry entry) {
        this.lofFile = entry;
    }

    @Override
    public ContentEntry getLofFile() {
        return this.lofFile;
    }

    public void setLotFile(ContentEntry entry) {
        this.lotFile = entry;
    }

    @Override
    public ContentEntry getLotFile() {
        return this.lotFile;
    }

    public void setIndexFile(ContentEntry entry) {
        this.indexFile = entry;
    }

    @Override
    public ContentEntry getIndexFile() {
        return this.indexFile;
    }

    public void setBibliographyFile(ContentEntry entry) {
        this.bibliographyFile = entry;
    }

    @Override
    public ContentEntry getBibliographyFile() {
        return this.bibliographyFile;
    }

    public void setCoverFile(ContentEntry entry) {
        this.coverFile = entry;
    }

    @Override
    public ContentEntry getCoverFile() {
        return this.coverFile;
    }

    public void setCoverImageFile(ContentEntry entry) {
        this.coverImageFile = entry;
    }

    @Override
    public ContentEntry getCoverImageFile() {
        return this.coverImageFile;
    }

    public void setMetaData(MetaData metaData) {
        this.metaData = metaData;
    }

    @Override
    public MetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public void write(File dir) throws IOException {
        if (dir != null && !dir.exists()) {
            throw new IOException("Directory does not exist");
        }
        Iterator<OutputFile> docEnum = this.iterator();
        while (docEnum.hasNext()) {
            OutputFile docOut = docEnum.next();
            String sDirName = "";
            String sFileName = docOut.getFileName();
            File subdir = dir;
            int nSlash = sFileName.indexOf("/");
            if (nSlash > -1) {
                sDirName = sFileName.substring(0, nSlash);
                sFileName = sFileName.substring(nSlash + 1);
                subdir = new File(dir, sDirName);
                if (!subdir.exists()) {
                    subdir.mkdir();
                }
            }
            File outfile = new File(subdir, sFileName);
            FileOutputStream fos = new FileOutputStream(outfile);
            docOut.write(fos);
            fos.flush();
            fos.close();
        }
    }
}

