/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.ConnectException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.dlight.libs.common.PathUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.FileInfoProvider;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.remote.impl.RemoteLogger;
import org.netbeans.modules.remote.impl.fileoperations.spi.FilesystemInterceptorProvider;
import org.netbeans.modules.remote.impl.fs.DirEntry;
import org.netbeans.modules.remote.impl.fs.DirEntryInvalid;
import org.netbeans.modules.remote.impl.fs.DirEntryList;
import org.netbeans.modules.remote.impl.fs.DirectoryStorage;
import org.netbeans.modules.remote.impl.fs.FormatException;
import org.netbeans.modules.remote.impl.fs.MagicCache;
import org.netbeans.modules.remote.impl.fs.RemoteExceptions;
import org.netbeans.modules.remote.impl.fs.RemoteFileObject;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectBase;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectWithCache;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystem;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemTransport;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemUtils;
import org.netbeans.modules.remote.impl.fs.RemoteLinkBase;
import org.netbeans.modules.remote.impl.fs.RemotePlainFile;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public class RemoteDirectory
extends RemoteFileObjectWithCache {
    private static final boolean trace = Boolean.getBoolean("cnd.remote.directory.trace");
    private Reference<DirectoryStorage> storageRef = new SoftReference<Object>(null);
    private Reference<MagicCache> magicCache = new SoftReference<Object>(null);
    private final Object refLock = new RefLock();
    private final Object magicLock = new MagicLock();
    private volatile RemoteFileSystemTransport.Warmup warmup;
    private static final AtomicInteger warmupHints = new AtomicInteger();
    private static final AtomicInteger warmupReqs = new AtomicInteger();
    private static final AtomicInteger readEntryReqs = new AtomicInteger();

    RemoteDirectory(RemoteFileObject wrapper, RemoteFileSystem fileSystem, ExecutionEnvironment execEnv, RemoteDirectory parent, String remotePath, File cache) {
        super(wrapper, fileSystem, execEnv, parent, remotePath, cache);
        if (this.getStorageFile().exists()) {
            RemoteFileSystemTransport.registerDirectory(this);
        }
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public boolean isData() {
        return false;
    }

    @Override
    public RemoteFileObject getFileObject(String name, String ext, @NonNull Set<String> antiLoop) {
        return this.getFileObject(RemoteDirectory.composeName(name, ext), antiLoop);
    }

    public final FileSystemProvider.Stat getStat(String childNameExt) throws IOException {
        DirEntry entry = this.getEntry(childNameExt);
        return FileSystemProvider.Stat.create((long)entry.getDevice(), (long)entry.getINode());
    }

    private DirEntry getEntry(String childNameExt) throws IOException {
        try {
            DirectoryStorage storage = this.getDirectoryStorage(childNameExt);
            DirEntry entry = storage.getValidEntry(childNameExt);
            return entry;
        }
        catch (ConnectException ex) {
            throw ex;
        }
        catch (InterruptedIOException | InterruptedException | ExecutionException | TimeoutException ex) {
            RemoteLogger.finest(ex, (Object)this);
            return null;
        }
        catch (CancellationException ex) {
            return null;
        }
    }

    boolean canWrite(String childNameExt) throws IOException, ConnectException {
        DirEntry entry = this.getEntry(childNameExt);
        return entry != null && entry.canWrite();
    }

    boolean canRead(String childNameExt) throws IOException {
        DirEntry entry = this.getEntry(childNameExt);
        return entry != null && entry.canRead();
    }

    boolean canExecute(String childNameExt) throws IOException {
        DirEntry entry = this.getEntry(childNameExt);
        return entry != null && entry.canExecute();
    }

    @Override
    public RemoteFileObject createDataImpl(String name, String ext, RemoteFileObjectBase orig) throws IOException {
        return this.create(RemoteDirectory.composeName(name, ext), false, orig);
    }

    @Override
    public RemoteFileObject createFolderImpl(String name, RemoteFileObjectBase orig) throws IOException {
        return this.create(name, true, orig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void postDeleteOrCreateChild(RemoteFileObject child, DirEntryList entryList) {
        String childNameExt;
        String string = childNameExt = child == null ? null : child.getNameExt();
        if (RemoteFileSystemUtils.getBoolean("remote.fast.delete", true)) {
            boolean sendEvents;
            block21: {
                Lock writeLock = this.getLockSupport().getCacheLock(this).writeLock();
                writeLock.lock();
                sendEvents = true;
                try {
                    DirectoryStorage storage = this.getExistingDirectoryStorage();
                    if (child != null && storage == DirectoryStorage.EMPTY) {
                        Exceptions.printStackTrace((Throwable)new IllegalStateException("postDeleteOrCreateChild stat is called but remote directory cache does not exist"));
                    }
                    if (entryList == null) {
                        List<DirEntry> entries = storage.listValid(childNameExt);
                        DirectoryStorage newStorage = new DirectoryStorage(this.getStorageFile(), entries);
                        try {
                            newStorage.store();
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        Object object = this.refLock;
                        synchronized (object) {
                            this.storageRef = new SoftReference<DirectoryStorage>(newStorage);
                        }
                        if (child != null) {
                            this.getFileSystem().getFactory().invalidate(child.getPath());
                        }
                        break block21;
                    }
                    try {
                        this.updateChildren(this.toMap(entryList), storage, true, childNameExt, null, false);
                    }
                    catch (IOException ex) {
                        RemoteLogger.finest(ex, (Object)this);
                    }
                    sendEvents = false;
                }
                finally {
                    writeLock.unlock();
                }
            }
            if (sendEvents && child != null) {
                RemoteLogger.assertTrue(!child.isValid(), "Calling postDelete ob valid child " + child, new Object[0]);
                this.fireDeletedEvent(this.getOwnerFileObject(), child, false, true);
            }
        } else {
            try {
                DirectoryStorage writeLock = this.refreshDirectoryStorage(childNameExt, false);
            }
            catch (ConnectException ex) {
                RemoteLogger.getInstance().log(Level.INFO, "Error post removing/creating child " + child, ex);
            }
            catch (IOException | ExecutionException | TimeoutException ex) {
                RemoteLogger.finest(ex, (Object)this);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                RemoteLogger.finest(ex, (Object)this);
            }
            catch (CancellationException cancellationException) {
                // empty catch block
            }
        }
    }

    @Override
    protected DirEntryList deleteImpl(FileLock lock) throws IOException {
        return RemoteFileSystemTransport.delete(this.getExecutionEnvironment(), this.getPath(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteFileObject create(String name, boolean directory, RemoteFileObjectBase orig) throws IOException {
        ProcessUtils.ExitStatus res;
        FilesystemInterceptorProvider.FilesystemInterceptor interceptor;
        String path = this.getPath() + '/' + name;
        if (name.contains("\\") || name.contains("/")) {
            throw RemoteExceptions.createIOException(NbBundle.getMessage(RemoteDirectory.class, (String)"EXC_CannotCreateFile", (Object)this.getDisplayName(path)));
        }
        if (!ConnectionManager.getInstance().isConnectedTo(this.getExecutionEnvironment())) {
            throw RemoteExceptions.createConnectException(NbBundle.getMessage(RemoteDirectory.class, (String)"EXC_CantCreateNoConnect", (Object)this.getDisplayName(path)));
        }
        if (USE_VCS && (interceptor = FilesystemInterceptorProvider.getDefault().getFilesystemInterceptor(this.getFileSystem())) != null) {
            try {
                this.getFileSystem().setInsideVCS(true);
                interceptor.beforeCreate(FilesystemInterceptorProvider.toFileProxy(orig.getOwnerFileObject()), name, directory);
            }
            finally {
                this.getFileSystem().setInsideVCS(false);
            }
        }
        if (directory) {
            res = ProcessUtils.execute((ExecutionEnvironment)this.getExecutionEnvironment(), (String)"mkdir", (String[])new String[]{path});
        } else {
            String script = String.format("ls ./\"%s\" || touch ./\"%s\"", name, name);
            res = ProcessUtils.executeInDir((String)this.getPath(), (ExecutionEnvironment)this.getExecutionEnvironment(), (String)"sh", (String[])new String[]{"-c", script});
            if (res.isOK() && res.getErrorString().length() == 0) {
                this.creationFalure(name, directory, orig);
                throw RemoteExceptions.createIOException(NbBundle.getMessage(RemoteDirectory.class, (String)"EXC_AlreadyExists", (Object)this.getDisplayName(path)));
            }
        }
        if (res.isOK()) {
            try {
                this.refreshDirectoryStorage(name, false);
                RemoteFileObject fo = this.getFileObject(name, new HashSet<String>());
                if (fo == null) {
                    this.creationFalure(name, directory, orig);
                    throw RemoteExceptions.createFileNotFoundException(NbBundle.getMessage(RemoteDirectory.class, (String)"EXC_CannotCreateFile", (Object)this.getDisplayName(path)));
                }
                if (USE_VCS) {
                    try {
                        this.getFileSystem().setInsideVCS(true);
                        this.getFileSystem().setBeingCreated(fo.getImplementor());
                        FilesystemInterceptorProvider.FilesystemInterceptor interceptor2 = FilesystemInterceptorProvider.getDefault().getFilesystemInterceptor(this.getFileSystem());
                        if (interceptor2 != null) {
                            if (this == orig) {
                                interceptor2.createSuccess(FilesystemInterceptorProvider.toFileProxy(fo));
                            } else {
                                RemoteFileObject originalFO = orig.getFileObject(name, new HashSet<String>());
                                if (originalFO == null) {
                                    throw RemoteExceptions.createFileNotFoundException(NbBundle.getMessage(RemoteDirectory.class, (String)"EXC_CannotCreateFile", (Object)this.getDisplayName(path)));
                                }
                                interceptor2.createSuccess(FilesystemInterceptorProvider.toFileProxy(originalFO));
                            }
                        }
                    }
                    finally {
                        this.getFileSystem().setInsideVCS(false);
                        this.getFileSystem().setBeingCreated(null);
                    }
                }
                return fo;
            }
            catch (ConnectException ex) {
                this.creationFalure(name, directory, orig);
                throw RemoteExceptions.createIOException(NbBundle.getMessage(RemoteDirectory.class, (String)"EXC_CannotCreateFileWithReason", (Object)this.getDisplayName(path), (Object)"not connected"), ex);
            }
            catch (InterruptedIOException ex) {
                this.creationFalure(name, directory, orig);
                throw RemoteExceptions.createInterruptedIOException(NbBundle.getMessage(RemoteDirectory.class, (String)"EXC_CannotCreateFileWithReason", (Object)this.getDisplayName(path), (Object)"interrupted"), ex);
            }
            catch (TimeoutException ex) {
                this.creationFalure(name, directory, orig);
                throw RemoteExceptions.createIOException(NbBundle.getMessage(RemoteDirectory.class, (String)"EXC_CannotCreateFileWithReason", (Object)this.getDisplayName(path), (Object)ex.getLocalizedMessage()), ex);
            }
            catch (IOException ex) {
                this.creationFalure(name, directory, orig);
                throw ex;
            }
            catch (ExecutionException ex) {
                this.creationFalure(name, directory, orig);
                throw RemoteExceptions.createIOException(NbBundle.getMessage(RemoteDirectory.class, (String)"EXC_CannotCreateFileWithReason2", (Object)this.getDisplayName(path), (Object)"exception occurred", (Object)ex.getLocalizedMessage()), ex);
            }
            catch (InterruptedException ex) {
                this.creationFalure(name, directory, orig);
                throw RemoteExceptions.createIOException(NbBundle.getMessage(RemoteDirectory.class, (String)"EXC_CannotCreateFileWithReason", (Object)this.getDisplayName(path), (Object)"interrupted"), ex);
            }
            catch (CancellationException ex) {
                this.creationFalure(name, directory, orig);
                throw RemoteExceptions.createIOException(NbBundle.getMessage(RemoteDirectory.class, (String)"EXC_CannotCreateFileWithReason", (Object)this.getDisplayName(path), (Object)"cancelled"), ex);
            }
        }
        this.creationFalure(name, directory, orig);
        throw RemoteExceptions.createIOException(NbBundle.getMessage(RemoteDirectory.class, (String)"EXC_CannotCreateFileWithReason", (Object)this.getDisplayName(path), (Object)res.getErrorString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void creationFalure(String name, boolean directory, RemoteFileObjectBase orig) {
        if (USE_VCS) {
            try {
                this.getFileSystem().setInsideVCS(true);
                FilesystemInterceptorProvider.FilesystemInterceptor interceptor = FilesystemInterceptorProvider.getDefault().getFilesystemInterceptor(this.getFileSystem());
                if (interceptor != null) {
                    interceptor.createFailure(FilesystemInterceptorProvider.toFileProxy(this.getOwnerFileObject()), name, directory);
                }
            }
            finally {
                this.getFileSystem().setInsideVCS(false);
            }
        }
    }

    @Override
    public RemoteFileObject getFileObject(String relativePath, @NonNull Set<String> antiLoop) {
        int slashPos;
        Parameters.notNull((CharSequence)"path", (Object)relativePath);
        relativePath = PathUtilities.normalizeUnixPath((String)relativePath);
        if ("".equals(relativePath) || ".".equals(relativePath)) {
            return this.getOwnerFileObject();
        }
        if (relativePath.startsWith("..")) {
            String absPath = this.getPath() + '/' + relativePath;
            absPath = PathUtilities.normalizeUnixPath((String)absPath);
            return this.getFileSystem().findResource(absPath, antiLoop);
        }
        if (relativePath.length() > 0 && relativePath.charAt(0) == '/') {
            relativePath = relativePath.substring(1);
        }
        if (relativePath.endsWith("/")) {
            relativePath = relativePath.substring(0, relativePath.length() - 1);
        }
        if ((slashPos = relativePath.lastIndexOf(47)) > 0) {
            String parentRemotePath = this.getPath() + '/' + relativePath.substring(0, slashPos);
            if (antiLoop != null) {
                String absPath = this.getPath() + '/' + relativePath;
                if (antiLoop.contains(absPath)) {
                    return null;
                }
                antiLoop.add(absPath);
            }
            String childNameExt = relativePath.substring(slashPos + 1);
            RemoteFileObject parentFileObject = this.getFileSystem().findResource(parentRemotePath, antiLoop);
            if (parentFileObject != null && parentFileObject.isFolder()) {
                RemoteFileObject result = parentFileObject.getFileObject(childNameExt, antiLoop);
                return result;
            }
            return null;
        }
        RemoteLogger.assertTrue(slashPos == -1);
        try {
            DirectoryStorage storage = this.getDirectoryStorage(relativePath);
            DirEntry entry = storage.getValidEntry(relativePath);
            if (entry == null) {
                return null;
            }
            return this.getFileSystem().getFactory().createFileObject(this, entry).getOwnerFileObject();
        }
        catch (FileNotFoundException | InterruptedIOException | InterruptedException | CancellationException | ExecutionException | TimeoutException ex) {
            RemoteLogger.finest(ex, (Object)this);
            return null;
        }
        catch (ConnectException ex) {
            this.setFlag((byte)8, true);
            RemoteLogger.finest(ex, (Object)this);
            return null;
        }
        catch (IOException ex) {
            RemoteLogger.fine(ex);
            return null;
        }
    }

    private void fireRemoteFileObjectCreated(RemoteFileObject fo) {
        FileEvent e = new FileEvent((FileObject)this.getOwnerFileObject(), (FileObject)fo);
        RemoteFileObjectBase delegate = fo.getImplementor();
        if (delegate instanceof RemoteDirectory) {
            this.fireFileFolderCreatedEvent(this.getListeners(), e);
        } else if (delegate instanceof RemotePlainFile) {
            this.fireFileDataCreatedEvent(this.getListeners(), e);
        } else {
            if (delegate instanceof RemoteLinkBase) {
                RemoteLogger.warning("firing fireFileDataCreatedEvent for a link {0} [{1}]", delegate, delegate.getClass().getSimpleName());
            }
            this.fireFileDataCreatedEvent(this.getListeners(), e);
        }
    }

    @Override
    protected RemoteFileObjectBase[] getExistentChildren() {
        return this.getExistentChildren(this.getExistingDirectoryStorage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirectoryStorage getExistingDirectoryStorage() {
        File storageFile;
        DirectoryStorage storage;
        Object object = this.refLock;
        synchronized (object) {
            storage = this.storageRef.get();
        }
        if (storage == null && (storageFile = this.getStorageFile()).exists()) {
            Lock readLock = this.getLockSupport().getCacheLock(this).readLock();
            readLock.lock();
            try {
                storage = DirectoryStorage.load(storageFile, this.getExecutionEnvironment());
            }
            catch (FormatException e) {
                FormatException.reportIfNeeded(e);
                storageFile.delete();
            }
            catch (InterruptedIOException e) {
            }
            catch (FileNotFoundException e) {
                RemoteLogger.finest(e, (Object)this);
            }
            catch (IOException e) {
                RemoteLogger.finest(e, (Object)this);
            }
            finally {
                readLock.unlock();
            }
        }
        return storage == null ? DirectoryStorage.EMPTY : storage;
    }

    private RemoteFileObjectBase[] getExistentChildren(DirectoryStorage storage) {
        List<DirEntry> entries = storage.listValid();
        ArrayList<RemoteFileObjectBase> result = new ArrayList<RemoteFileObjectBase>(entries.size());
        for (DirEntry entry : entries) {
            String path = this.getPath() + '/' + entry.getName();
            RemoteFileObjectBase fo = this.getFileSystem().getFactory().getCachedFileObject(path);
            if (fo == null) continue;
            result.add(fo);
        }
        return result.toArray(new RemoteFileObjectBase[result.size()]);
    }

    @Override
    public RemoteFileObject[] getChildren() {
        try {
            DirectoryStorage storage = this.getDirectoryStorage(null);
            List<DirEntry> entries = storage.listValid();
            RemoteFileObject[] childrenFO = new RemoteFileObject[entries.size()];
            for (int i = 0; i < entries.size(); ++i) {
                DirEntry entry = entries.get(i);
                childrenFO[i] = this.getFileSystem().getFactory().createFileObject(this, entry).getOwnerFileObject();
            }
            return childrenFO;
        }
        catch (FileNotFoundException | InterruptedIOException | InterruptedException | CancellationException | ExecutionException | TimeoutException ex) {
            RemoteLogger.finest(ex, (Object)this);
        }
        catch (ConnectException ex) {
            RemoteLogger.finest(ex, (Object)this);
            this.setFlag((byte)8, true);
        }
        catch (IOException ex) {
            RemoteLogger.info(ex, (Object)this);
        }
        return new RemoteFileObject[0];
    }

    private DirectoryStorage getDirectoryStorage(String childName) throws TimeoutException, ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
        DirectoryStorage directoryStorage;
        block5: {
            long time = System.currentTimeMillis();
            try {
                directoryStorage = this.getDirectoryStorageImpl(false, null, childName, false);
                if (!trace) break block5;
            }
            catch (StackOverflowError soe) {
                try {
                    String text = "StackOverflowError when accessing " + this.getPath();
                    Exceptions.printStackTrace((Throwable)new Exception(text, soe));
                    throw new IOException(text, soe);
                }
                catch (Throwable throwable) {
                    if (trace) {
                        this.trace("getDirectoryStorage for {1} took {0} ms", this, System.currentTimeMillis() - time);
                    }
                    throw throwable;
                }
            }
            this.trace("getDirectoryStorage for {1} took {0} ms", this, System.currentTimeMillis() - time);
        }
        return directoryStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirectoryStorage refreshDirectoryStorage(String expectedName, boolean expected) throws TimeoutException, ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
        DirectoryStorage directoryStorage;
        block3: {
            long time = System.currentTimeMillis();
            try {
                directoryStorage = this.getDirectoryStorageImpl(true, expectedName, null, expected);
                if (!trace) break block3;
            }
            catch (Throwable throwable) {
                if (trace) {
                    this.trace("refreshDirectoryStorage for {1} took {0} ms", this, System.currentTimeMillis() - time);
                }
                throw throwable;
            }
            this.trace("refreshDirectoryStorage for {1} took {0} ms", this, System.currentTimeMillis() - time);
        }
        return directoryStorage;
    }

    private void warmupDirs() {
        if (RemoteFileSystemUtils.getBoolean("remote.warmup", true)) {
            this.setFlag((byte)16, true);
        }
    }

    private RemoteDirectory getParentImpl() {
        return (RemoteDirectory)this.getParent();
    }

    private boolean isFlaggedForWarmup() {
        if (this.getFlag((byte)16)) {
            return true;
        }
        RemoteDirectory p = this.getParentImpl();
        if (p != null) {
            return p.isFlaggedForWarmup();
        }
        return false;
    }

    private RemoteFileSystemTransport.Warmup getWarmup() {
        RemoteDirectory p;
        RemoteFileSystemTransport.Warmup w = this.warmup;
        if (w == null && (p = this.getParentImpl()) != null) {
            return p.getWarmup();
        }
        return w;
    }

    private Map<String, DirEntry> toMap(DirEntryList entryList) {
        HashMap<String, DirEntry> map = new HashMap<String, DirEntry>();
        for (DirEntry entry : entryList.getEntries()) {
            map.put(entry.getName(), entry);
        }
        return map;
    }

    int getReadEntriesCount() {
        return readEntryReqs.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, DirEntry> readEntries(DirectoryStorage oldStorage, boolean forceRefresh, String childName) throws TimeoutException, IOException, InterruptedException, ExecutionException, CancellationException {
        block16: {
            Map<String, DirEntry> map;
            block17: {
                if (this.getFileSystem().isProhibitedToEnter(this.getPath())) {
                    return Collections.emptyMap();
                }
                readEntryReqs.incrementAndGet();
                try {
                    if (!this.isFlaggedForWarmup()) break block16;
                    RemoteFileSystemTransport.Warmup w = this.getWarmup();
                    if (forceRefresh) {
                        if (w != null) {
                            w.remove(this.getPath());
                        }
                        break block16;
                    }
                    warmupReqs.incrementAndGet();
                    DirEntryList entryList = null;
                    if (w == null) {
                        this.warmup = RemoteFileSystemTransport.createWarmup(this.getExecutionEnvironment(), this.getPath());
                        if (this.warmup != null) {
                            entryList = this.warmup.getAndRemove(this.getPath());
                        }
                    } else {
                        entryList = w.tryGetAndRemove(this.getPath());
                    }
                    if (entryList == null) break block16;
                    warmupHints.incrementAndGet();
                    map = this.toMap(entryList);
                    if (!RemoteLogger.getInstance().isLoggable(Level.FINEST)) break block17;
                }
                catch (Throwable throwable) {
                    if (RemoteLogger.getInstance().isLoggable(Level.FINEST)) {
                        RemoteLogger.finest("Warmup hits: {0} of {1} (total {2} dir.read reqs)", warmupHints.get(), warmupReqs.get(), readEntryReqs.get());
                    }
                    throw throwable;
                }
                RemoteLogger.finest("Warmup hits: {0} of {1} (total {2} dir.read reqs)", warmupHints.get(), warmupReqs.get(), readEntryReqs.get());
            }
            return map;
        }
        if (RemoteLogger.getInstance().isLoggable(Level.FINEST)) {
            RemoteLogger.finest("Warmup hits: {0} of {1} (total {2} dir.read reqs)", warmupHints.get(), warmupReqs.get(), readEntryReqs.get());
        }
        Map<String, DirEntry> newEntries = new HashMap<String, DirEntry>();
        boolean canLs = this.canLs();
        if (canLs) {
            DirEntryList entryList = RemoteFileSystemTransport.readDirectory(this.getExecutionEnvironment(), this.getPath());
            newEntries = this.toMap(entryList);
        }
        if (canLs && !this.isAutoMount()) {
            return newEntries;
        }
        if (childName != null) {
            String absPath = this.getPath() + '/' + childName;
            RemoteLogger.assertTrueInConsole(!oldStorage.isKnown(childName) || forceRefresh, "should not get here: " + absPath, new Object[0]);
            if (!newEntries.containsKey(childName)) {
                DirEntry entry = this.getSpecialDirChildEntry(absPath, childName);
                newEntries.put(entry.getName(), entry);
            }
        }
        for (DirEntry oldEntry : oldStorage.listAll()) {
            String oldChildName = oldEntry.getName();
            if (newEntries.containsKey(oldChildName)) continue;
            if (forceRefresh) {
                if (!oldEntry.isValid()) continue;
                String absPath = this.getPath() + '/' + oldChildName;
                DirEntry newEntry = this.getSpecialDirChildEntry(absPath, oldChildName);
                newEntries.put(oldChildName, newEntry);
                continue;
            }
            newEntries.put(oldChildName, oldEntry);
        }
        return newEntries;
    }

    private DirEntry getSpecialDirChildEntry(String absPath, String childName) throws TimeoutException, ConnectException, IOException, InterruptedException, ExecutionException {
        DirEntry entry;
        try {
            entry = RemoteFileSystemTransport.lstat(this.getExecutionEnvironment(), absPath);
        }
        catch (ExecutionException e) {
            if (RemoteFileSystemUtils.isFileNotFoundException(e)) {
                entry = null;
            }
            throw e;
        }
        return entry != null ? entry : new DirEntryInvalid(childName);
    }

    private boolean isAutoMount() {
        return this.getFileSystem().isAutoMount(this.getPath());
    }

    private boolean canLs() {
        return this.canRead();
    }

    private boolean isSpecialDirectory() {
        return this.isAutoMount() || !this.canLs();
    }

    private boolean isAlreadyKnownChild(DirectoryStorage storage, String childName) {
        return childName == null || storage == null || storage.isKnown(childName) || !ConnectionManager.getInstance().isConnectedTo(this.getExecutionEnvironment()) || !this.isSpecialDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void renameChild(FileLock lock, RemoteFileObjectBase directChild2Rename, String newNameExt, RemoteFileObjectBase orig) throws ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
        String nameExt2Rename = directChild2Rename.getNameExt();
        String name2Rename = directChild2Rename.getName();
        String ext2Rename = directChild2Rename.getExt();
        String path2Rename = directChild2Rename.getPath();
        this.checkConnection(this, true);
        Lock writeLock = this.getLockSupport().getCacheLock(this).writeLock();
        if (trace) {
            this.trace("waiting for lock", new Object[0]);
        }
        writeLock.lock();
        try {
            ProcessUtils.ExitStatus ret;
            DirectoryStorage storage = this.getExistingDirectoryStorage();
            if (storage.getValidEntry(nameExt2Rename) == null) {
                throw RemoteExceptions.createIOException(NbBundle.getMessage(RemoteDirectory.class, (String)"EXC_NotExistingChild", (Object)nameExt2Rename, (Object)this.getDisplayName()));
            }
            if (!this.getCache().exists()) {
                this.getCache().mkdirs();
                if (!this.getCache().exists()) {
                    throw new IOException("Can not create cache directory " + this.getCache());
                }
            }
            if (trace) {
                this.trace("renaming", new Object[0]);
            }
            boolean isRenamed = false;
            if (USE_VCS) {
                try {
                    FilesystemInterceptorProvider.IOHandler renameHandler;
                    this.getFileSystem().setInsideVCS(true);
                    FilesystemInterceptorProvider.FilesystemInterceptor interceptor = FilesystemInterceptorProvider.getDefault().getFilesystemInterceptor(this.getFileSystem());
                    if (interceptor != null && (renameHandler = interceptor.getRenameHandler(FilesystemInterceptorProvider.toFileProxy(orig.getOwnerFileObject()), newNameExt)) != null) {
                        renameHandler.handle();
                        isRenamed = true;
                    }
                }
                finally {
                    this.getFileSystem().setInsideVCS(false);
                }
            }
            if (!isRenamed && !(ret = ProcessUtils.executeInDir((String)this.getPath(), (ExecutionEnvironment)this.getExecutionEnvironment(), (String)"mv", (String[])new String[]{nameExt2Rename, newNameExt})).isOK()) {
                throw RemoteExceptions.createIOException(NbBundle.getMessage(RemoteDirectory.class, (String)"EXC_CanNotRename", (Object)ret.getErrorString()));
            }
            if (trace) {
                this.trace("synchronizing", new Object[0]);
            }
            Exception problem = null;
            Map<Object, Object> newEntries = Collections.emptyMap();
            try {
                newEntries = this.readEntries(storage, true, newNameExt);
            }
            catch (FileNotFoundException ex) {
                throw ex;
            }
            catch (IOException | ExecutionException | TimeoutException ex) {
                problem = ex;
            }
            if (problem != null) {
                if (!ConnectionManager.getInstance().isConnectedTo(this.getExecutionEnvironment())) {
                    this.getFileSystem().addPendingFile(this);
                    throw RemoteExceptions.createConnectException(problem.getMessage());
                }
                boolean fileNotFoundException = RemoteFileSystemUtils.isFileNotFoundException(problem);
                if (fileNotFoundException) {
                    this.getFileSystem().getFactory().invalidate(this);
                    Object object = this.refLock;
                    synchronized (object) {
                        this.storageRef = new SoftReference<DirectoryStorage>(DirectoryStorage.EMPTY);
                    }
                }
                if (!fileNotFoundException) {
                    if (problem instanceof IOException) {
                        throw (IOException)problem;
                    }
                    if (problem instanceof ExecutionException) {
                        throw (ExecutionException)problem;
                    }
                    throw new IllegalStateException("Unexpected exception class: " + problem.getClass().getName(), problem);
                }
            }
            this.getFileSystem().incrementDirSyncCount();
            HashMap<String, List<DirEntry>> dupLowerNames = new HashMap<String, List<DirEntry>>();
            boolean hasDups = false;
            boolean changed = true;
            HashSet<DirEntry> keepCacheNames = new HashSet<DirEntry>();
            ArrayList<DirEntry> entriesToFireChanged = new ArrayList<DirEntry>();
            ArrayList<DirEntry> entriesToFireChangedRO = new ArrayList<DirEntry>();
            ArrayList<DirEntry> entriesToFireCreated = new ArrayList<DirEntry>();
            ArrayList<RemoteFileObject> filesToFireDeleted = new ArrayList<RemoteFileObject>();
            for (DirEntry dirEntry : newEntries.values()) {
                if (dirEntry.isValid()) {
                    String lowerCacheName;
                    ArrayList<DirEntry> dupEntries;
                    String cacheName;
                    DirEntry oldEntry = storage.getValidEntry(dirEntry.getName());
                    if (oldEntry == null) {
                        cacheName = RemoteFileSystemUtils.escapeFileName(dirEntry.getName());
                        if (dirEntry.getName().equals(newNameExt)) {
                            DirEntry renamedEntry = storage.getValidEntry(nameExt2Rename);
                            RemoteLogger.assertTrueInConsole(renamedEntry != null, "original DirEntry is absent for " + path2Rename + " in " + this, new Object[0]);
                            if (renamedEntry != null) {
                                cacheName = renamedEntry.getCache();
                                dirEntry.setCache(cacheName);
                                keepCacheNames.add(dirEntry);
                            }
                        } else {
                            entriesToFireCreated.add(dirEntry);
                        }
                    } else if (oldEntry.isSameType(dirEntry)) {
                        cacheName = oldEntry.getCache();
                        keepCacheNames.add(dirEntry);
                        boolean fire = false;
                        if ((!dirEntry.isSameLastModified(oldEntry) || dirEntry.getSize() != oldEntry.getSize()) && dirEntry.isPlainFile()) {
                            fire = true;
                            changed = true;
                            File entryCache = new File(this.getCache(), oldEntry.getCache());
                            if (entryCache.exists()) {
                                if (trace) {
                                    this.trace("removing cache for updated file {0}", entryCache.getAbsolutePath());
                                }
                                entryCache.delete();
                            }
                        }
                        if (!RemoteDirectory.equals(dirEntry.getLinkTarget(), oldEntry.getLinkTarget())) {
                            fire = true;
                            changed = true;
                            this.getFileSystem().getFactory().setLink(this, this.getPath() + '/' + dirEntry.getName(), dirEntry.getLinkTarget());
                        }
                        if (!dirEntry.isSameAccess(oldEntry)) {
                            entriesToFireChangedRO.add(dirEntry);
                            fire = true;
                            changed = true;
                        }
                        if (!dirEntry.isDirectory() && dirEntry.getSize() != oldEntry.getSize()) {
                            fire = true;
                            changed = true;
                        }
                        if (fire) {
                            entriesToFireChanged.add(dirEntry);
                        }
                    } else {
                        changed = true;
                        this.getFileSystem().getFactory().changeImplementor(this, oldEntry, dirEntry);
                        entriesToFireChanged.add(dirEntry);
                        cacheName = null;
                    }
                    if (cacheName != null) {
                        dirEntry.setCache(cacheName);
                    }
                    if ((dupEntries = (ArrayList<DirEntry>)dupLowerNames.get(lowerCacheName = RemoteFileSystemUtils.isSystemCaseSensitive() ? dirEntry.getCache() : dirEntry.getCache().toLowerCase())) == null) {
                        dupEntries = new ArrayList<DirEntry>();
                        dupLowerNames.put(lowerCacheName, dupEntries);
                    } else {
                        hasDups = true;
                    }
                    dupEntries.add(dirEntry);
                    continue;
                }
                changed = true;
            }
            if (changed) {
                for (DirEntry dirEntry : storage.listValid()) {
                    RemoteFileObject removedFO;
                    DirEntry newEntry;
                    if (dirEntry.getName().equals(nameExt2Rename) || (newEntry = (DirEntry)newEntries.get(dirEntry.getName())) != null && newEntry.isValid() || (removedFO = this.invalidate(dirEntry)) == null) continue;
                    filesToFireDeleted.add(removedFO);
                }
                if (hasDups) {
                    for (Map.Entry entry : new ArrayList(dupLowerNames.entrySet())) {
                        List dupEntries = (List)entry.getValue();
                        if (dupEntries.size() <= 1) continue;
                        block18: for (int i = 0; i < dupEntries.size(); ++i) {
                            DirEntry entry2 = (DirEntry)dupEntries.get(i);
                            if (keepCacheNames.contains(entry2)) continue;
                            for (int j = 0; j < Integer.MAX_VALUE; ++j) {
                                String cacheName = (String)entry.getKey() + '_' + j;
                                String lowerCacheName = cacheName.toLowerCase();
                                if (dupLowerNames.containsKey(lowerCacheName)) continue;
                                if (trace) {
                                    this.trace("resolving cache names conflict in {0}: {1} -> {2}", this.getCache().getAbsolutePath(), entry2.getCache(), cacheName);
                                }
                                entry2.setCache(cacheName);
                                dupLowerNames.put(lowerCacheName, Collections.singletonList(entry2));
                                continue block18;
                            }
                        }
                    }
                }
                storage = new DirectoryStorage(this.getStorageFile(), newEntries.values());
                storage.store();
            } else {
                storage.touch();
            }
            Iterator iterator = this.refLock;
            synchronized (iterator) {
                this.storageRef = new SoftReference<DirectoryStorage>(storage);
            }
            if (changed) {
                RemoteFileObjectBase fo;
                this.dropMagic();
                for (FileObject fileObject : filesToFireDeleted) {
                    this.fireFileDeletedEvent(this.getListeners(), new FileEvent((FileObject)this.getOwnerFileObject(), fileObject));
                }
                for (DirEntry dirEntry : entriesToFireCreated) {
                    fo = this.getFileSystem().getFactory().createFileObject(this, dirEntry);
                    this.fireRemoteFileObjectCreated(fo.getOwnerFileObject());
                }
                for (DirEntry dirEntry : entriesToFireChanged) {
                    fo = this.getFileSystem().getFactory().getCachedFileObject(this.getPath() + '/' + dirEntry.getName());
                    if (fo == null) continue;
                    RemoteFileObject ownerFileObject = fo.getOwnerFileObject();
                    this.fireFileChangedEvent(this.getListeners(), new FileEvent((FileObject)ownerFileObject, (FileObject)ownerFileObject, false, ownerFileObject.lastModified().getTime()));
                }
                String newPath = this.getPath() + '/' + newNameExt;
                this.getFileSystem().getFactory().rename(path2Rename, newPath, directChild2Rename);
                this.fireFileRenamedEvent(directChild2Rename.getListeners(), new FileRenameEvent((FileObject)directChild2Rename.getOwnerFileObject(), (FileObject)directChild2Rename.getOwnerFileObject(), name2Rename, ext2Rename));
                this.fireFileRenamedEvent(this.getListeners(), new FileRenameEvent((FileObject)this.getOwnerFileObject(), (FileObject)directChild2Rename.getOwnerFileObject(), name2Rename, ext2Rename));
                this.fireReadOnlyChangedEventsIfNeed(entriesToFireChangedRO);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DirEntry getDirEntry(String childName) {
        Lock writeLock = this.getLockSupport().getCacheLock(this).writeLock();
        if (trace) {
            this.trace("waiting for lock", new Object[0]);
        }
        writeLock.lock();
        try {
            DirectoryStorage storage = this.getExistingDirectoryStorage();
            if (storage == DirectoryStorage.EMPTY) {
                DirEntry dirEntry = null;
                return dirEntry;
            }
            DirEntry dirEntry = storage.getValidEntry(childName);
            return dirEntry;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateStat(RemotePlainFile fo, DirEntry entry) {
        block10: {
            RemoteLogger.assertTrue(fo.getNameExt().equals(entry.getName()));
            RemoteLogger.assertTrue(fo.getParent() == this);
            RemoteLogger.assertFalse(entry.isDirectory());
            RemoteLogger.assertFalse(entry.isLink());
            Lock writeLock = this.getLockSupport().getCacheLock(this).writeLock();
            if (trace) {
                this.trace("waiting for lock", new Object[0]);
            }
            writeLock.lock();
            try {
                DirectoryStorage storage = this.getExistingDirectoryStorage();
                if (storage == DirectoryStorage.EMPTY) {
                    Exceptions.printStackTrace((Throwable)new IllegalStateException("Update stat is called but remote directory cache does not exist"));
                    break block10;
                }
                List<DirEntry> entries = storage.listValid(fo.getNameExt());
                entry.setCache(fo.getCache().getName());
                entries.add(entry);
                DirectoryStorage newStorage = new DirectoryStorage(this.getStorageFile(), entries);
                try {
                    newStorage.store();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                Object object = this.refLock;
                synchronized (object) {
                    this.storageRef = new SoftReference<DirectoryStorage>(newStorage);
                }
                fo.setPendingRemoteDelivery(false);
            }
            finally {
                writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private DirectoryStorage getDirectoryStorageImpl(boolean forceRefresh, String expectedName, String childName, boolean expected) throws TimeoutException, ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
        DirectoryStorage s;
        boolean fromMemOrDiskCache;
        if (forceRefresh && !ConnectionManager.getInstance().isConnectedTo(this.getExecutionEnvironment())) {
            throw RemoteExceptions.createConnectException(RemoteFileSystemUtils.getConnectExceptionMessage(this.getExecutionEnvironment()));
        }
        File storageFile = this.getStorageFile();
        Object object = this.refLock;
        // MONITORENTER : object
        DirectoryStorage storage = this.storageRef.get();
        // MONITOREXIT : object
        if (storage == null) {
            fromMemOrDiskCache = false;
            storage = DirectoryStorage.EMPTY;
            if (storageFile.exists()) {
                Lock readLock = this.getLockSupport().getCacheLock(this).readLock();
                try {
                    readLock.lock();
                    try {
                        storage = DirectoryStorage.load(storageFile, this.getExecutionEnvironment());
                        fromMemOrDiskCache = true;
                        Object object2 = this.refLock;
                        // MONITORENTER : object2
                        s = this.storageRef.get();
                        if (s != null) {
                            if (trace) {
                                this.trace("using storage that was kept by other thread", new Object[0]);
                            }
                            storage = s;
                        } else {
                            this.storageRef = new SoftReference<DirectoryStorage>(storage);
                        }
                        // MONITOREXIT : object2
                    }
                    catch (FormatException e) {
                        FormatException.reportIfNeeded(e);
                        storageFile.delete();
                    }
                    catch (InterruptedIOException e) {
                        throw e;
                    }
                    catch (FileNotFoundException e) {
                        RemoteLogger.finest(e, (Object)this);
                    }
                    catch (IOException e) {
                        Exceptions.printStackTrace((Throwable)e);
                    }
                }
                finally {
                    readLock.unlock();
                }
            }
        } else {
            if (trace) {
                this.trace("use memory cached storage", new Object[0]);
            }
            fromMemOrDiskCache = true;
        }
        if (fromMemOrDiskCache && !forceRefresh && this.isAlreadyKnownChild(storage, childName)) {
            RemoteLogger.assertTrue(storage != null);
            if (!trace) return storage;
            this.trace("returning cached storage", new Object[0]);
            return storage;
        }
        if (childName != null && RemoteFileSystem.isSniffing(childName)) {
            if (this.isAutoMount()) return DirectoryStorage.EMPTY;
            if (this.getFileSystem().isDirectAutoMountChild(this.getPath())) {
                return DirectoryStorage.EMPTY;
            }
        }
        this.checkConnection(this, true);
        Lock writeLock = this.getLockSupport().getCacheLock(this).writeLock();
        if (trace) {
            this.trace("waiting for lock", new Object[0]);
        }
        writeLock.lock();
        try {
            Object e = this.refLock;
            // MONITORENTER : e
            s = this.storageRef.get();
            if (s != null) {
                if (trace) {
                    this.trace("got storage from mem cache after waiting on writeLock: {0} expectedName={1}", this.getPath(), expectedName);
                }
                if (!forceRefresh && this.isAlreadyKnownChild(s, childName)) {
                    DirectoryStorage directoryStorage = s;
                    // MONITOREXIT : e
                    return directoryStorage;
                }
                storage = s;
            }
            // MONITOREXIT : e
            if (!this.getCache().exists()) {
                this.getCache().mkdirs();
                if (!this.getCache().exists()) {
                    throw new IOException("Can not create cache directory " + this.getCache());
                }
            }
            if (trace) {
                this.trace("synchronizing", new Object[0]);
            }
            if (childName != null && RemoteLogger.isLoggable(Level.FINEST)) {
                RemoteLogger.finest("{0} is asked for child {1} while not having cache", this.getPath(), childName);
            }
            Exception problem = null;
            Map<String, DirEntry> newEntries = Collections.emptyMap();
            try {
                newEntries = this.readEntries(storage, forceRefresh, childName);
            }
            catch (FileNotFoundException ex) {
                throw ex;
            }
            catch (IOException | ExecutionException | TimeoutException ex) {
                problem = ex;
            }
            if (problem != null) {
                if (!ConnectionManager.getInstance().isConnectedTo(this.getExecutionEnvironment())) {
                    this.getFileSystem().addPendingFile(this);
                    throw RemoteExceptions.createConnectException(problem.getMessage());
                }
                boolean fileNotFoundException = RemoteFileSystemUtils.isFileNotFoundException(problem);
                if (fileNotFoundException) {
                    Object object3 = this.refLock;
                    // MONITORENTER : object3
                    this.storageRef = new SoftReference<DirectoryStorage>(DirectoryStorage.EMPTY);
                    // MONITOREXIT : object3
                }
                if (!fileNotFoundException) {
                    if (problem instanceof IOException) {
                        throw (IOException)problem;
                    }
                    if (problem instanceof ExecutionException) {
                        throw (ExecutionException)problem;
                    }
                    if (!(problem instanceof TimeoutException)) throw new IllegalStateException("Unexpected exception class: " + problem.getClass().getName(), problem);
                    throw (TimeoutException)problem;
                }
            }
            storage = this.updateChildren(newEntries, storage, fromMemOrDiskCache, expectedName, childName, expected);
            return storage;
        }
        finally {
            writeLock.unlock();
        }
    }

    private boolean isPendingDelivery(DirEntry entry) {
        RemotePlainFile pf;
        RemoteFileObject child;
        String name = entry.getName();
        return name.startsWith("#") && name.endsWith("#") && (child = this.getFileObject(name = name.substring(1, name.length() - 1), null)) != null && child.getImplementor() instanceof RemotePlainFile && (pf = (RemotePlainFile)child.getImplementor()).isPendingRemoteDelivery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirectoryStorage updateChildren(Map<String, DirEntry> newEntries, DirectoryStorage storage, boolean fromMemOrDiskCache, String expectedName, String childName, boolean expected) throws IOException {
        Object mapEntry;
        this.getFileSystem().incrementDirSyncCount();
        HashMap<String, List<DirEntry>> dupLowerNames = new HashMap<String, List<DirEntry>>();
        boolean hasDups = false;
        boolean changed = newEntries.size() != storage.listAll().size() || storage == DirectoryStorage.EMPTY;
        HashSet<DirEntry> keepCacheNames = new HashSet<DirEntry>();
        ArrayList<DirEntry> entriesToFireChanged = new ArrayList<DirEntry>();
        ArrayList<DirEntry> entriesToFireChangedRO = new ArrayList<DirEntry>();
        ArrayList<DirEntry> entriesToFireCreated = new ArrayList<DirEntry>();
        DirEntry expectedCreated = null;
        ArrayList<RemoteFileObject> filesToFireDeleted = new ArrayList<RemoteFileObject>();
        Iterator<Map.Entry<String, DirEntry>> it = newEntries.entrySet().iterator();
        while (it.hasNext()) {
            mapEntry = it.next();
            if (!this.isPendingDelivery((DirEntry)mapEntry.getValue())) continue;
            it.remove();
        }
        for (DirEntry newEntry : newEntries.values()) {
            if (newEntry.isValid()) {
                String lowerCacheName;
                ArrayList<DirEntry> dupEntries;
                String cacheName;
                DirEntry oldEntry = storage.getValidEntry(newEntry.getName());
                if (oldEntry == null || !oldEntry.isValid()) {
                    changed = true;
                    cacheName = RemoteFileSystemUtils.escapeFileName(newEntry.getName());
                    if (fromMemOrDiskCache || newEntry.getName().equals(expectedName) || this.getFlag((byte)8)) {
                        entriesToFireCreated.add(newEntry);
                        expectedCreated = newEntry;
                    }
                } else if (oldEntry.isSameType(newEntry)) {
                    cacheName = oldEntry.getCache();
                    keepCacheNames.add(newEntry);
                    boolean fire = false;
                    if ((!newEntry.isSameLastModified(oldEntry) || newEntry.getSize() != oldEntry.getSize()) && newEntry.isPlainFile()) {
                        fire = true;
                        changed = true;
                        File entryCache = new File(this.getCache(), oldEntry.getCache());
                        if (entryCache.exists()) {
                            if (trace) {
                                this.trace("removing cache for updated file {0}", entryCache.getAbsolutePath());
                            }
                            entryCache.delete();
                        }
                    }
                    if (!RemoteDirectory.equals(newEntry.getLinkTarget(), oldEntry.getLinkTarget())) {
                        fire = true;
                        changed = true;
                        this.getFileSystem().getFactory().setLink(this, this.getPath() + '/' + newEntry.getName(), newEntry.getLinkTarget());
                    }
                    if (!newEntry.isSameAccess(oldEntry)) {
                        entriesToFireChangedRO.add(newEntry);
                        fire = true;
                        changed = true;
                    }
                    if (!newEntry.isDirectory() && newEntry.getSize() != oldEntry.getSize()) {
                        fire = true;
                        changed = true;
                    }
                    if (newEntry.hasINode() && !newEntry.isSameINode(oldEntry)) {
                        fire = true;
                        changed = true;
                    }
                    if (fire) {
                        entriesToFireChanged.add(newEntry);
                    }
                } else {
                    changed = true;
                    this.getFileSystem().getFactory().changeImplementor(this, oldEntry, newEntry);
                    if (oldEntry.isLink() && newEntry.isPlainFile() && newEntry.canWrite()) {
                        entriesToFireChangedRO.add(newEntry);
                    } else {
                        entriesToFireChanged.add(newEntry);
                    }
                    cacheName = null;
                }
                if (cacheName != null) {
                    newEntry.setCache(cacheName);
                }
                if ((dupEntries = (ArrayList<DirEntry>)dupLowerNames.get(lowerCacheName = RemoteFileSystemUtils.isSystemCaseSensitive() ? newEntry.getCache() : newEntry.getCache().toLowerCase())) == null) {
                    dupEntries = new ArrayList<DirEntry>();
                    dupLowerNames.put(lowerCacheName, dupEntries);
                } else {
                    hasDups = true;
                }
                dupEntries.add(newEntry);
                continue;
            }
            if (storage.isKnown(childName)) continue;
            changed = true;
        }
        if (changed) {
            for (DirEntry oldEntry : storage.listValid()) {
                RemoteFileObject removedFO;
                DirEntry newEntry = newEntries.get(oldEntry.getName());
                if (newEntry != null && newEntry.isValid() || (removedFO = this.invalidate(oldEntry)) == null) continue;
                filesToFireDeleted.add(removedFO);
            }
            if (hasDups) {
                for (Map.Entry mapEntry2 : new ArrayList(dupLowerNames.entrySet())) {
                    List dupEntries = (List)mapEntry2.getValue();
                    if (dupEntries.size() <= 1) continue;
                    block13: for (int i = 0; i < dupEntries.size(); ++i) {
                        DirEntry entry = (DirEntry)dupEntries.get(i);
                        if (keepCacheNames.contains(entry)) continue;
                        for (int j = 0; j < Integer.MAX_VALUE; ++j) {
                            String cacheName = (String)mapEntry2.getKey() + '_' + j;
                            String lowerCacheName = cacheName.toLowerCase();
                            if (dupLowerNames.containsKey(lowerCacheName)) continue;
                            if (trace) {
                                this.trace("resolving cache names conflict in {0}: {1} -> {2}", this.getCache().getAbsolutePath(), entry.getCache(), cacheName);
                            }
                            entry.setCache(cacheName);
                            dupLowerNames.put(lowerCacheName, Collections.singletonList(entry));
                            continue block13;
                        }
                    }
                }
            }
            storage = new DirectoryStorage(this.getStorageFile(), newEntries.values());
            storage.store();
        } else {
            storage.touch();
        }
        this.setFlag((byte)8, false);
        mapEntry = this.refLock;
        synchronized (mapEntry) {
            this.storageRef = new SoftReference<DirectoryStorage>(storage);
        }
        if (changed) {
            Object fo;
            this.dropMagic();
            for (RemoteFileObject deleted : filesToFireDeleted) {
                this.fireDeletedEvent(this.getOwnerFileObject(), deleted, expected, true);
            }
            FilesystemInterceptorProvider.FilesystemInterceptor interceptor = USE_VCS ? FilesystemInterceptorProvider.getDefault().getFilesystemInterceptor(this.getFileSystem()) : null;
            for (DirEntry entry : entriesToFireCreated) {
                fo = this.getFileSystem().getFactory().createFileObject(this, entry).getOwnerFileObject();
                if (interceptor != null && expectedCreated != null && !expectedCreated.equals(entry)) {
                    try {
                        this.getFileSystem().setInsideVCS(true);
                        interceptor.createdExternally(FilesystemInterceptorProvider.toFileProxy((FileObject)fo));
                    }
                    finally {
                        this.getFileSystem().setInsideVCS(false);
                    }
                }
                this.fireRemoteFileObjectCreated((RemoteFileObject)fo);
            }
            for (DirEntry entry : entriesToFireChanged) {
                fo = this.getFileSystem().getFactory().getCachedFileObject(this.getPath() + '/' + entry.getName());
                if (fo == null) continue;
                if (((RemoteFileObjectBase)fo).isPendingRemoteDelivery()) {
                    RemoteLogger.getInstance().log(Level.FINE, "Skipping change event for pending file {0}", fo);
                    continue;
                }
                long time = ((RemoteFileObjectBase)fo).lastModified().getTime();
                ((RemoteFileObjectBase)fo).fireFileChangedEvent(((RemoteFileObjectBase)fo).getListeners(), new FileEvent((FileObject)((RemoteFileObjectBase)fo).getOwnerFileObject(), (FileObject)((RemoteFileObjectBase)fo).getOwnerFileObject(), expected, time));
                this.fireFileChangedEvent(this.getListeners(), new FileEvent((FileObject)this.getOwnerFileObject(), (FileObject)((RemoteFileObjectBase)fo).getOwnerFileObject(), expected, time));
            }
            this.fireReadOnlyChangedEventsIfNeed(entriesToFireChangedRO);
            if (interceptor != null && !Boolean.getBoolean("org.netbeans.modules.masterfs.watcher.disable")) {
                try {
                    this.getFileSystem().setInsideVCS(true);
                    interceptor.refreshRecursively(FilesystemInterceptorProvider.toFileProxy(this.getOwnerFileObject()), this.lastModified().getTime(), new LinkedList());
                }
                finally {
                    this.getFileSystem().setInsideVCS(false);
                }
            }
        }
        return storage;
    }

    private void fireReadOnlyChangedEventsIfNeed(List<DirEntry> entriesToFireChangedRO) {
        for (DirEntry entry : entriesToFireChangedRO) {
            RemoteFileObjectBase fo = this.getFileSystem().getFactory().getCachedFileObject(this.getPath() + '/' + entry.getName());
            if (fo == null) continue;
            if (fo.isPendingRemoteDelivery()) {
                RemoteLogger.getInstance().log(Level.FINE, "Skipping change r/o event for pending file {0}", fo);
                continue;
            }
            fo.fireReadOnlyChangedEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDeletedEvent(RemoteFileObject parent, RemoteFileObject fo, boolean expected, boolean recursive) {
        FilesystemInterceptorProvider.FilesystemInterceptor interceptor;
        FilesystemInterceptorProvider.FilesystemInterceptor filesystemInterceptor = interceptor = USE_VCS ? FilesystemInterceptorProvider.getDefault().getFilesystemInterceptor(this.getFileSystem()) : null;
        if (recursive) {
            RemoteFileObjectBase[] children;
            for (RemoteFileObjectBase c : children = fo.getImplementor().getExistentChildren(true)) {
                Enumeration<FileChangeListener> listeners = c.getListeners();
                RemoteFileObject childFO = c.getOwnerFileObject();
                if (interceptor != null) {
                    try {
                        this.getFileSystem().setInsideVCS(true);
                        this.getFileSystem().setExternallyRemoved(childFO.getImplementor());
                        try {
                            interceptor.deletedExternally(FilesystemInterceptorProvider.toFileProxy(childFO));
                        }
                        finally {
                            this.getFileSystem().setExternallyRemoved(null);
                        }
                    }
                    finally {
                        this.getFileSystem().setInsideVCS(false);
                    }
                }
                c.fireFileDeletedEvent(listeners, new FileEvent((FileObject)childFO, (FileObject)childFO, expected));
                RemoteFileObjectBase p = c.getParent();
                p.fireFileDeletedEvent(p.getListeners(), new FileEvent((FileObject)p.getOwnerFileObject(), (FileObject)childFO, expected));
            }
        }
        if (interceptor != null) {
            this.getFileSystem().setExternallyRemoved(fo.getImplementor());
            try {
                this.getFileSystem().setInsideVCS(true);
                interceptor.deletedExternally(FilesystemInterceptorProvider.toFileProxy(fo));
            }
            finally {
                this.getFileSystem().setInsideVCS(false);
                this.getFileSystem().setExternallyRemoved(null);
            }
        }
        fo.fireFileDeletedEvent(fo.getImplementor().getListeners(), new FileEvent((FileObject)fo, (FileObject)fo, expected));
        parent.fireFileDeletedEvent(parent.getImplementor().getListeners(), new FileEvent((FileObject)parent, (FileObject)fo, expected));
    }

    @Override
    public void warmup(FileSystemProvider.WarmupMode mode, Collection<String> extensions) {
        switch (mode) {
            case FILES_CONTENT: {
                this.warmupFiles(extensions);
                break;
            }
            case RECURSIVE_LS: {
                this.warmupDirs();
                break;
            }
            default: {
                Exceptions.printStackTrace((Throwable)new IllegalAccessException("Unexpected warmup mode: " + mode));
            }
        }
    }

    private void warmupFiles(Collection<String> extensions) {
        File zipFile;
        if (ConnectionManager.getInstance().isConnectedTo(this.getExecutionEnvironment()) && !(zipFile = new File(this.getCache(), ".rfs_zip.zip")).exists()) {
            File zipPartFile = new File(this.getCache(), ".rfs_zip.part");
            this.getFileSystem().getZipper().schedule(zipFile, zipPartFile, this.getPath(), extensions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ensureChildSyncFromZip(RemotePlainFile child) {
        File file = new File(this.getCache(), ".rfs_zip.zip");
        if (file.exists()) {
            ZipFile zipFile = null;
            InputStream is = null;
            OutputStream os = null;
            boolean ok = false;
            try {
                zipFile = new ZipFile(file);
                String path = child.getPath();
                RemoteLogger.assertTrue(path.startsWith("/"));
                path = path.substring(1);
                ZipEntry zipEntry = zipFile.getEntry(path);
                if (zipEntry != null) {
                    long hours;
                    long delta;
                    boolean same;
                    if (zipEntry.getSize() != child.getSize()) {
                        boolean bl = false;
                        return bl;
                    }
                    long zipTime = zipEntry.getTime();
                    long childTime = child.lastModified().getTime() - (long)TimeZone.getDefault().getRawOffset();
                    if ((childTime /= 1000L) % 2L == 1L && (zipTime /= 1000L) % 2L == 0L) {
                        ++childTime;
                    }
                    if (same = (delta = zipTime - childTime) == 0L ? true : (delta % 3600L == 0L ? -23L <= (hours = delta / 3600L) && hours <= 23L : false)) {
                        is = zipFile.getInputStream(zipEntry);
                        os = new FileOutputStream(child.getCache());
                        FileUtil.copy((InputStream)is, (OutputStream)os);
                        ok = true;
                    }
                    RemoteLogger.finest("Zip timestamp differ for {0}", child);
                }
            }
            catch (IOException ex) {
                RemoteLogger.fine(ex);
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException ex) {
                        ok = false;
                        RemoteLogger.fine(ex);
                    }
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ex) {
                        RemoteLogger.fine(ex);
                    }
                }
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException ex) {
                        RemoteLogger.fine(ex);
                    }
                }
                return ok;
            }
        }
        RemoteDirectory parent = this.getParentImpl();
        if (parent != null) {
            return parent.ensureChildSyncFromZip(child);
        }
        return false;
    }

    private static boolean isLoadingInEditor() {
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (!"org.openide.text.DocumentOpenClose$DocumentLoad".equals(element.getClassName()) || !"atomicLockedRun".equals(element.getMethodName())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cacheExists(RemotePlainFile child) {
        Lock lock = this.getLockSupport().getCacheLock(child).readLock();
        lock.lock();
        try {
            boolean bl = child.getCache().exists();
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    void ensureChildSync(RemotePlainFile child) throws TimeoutException, ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
        block15: {
            if (this.cacheExists(child)) {
                if (RemoteDirectory.isLoadingInEditor() && ConnectionManager.getInstance().isConnectedTo(this.getExecutionEnvironment())) {
                    child.refreshImpl(false, null, false, RemoteFileObjectBase.RefreshMode.DEFAULT);
                }
                if (this.cacheExists(child)) {
                    return;
                }
            }
            this.checkConnection(child, true);
            DirectoryStorage storage = this.getDirectoryStorage(child.getNameExt());
            Lock lock = this.getLockSupport().getCacheLock(child).writeLock();
            lock.lock();
            try {
                if (child.getCache().exists()) {
                    return;
                }
                File cacheParentFile = child.getCache().getParentFile();
                if (!cacheParentFile.exists()) {
                    cacheParentFile.mkdirs();
                    if (!cacheParentFile.exists()) {
                        throw new IOException("Unable to create parent firectory " + cacheParentFile.getAbsolutePath());
                    }
                }
                if (this.ensureChildSyncFromZip(child)) {
                    return;
                }
                StringWriter errorWriter = new StringWriter();
                Future task = CommonTasksSupport.downloadFile((String)child.getPath(), (ExecutionEnvironment)this.getExecutionEnvironment(), (String)child.getCache().getAbsolutePath(), (Writer)errorWriter);
                int rc = (Integer)task.get();
                if (rc == 0) {
                    this.getFileSystem().incrementFileCopyCount();
                    break block15;
                }
                throw RemoteExceptions.createIOException(NbBundle.getMessage(RemoteDirectory.class, (String)"EXC_CanNotDownload", (Object)this.getDisplayName(child.getPath()), (Object)errorWriter.toString()));
            }
            catch (InterruptedException | ExecutionException ex) {
                child.getCache().delete();
                throw ex;
            }
            finally {
                lock.unlock();
            }
        }
    }

    private void checkConnection(RemoteFileObjectBase fo, boolean throwConnectException) throws ConnectException {
        if (!ConnectionManager.getInstance().isConnectedTo(this.getExecutionEnvironment())) {
            this.getFileSystem().addPendingFile(fo);
            if (throwConnectException) {
                throw RemoteExceptions.createConnectException(RemoteFileSystemUtils.getConnectExceptionMessage(this.getExecutionEnvironment()));
            }
        }
    }

    @Override
    public FileInfoProvider.StatInfo.FileType getType() {
        return FileInfoProvider.StatInfo.FileType.Directory;
    }

    @Override
    public final InputStream getInputStream(boolean checkLock) throws FileNotFoundException {
        throw new FileNotFoundException(this.getPath());
    }

    public byte[] getMagic(RemoteFileObjectBase file) {
        return this.getMagicCache().get(file.getNameExt());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MagicCache getMagicCache() {
        MagicCache magic;
        Object object = this.magicLock;
        synchronized (object) {
            magic = this.magicCache.get();
            if (magic == null) {
                magic = new MagicCache(this);
                this.magicCache = new SoftReference<MagicCache>(magic);
            }
        }
        return magic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropMagic() {
        Object object = this.magicLock;
        synchronized (object) {
            MagicCache magic = this.magicCache.get();
            if (magic != null) {
                magic.clean(null);
                this.magicCache = new SoftReference<Object>(null);
            } else {
                new MagicCache(this).clean(null);
            }
        }
    }

    @Override
    protected final OutputStream getOutputStreamImpl(FileLock lock, RemoteFileObjectBase orig) throws IOException {
        throw new IOException("Can not write into a directory " + this.getDisplayName());
    }

    private RemoteFileObject invalidate(DirEntry oldEntry) {
        RemoteFileObject fo = this.getFileSystem().getFactory().invalidate(this.getPath() + '/' + oldEntry.getName());
        File oldEntryCache = new File(this.getCache(), oldEntry.getCache());
        this.removeFile(oldEntryCache);
        return fo;
    }

    private void removeFile(File cache) {
        File[] children;
        if (cache.isDirectory() && (children = cache.listFiles()) != null) {
            for (File child : children) {
                this.removeFile(child);
            }
        }
        cache.delete();
    }

    @Override
    public void refreshImpl(boolean recursive, Set<String> antiLoop, boolean expected, RemoteFileObjectBase.RefreshMode refreshMode, int timeoutMillis) throws TimeoutException, ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
        DirectoryStorage storage;
        if (antiLoop != null) {
            if (antiLoop.contains(this.getPath())) {
                return;
            }
            antiLoop.add(this.getPath());
        }
        if (!((storage = this.getExistingDirectoryStorage()) != null && storage != DirectoryStorage.EMPTY || this.getFlag((byte)8))) {
            return;
        }
        try {
            DirectoryStorage refreshedStorage = this.refreshDirectoryStorage(null, expected);
            if (recursive) {
                for (RemoteFileObjectBase child : this.getExistentChildren(refreshedStorage)) {
                    child.refreshImpl(true, antiLoop, expected, RemoteFileObjectBase.RefreshMode.FROM_PARENT);
                }
            }
        }
        catch (FileNotFoundException ex) {
            RemoteDirectory parent = this.getParentImpl();
            if (parent != null) {
                parent.refreshImpl(false, antiLoop, expected, refreshMode);
            }
            throw ex;
        }
    }

    private void trace(String message, Object ... args) {
        if (trace) {
            message = "SYNC [" + this.getPath() + "][" + System.identityHashCode(this) + "][" + Thread.currentThread().getId() + "]: " + message;
            RemoteLogger.getInstance().log(Level.FINEST, message, args);
        }
    }

    private static boolean equals(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    private DirEntry getChildEntry(RemoteFileObjectBase child) {
        try {
            DirectoryStorage directoryStorage = this.getDirectoryStorage(child.getNameExt());
            if (directoryStorage != null) {
                DirEntry entry = directoryStorage.getValidEntry(child.getNameExt());
                if (entry != null) {
                    return entry;
                }
                RemoteLogger.getInstance().log(Level.INFO, "Not found entry for file {0}", child);
            }
        }
        catch (ConnectException ex) {
            RemoteLogger.finest(ex, (Object)this);
        }
        catch (IOException | InterruptedException | CancellationException | ExecutionException | TimeoutException ex) {
            RemoteLogger.finest(ex, (Object)this);
        }
        return null;
    }

    long getSize(RemoteFileObjectBase child) {
        DirEntry childEntry = this.getChildEntry(child);
        if (childEntry != null) {
            return childEntry.getSize();
        }
        return 0L;
    }

    Date lastModified(RemoteFileObjectBase child) {
        DirEntry childEntry = this.getChildEntry(child);
        if (childEntry != null) {
            return childEntry.getLastModified();
        }
        return new Date(0L);
    }

    DirectoryStorage testGetExistingDirectoryStorage() {
        return this.getExistingDirectoryStorage();
    }

    private File getStorageFile() {
        return new File(this.getCache(), ".rfs_cache");
    }

    @Override
    public boolean hasCache() {
        return this.getStorageFile().exists();
    }

    @Override
    public void diagnostics(boolean recursive) {
        RemoteFileObjectBase[] existentChildren = this.getExistentChildren();
        System.err.printf("\nRemoteFS diagnostics for %s\n", this);
        System.err.printf("Existing children count: %d\n", existentChildren.length);
        File cache = this.getStorageFile();
        System.err.printf("Cache file: %s\n", cache.getAbsolutePath());
        System.err.printf("Cache content: \n", new Object[0]);
        RemoteDirectory.printFile(cache, System.err);
        System.err.printf("Existing children:\n", new Object[0]);
        for (RemoteFileObjectBase fo : existentChildren) {
            System.err.printf("\t%s [%s] %d\n", fo.getNameExt(), fo.getCache().getName(), fo.getCache().length());
        }
        if (recursive) {
            for (RemoteFileObjectBase fo : existentChildren) {
                fo.diagnostics(recursive);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printFile(File file, PrintStream out) {
        BufferedReader rdr = null;
        try {
            rdr = Files.newBufferedReader(file.toPath(), Charset.forName("UTF-8"));
            try {
                String line;
                while ((line = rdr.readLine()) != null) {
                    out.printf("%s\n", line);
                }
            }
            finally {
                try {
                    rdr.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
        finally {
            try {
                if (rdr != null) {
                    rdr.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
        }
    }

    private static final class MagicLock {
        private MagicLock() {
        }
    }

    private static final class RefLock {
        private RefLock() {
        }
    }
}

