/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.support.actions;

import java.io.IOException;
import java.lang.ref.Reference;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.groovy.support.actions.GroovyTestClassInfoTask;
import org.netbeans.spi.project.SingleMethod;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.NbDocument;

public final class TestMethodUtil {
    private static final Logger LOGGER = Logger.getLogger(TestMethodUtil.class.getName());
    private Reference<JavaSource> resolver;

    static boolean isTestClass(Node activatedNode) {
        FileObject fo = TestMethodUtil.getFileObjectFromNode(activatedNode);
        if (fo != null && !TestMethodUtil.isGroovyFile(fo)) {
            return false;
        }
        return false;
    }

    static SingleMethod getTestMethod(Document doc, int cursor) {
        SingleMethod sm = null;
        if (doc != null) {
            JavaSource js = JavaSource.forDocument((Document)doc);
            GroovyTestClassInfoTask task = new GroovyTestClassInfoTask(cursor);
            try {
                Future f;
                if (js != null && (f = js.runWhenScanFinished((Task)task, true)).isDone() && task.getFileObject() != null && task.getMethodName() != null) {
                    sm = new SingleMethod(task.getFileObject(), task.getMethodName());
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, null, ex);
            }
        }
        return sm;
    }

    static boolean canHandle(Node activatedNode) {
        FileObject fo = TestMethodUtil.getFileObjectFromNode(activatedNode);
        if (fo != null) {
            SingleMethod sm;
            JEditorPane pane;
            if (!TestMethodUtil.isGroovyFile(fo)) {
                return false;
            }
            EditorCookie ec = (EditorCookie)activatedNode.getLookup().lookup(EditorCookie.class);
            if (ec != null && (pane = NbDocument.findRecentEditorPane((EditorCookie)ec)) != null && (sm = TestMethodUtil.getTestMethod(pane.getDocument(), pane.getCaret().getDot())) != null) {
                return true;
            }
        }
        return false;
    }

    private static FileObject getFileObjectFromNode(Node node) {
        DataObject dO = (DataObject)node.getLookup().lookup(DataObject.class);
        if (null != dO) {
            return dO.getPrimaryFile();
        }
        DataFolder df = (DataFolder)node.getLookup().lookup(DataFolder.class);
        if (null != df) {
            return df.getPrimaryFile();
        }
        return null;
    }

    private static boolean isGroovyFile(FileObject fileObj) {
        return "groovy".equals(fileObj.getExt()) || "text/x-groovy".equals(FileUtil.getMIMEType((FileObject)fileObj));
    }
}

