/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations;

import org.netbeans.api.annotations.common.CheckReturnValue;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;

public class CppUtils {
    private CppUtils() {
    }

    public static String normalizeDriveLetter(CompilerSet cs, String path) {
        if (path.length() > 1 && path.charAt(1) == ':') {
            String driveLetterPrefix = cs.getCompilerFlavor().getToolchainDescriptor().getDriveLetterPrefix();
            String res = driveLetterPrefix != null ? driveLetterPrefix + path.charAt(0) + path.substring(2) : "/" + path.charAt(0) + path.substring(2);
            return res.replace('\\', '/');
        }
        return path;
    }

    @CheckReturnValue
    public static String getQmakeSpec(CompilerSet cs, int platform) {
        CompilerFlavor flavor = cs.getCompilerFlavor();
        String qmakespec = flavor.getToolchainDescriptor().getQmakeSpec();
        if (qmakespec != null && 0 <= qmakespec.indexOf("${os}")) {
            String os = null;
            switch (platform) {
                case 2: {
                    os = "linux";
                    break;
                }
                case 4: {
                    os = "macx";
                    break;
                }
                case 0: 
                case 1: {
                    os = "solaris";
                    break;
                }
                case 3: {
                    os = "win32";
                }
            }
            qmakespec = os == null ? null : qmakespec.replaceAll("\\$\\{os\\}", os);
        }
        return qmakespec;
    }

    public static String getDefaultDevelopmentHost(FileObject projectDirectory) {
        ExecutionEnvironment env = FileSystemProvider.getExecutionEnvironment((FileObject)projectDirectory);
        if (env.isLocal()) {
            env = ServerList.getDefaultRecord().getExecutionEnvironment();
        }
        return ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)env);
    }

    public static String getDefaultDevelopmentHost(FileSystem projectFS) {
        ExecutionEnvironment env = FileSystemProvider.getExecutionEnvironment((FileSystem)projectFS);
        if (env.isLocal()) {
            env = ServerList.getDefaultRecord().getExecutionEnvironment();
        }
        return ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)env);
    }

    public static ExecutionEnvironment convertAfterReading(ExecutionEnvironment env, MakeConfiguration makeConfiguration) {
        if (env.isLocal()) {
            return makeConfiguration.getFileSystemHost();
        }
        return env;
    }

    public static ExecutionEnvironment convertBeforeWriting(ExecutionEnvironment env, MakeConfiguration makeConfiguration) {
        if (env.isRemote() && env.equals((Object)makeConfiguration.getFileSystemHost())) {
            return ExecutionEnvironmentFactory.getLocal();
        }
        return env;
    }
}

