/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.ide.ui;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.jar.Attributes;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.jboss4.JBDeploymentManager;
import org.netbeans.modules.j2ee.jboss4.ide.ui.JBPluginProperties;
import org.netbeans.modules.j2ee.jboss4.util.JBProperties;
import org.openide.filesystems.JarFileSystem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JBPluginUtils {
    public static final String SERVER_4_XML = File.separator + "deploy" + File.separator + "jbossweb-tomcat55.sar" + File.separator + "server.xml";
    public static final String SERVER_4_2_XML = File.separator + "deploy" + File.separator + "jboss-web.deployer" + File.separator + "server.xml";
    public static final String SERVER_5_XML = File.separator + "deploy" + File.separator + "jbossweb.sar" + File.separator + "server.xml";
    public static final Version JBOSS_5_0_0 = new Version("5.0.0");
    public static final Version JBOSS_5_0_1 = new Version("5.0.1");
    public static final Version JBOSS_6_0_0 = new Version("6.0.0");
    public static final Version JBOSS_7_0_0 = new Version("7.0.0");
    public static final Version JBOSS_7_1_0 = new Version("7.1.0");
    private static final Logger LOGGER = Logger.getLogger(JBPluginUtils.class.getName());
    private static final Version DOM4J_SERVER = new Version("4.0.4");
    public static final String LIB = "lib" + File.separator;
    public static final String MODULES_BASE = "modules" + File.separator;
    public static final String MODULES_BASE_7 = "modules" + File.separator + "system" + File.separator + "layers" + File.separator + "base" + File.separator;
    public static final String CLIENT = "client" + File.separator;
    public static final String COMMON = "common" + File.separator;
    public static final String[] JBOSS5_CLIENT_LIST = new String[]{"javassist.jar", "jbossall-client.jar", "jboss-deployment.jar", "jnp-client.jar", "jbosssx-client.jar", "jboss-client.jar", "jboss-common-core.jar", "jboss-logging-log4j.jar", "jboss-logging-spi.jar"};
    private static List<String> domainRequirements4x;
    private static List<String> domainRequirements5x;
    private static List<String> domainRequirements6x;
    private static List<String> domainRequirements7x;
    private static List<String> serverRequirements4x;
    private static List<String> serverAlterRequirements4x;
    private static List<String> serverRequirements5And6x;
    private static List<String> serverRequirements7x;

    public static List<URL> getJB5ClientClasspath(String serverRoot) throws MalformedURLException {
        ArrayList<URL> urlList = new ArrayList<URL>();
        File clientDir = new File(serverRoot, CLIENT);
        if (clientDir.exists()) {
            for (String jar : JBOSS5_CLIENT_LIST) {
                File jarFile = new File(clientDir, jar);
                if (!jarFile.exists()) continue;
                urlList.add(jarFile.toURI().toURL());
            }
        }
        return urlList;
    }

    private static synchronized List<String> getDomainRequirements4x() {
        if (domainRequirements4x == null) {
            domainRequirements4x = new ArrayList<String>(13);
            Collections.addAll(domainRequirements4x, "conf", "deploy", "lib", "conf/jboss-service.xml", "lib/jboss-j2ee.jar", "lib/jboss.jar", "lib/jbosssx.jar", "lib/jboss-transaction.jar", "lib/jmx-adaptor-plugin.jar", "lib/jnpserver.jar", "lib/log4j.jar", "deploy/jmx-invoker-service.xml");
        }
        return domainRequirements4x;
    }

    private static synchronized List<String> getDomainRequirements5x() {
        if (domainRequirements5x == null) {
            domainRequirements5x = new ArrayList<String>(11);
            Collections.addAll(domainRequirements5x, "conf", "deploy", "deployers", "lib", "conf/jboss-service.xml", "conf/bootstrap.xml", "deploy/jmx-invoker-service.xml");
        }
        return domainRequirements5x;
    }

    private static synchronized List<String> getDomainRequirements6x() {
        if (domainRequirements6x == null) {
            domainRequirements6x = new ArrayList<String>(11);
            Collections.addAll(domainRequirements6x, "conf", "deploy", "deployers", "lib", "conf/jboss-service.xml", "conf/bootstrap.xml", "deploy/hdscanner-jboss-beans.xml");
        }
        return domainRequirements6x;
    }

    private static synchronized List<String> getDomainRequirements7x() {
        if (domainRequirements7x == null) {
            domainRequirements7x = new ArrayList<String>(11);
            Collections.addAll(domainRequirements7x, "configuration", "deployments", "lib");
        }
        return domainRequirements7x;
    }

    private static synchronized List<String> getServerRequirements4x() {
        if (serverRequirements4x == null) {
            serverRequirements4x = new ArrayList<String>(6);
            Collections.addAll(serverRequirements4x, "bin", "client", "lib", "server", "lib/jboss-common.jar", "lib/endorsed/resolver.jar");
        }
        return serverRequirements4x;
    }

    private static synchronized List<String> getServerAlterRequirements4x() {
        if (serverAlterRequirements4x == null) {
            serverAlterRequirements4x = new ArrayList<String>(8);
            Collections.addAll(serverAlterRequirements4x, "bin", "client", "lib", "server", "lib/jboss-common.jar", "client/jaxb-xjc.jar", "client/jaxb-impl.jar", "client/jaxb-api.jar");
        }
        return serverAlterRequirements4x;
    }

    private static synchronized List<String> getServerRequirements5And6x() {
        if (serverRequirements5And6x == null) {
            serverRequirements5And6x = new ArrayList<String>(6);
            Collections.addAll(serverRequirements5And6x, "bin", "client", "lib", "server", "common/lib", "lib/dom4j.jar", "lib/jboss-dependency.jar", "lib/jboss-common-core.jar", "lib/endorsed");
        }
        return serverRequirements5And6x;
    }

    private static synchronized List<String> getServerRequirements7x() {
        if (serverRequirements7x == null) {
            serverRequirements7x = new ArrayList<String>(6);
            Collections.addAll(serverRequirements7x, "bin", "modules", "jboss-modules.jar");
        }
        return serverRequirements7x;
    }

    @NonNull
    public static String getModulesBase(String serverRoot) {
        File file = new File(serverRoot, MODULES_BASE_7);
        if (file.isDirectory()) {
            return MODULES_BASE_7;
        }
        return MODULES_BASE;
    }

    public static Hashtable getRegisteredDomains(String serverLocation) {
        Hashtable<String, String> result = new Hashtable<String, String>();
        File serverDirectory = new File(serverLocation);
        if (JBPluginUtils.isGoodJBServerLocation(serverDirectory, (Version)null)) {
            File file;
            String[] files;
            Version version = JBPluginUtils.getServerVersion(serverDirectory);
            if (version != null && "7".equals(version.getMajorNumber())) {
                files = new String[]{"standalone", "domain"};
                file = serverDirectory;
            } else {
                file = new File(serverLocation + File.separator + "server");
                files = file.list(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return new File(dir.getAbsolutePath() + File.separator + name).isDirectory();
                    }
                });
            }
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    String path = file.getAbsolutePath() + File.separator + files[i];
                    if (!JBPluginUtils.isGoodJBInstanceLocation(serverDirectory, new File(path))) continue;
                    result.put(files[i], path);
                }
            }
        }
        return result;
    }

    private static boolean isGoodJBInstanceLocation(File candidate, List<String> requirements) {
        return null != candidate && candidate.exists() && candidate.canRead() && candidate.isDirectory() && JBPluginUtils.hasRequiredChildren(candidate, requirements);
    }

    private static boolean isGoodJBInstanceLocation4x(File serverDir, File candidate) {
        if (!JBPluginUtils.isGoodJBInstanceLocation(candidate, JBPluginUtils.getDomainRequirements4x())) {
            return false;
        }
        Version version = JBPluginUtils.getServerVersion(serverDir);
        if (version == null) {
            return true;
        }
        if (version.compareToIgnoreUpdate(DOM4J_SERVER) > 0) {
            File dom4j = new File(candidate, "lib/dom4j.jar");
            return dom4j.exists() && dom4j.canRead();
        }
        return true;
    }

    private static boolean isGoodJBInstanceLocation5x(File serverDir, File candidate) {
        return JBPluginUtils.isGoodJBInstanceLocation(candidate, JBPluginUtils.getDomainRequirements5x());
    }

    private static boolean isGoodJBInstanceLocation6x(File serverDir, File candidate) {
        return JBPluginUtils.isGoodJBInstanceLocation(candidate, JBPluginUtils.getDomainRequirements6x());
    }

    private static boolean isGoodJBInstanceLocation7x(File serverDir, File candidate) {
        return JBPluginUtils.isGoodJBInstanceLocation(candidate, JBPluginUtils.getDomainRequirements7x());
    }

    public static boolean isGoodJBInstanceLocation(File serverDir, File candidate) {
        Version version = JBPluginUtils.getServerVersion(serverDir);
        if (version == null || !"4".equals(version.getMajorNumber()) && !"5".equals(version.getMajorNumber()) && !"6".equals(version.getMajorNumber()) && !"7".equals(version.getMajorNumber())) {
            return JBPluginUtils.isGoodJBInstanceLocation4x(serverDir, candidate) || JBPluginUtils.isGoodJBInstanceLocation5x(serverDir, candidate) || JBPluginUtils.isGoodJBInstanceLocation6x(serverDir, candidate) || JBPluginUtils.isGoodJBInstanceLocation7x(serverDir, candidate);
        }
        return "4".equals(version.getMajorNumber()) && JBPluginUtils.isGoodJBInstanceLocation4x(serverDir, candidate) || "5".equals(version.getMajorNumber()) && JBPluginUtils.isGoodJBInstanceLocation5x(serverDir, candidate) || "6".equals(version.getMajorNumber()) && JBPluginUtils.isGoodJBInstanceLocation6x(serverDir, candidate) || "7".equals(version.getMajorNumber()) && JBPluginUtils.isGoodJBInstanceLocation7x(serverDir, candidate);
    }

    private static boolean isGoodJBServerLocation(File candidate, List<String> requirements) {
        return null != candidate && candidate.exists() && candidate.canRead() && candidate.isDirectory() && JBPluginUtils.hasRequiredChildren(candidate, requirements);
    }

    private static boolean isGoodJBServerLocation4x(File candidate) {
        if (!JBPluginUtils.isGoodJBServerLocation(candidate, JBPluginUtils.getServerRequirements4x()) && !JBPluginUtils.isGoodJBServerLocation(candidate, JBPluginUtils.getServerAlterRequirements4x())) {
            return false;
        }
        Version version = JBPluginUtils.getServerVersion(candidate);
        if (version == null) {
            return true;
        }
        if (version.compareToIgnoreUpdate(DOM4J_SERVER) <= 0) {
            File dom4j = new File(candidate, "lib/dom4j.jar");
            return dom4j.exists() && dom4j.canRead();
        }
        return true;
    }

    private static boolean isGoodJBServerLocation5x(File candidate) {
        return JBPluginUtils.isGoodJBServerLocation(candidate, JBPluginUtils.getServerRequirements5And6x());
    }

    private static boolean isGoodJBServerLocation6x(File candidate) {
        return JBPluginUtils.isGoodJBServerLocation(candidate, JBPluginUtils.getServerRequirements5And6x());
    }

    private static boolean isGoodJBServerLocation7x(File candidate) {
        return JBPluginUtils.isGoodJBServerLocation(candidate, JBPluginUtils.getServerRequirements7x());
    }

    public static boolean isGoodJBServerLocation(@NonNull File candidate, @NullAllowed Version version) {
        Version realVersion = version;
        if (realVersion == null) {
            realVersion = JBPluginUtils.getServerVersion(candidate);
        }
        if (realVersion == null || !"4".equals(realVersion.getMajorNumber()) && !"5".equals(realVersion.getMajorNumber()) && !"6".equals(realVersion.getMajorNumber()) && !"7".equals(realVersion.getMajorNumber())) {
            return JBPluginUtils.isGoodJBServerLocation4x(candidate) || JBPluginUtils.isGoodJBServerLocation5x(candidate) || JBPluginUtils.isGoodJBServerLocation5x(candidate) || JBPluginUtils.isGoodJBServerLocation7x(candidate);
        }
        return "4".equals(realVersion.getMajorNumber()) && JBPluginUtils.isGoodJBServerLocation4x(candidate) || "5".equals(realVersion.getMajorNumber()) && JBPluginUtils.isGoodJBServerLocation5x(candidate) || "6".equals(realVersion.getMajorNumber()) && JBPluginUtils.isGoodJBServerLocation6x(candidate) || "7".equals(realVersion.getMajorNumber()) && JBPluginUtils.isGoodJBServerLocation7x(candidate);
    }

    public static boolean isJB4(JBDeploymentManager dm) {
        String installDir = dm.getInstanceProperties().getProperty("root-dir");
        Version version = JBPluginUtils.getServerVersion(new File(installDir));
        if (version == null) {
            return JBPluginUtils.isGoodJBServerLocation4x(new File(installDir));
        }
        return "4".equals(version.getMajorNumber());
    }

    public static boolean isGoodJBLocation(File server, File domain) {
        return JBPluginUtils.isGoodJBServerLocation4x(server) && JBPluginUtils.isGoodJBInstanceLocation4x(server, domain) || JBPluginUtils.isGoodJBServerLocation5x(server) && JBPluginUtils.isGoodJBInstanceLocation5x(server, domain);
    }

    private static boolean hasRequiredChildren(File candidate, List<String> requiredChildren) {
        if (null == candidate || null == candidate.list()) {
            return false;
        }
        if (null == requiredChildren) {
            return true;
        }
        for (String next : requiredChildren) {
            File test = new File(candidate.getPath() + File.separator + next);
            if (test.exists()) continue;
            return false;
        }
        return true;
    }

    public static String getDeployDir(String domainDir) {
        Version version = JBPluginUtils.getServerVersion(new File(JBPluginProperties.getInstance().getInstallLocation()));
        if ("7".equals(version.getMajorNumber())) {
            return domainDir + File.separator + "deployments";
        }
        return domainDir + File.separator + "deploy";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHTTPConnectorPort(String domainDir) {
        String defaultPort = "8080";
        File serverXmlFile = new File(domainDir + SERVER_4_XML);
        if (!(serverXmlFile.exists() || (serverXmlFile = new File(domainDir + SERVER_4_2_XML)).exists() || (serverXmlFile = new File(domainDir + SERVER_5_XML)).exists())) {
            return defaultPort;
        }
        FileInputStream inputStream = null;
        Document document = null;
        try {
            inputStream = new FileInputStream(serverXmlFile);
            try {
                document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
            }
            finally {
                ((InputStream)inputStream).close();
            }
            Element root = document.getDocumentElement();
            NodeList children = root.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (!child.getNodeName().equals("Service")) continue;
                NodeList nl = child.getChildNodes();
                for (int j = 0; j < nl.getLength(); ++j) {
                    Node ch = nl.item(j);
                    if (!ch.getNodeName().equals("Connector")) continue;
                    String port = ch.getAttributes().getNamedItem("port").getNodeValue();
                    if (port.startsWith("$")) {
                        return defaultPort;
                    }
                    try {
                        Integer.parseInt(port);
                        return port;
                    }
                    catch (NumberFormatException ex) {
                        return defaultPort;
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, null, e);
        }
        return defaultPort;
    }

    public static int getJnpPortNumber(String domainDir) {
        String jnpPort = JBPluginUtils.getJnpPort(domainDir);
        if (jnpPort != null && (jnpPort = jnpPort.trim()).length() > 0) {
            try {
                return Integer.parseInt(jnpPort);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1099;
    }

    public static int getJmxPortNumber(JBProperties jb, InstanceProperties ip) {
        String strPort = ip.getProperty("jmx-Port");
        if (strPort == null || strPort.trim().isEmpty()) {
            return JBPluginUtils.getDefaultJmxPortNumber(jb.getServerVersion());
        }
        try {
            return Integer.parseInt(strPort.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return JBPluginUtils.getDefaultJmxPortNumber(jb.getServerVersion());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getJnpPort(String domainDir) {
        String serviceXml = domainDir + File.separator + "conf" + File.separator + "jboss-service.xml";
        File xmlFile = new File(serviceXml);
        if (!xmlFile.exists()) {
            return "";
        }
        FileInputStream inputStream = null;
        Document document = null;
        try {
            inputStream = new FileInputStream(xmlFile);
            try {
                document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
            }
            finally {
                ((InputStream)inputStream).close();
            }
            Element root = document.getDocumentElement();
            NodeList children = root.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (!child.getNodeName().equals("mbean")) continue;
                NodeList nl = child.getChildNodes();
                if (!child.getAttributes().getNamedItem("name").getNodeValue().equals("jboss:service=Naming")) continue;
                for (int j = 0; j < nl.getLength(); ++j) {
                    Node ch = nl.item(j);
                    if (!ch.getNodeName().equals("attribute") || !ch.getAttributes().getNamedItem("name").getNodeValue().equals("Port")) continue;
                    return ch.getFirstChild().getNodeValue();
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger("global").log(Level.INFO, null, e);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRMINamingServicePort(String domainDir) {
        String serviceXml = domainDir + File.separator + "conf" + File.separator + "jboss-service.xml";
        File xmlFile = new File(serviceXml);
        if (!xmlFile.exists()) {
            return "";
        }
        FileInputStream inputStream = null;
        Document document = null;
        try {
            inputStream = new FileInputStream(xmlFile);
            try {
                document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
            }
            finally {
                ((InputStream)inputStream).close();
            }
            Element root = document.getDocumentElement();
            NodeList children = root.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (!child.getNodeName().equals("mbean")) continue;
                NodeList nl = child.getChildNodes();
                if (!child.getAttributes().getNamedItem("name").getNodeValue().equals("jboss:service=Naming")) continue;
                for (int j = 0; j < nl.getLength(); ++j) {
                    Node ch = nl.item(j);
                    if (!ch.getNodeName().equals("attribute") || !ch.getAttributes().getNamedItem("name").getNodeValue().equals("RmiPort")) continue;
                    return ch.getFirstChild().getNodeValue();
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger("global").log(Level.INFO, null, e);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRMIInvokerPort(String domainDir) {
        String serviceXml = domainDir + File.separator + "conf" + File.separator + "jboss-service.xml";
        File xmlFile = new File(serviceXml);
        if (!xmlFile.exists()) {
            return "";
        }
        FileInputStream inputStream = null;
        Document document = null;
        try {
            inputStream = new FileInputStream(xmlFile);
            try {
                document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
            }
            finally {
                ((InputStream)inputStream).close();
            }
            Element root = document.getDocumentElement();
            NodeList children = root.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (!child.getNodeName().equals("mbean")) continue;
                NodeList nl = child.getChildNodes();
                if (!child.getAttributes().getNamedItem("name").getNodeValue().equals("jboss:service=invoker,type=jrmp")) continue;
                for (int j = 0; j < nl.getLength(); ++j) {
                    Node ch = nl.item(j);
                    if (!ch.getNodeName().equals("attribute") || !ch.getAttributes().getNamedItem("name").getNodeValue().equals("RMIObjectPort")) continue;
                    return ch.getFirstChild().getNodeValue();
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger("global").log(Level.INFO, null, e);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPortFree(int port) {
        ServerSocket soc = null;
        try {
            soc = new ServerSocket(port);
        }
        catch (IOException ioe) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (soc != null) {
                try {
                    soc.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    @CheckForNull
    public static Version getServerVersion(File serverPath) {
        File serverDir;
        File[] files;
        assert (serverPath != null) : "Can't determine version with null server path";
        File systemJarFile = new File(serverPath, "lib/jboss-system.jar");
        Version version = JBPluginUtils.getVersion(systemJarFile);
        if (version == null && (files = (serverDir = new File(serverPath, JBPluginUtils.getModulesBase(serverPath.getAbsolutePath()) + "org/jboss/as/server/main")).listFiles(new JarFileFilter())) != null) {
            File jarFile;
            File[] fileArray = files;
            int n = fileArray.length;
            for (int i = 0; i < n && (version = JBPluginUtils.getVersion(jarFile = fileArray[i])) == null; ++i) {
            }
        }
        return version;
    }

    public static int getDefaultJmxPortNumber(Version version) {
        if (version != null && version.compareToIgnoreUpdate(JBOSS_7_0_0) >= 0) {
            return 9999;
        }
        return 1090;
    }

    private static Version getVersion(File systemJarFile) {
        if (!systemJarFile.exists()) {
            return null;
        }
        try {
            JarFileSystem systemJar = new JarFileSystem();
            systemJar.setJarFile(systemJarFile);
            Attributes attributes = systemJar.getManifest().getMainAttributes();
            String version = attributes.getValue("Specification-Version");
            if (version != null) {
                return new Version(version);
            }
            return null;
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, null, ex);
            return null;
        }
        catch (PropertyVetoException ex) {
            LOGGER.log(Level.INFO, null, ex);
            return null;
        }
    }

    public static final class Version
    implements Comparable<Version> {
        private String majorNumber = "0";
        private String minorNumber = "0";
        private String microNumber = "0";
        private String update = "";

        public Version(String version) {
            assert (version != null) : "Version can't be null";
            String[] tokens = version.split("\\.");
            if (tokens.length >= 4) {
                this.update = tokens[3];
            }
            if (tokens.length >= 3) {
                this.microNumber = tokens[2];
            }
            if (tokens.length >= 2) {
                this.minorNumber = tokens[1];
            }
            this.majorNumber = tokens[0];
        }

        public String getMajorNumber() {
            return this.majorNumber;
        }

        public String getMinorNumber() {
            return this.minorNumber;
        }

        public String getMicroNumber() {
            return this.microNumber;
        }

        public String getUpdate() {
            return this.update;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Version other = (Version)obj;
            if (!(this.majorNumber == other.majorNumber || this.majorNumber != null && this.majorNumber.equals(other.majorNumber))) {
                return false;
            }
            if (!(this.minorNumber == other.minorNumber || this.minorNumber != null && this.minorNumber.equals(other.minorNumber))) {
                return false;
            }
            if (!(this.microNumber == other.microNumber || this.microNumber != null && this.microNumber.equals(other.microNumber))) {
                return false;
            }
            return this.update == other.update || this.update != null && this.update.equals(other.update);
        }

        public int hashCode() {
            int hash = 7;
            hash = 17 * hash + (this.majorNumber != null ? this.majorNumber.hashCode() : 0);
            hash = 17 * hash + (this.minorNumber != null ? this.minorNumber.hashCode() : 0);
            hash = 17 * hash + (this.microNumber != null ? this.microNumber.hashCode() : 0);
            hash = 17 * hash + (this.update != null ? this.update.hashCode() : 0);
            return hash;
        }

        @Override
        public int compareTo(Version o) {
            int comparison = this.compareToIgnoreUpdate(o);
            if (comparison != 0) {
                return comparison;
            }
            return this.update.compareTo(o.update);
        }

        public int compareToIgnoreUpdate(Version o) {
            int comparison = this.majorNumber.compareTo(o.majorNumber);
            if (comparison != 0) {
                return comparison;
            }
            comparison = this.minorNumber.compareTo(o.minorNumber);
            if (comparison != 0) {
                return comparison;
            }
            return this.microNumber.compareTo(o.microNumber);
        }
    }

    static class JarFileFilter
    implements FilenameFilter {
        JarFileFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".jar");
        }
    }
}

