/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mylyn.util;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.netbeans.modules.mylyn.util.BugtrackingCommand;

public class PerformQueryCommand
extends BugtrackingCommand {
    private final AbstractRepositoryConnector repositoryConnector;
    private final TaskRepository taskRepository;
    private final IRepositoryQuery query;
    private final TaskDataCollector collector;
    private IStatus status;

    public PerformQueryCommand(AbstractRepositoryConnector repositoryConnector, TaskRepository taskRepository, TaskDataCollector collector, IRepositoryQuery query) {
        this.taskRepository = taskRepository;
        this.repositoryConnector = repositoryConnector;
        this.query = query;
        this.collector = collector;
    }

    @Override
    public void execute() throws CoreException {
        Logger log = Logger.getLogger(this.getClass().getName());
        if (log.isLoggable(Level.FINE)) {
            Map attrs = this.query.getAttributes();
            log.log(Level.FINE, "executing PerformQueryCommand for query {0} on repository {1} with url \n\t{2} and parameters \n\t{3}", new Object[]{this.query.getSummary(), this.taskRepository.getUrl(), this.query.getUrl(), attrs != null ? attrs : null});
        }
        this.status = this.repositoryConnector.performQuery(this.taskRepository, this.query, this.collector, null, (IProgressMonitor)new NullProgressMonitor());
    }

    public IStatus getStatus() {
        return this.status;
    }

    public IRepositoryQuery getQuery() {
        return this.query;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PerformQueryCommand [repository=");
        sb.append(this.taskRepository.getUrl());
        sb.append(", summary=");
        sb.append(this.query.getSummary());
        sb.append(", url=");
        sb.append(this.query.getUrl());
        sb.append("]");
        return super.toString();
    }
}

