/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.metrics.hints;

import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.IntersectionTypeTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.UnionTypeTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.metrics.hints.DeclaredTypeCollector;

class DependencyCollector
extends TreePathScanner<Object, Object> {
    private boolean ignoreJavaLibraries;
    private final CompilationInfo info;
    private TypeElement outermostClass;
    private final Set<Name> seenQNames = new HashSet<Name>();
    private final Set<Name> ignoreQNames = new HashSet<Name>();
    private boolean inClass;

    public DependencyCollector(CompilationInfo info) {
        this.info = info;
    }

    public void setIgnoreJavaLibraries(boolean ignoreJavaLibraries) {
        this.ignoreJavaLibraries = ignoreJavaLibraries;
    }

    public void setOutermostClass(TypeElement outermostClass) {
        this.outermostClass = outermostClass;
    }

    public Set<Name> getSeenQNames() {
        return this.seenQNames;
    }

    public void addIgnoredQName(Name n) {
        this.ignoreQNames.add(n);
    }

    private void addDependency(Tree t) {
        if (t == null) {
            return;
        }
        this.addDependency(this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), t)));
    }

    private void addDependency(TypeMirror t) {
        ArrayList declaredTypes = new ArrayList(7);
        DeclaredTypeCollector.INSTANCE.visit(t, declaredTypes);
        for (DeclaredType dt : declaredTypes) {
            TypeElement outermost;
            TypeElement te = (TypeElement)dt.asElement();
            if (this.outermostClass != null && (outermost = this.info.getElementUtilities().outermostTypeElement((Element)te)) == this.outermostClass) {
                return;
            }
            Name qn = ((TypeElement)dt.asElement()).getQualifiedName();
            if (qn.length() > 5 && qn.subSequence(0, 4).equals("java") && (qn.charAt(4) == '.' || qn.length() > 6 && qn.charAt(4) == 'x' && qn.charAt(5) == '.') && this.ignoreJavaLibraries) {
                return;
            }
            if (this.ignoreQNames.contains(qn)) continue;
            this.seenQNames.add(qn);
        }
    }

    @Override
    public Object visitClass(ClassTree node, Object p) {
        if (!this.inClass) {
            this.inClass = true;
            Object r = super.visitClass(node, p);
            this.inClass = false;
            return r;
        }
        return null;
    }

    @Override
    public Object visitArrayType(ArrayTypeTree node, Object p) {
        this.addDependency(node.getType());
        return super.visitArrayType(node, p);
    }

    @Override
    public Object visitCatch(CatchTree node, Object p) {
        this.addDependency(node.getParameter());
        return super.visitCatch(node, p);
    }

    @Override
    public Object visitMethod(MethodTree node, Object p) {
        ExecutableElement e = (ExecutableElement)this.info.getTrees().getElement(this.getCurrentPath());
        this.addDependency(e.getReturnType());
        for (TypeMirror typeMirror : e.getThrownTypes()) {
            this.addDependency(typeMirror);
        }
        return super.visitMethod(node, p);
    }

    @Override
    public Object visitCase(CaseTree node, Object p) {
        if (node.getExpression() != null && node.getExpression().getKind() == Tree.Kind.IDENTIFIER) {
            Element e = this.info.getTrees().getElement(new TreePath(this.getCurrentPath(), node.getExpression()));
            this.addDependency(node.getExpression());
        }
        return super.visitCase(node, p);
    }

    @Override
    public Object visitNewClass(NewClassTree node, Object p) {
        this.addDependency(node.getIdentifier());
        return super.visitNewClass(node, p);
    }

    @Override
    public Object visitTypeCast(TypeCastTree node, Object p) {
        this.addDependency(node.getType());
        return super.visitTypeCast(node, p);
    }

    @Override
    public Object visitInstanceOf(InstanceOfTree node, Object p) {
        this.addDependency(node.getType());
        return super.visitInstanceOf(node, p);
    }

    @Override
    public Object visitMemberSelect(MemberSelectTree node, Object p) {
        this.addDependency(node.getExpression());
        return super.visitMemberSelect(node, p);
    }

    @Override
    public Object visitVariable(VariableTree node, Object p) {
        this.addDependency(node.getType());
        return super.visitVariable(node, p);
    }

    @Override
    public Object visitNewArray(NewArrayTree node, Object p) {
        this.addDependency(node.getType());
        return super.visitNewArray(node, p);
    }

    @Override
    public Object visitUnionType(UnionTypeTree node, Object p) {
        for (Tree tree : node.getTypeAlternatives()) {
            this.addDependency(this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), tree)));
        }
        return super.visitUnionType(node, p);
    }

    @Override
    public Object visitIntersectionType(IntersectionTypeTree node, Object p) {
        for (Tree tree : node.getBounds()) {
            this.addDependency(this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), tree)));
        }
        return super.visitIntersectionType(node, p);
    }

    @Override
    public Object visitMemberReference(MemberReferenceTree node, Object p) {
        return super.visitMemberReference(node, p);
    }
}

