/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import org.netbeans.lib.profiler.heap.Field;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.HprofByteBuffer;
import org.netbeans.lib.profiler.heap.HprofField;
import org.netbeans.lib.profiler.heap.HprofObject;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.InstanceDump;

class HprofInstanceValue
extends HprofObject
implements FieldValue {
    HprofField field;
    InstanceDump instance;

    HprofInstanceValue(InstanceDump i, HprofField f, long offset) {
        super(offset);
        this.instance = i;
        this.field = f;
    }

    @Override
    public Instance getDefiningInstance() {
        return this.instance;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public String getValue() {
        return this.getTypeValue().toString();
    }

    Object getTypeValue() {
        byte type = this.field.getValueType();
        HprofByteBuffer dumpBuffer = this.instance.dumpClass.getHprofBuffer();
        return HprofInstanceValue.getTypeValue(dumpBuffer, this.fileOffset, type);
    }

    static Object getTypeValue(HprofByteBuffer dumpBuffer, long position, byte type) {
        switch (type) {
            case 2: {
                long obj = dumpBuffer.getID(position);
                return new Long(obj);
            }
            case 4: {
                byte b = dumpBuffer.get(position);
                return b != 0;
            }
            case 5: {
                char ch = dumpBuffer.getChar(position);
                return Character.valueOf(ch);
            }
            case 6: {
                float f = dumpBuffer.getFloat(position);
                return new Float(f);
            }
            case 7: {
                double d = dumpBuffer.getDouble(position);
                return new Double(d);
            }
            case 8: {
                byte bt = dumpBuffer.get(position);
                return new Byte(bt);
            }
            case 9: {
                short sh = dumpBuffer.getShort(position);
                return new Short(sh);
            }
            case 10: {
                int i = dumpBuffer.getInt(position);
                return i;
            }
            case 11: {
                long lg = dumpBuffer.getLong(position);
                return new Long(lg);
            }
        }
        return "Invalid type " + type;
    }
}

