/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.hints;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.refactoring.plugins.InlinePlugin;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;

public class InlineFix
implements Fix {
    private final BaseDocument doc;
    private final CsmReference ref;
    private final CsmFile file;
    private final String replacement;

    public InlineFix(CsmReference ref, Document doc, CsmFile file, String replacement) {
        this.doc = (BaseDocument)doc;
        this.ref = ref;
        this.file = file;
        this.replacement = replacement;
    }

    public String getText() {
        return NbBundle.getMessage(InlineFix.class, (String)"FIX_Inline");
    }

    public ChangeInfo implement() throws Exception {
        this.doc.runAtomicAsUser(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Position startPos = NbDocument.createPosition((Document)InlineFix.this.doc, (int)InlineFix.this.ref.getStartOffset(), (Position.Bias)Position.Bias.Forward);
                    Position endPos = NbDocument.createPosition((Document)InlineFix.this.doc, (int)(InlineFix.this.ref.getEndOffset() + InlinePlugin.getMacroParametersEndOffset(InlineFix.this.file, (CsmMacro)InlineFix.this.ref.getReferencedObject(), InlineFix.this.ref.getEndOffset())), (Position.Bias)Position.Bias.Backward);
                    InlineFix.this.doc.remove(startPos.getOffset(), endPos.getOffset() - startPos.getOffset());
                    int start = startPos.getOffset();
                    InlineFix.this.doc.insertString(start, InlineFix.this.replacement, null);
                    Reformat format = Reformat.get((Document)InlineFix.this.doc);
                    format.lock();
                    try {
                        format.reformat(start, start + InlineFix.this.replacement.length() + 1);
                    }
                    finally {
                        format.unlock();
                    }
                }
                catch (BadLocationException ex) {
                    ex.printStackTrace(System.err);
                }
            }
        });
        return null;
    }
}

