/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2me.project.J2MEProject;
import org.netbeans.modules.j2me.project.ui.customizer.J2MEProjectProperties;
import org.netbeans.modules.java.api.common.util.CommonProjectUtils;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;

final class PlatformListener
implements Runnable,
PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(PlatformListener.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(PlatformListener.class);
    private final J2MEProject project;

    private PlatformListener(@NonNull J2MEProject project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        this.project = project;
    }

    @Override
    public void propertyChange(@NonNull PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if (propName == null || "platform.active".equals(propName)) {
            this.run();
        }
    }

    @Override
    public void run() {
        if (J2MEProjectProperties.isPropertiesSave()) {
            J2MEProjectProperties.postSave(new Runnable(){

                @Override
                public void run() {
                    PlatformListener.this.updateIfNeeded();
                }
            });
        } else if (ProjectManager.mutex().isReadAccess()) {
            RP.execute((Runnable)this);
        } else if (ProjectManager.mutex().isWriteAccess()) {
            this.updateIfNeeded();
        } else {
            ProjectManager.mutex().writeAccess((Runnable)this);
        }
    }

    void start() {
        PropertyEvaluator eval = this.project.evaluator();
        eval.addPropertyChangeListener((PropertyChangeListener)this);
        this.run();
    }

    void stop() {
        PropertyEvaluator eval = this.project.evaluator();
        eval.removePropertyChangeListener((PropertyChangeListener)this);
    }

    private void updateIfNeeded() {
        PropertyEvaluator eval = this.project.evaluator();
        AntProjectHelper helper = this.project.getHelper();
        String activePlatformId = eval.getProperty("platform.active");
        JavaPlatform activePlatform = CommonProjectUtils.getActivePlatform((String)activePlatformId, (String)"j2me");
        if (activePlatform == null) {
            return;
        }
        Collection installFolders = activePlatform.getInstallFolders();
        if (installFolders.isEmpty()) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Project {0} has broken platform.", ProjectUtils.getInformation((Project)this.project).getDisplayName());
            }
            return;
        }
        FileObject installFolder = (FileObject)installFolders.iterator().next();
        File installDir = FileUtil.toFile((FileObject)installFolder);
        if (installDir == null) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "Project {0} platfrom is on non local file system.", ProjectUtils.getInformation((Project)this.project).getDisplayName());
            }
            return;
        }
        EditableProperties ep = helper.getProperties("nbproject/private/private.properties");
        String currentPlatformHome = ep.getProperty("platform.home");
        if (!installDir.getAbsolutePath().equals(currentPlatformHome)) {
            ep.setProperty("platform.home", installDir.getAbsolutePath());
            helper.putProperties("nbproject/private/private.properties", ep);
            try {
                ProjectManager.getDefault().saveProject((Project)this.project);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    @NonNull
    static PlatformListener create(@NonNull J2MEProject project) {
        return new PlatformListener(project);
    }
}

