/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.preprocessorbridge.api;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Collection;
import java.util.EventListener;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.java.preprocessorbridge.spi.CompileOnSaveAction;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;

public final class CompileOnSaveActionQuery {
    private static final Lookup.Result<CompileOnSaveAction.Provider> instances = Lookup.getDefault().lookupResult(CompileOnSaveAction.Provider.class);
    private static final Map<URL, Reference<CompileOnSaveAction>> u2a = new WeakHashMap<URL, Reference<CompileOnSaveAction>>();
    private static final Map<CompileOnSaveAction, URL> a2u = new WeakHashMap<CompileOnSaveAction, URL>();

    private CompileOnSaveActionQuery() {
        throw new IllegalStateException("No instance allowed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public static CompileOnSaveAction getAction(@NonNull URL sourceRoot) {
        CompileOnSaveAction res;
        Map<URL, Reference<CompileOnSaveAction>> map = u2a;
        synchronized (map) {
            Reference<CompileOnSaveAction> ref = u2a.get(sourceRoot);
            res = ref != null ? ref.get() : null;
        }
        if (res == null) {
            Collection<CompileOnSaveAction> actions = CompileOnSaveActionQuery.findAll(sourceRoot);
            res = actions.isEmpty() ? null : new ProxyAction(sourceRoot, actions, instances);
            Map<URL, Reference<CompileOnSaveAction>> map2 = u2a;
            synchronized (map2) {
                CompileOnSaveAction tmpRes;
                Reference<CompileOnSaveAction> ref = u2a.get(sourceRoot);
                if (ref == null || (tmpRes = ref.get()) == null) {
                    u2a.put(sourceRoot, new WeakReference<CompileOnSaveAction>(res));
                    a2u.put(res, sourceRoot);
                } else {
                    res = tmpRes;
                }
            }
        }
        return res;
    }

    private static Collection<CompileOnSaveAction> findAll(URL root) {
        return instances.allInstances().stream().map(p -> p.forRoot(root)).filter(a -> a != null).collect(Collectors.toList());
    }

    private static final class ProxyAction
    implements CompileOnSaveAction,
    LookupListener,
    ChangeListener {
        private static Predicate<CompileOnSaveAction> ALL = a -> true;
        private static Predicate<CompileOnSaveAction> ACTIVE = a -> a.isEnabled();
        private final URL root;
        private final AtomicReference<Collection<CompileOnSaveAction>> active;
        private final ChangeSupport listeners;

        ProxyAction(@NonNull URL root, @NonNull Collection<CompileOnSaveAction> current, @NonNull Lookup.Result<CompileOnSaveAction.Provider> eventSource) {
            this.root = root;
            this.active = new AtomicReference<Collection<CompileOnSaveAction>>(current);
            this.listeners = new ChangeSupport((Object)this);
            instances.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, (Object)instances));
            this.getActions(ALL).forEach(a -> a.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)a)));
        }

        @Override
        public Boolean performAction(CompileOnSaveAction.Context ctx) throws IOException {
            return this.getActions(ACTIVE).findFirst().map(a -> {
                try {
                    return a.performAction(ctx);
                }
                catch (IOException ioe) {
                    return null;
                }
            }).orElse(null);
        }

        @Override
        public boolean isEnabled() {
            return this.getActions(ACTIVE).findAny().isPresent();
        }

        @Override
        public boolean isUpdateResources() {
            return this.getActions(ACTIVE).findFirst().map(a -> a.isUpdateResources()).orElse(Boolean.FALSE);
        }

        @Override
        public boolean isUpdateClasses() {
            return this.getActions(ACTIVE).findFirst().map(a -> a.isUpdateClasses()).orElse(Boolean.FALSE);
        }

        @Override
        public void addChangeListener(@NonNull ChangeListener l) {
            this.listeners.addChangeListener(l);
        }

        @Override
        public void removeChangeListner(@NonNull ChangeListener l) {
            this.listeners.removeChangeListener(l);
        }

        public void resultChanged(@NonNull LookupEvent ev) {
            this.reset();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.reset();
        }

        private void reset() {
            this.active.set(null);
            this.listeners.fireChange();
        }

        @NonNull
        private Stream<CompileOnSaveAction> getActions(@NonNull Predicate<CompileOnSaveAction> filter) {
            Collection res = this.active.get();
            if (res == null) {
                res = CompileOnSaveActionQuery.findAll(this.root);
                this.active.compareAndSet(null, res);
            }
            return res.stream().filter(filter);
        }
    }
}

