/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.refactoring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.css.refactoring.api.CssRefactoring;
import org.netbeans.modules.css.refactoring.api.EntryHandle;
import org.netbeans.modules.css.refactoring.api.RefactoringElementType;
import org.netbeans.modules.html.editor.api.Utils;
import org.netbeans.modules.html.editor.indexing.HtmlFileModel;
import org.netbeans.modules.html.editor.indexing.HtmlLinkEntry;
import org.netbeans.modules.html.editor.refactoring.DeclarationItem;
import org.netbeans.modules.html.editor.refactoring.InlinedStyleInfo;
import org.netbeans.modules.html.editor.refactoring.ResolveDeclarationItem;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.web.common.api.FileReference;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class RefactoringContext {
    private static final String CSS_MIME_TYPE = "text/css";
    private FileObject file;
    private Document document;
    private int from;
    private int to;
    private HtmlFileModel model;
    private List<InlinedStyleInfo> inlinedStyles;
    private List<OffsetRange> existingEmbeddedCssSections;
    private List<HtmlLinkEntry> linkedExternalStylesheets;
    private Map<InlinedStyleInfo, ResolveDeclarationItem> idSelectorsToResolve;
    private Map<InlinedStyleInfo, ResolveDeclarationItem> classSelectorsToResolve;

    public static RefactoringContext create(FileObject file, Document document, int from, int to) throws ParseException {
        List<InlinedStyleInfo> inlinedStyles = RefactoringContext.findInlinedStyles(document, from, to);
        HtmlFileModel model = new HtmlFileModel(Source.create((Document)document));
        List<HtmlLinkEntry> references = model.getReferences();
        LinkedList<HtmlLinkEntry> cssOnlyLinks = new LinkedList<HtmlLinkEntry>();
        for (HtmlLinkEntry linkEntry : references) {
            FileObject linkTarget;
            FileReference ref = linkEntry.getFileReference();
            if (ref == null || !CSS_MIME_TYPE.equals((linkTarget = ref.target()).getMIMEType())) continue;
            cssOnlyLinks.add(linkEntry);
        }
        List<OffsetRange> cssEmbeddedSections = model.getEmbeddedCssSections();
        Map<InlinedStyleInfo, ResolveDeclarationItem> ids2resolve = RefactoringContext.getUnresolvedSelectorDeclarations(RefactoringElementType.ID, inlinedStyles, file);
        Map<InlinedStyleInfo, ResolveDeclarationItem> classes2resolve = RefactoringContext.getUnresolvedSelectorDeclarations(RefactoringElementType.CLASS, inlinedStyles, file);
        return new RefactoringContext(file, document, from, to, model, inlinedStyles, cssEmbeddedSections, cssOnlyLinks, ids2resolve, classes2resolve);
    }

    private RefactoringContext(FileObject file, Document document, int from, int to, HtmlFileModel model, List<InlinedStyleInfo> inlinedStyles, List<OffsetRange> existingEmbeddedCssSections, List<HtmlLinkEntry> externalStyleSheets, Map<InlinedStyleInfo, ResolveDeclarationItem> ids2resolve, Map<InlinedStyleInfo, ResolveDeclarationItem> classes2resolve) {
        this.file = file;
        this.document = document;
        this.from = from;
        this.to = to;
        this.model = model;
        this.inlinedStyles = inlinedStyles;
        this.existingEmbeddedCssSections = existingEmbeddedCssSections;
        this.linkedExternalStylesheets = externalStyleSheets;
        this.idSelectorsToResolve = ids2resolve;
        this.classSelectorsToResolve = classes2resolve;
    }

    public FileObject getFile() {
        return this.file;
    }

    public Document getDocument() {
        return this.document;
    }

    public int getFrom() {
        return this.from;
    }

    public int getTo() {
        return this.to;
    }

    public List<InlinedStyleInfo> getInlinedStyles() {
        return this.inlinedStyles;
    }

    public List<OffsetRange> getExistingEmbeddedCssSections() {
        return this.existingEmbeddedCssSections == null ? Collections.emptyList() : this.existingEmbeddedCssSections;
    }

    public List<HtmlLinkEntry> getLinkedExternalStylesheets() {
        return this.linkedExternalStylesheets == null ? Collections.emptyList() : this.linkedExternalStylesheets;
    }

    public HtmlFileModel getModel() {
        return this.model;
    }

    public OffsetRange getDocumentRange(OffsetRange astRange) {
        Snapshot snap = this.getModel().getSnapshot();
        int dfrom = snap.getOriginalOffset(astRange.getStart());
        int dto = snap.getOriginalOffset(astRange.getEnd());
        return dfrom == -1 || dto == -1 ? null : new OffsetRange(dfrom, dto);
    }

    public Map<InlinedStyleInfo, ResolveDeclarationItem> getIdSelectorsToResolve() {
        return this.idSelectorsToResolve;
    }

    public Map<InlinedStyleInfo, ResolveDeclarationItem> getClassSelectorsToResolve() {
        return this.classSelectorsToResolve;
    }

    static List<InlinedStyleInfo> findInlinedStyles(final Document doc, final int from, final int to) {
        final AtomicReference result = new AtomicReference();
        doc.render(new Runnable(){

            @Override
            public void run() {
                LinkedList<InlinedStyleInfo> found = new LinkedList<InlinedStyleInfo>();
                result.set(found);
                TokenHierarchy th = TokenHierarchy.get((Document)doc);
                TokenSequence<HTMLTokenId> ts = Utils.getJoinedHtmlSequence(th, from);
                if (ts == null) {
                    return;
                }
                String tag = null;
                String attr = null;
                String styleAttr = null;
                int styleAttrOffset = -1;
                int classValueAppendOffset = -1;
                int attrOffset = -1;
                String tagsClass = null;
                String tagsId = null;
                String value = null;
                OffsetRange range = null;
                do {
                    Token t;
                    if ((t = ts.token()).id() == HTMLTokenId.TAG_OPEN) {
                        tag = t.text().toString();
                        tagsId = null;
                        tagsClass = null;
                        styleAttr = null;
                        attr = null;
                        styleAttrOffset = -1;
                        classValueAppendOffset = -1;
                        attrOffset = -1;
                        range = null;
                        value = null;
                        continue;
                    }
                    if (t.id() == HTMLTokenId.TAG_CLOSE_SYMBOL) {
                        if (tag == null || range == null) continue;
                        found.add(new InlinedStyleInfo(tag, tagsClass, tagsId, styleAttr, styleAttrOffset, classValueAppendOffset, range, value));
                        tagsId = null;
                        tagsClass = null;
                        styleAttr = null;
                        attr = null;
                        tag = null;
                        classValueAppendOffset = -1;
                        styleAttrOffset = -1;
                        attrOffset = -1;
                        continue;
                    }
                    if (t.id() == HTMLTokenId.ARGUMENT) {
                        attr = t.text().toString();
                        attrOffset = ts.offset();
                        continue;
                    }
                    if (t.id() == HTMLTokenId.VALUE_CSS) {
                        String csstype = (String)t.getProperty((Object)"valueCssType");
                        if (csstype == null) {
                            CharSequence text = t.text();
                            int start = ts.offset();
                            int end = ts.offset() + t.length();
                            List parts = t.joinedParts();
                            if (parts != null) {
                                Token first = (Token)parts.get(0);
                                Token last = (Token)parts.get(parts.size() - 1);
                                start = first.offset(th);
                                end = last.offset(th) + last.length();
                                try {
                                    text = doc.getText(start, end - start);
                                }
                                catch (BadLocationException ex) {
                                    Exceptions.printStackTrace((Throwable)ex);
                                }
                            }
                            int diff = WebUtils.isValueQuoted((CharSequence)text) ? 1 : 0;
                            range = new OffsetRange(start + diff, end - diff);
                            value = WebUtils.unquotedValue((CharSequence)text.toString());
                            styleAttrOffset = attrOffset;
                            styleAttr = attr;
                            continue;
                        }
                        if ("class".equalsIgnoreCase(attr)) {
                            classValueAppendOffset = ts.offset() + t.length() - (WebUtils.isValueQuoted((CharSequence)t.text()) ? 1 : 0);
                            tagsClass = WebUtils.unquotedValue((CharSequence)t.text());
                            continue;
                        }
                        if (!"id".equalsIgnoreCase(attr)) continue;
                        tagsId = WebUtils.unquotedValue((CharSequence)t.text());
                        continue;
                    }
                    if (t.id() != HTMLTokenId.VALUE_CSS) continue;
                } while (ts.moveNext() && ts.offset() <= to);
            }
        });
        return (List)result.get();
    }

    private static Map<InlinedStyleInfo, ResolveDeclarationItem> getUnresolvedSelectorDeclarations(RefactoringElementType type, Collection<InlinedStyleInfo> infos, FileObject file) {
        HashMap<InlinedStyleInfo, ResolveDeclarationItem> toResolve = new HashMap<InlinedStyleInfo, ResolveDeclarationItem>();
        for (InlinedStyleInfo si : infos) {
            String element = RefactoringContext.getElementNameByType(si, type);
            if (element == null) continue;
            Map definitionsInAllFiles = CssRefactoring.findAllOccurances((String)element, (RefactoringElementType)type, (FileObject)file, (boolean)true);
            ResolveDeclarationItemImpl item = new ResolveDeclarationItemImpl(si, type, definitionsInAllFiles);
            toResolve.put(si, item);
        }
        return toResolve;
    }

    private static String getElementNameByType(InlinedStyleInfo si, RefactoringElementType type) {
        String element;
        switch (type) {
            case CLASS: {
                element = si.getTagsClass();
                break;
            }
            case ID: {
                element = si.getTagsId();
                break;
            }
            default: {
                element = null;
                assert (false);
                break;
            }
        }
        return element;
    }

    private static class ResolveDeclarationItemImpl
    extends ResolveDeclarationItem {
        private InlinedStyleInfo si;
        private List<DeclarationItem> declarations;
        private RefactoringElementType type;

        public ResolveDeclarationItemImpl(InlinedStyleInfo si, RefactoringElementType type, Map<FileObject, Collection<EntryHandle>> declarationsMap) {
            this.type = type;
            this.si = si;
            this.declarations = new ArrayList<DeclarationItem>();
            for (FileObject file : declarationsMap.keySet()) {
                for (EntryHandle handle : declarationsMap.get(file)) {
                    this.declarations.add(new DeclarationItem(handle, file));
                }
            }
        }

        @Override
        public String getName() {
            return RefactoringContext.getElementNameByType(this.si, this.type);
        }

        @Override
        public List<DeclarationItem> getPossibleDeclarations() {
            return this.declarations;
        }
    }
}

