/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelui.switcher;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.model.CsmModel;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmModelState;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public final class SwitchProjectAction
extends NodeAction {
    private final JCheckBoxMenuItem presenter;
    private final CsmModel model;
    private final AtomicBoolean running = new AtomicBoolean(false);

    public SwitchProjectAction() {
        this.presenter = new JCheckBoxMenuItem(this.getName());
        this.presenter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwitchProjectAction.this.onActionPerformed();
            }
        });
        CsmModel aModel = CsmModelAccessor.getModel();
        this.model = CsmModelAccessor.getModelState() == CsmModelState.OFF ? null : aModel;
    }

    public String getName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_SwitchProjectAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public JMenuItem getMenuPresenter() {
        return this.getPresenter();
    }

    public JMenuItem getPopupPresenter() {
        return this.getPresenter();
    }

    private JMenuItem getPresenter() {
        Collection<NativeProject> projects = this.getNativeProjects(this.getActivatedNodes());
        if (projects == null) {
            this.presenter.setEnabled(!this.running.get());
            this.presenter.setSelected(false);
        } else if (this.model == null) {
            this.presenter.setEnabled(false);
            this.presenter.setSelected(false);
        } else {
            try {
                State state = this.getState(projects);
                switch (state) {
                    case Indeterminate: {
                        this.presenter.setEnabled(!this.running.get());
                        this.presenter.setSelected(false);
                        break;
                    }
                    case BeingCreated: {
                        this.presenter.setEnabled(false);
                        this.presenter.setSelected(true);
                        break;
                    }
                    case Enabled: {
                        this.presenter.setEnabled(!this.running.get());
                        this.presenter.setSelected(true);
                        break;
                    }
                    case Disabled: {
                        this.presenter.setEnabled(!this.running.get());
                        this.presenter.setSelected(false);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("" + (Object)((Object)state));
                    }
                }
            }
            catch (Throwable thr) {
                thr.printStackTrace(System.err);
                this.presenter.setEnabled(false);
                this.presenter.setSelected(true);
            }
        }
        return this.presenter;
    }

    private Collection<NativeProject> getNativeProjects(Node[] nodes) {
        ArrayList<NativeProject> projects = new ArrayList<NativeProject>();
        for (int i = 0; i < nodes.length; ++i) {
            Object o = nodes[i].getValue("Project");
            if (!(o instanceof Project) && (o = nodes[0].getLookup().lookup(Project.class)) == null) {
                return null;
            }
            NativeProject nativeProject = (NativeProject)((Project)o).getLookup().lookup(NativeProject.class);
            if (nativeProject == null) {
                return null;
            }
            projects.add(nativeProject);
        }
        return projects;
    }

    private State getState(Collection<NativeProject> projects) {
        CndUtils.assertNotNull((Object)this.model, (String)"null model");
        State state = State.Indeterminate;
        for (NativeProject p : projects) {
            State curr = this.getState(p);
            if (state == State.BeingCreated) {
                return State.BeingCreated;
            }
            if (state == State.Indeterminate) {
                state = curr;
                continue;
            }
            if (state == curr) continue;
            return State.Indeterminate;
        }
        return state;
    }

    private State getState(NativeProject p) {
        Boolean enabled = this.model.isProjectEnabled((Object)p);
        if (enabled == null) {
            return State.BeingCreated;
        }
        if (enabled.booleanValue()) {
            return State.Enabled;
        }
        return State.Disabled;
    }

    protected boolean enable(Node[] activatedNodes) {
        if (this.model == null) {
            return false;
        }
        if (this.running.get()) {
            return false;
        }
        Collection<NativeProject> projects = this.getNativeProjects(this.getActivatedNodes());
        if (projects == null) {
            return false;
        }
        State state = this.getState(projects);
        switch (state) {
            case Enabled: {
                return true;
            }
            case Disabled: {
                return true;
            }
            case Indeterminate: {
                return false;
            }
            case BeingCreated: {
                return false;
            }
        }
        throw new IllegalArgumentException("" + (Object)((Object)state));
    }

    private void onActionPerformed() {
        this.performAction(this.getActivatedNodes());
    }

    public void performAction(Node[] activatedNodes) {
        if (this.model == null) {
            return;
        }
        if (!this.running.compareAndSet(false, true)) {
            return;
        }
        this.model.enqueue(new Runnable(){

            @Override
            public void run() {
                try {
                    SwitchProjectAction.this.performAction(SwitchProjectAction.this.getNativeProjects(SwitchProjectAction.this.getActivatedNodes()));
                }
                finally {
                    SwitchProjectAction.this.running.set(false);
                }
            }
        }, (CharSequence)"Switching code model ON/OFF");
    }

    private void performAction(Collection<NativeProject> projects) {
        CndUtils.assertNotNull((Object)this.model, (String)"null model");
        if (projects != null) {
            State state = this.getState(projects);
            switch (state) {
                case Enabled: {
                    for (NativeProject p : projects) {
                        this.model.disableProject((Object)p);
                    }
                    break;
                }
                case Disabled: {
                    for (NativeProject p : projects) {
                        this.model.enableProject((Object)p);
                    }
                    break;
                }
            }
        }
    }

    protected boolean asynchronous() {
        return false;
    }

    private static enum State {
        Enabled,
        Disabled,
        Indeterminate,
        BeingCreated;

    }
}

