/*
 * Decompiled with CFR 0.152.
 */
package org.clang.tools.services.support;

import java.util.ArrayList;
import java.util.Collection;
import org.clang.basic.vfs.FileSystem;
import org.clang.basic.vfs.VfsGlobals;
import org.clang.frontend.InputKind;
import org.clang.frontend.LangStandard;
import org.clang.tools.services.ClankCompilationDataBase;
import org.clang.tools.services.support.ClangUtilities;
import org.clang.tools.services.support.DataBaseEntry;
import org.clang.tools.services.support.DataBaseIncludePath;
import org.llvm.adt.IntrusiveRefCntPtr;

public class DataBaseEntryBuilder {
    private CharSequence mainFile;
    private CharSequence cwd;
    private CharSequence sysRoot;
    private final Collection<CharSequence> incFiles = new ArrayList<CharSequence>();
    private final Collection<ClankCompilationDataBase.IncludePath> userIncludePaths = new ArrayList<ClankCompilationDataBase.IncludePath>();
    private final Collection<String> userMacroDefs = new ArrayList<String>();
    private final Collection<String> userMacroUndefs = new ArrayList<String>();
    private final Collection<ClankCompilationDataBase.IncludePath> predefinedIncludePaths = new ArrayList<ClankCompilationDataBase.IncludePath>();
    private final Collection<String> predefinedMacroDefs = new ArrayList<String>();
    private InputKind lang = InputKind.IK_None;
    private LangStandard.Kind langStd = LangStandard.Kind.lang_unspecified;
    private IntrusiveRefCntPtr<FileSystem> fileSystem;
    private CharSequence absPathLookupPrefix;

    public DataBaseEntryBuilder() {
    }

    public DataBaseEntryBuilder(CharSequence mainFile, CharSequence cwd) {
        this.mainFile = mainFile;
        this.cwd = cwd;
    }

    public DataBaseEntryBuilder setMainFile(CharSequence mainFile) {
        this.mainFile = mainFile;
        return this;
    }

    public DataBaseEntryBuilder setCwd(CharSequence cwd) {
        this.cwd = cwd;
        return this;
    }

    public DataBaseEntryBuilder setSysRoot(CharSequence sysRoot) {
        this.sysRoot = sysRoot;
        return this;
    }

    public DataBaseEntryBuilder addIncFile(String incFile) {
        this.incFiles.add(incFile);
        return this;
    }

    public DataBaseEntryBuilder addUserIncludePath(CharSequence userIncludePath, boolean framework, boolean ignoreSysRoot) {
        this.userIncludePaths.add(new DataBaseIncludePath(userIncludePath, framework, ignoreSysRoot));
        return this;
    }

    public DataBaseEntryBuilder addUserMacroDef(String userMacroDef) {
        this.userMacroDefs.add(userMacroDef);
        return this;
    }

    public DataBaseEntryBuilder setFileSystem(IntrusiveRefCntPtr<FileSystem> fileSystem) {
        this.fileSystem = fileSystem;
        return this;
    }

    public DataBaseEntryBuilder setAbsPathLookupPrefix(CharSequence absPathLookupPrefix) {
        this.absPathLookupPrefix = absPathLookupPrefix;
        return this;
    }

    public DataBaseEntryBuilder addUserMacroUndef(String userMacroUndef) {
        this.userMacroUndefs.add(userMacroUndef);
        return this;
    }

    public DataBaseEntryBuilder addPredefinedSystemIncludePath(CharSequence predefinedIncludePath, boolean framework, boolean ignoreSysRoot) {
        this.predefinedIncludePaths.add(new DataBaseIncludePath(predefinedIncludePath, framework, ignoreSysRoot));
        return this;
    }

    public DataBaseEntryBuilder addPredefinedSystemMacroDef(String predefinedMacroDef) {
        this.predefinedMacroDefs.add(predefinedMacroDef);
        return this;
    }

    public DataBaseEntryBuilder setLang(InputKind lang) {
        this.lang = lang;
        return this;
    }

    public DataBaseEntryBuilder setLang(String param, String mainFile) {
        return this.setLang(ClangUtilities.getInputKind(param, mainFile));
    }

    public DataBaseEntryBuilder setLangStd(LangStandard.Kind langStd) {
        this.langStd = langStd;
        return this;
    }

    public DataBaseEntryBuilder setLangStd(String param) {
        return this.setLangStd(ClangUtilities.getLangStandard(param));
    }

    public DataBaseEntry createDataBaseEntry() {
        return new DataBaseEntry(this.mainFile, this.cwd, this.sysRoot, this.incFiles, this.userIncludePaths, this.userMacroDefs, this.userMacroUndefs, this.predefinedIncludePaths, this.predefinedMacroDefs, this.lang, this.langStd, this.fileSystem == null ? VfsGlobals.getRealFileSystem() : this.fileSystem, this.absPathLookupPrefix);
    }
}

