/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.content.project;

import java.io.IOException;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.repository.support.KeyFactory;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.netbeans.modules.cnd.utils.CndUtils;

public abstract class ProjectComponent
implements Persistent,
SelfPersistent {
    private final Key key;

    public ProjectComponent(Key key) {
        CndUtils.assertTrueInConsole((key == null || key.getBehavior() == Key.Behavior.LargeAndMutable ? 1 : 0) != 0, (String)"should be LargeAndMutable ", (Object)key);
        this.key = key;
    }

    public ProjectComponent(RepositoryDataInput in) throws IOException {
        this.key = KeyFactory.getDefaultFactory().readKey(in);
        if (TraceFlags.TRACE_PROJECT_COMPONENT_RW) {
            System.err.printf("< ProjectComponent: Reading %s key %s%n", this, this.key);
        }
    }

    public Key getKey() {
        return this.key;
    }

    protected final int getUnitId() {
        return this.getKey().getUnitId();
    }

    public void put() {
        if (TraceFlags.TRACE_PROJECT_COMPONENT_RW) {
            System.err.printf("> ProjectComponent: store %s by key %s%n", this, this.key);
        }
        RepositoryUtils.put(this.key, this);
    }

    public void write(RepositoryDataOutput out) throws IOException {
        if (TraceFlags.TRACE_PROJECT_COMPONENT_RW) {
            System.err.printf("> ProjectComponent: Writing %s by key %s%n", this, this.key);
        }
        ProjectComponent.writeKey(this.key, out);
    }

    public static Key readKey(RepositoryDataInput in) throws IOException {
        return KeyFactory.getDefaultFactory().readKey(in);
    }

    public static void writeKey(Key key, RepositoryDataOutput out) throws IOException {
        KeyFactory.getDefaultFactory().writeKey(key, out);
    }
}

