/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.services.CsmInstantiationProvider;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.apt.support.lang.APTLanguageSupport;
import org.netbeans.modules.cnd.modelimpl.content.file.FileContent;
import org.netbeans.modules.cnd.modelimpl.csm.AstRendererException;
import org.netbeans.modules.cnd.modelimpl.csm.CastUtils;
import org.netbeans.modules.cnd.modelimpl.csm.ClassImpl;
import org.netbeans.modules.cnd.modelimpl.csm.ClassImplSpecialization;
import org.netbeans.modules.cnd.modelimpl.csm.InheritanceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.Instantiation;
import org.netbeans.modules.cnd.modelimpl.csm.MutableDeclarationsContainer;
import org.netbeans.modules.cnd.modelimpl.csm.NameHolder;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.impl.services.InstantiationProviderImpl;
import org.netbeans.modules.cnd.modelimpl.parser.spi.CsmParserProvider;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.openide.util.CharSequences;
import org.openide.util.Exceptions;

public final class ClassImplFunctionSpecialization
extends ClassImplSpecialization
implements CsmTemplate {
    Collection<CsmInheritance> baseClasses = null;
    Collection<CsmMember> members = null;

    private ClassImplFunctionSpecialization(AST ast, NameHolder name, CsmFile file) {
        super(ast, name, file, ClassImplFunctionSpecialization.getStartOffset(ast), ClassImplFunctionSpecialization.getStartOffset(ast));
    }

    private ClassImplFunctionSpecialization(NameHolder name, CsmDeclaration.Kind kind, CsmFile file, int start, int end) {
        super(name, kind, file, start, end);
    }

    public static ClassImplFunctionSpecialization create(AST ast, CsmScope scope, CsmFile file, String language, FileContent fileContent, boolean register, MutableDeclarationsContainer container) throws AstRendererException {
        assert (!APTLanguageSupport.getInstance().isLanguageC(language)) : "Function specialization is not allowed in C";
        NameHolder nameHolder = NameHolder.createName(ClassImplFunctionSpecialization.getClassName(ast));
        ClassImplFunctionSpecialization impl = new ClassImplFunctionSpecialization(ast, nameHolder, file);
        impl.initQualifiedName(ast, scope, false, file);
        ClassImplFunctionSpecialization clsImpl = ClassImplFunctionSpecialization.findExistingClassImplClassImplFunctionSpecializationInProject(file, impl);
        if (clsImpl != null) {
            impl = clsImpl;
        } else {
            impl.init(scope, ast, file, fileContent, language, register, container);
            container.addDeclaration(impl);
        }
        nameHolder.addReference(fileContent, impl);
        return impl;
    }

    private static ClassImplFunctionSpecialization findExistingClassImplClassImplFunctionSpecializationInProject(CsmFile file, ClassImplFunctionSpecialization spec) {
        CsmClassifier existing;
        ClassImplFunctionSpecialization out = null;
        if (file != null && (existing = file.getProject().findClassifier(spec.getQualifiedName())) instanceof ClassImplFunctionSpecialization) {
            out = (ClassImplFunctionSpecialization)existing;
        }
        return out;
    }

    private ClassImpl findBaseClassImplInProject() {
        CsmClassifier base;
        ClassImpl out = null;
        CsmFile file = this.getContainingFile();
        if (file != null && (base = file.getProject().findClassifier(this.getQualifiedNameWithoutSuffix())) instanceof ClassImpl) {
            out = (ClassImpl)base;
        }
        return out;
    }

    @Override
    public void addMember(CsmMember member, boolean global) {
        String name = member.getQualifiedName().toString();
        for (CsmMember m : super.getMembers()) {
            if (!name.equals(m.getQualifiedName().toString())) continue;
            return;
        }
        super.addMember(member, global);
    }

    @Override
    public Collection<CsmMember> getMembers() {
        if (this.members == null) {
            this.members = this._getMembers();
        }
        return this.members;
    }

    public Collection<CsmMember> _getMembers() {
        CsmObject baseInst;
        CsmInstantiationProvider p;
        ClassImpl base;
        ArrayList<CsmMember> members = new ArrayList<CsmMember>();
        members.addAll(super.getMembers());
        if (this.isValid() && (base = this.findBaseClassImplInProject()) != null && base != this && (p = CsmInstantiationProvider.getDefault()) instanceof InstantiationProviderImpl && CsmKindUtilities.isClass((CsmObject)(baseInst = ((InstantiationProviderImpl)p).instantiate((CsmTemplate)base, this.getSpecializationParameters(), false)))) {
            members.addAll(((CsmClass)baseInst).getMembers());
        }
        return members;
    }

    @Override
    public Iterator<CsmMember> getMembers(CsmSelect.CsmFilter filter) {
        CsmInstantiationProvider p;
        ClassImpl base = this.findBaseClassImplInProject();
        if (base != null && base != this && (p = CsmInstantiationProvider.getDefault()) instanceof InstantiationProviderImpl) {
            CsmObject baseInst = ((InstantiationProviderImpl)p).instantiate((CsmTemplate)base, this.getSpecializationParameters(), false);
            if (baseInst instanceof ClassImpl) {
                return new MultiIterator<CsmMember>(super.getMembers(filter), ((ClassImpl)baseInst).getMembers(filter));
            }
            if (baseInst instanceof Instantiation.Class) {
                return new MultiIterator<CsmMember>(super.getMembers(filter), ((Instantiation.Class)baseInst).getMembers(filter));
            }
        }
        return super.getMembers(filter);
    }

    @Override
    public Collection<CsmInheritance> getBaseClasses() {
        if (this.baseClasses == null) {
            this.baseClasses = this._getBaseClasses();
        }
        return this.baseClasses;
    }

    public Collection<CsmInheritance> _getBaseClasses() {
        ClassImpl base = this.findBaseClassImplInProject();
        if (base != null && base != this) {
            return base.getBaseClasses();
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isExplicitSpecialization() {
        return true;
    }

    private static CharSequence getClassName(AST ast) {
        CharSequence funName = CastUtils.isCast(ast) ? CharSequences.create((CharSequence)CastUtils.getFunctionRawName(ast, "::")) : CharSequences.create((CharSequence)AstUtil.findId(ast, 17, true));
        return ClassImplFunctionSpecialization.getClassNameFromFunctionSpecialicationName(funName);
    }

    private static CharSequence getClassNameFromFunctionSpecialicationName(CharSequence functionName) {
        CharSequence[] nameParts = Utils.splitQualifiedName(functionName.toString());
        StringBuilder className = new StringBuilder("");
        for (int i = 0; i < nameParts.length - 1 && !"operator".equals(nameParts[i].toString()); ++i) {
            className.append(nameParts[i]);
        }
        return className;
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
    }

    public ClassImplFunctionSpecialization(RepositoryDataInput input) throws IOException {
        super(input);
    }

    private static class MultiIterator<T>
    implements Iterator<T> {
        private int currentIterator;
        private final Iterator<T>[] iterators;

        public MultiIterator(Iterator<T> ... iterators) {
            this.iterators = iterators;
            this.currentIterator = 0;
        }

        @Override
        public T next() {
            while (this.currentIterator < this.iterators.length && !this.iterators[this.currentIterator].hasNext()) {
                ++this.currentIterator;
            }
            return this.iterators[this.currentIterator].next();
        }

        @Override
        public boolean hasNext() {
            while (this.currentIterator < this.iterators.length && !this.iterators[this.currentIterator].hasNext()) {
                ++this.currentIterator;
            }
            return this.currentIterator < this.iterators.length;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    public static class ClassFunctionSpecializationBuilder
    extends ClassImplSpecialization.ClassSpecializationBuilder {
        private ClassImplFunctionSpecialization instance;

        private ClassImplFunctionSpecialization getInstance() {
            if (this.instance != null) {
                return this.instance;
            }
            CsmClassifier cls = this.getFile().getProject().findClassifier(this.getName());
            if (cls instanceof ClassImplFunctionSpecialization) {
                this.instance = (ClassImplFunctionSpecialization)cls;
            }
            return this.instance;
        }

        @Override
        public ClassImpl create(CsmParserProvider.ParserErrorDelegate delegate) {
            ClassImplFunctionSpecialization impl = this.getInstance();
            if (impl == null) {
                this.instance = impl = new ClassImplFunctionSpecialization(this.getNameHolder(), this.getKind(), this.getFile(), this.getStartOffset(), this.getEndOffset());
                try {
                    impl.init2(this.getSpecializationDescriptor(), NameCache.getManager().getString(CharSequences.create((CharSequence)"")), this.getScope(), this.getFile(), this.getFileContent(), this.isGlobal());
                }
                catch (AstRendererException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                if (this.getTemplateDescriptorBuilder() != null) {
                    impl.setTemplateDescriptor(this.getTemplateDescriptor());
                }
                for (InheritanceImpl.InheritanceBuilder inheritanceBuilder : this.getInheritanceBuilders()) {
                    inheritanceBuilder.setScope((CsmScope)impl);
                    impl.addInheritance(inheritanceBuilder.create(), this.isGlobal());
                }
                for (ClassImpl.MemberBuilder builder : this.getMemberBuilders()) {
                    builder.setScope((CsmScope)impl);
                    CsmMember member = builder.create(delegate);
                    if (member != null) {
                        impl.addMember(member, this.isGlobal());
                        continue;
                    }
                    CsmParserProvider.registerParserError(delegate, "Skip unrecognized member for builder '" + builder, this.getFile(), ClassFunctionSpecializationBuilder.getStartOffsetImpl(builder, this));
                }
                this.addDeclaration(impl);
            }
            this.getNameHolder().addReference(this.getFileContent(), impl);
            return impl;
        }
    }
}

