/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.IOException;
import org.netbeans.modules.cnd.antlr.Token;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmValidable;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.modelimpl.content.file.FileContent;
import org.netbeans.modules.cnd.modelimpl.csm.CsmObjectBuilder;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.PositionManager;
import org.netbeans.modules.cnd.modelimpl.parser.OffsetableAST;
import org.netbeans.modules.cnd.modelimpl.parser.TokenBasedAST;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.utils.CndUtils;

public abstract class OffsetableBase
implements CsmOffsetable,
Disposable,
CsmValidable {
    private final CsmFile fileRef;
    private boolean isValid = true;
    private final int startPosition;
    private final int endPosition;

    protected OffsetableBase(CsmOffsetable pos) {
        this(pos.getContainingFile(), pos.getStartOffset(), pos.getEndOffset());
    }

    protected OffsetableBase(CsmFile file, int start, int end) {
        this.fileRef = file;
        if (end < start) {
            if (CndUtils.isDebugMode()) {
                CndUtils.assertTrueInConsole((boolean)false, (String)("end < start for " + (file != null ? file.getAbsolutePath() : "null file") + ":[" + start + "-" + end + "]"));
            }
            end = start;
        }
        CsmUID<CsmFile> fileUID = UIDCsmConverter.fileToUID(file);
        this.startPosition = PositionManager.createPositionID(fileUID, start, PositionManager.Position.Bias.FOWARD);
        this.endPosition = PositionManager.createPositionID(fileUID, end, PositionManager.Position.Bias.BACKWARD);
    }

    public final int getStartOffset() {
        return PositionManager.getOffset(this.fileRef, this.startPosition);
    }

    public final int getEndOffset() {
        return this.endPosition != 0 ? PositionManager.getOffset(this.fileRef, this.endPosition) : PositionManager.getOffset(this.fileRef, this.startPosition);
    }

    public final CsmOffsetable.Position getStartPosition() {
        return PositionManager.getPosition(this.fileRef, this.startPosition);
    }

    public final CsmOffsetable.Position getEndPosition() {
        return PositionManager.getPosition(this.fileRef, this.endPosition);
    }

    public static int getStartOffset(AST node) {
        OffsetableAST csmAst;
        if (node != null && (csmAst = AstUtil.getFirstOffsetableAST(node)) != null) {
            return csmAst.getOffset();
        }
        return 0;
    }

    public static int getMacroStartMarker(AST node) {
        TokenBasedAST csmAst;
        if (node != null && (csmAst = AstUtil.getFirstTokenBasedAST(node)) != null && APTUtils.isMacroExpandedToken((Token)csmAst.getToken())) {
            return APTUtils.getExpandedTokenMarker((APTToken)((APTToken)csmAst.getToken()));
        }
        return -1;
    }

    public static int getEndOffset(AST node) {
        if (node != null) {
            AST lastChild = AstUtil.getLastChildRecursively(node);
            if (lastChild.getType() != 1 && lastChild instanceof OffsetableAST) {
                return ((OffsetableAST)lastChild).getEndOffset();
            }
            lastChild = AstUtil.getLastNonEOFChildRecursively(node);
            if (lastChild instanceof OffsetableAST) {
                return ((OffsetableAST)lastChild).getEndOffset();
            }
        }
        return 0;
    }

    public CsmFile getContainingFile() {
        return this.fileRef;
    }

    public boolean isValid() {
        return this.isValid && CsmBaseUtilities.isValid((CsmObject)this.fileRef);
    }

    public CharSequence getText() {
        CsmFile containingFile = this.getContainingFile();
        if (containingFile != null) {
            return containingFile.getText(this.getStartOffset(), this.getEndOffset());
        }
        return "";
    }

    @Override
    public void dispose() {
        this.onDispose();
    }

    private synchronized void onDispose() {
        this.isValid = false;
    }

    public void write(RepositoryDataOutput output) throws IOException {
        output.writeInt(this.startPosition);
        output.writeInt(this.endPosition);
        CsmUID<CsmFile> fileUID = UIDCsmConverter.fileToUID(this.fileRef);
        assert (fileUID != null);
        UIDObjectFactory.getDefaultFactory().writeUID(fileUID, output);
    }

    protected OffsetableBase(RepositoryDataInput input) throws IOException {
        this.startPosition = input.readInt();
        this.endPosition = input.readInt();
        CsmUID fileUID = UIDObjectFactory.getDefaultFactory().readUID(input);
        assert (fileUID != null);
        this.fileRef = UIDCsmConverter.UIDtoFile(fileUID);
        this.isValid = this.fileRef != null;
    }

    protected OffsetableBase(CsmFile containingFile, RepositoryDataInput input) throws IOException {
        this.startPosition = input.readInt();
        this.endPosition = input.readInt();
        CsmUID fileUID = UIDObjectFactory.getDefaultFactory().readUID(input);
        assert (fileUID != null);
        this.fileRef = containingFile;
        this.isValid = this.fileRef != null;
    }

    protected String getOffsetString() {
        return "[ " + this.getStartPosition() + " - " + this.getEndPosition() + " ]";
    }

    protected CharSequence getPositionString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        CsmFile containingFile = this.fileRef;
        if (containingFile == null) {
            sb.append(" NO CONTAINER ");
        } else {
            sb.append(containingFile.getName());
        }
        sb.append(' ');
        CsmOffsetable.Position pos = this.getStartPosition();
        sb.append(pos.getLine());
        sb.append(':');
        sb.append(pos.getColumn());
        sb.append('-');
        pos = this.getEndPosition();
        sb.append(pos.getLine());
        sb.append(':');
        sb.append(pos.getColumn());
        sb.append(']');
        return sb;
    }

    public String toString() {
        return this.getOffsetString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OffsetableBase other = (OffsetableBase)obj;
        if (this.fileRef == null || !this.fileRef.equals(other.fileRef)) {
            return false;
        }
        if (this.startPosition != other.startPosition) {
            return false;
        }
        return this.endPosition == other.endPosition;
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + (this.fileRef != null ? this.fileRef.hashCode() : 0);
        hash = 47 * hash + this.startPosition;
        hash = 47 * hash + this.endPosition;
        return hash;
    }

    public static abstract class OffsetableBuilder
    implements CsmObjectBuilder {
        private CsmFile file;
        private FileContent fileContent;
        private int startOffset = -1;
        private int endOffset = -1;

        public OffsetableBuilder() {
        }

        protected OffsetableBuilder(OffsetableBuilder builder) {
            this.file = builder.file;
            this.fileContent = builder.fileContent;
            this.startOffset = builder.startOffset;
            this.endOffset = builder.endOffset;
        }

        public void setFile(CsmFile file) {
            this.file = file;
            this.fileContent = ((FileImpl)file).getParsingFileContent();
        }

        public void setStartOffset(int startOffset) {
            this.startOffset = startOffset;
        }

        public void setEndOffset(int endOffset) {
            this.endOffset = endOffset;
        }

        public CsmFile getFile() {
            return this.file;
        }

        public FileContent getFileContent() {
            return this.fileContent;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public String toString() {
            return "[" + this.getStartOffset() + ":" + this.getEndOffset() + "]";
        }
    }
}

