/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.impl.services;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceAlias;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUsingDeclaration;
import org.netbeans.modules.cnd.api.model.CsmUsingDirective;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.services.CsmUsingResolver;
import org.netbeans.modules.cnd.modelimpl.impl.services.FileElementsCollector;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.openide.util.CharSequences;

public final class UsingResolverImpl
extends CsmUsingResolver
implements CsmProgressListener {
    private final Object lock = new Lock();
    private Set<Reference<SearchInfo>> allThreadsCache = new HashSet<Reference<SearchInfo>>();
    private ThreadLocal<Reference<SearchInfo>> lastSearch = new ThreadLocal<Reference<SearchInfo>>(){

        @Override
        protected Reference<SearchInfo> initialValue() {
            return new SoftReference<Object>(null);
        }
    };
    private final ThreadLocal<Reference<SearchInfo>> lastSearchInProject = new ThreadLocal<Reference<SearchInfo>>(){

        @Override
        protected Reference<SearchInfo> initialValue() {
            return new SoftReference<Object>(null);
        }
    };
    private final boolean cache = true;

    public UsingResolverImpl() {
        CsmListeners.getDefault().addProgressListener((CsmProgressListener)this);
    }

    public Collection<CsmDeclaration> findUsedDeclarations(CsmFile file, int offset, CsmProject onlyInProject) {
        return this.getCollector(file, offset, onlyInProject).getUsedDeclarations();
    }

    public Collection<CsmDeclaration> findUsedDeclarations(CsmNamespace namespace) {
        ArrayList<CsmUsingDeclaration> res = new ArrayList<CsmUsingDeclaration>();
        Iterator udecls = CsmSelect.getDeclarations((CsmNamespace)namespace, (CsmSelect.CsmFilter)CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.USING_DECLARATION}));
        while (udecls.hasNext()) {
            res.add((CsmUsingDeclaration)udecls.next());
        }
        if (!namespace.isGlobal()) {
            for (CsmProject lib : namespace.getProject().getLibraries()) {
                CsmNamespace ns = lib.findNamespace(namespace.getQualifiedName());
                if (ns == null) continue;
                Iterator it = CsmSelect.getDeclarations((CsmNamespace)ns, (CsmSelect.CsmFilter)CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.USING_DECLARATION}));
                while (it.hasNext()) {
                    res.add((CsmUsingDeclaration)it.next());
                }
            }
        }
        return UsingResolverImpl.extractDeclarations(res);
    }

    public Collection<CsmDeclaration> findUsedDeclarations(CsmNamespace namespace, CharSequence name) {
        ArrayList<CsmUsingDeclaration> res = new ArrayList<CsmUsingDeclaration>();
        Iterator udecls = CsmSelect.getDeclarations((CsmNamespace)namespace, (CsmSelect.CsmFilter)CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.USING_DECLARATION}));
        while (udecls.hasNext()) {
            CsmUsingDeclaration usindDecl = (CsmUsingDeclaration)udecls.next();
            CharSequence n = usindDecl.getName();
            int lastIndex = CharSequenceUtils.lastIndexOf((CharSequence)n, (CharSequence)"::");
            if (lastIndex >= 0) {
                if (CharSequences.comparator().compare(name, n.subSequence(lastIndex + 2, n.length())) != 0) continue;
                res.add(usindDecl);
                continue;
            }
            if (CharSequences.comparator().compare(name, n) != 0) continue;
            res.add(usindDecl);
        }
        if (!namespace.isGlobal()) {
            for (CsmProject lib : namespace.getProject().getLibraries()) {
                CsmNamespace ns = lib.findNamespace(namespace.getQualifiedName());
                if (ns == null) continue;
                Iterator it = CsmSelect.getDeclarations((CsmNamespace)ns, (CsmSelect.CsmFilter)CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.USING_DECLARATION}));
                while (it.hasNext()) {
                    CsmUsingDeclaration usindDecl = (CsmUsingDeclaration)it.next();
                    CharSequence n = usindDecl.getName();
                    int lastIndex = CharSequenceUtils.lastIndexOf((CharSequence)n, (CharSequence)"::");
                    if (lastIndex >= 0) {
                        if (CharSequences.comparator().compare(name, n.subSequence(lastIndex + 2, n.length())) != 0) continue;
                        res.add(usindDecl);
                        continue;
                    }
                    if (CharSequences.comparator().compare(name, n) != 0) continue;
                    res.add(usindDecl);
                }
            }
        }
        return UsingResolverImpl.extractDeclarations(res);
    }

    public Collection<CsmNamespace> findVisibleNamespaces(CsmFile file, int offset, CsmProject onlyInProject) {
        LinkedHashSet<CsmNamespace> seen = new LinkedHashSet<CsmNamespace>();
        LinkedList<CsmNamespace> queue = new LinkedList<CsmNamespace>(this.getCollector(file, offset, onlyInProject).getVisibleNamespaces());
        this.findVisibleNamespacesBfs(seen, queue, onlyInProject, file.getProject());
        return seen;
    }

    private void findVisibleNamespacesBfs(Set<CsmNamespace> seen, Queue<CsmNamespace> queue, CsmProject onlyInProject, CsmProject startProject) {
        while (!queue.isEmpty()) {
            CsmNamespace namespace = queue.poll();
            for (CsmNamespace used : this.findVisibleNamespaces(namespace, startProject)) {
                if (seen.contains(used) || queue.contains(used) || onlyInProject != null && onlyInProject != used.getProject()) continue;
                queue.add(used);
            }
            seen.add(namespace);
        }
    }

    public Collection<CsmUsingDirective> findUsingDirectives(CsmNamespace namespace) {
        ArrayList<CsmUsingDirective> res = new ArrayList<CsmUsingDirective>();
        Iterator udirs = CsmSelect.getDeclarations((CsmNamespace)namespace, (CsmSelect.CsmFilter)CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.USING_DIRECTIVE}));
        while (udirs.hasNext()) {
            res.add((CsmUsingDirective)udirs.next());
        }
        return res;
    }

    public Collection<CsmNamespaceAlias> findNamespaceAliases(CsmFile file, int offset, CsmProject onlyInProject) {
        return this.getCollector(file, offset, onlyInProject).getNamespaceAliases();
    }

    public Collection<CsmNamespaceAlias> findNamespaceAliases(CsmNamespace namespace) {
        ArrayList<CsmNamespaceAlias> res = new ArrayList<CsmNamespaceAlias>();
        Iterator udirs = CsmSelect.getDeclarations((CsmNamespace)namespace, (CsmSelect.CsmFilter)CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.NAMESPACE_ALIAS}));
        while (udirs.hasNext()) {
            res.add((CsmNamespaceAlias)udirs.next());
        }
        return res;
    }

    public static Collection<CsmDeclaration> extractDeclarations(Collection<CsmUsingDeclaration> decls) {
        LinkedHashMap<CharSequence, CsmDeclaration> out = new LinkedHashMap<CharSequence, CsmDeclaration>(decls.size());
        for (CsmUsingDeclaration decl : decls) {
            CsmDeclaration ref = null;
            ref = decl.getReferencedDeclaration();
            if (ref == null) continue;
            CharSequence name = decl.getName();
            out.remove(name);
            out.put(name, ref);
        }
        return new ArrayList<CsmDeclaration>(out.values());
    }

    public static Collection<CsmNamespace> extractNamespaces(Collection<CsmUsingDirective> decls, CsmProject startPrj) {
        LinkedHashSet<Pair> namespaces = new LinkedHashSet<Pair>();
        for (CsmUsingDirective decl : decls) {
            CsmProject proj;
            CsmFile file;
            CsmNamespace ref = decl.getReferencedNamespace();
            if (ref == null || (file = decl.getContainingFile()) == null || (proj = file.getProject()) == null) continue;
            Pair p = new Pair(ref, proj);
            namespaces.remove(p);
            namespaces.add(p);
        }
        LinkedHashSet<CsmNamespace> out = new LinkedHashSet<CsmNamespace>();
        Collection libraries = startPrj.getLibraries();
        for (Pair p : namespaces) {
            for (CsmNamespace ns : UsingResolverImpl.findNamespacesInProject(p.proj, p.fqn, libraries)) {
                out.remove(ns);
                out.add(ns);
            }
        }
        return out;
    }

    public Collection<CsmNamespace> findVisibleNamespaces(CsmNamespace namespace, CsmProject startPrj) {
        ArrayList<CsmNamespace> res = new ArrayList<CsmNamespace>();
        if (!namespace.isGlobal()) {
            for (CsmNamespace ns : namespace.getNestedNamespaces()) {
                if (ns.getName().length() != 0 && !ns.isInline()) continue;
                res.add(ns);
            }
        }
        res.addAll(UsingResolverImpl.extractNamespaces(this.findUsingDirectives(namespace), startPrj));
        return res;
    }

    private static Collection<CsmNamespace> findNamespacesInProject(CsmProject project, CharSequence namespaceQualifiedName, Collection<CsmProject> libs) {
        HashSet<CsmProject> scannedProjects = new HashSet<CsmProject>();
        ArrayList<CsmNamespace> out = new ArrayList<CsmNamespace>();
        CsmNamespace namespace = project.findNamespace(namespaceQualifiedName);
        if (namespace != null) {
            out.add(namespace);
        }
        scannedProjects.add(project);
        out.addAll(UsingResolverImpl.findNamespacesInProjects(libs, namespaceQualifiedName, scannedProjects));
        return out;
    }

    private static Collection<CsmNamespace> findNamespacesInProjects(Collection<CsmProject> projects, CharSequence namespaceQualifiedName, HashSet<CsmProject> scannedProjects) {
        ArrayList<CsmNamespace> out = new ArrayList<CsmNamespace>();
        for (CsmProject proj : projects) {
            if (scannedProjects.contains(proj)) continue;
            CsmNamespace namespace = proj.findNamespace(namespaceQualifiedName);
            if (namespace != null) {
                out.add(namespace);
            }
            scannedProjects.add(proj);
            Collection libs = proj.getLibraries();
            if (libs.isEmpty()) continue;
            out.addAll(UsingResolverImpl.findNamespacesInProjects(libs, namespaceQualifiedName, scannedProjects));
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileElementsCollector getCollector(CsmFile file, int offset, CsmProject onlyInProject) {
        Object object = this.lock;
        synchronized (object) {
            Reference<SearchInfo> ref = onlyInProject == null ? this.lastSearch.get() : this.lastSearchInProject.get();
            SearchInfo search = null;
            if (ref != null) {
                search = ref.get();
            }
            if (search == null || !search.valid(file, offset, onlyInProject)) {
                if (ref != null) {
                    this.allThreadsCache.remove(ref);
                }
                FileElementsCollector collector = new FileElementsCollector(file, offset, onlyInProject);
                search = new SearchInfo(file, onlyInProject, collector);
                ref = new SoftReference<SearchInfo>(search);
                this.allThreadsCache.add(ref);
                if (onlyInProject == null) {
                    this.lastSearch.set(ref);
                } else {
                    this.lastSearchInProject.set(ref);
                }
            } else {
                search.collector.incrementOffset(offset);
            }
            assert (search != null);
            assert (search.collector != null);
            return search.collector;
        }
    }

    public void projectParsingStarted(CsmProject project) {
    }

    public void projectFilesCounted(CsmProject project, int filesCount) {
    }

    public void projectParsingFinished(CsmProject project) {
        this.cleanCache();
    }

    public void projectParsingCancelled(CsmProject project) {
    }

    public void fileInvalidated(CsmFile file) {
    }

    public void fileAddedToParse(CsmFile file) {
    }

    public void fileParsingStarted(CsmFile file) {
    }

    public void fileParsingFinished(CsmFile file) {
        this.cleanCache();
    }

    public void projectLoaded(CsmProject project) {
    }

    public void parserIdle() {
    }

    public void fileRemoved(CsmFile file) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanCache() {
        Object object = this.lock;
        synchronized (object) {
            for (Reference<SearchInfo> ref : this.allThreadsCache) {
                ref.clear();
            }
        }
    }

    private static final class SearchInfo {
        private final CsmFile file;
        private final FileElementsCollector collector;
        private final CsmProject onlyInProject;

        public SearchInfo(CsmFile file, CsmProject onlyInProject, FileElementsCollector collector) {
            this.file = file;
            this.collector = collector;
            this.onlyInProject = onlyInProject;
        }

        private boolean valid(CsmFile file, int offset, CsmProject onlyInProject) {
            return this.file.equals(file) && this.collector.getReturnPoint() <= offset && this.onlyInProject == onlyInProject;
        }
    }

    private static final class Lock {
        private Lock() {
        }
    }

    private static class Pair {
        private final CharSequence fqn;
        private CsmProject proj;

        private Pair(CsmNamespace ref, CsmProject proj) {
            this.fqn = ref.getQualifiedName();
            this.proj = proj;
        }

        public int hashCode() {
            return this.fqn.hashCode() + this.proj.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Pair) {
                Pair p = (Pair)obj;
                return this.fqn.equals(p.fqn) && this.proj.equals(p.proj);
            }
            return false;
        }
    }
}

