/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.projectimport;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import org.netbeans.modules.cnd.discovery.projectimport.ImportProject;
import org.netbeans.modules.cnd.remote.api.RfsListener;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.openide.util.Exceptions;

final class RfsListenerImpl
implements RfsListener {
    private final Map<String, File> storage = new HashMap<String, File>();
    private final ExecutionEnvironment execEnv;

    RfsListenerImpl(ExecutionEnvironment execEnv) {
        this.execEnv = execEnv;
    }

    public void fileChanged(ExecutionEnvironment env, File localFile, String remotePath) {
        if (env.equals((Object)this.execEnv)) {
            this.storage.put(remotePath, localFile);
        }
    }

    void download() {
        HashMap<String, File> copy = new HashMap<String, File>(this.storage);
        for (Map.Entry entry : copy.entrySet()) {
            this.downloadImpl((String)entry.getKey(), (File)entry.getValue());
        }
    }

    private void downloadImpl(String remoteFile, File localFile) {
        try {
            Future task = CommonTasksSupport.downloadFile((String)remoteFile, (ExecutionEnvironment)this.execEnv, (String)localFile.getAbsolutePath(), null);
            if (ImportProject.TRACE) {
                ImportProject.logger.log(Level.INFO, "#download file {0}", localFile.getAbsolutePath());
            }
            task.get();
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

