/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.refactoring;

import org.netbeans.modules.hibernate.mapping.model.Array;
import org.netbeans.modules.hibernate.mapping.model.Bag;
import org.netbeans.modules.hibernate.mapping.model.Component;
import org.netbeans.modules.hibernate.mapping.model.CompositeElement;
import org.netbeans.modules.hibernate.mapping.model.DynamicComponent;
import org.netbeans.modules.hibernate.mapping.model.HibernateMapping;
import org.netbeans.modules.hibernate.mapping.model.Idbag;
import org.netbeans.modules.hibernate.mapping.model.Join;
import org.netbeans.modules.hibernate.mapping.model.JoinedSubclass;
import org.netbeans.modules.hibernate.mapping.model.KeyManyToOne;
import org.netbeans.modules.hibernate.mapping.model.List;
import org.netbeans.modules.hibernate.mapping.model.ManyToOne;
import org.netbeans.modules.hibernate.mapping.model.Map;
import org.netbeans.modules.hibernate.mapping.model.MyClass;
import org.netbeans.modules.hibernate.mapping.model.NaturalId;
import org.netbeans.modules.hibernate.mapping.model.NestedCompositeElement;
import org.netbeans.modules.hibernate.mapping.model.OneToOne;
import org.netbeans.modules.hibernate.mapping.model.Properties;
import org.netbeans.modules.hibernate.mapping.model.Property;
import org.netbeans.modules.hibernate.mapping.model.Set;
import org.netbeans.modules.hibernate.mapping.model.Subclass;
import org.netbeans.modules.hibernate.mapping.model.UnionSubclass;
import org.netbeans.modules.hibernate.refactoring.HibernateRefactoringUtil;

public class JavaRenameChanger {
    private final String nameAttrib = "Name";
    private final String classAttrib = "Class";
    private final String typeAttribute = "Type";
    private boolean packageOnly;
    private String origName;
    private String newName;

    public JavaRenameChanger(boolean packageOnly, String origName, String newName) {
        this.packageOnly = packageOnly;
        this.origName = origName;
        this.newName = newName;
    }

    private boolean foundPackageName(String className) {
        String pkgName = HibernateRefactoringUtil.getPackageName(className);
        return pkgName != null && pkgName.equals(this.origName);
    }

    public void refactoringImports(HibernateMapping hbMapping) {
        for (int i = 0; i < hbMapping.sizeImport(); ++i) {
            String clsName = hbMapping.getAttributeValue("Import", i, "Class");
            if (clsName == null) continue;
            if (this.packageOnly && this.foundPackageName(clsName)) {
                String newClsName = clsName.replaceFirst(this.origName, this.newName);
                hbMapping.setAttributeValue("Import", i, "Class", newClsName);
                continue;
            }
            if (!clsName.equals(this.origName)) continue;
            hbMapping.setAttributeValue("Import", i, "Class", this.newName);
        }
    }

    public void refactoringMyClasses(HibernateMapping hbMapping) {
        MyClass[] myClazz = hbMapping.getMyClass();
        for (int ci = 0; ci < myClazz.length; ++ci) {
            String compositeIdClsName;
            MyClass thisClazz = myClazz[ci];
            this.refactoringSubclasses(thisClazz.getSubclass());
            this.refactoringJoinedSubclasses(thisClazz.getJoinedSubclass());
            this.refactoringUnionSubclasses(thisClazz.getUnionSubclass());
            String clsName = thisClazz.getAttributeValue("Name");
            if (clsName != null) {
                if (this.packageOnly && this.foundPackageName(clsName)) {
                    String newClsName = clsName.replaceFirst(this.origName, this.newName);
                    myClazz[ci].setAttributeValue("Name", newClsName);
                } else if (clsName.equals(this.origName)) {
                    myClazz[ci].setAttributeValue("Name", this.newName);
                } else {
                    String pack = null;
                    try {
                        pack = hbMapping.getAttributeValue("Package");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (pack != null && pack.length() > 0 && (pack + "." + clsName).equals(this.origName)) {
                        String newShortName;
                        String string = newShortName = this.newName.indexOf(46) > -1 ? this.newName.substring(this.newName.lastIndexOf(46) + 1) : this.newName;
                        if (clsName.equals(newShortName)) {
                            myClazz[ci].setAttributeValue("Name", this.newName);
                        } else {
                            myClazz[ci].setAttributeValue("Name", newShortName);
                        }
                    }
                }
            }
            if (thisClazz.getCompositeId() != null && (compositeIdClsName = thisClazz.getCompositeId().getAttributeValue("Class")) != null) {
                if (this.packageOnly && this.foundPackageName(compositeIdClsName)) {
                    String newompositeIdClsName = compositeIdClsName.replaceFirst(this.origName, this.newName);
                    thisClazz.getCompositeId().setAttributeValue("Class", newompositeIdClsName);
                } else if (compositeIdClsName.equals(this.origName)) {
                    thisClazz.getCompositeId().setAttributeValue("Class", this.newName);
                }
            }
            this.refactoringOneToOnes(thisClazz.getOneToOne());
            this.refactoringManyToOnes(thisClazz.getManyToOne());
            this.refactoringJoins(thisClazz.getJoin());
            this.refactoringNaturalId(thisClazz.getNaturalId());
            this.refactoringPropertiez(thisClazz.getProperties());
            this.refactoringPropertiez2(thisClazz.getProperty2());
            this.refactoringIdBags(thisClazz.getIdbag());
            this.refactoringMaps(thisClazz.getMap());
            this.refactoringSets(thisClazz.getSet());
            this.refactoringLists(thisClazz.getList());
            this.refactoringBags(thisClazz.getBag());
            this.refactoringArrays(thisClazz.getArray());
            this.refactoringComponents(thisClazz.getComponent());
            this.refactoringDynamicComponents(thisClazz.getDynamicComponent());
        }
    }

    public void refactoringSubclasses(Subclass[] subclazz) {
        for (int ci = 0; ci < subclazz.length; ++ci) {
            String extendsClsName;
            Subclass thisClazz = subclazz[ci];
            this.refactoringSubclasses(thisClazz.getSubclass());
            String clsName = thisClazz.getAttributeValue("Name");
            if (clsName != null) {
                if (this.packageOnly && this.foundPackageName(clsName)) {
                    String newClsName = clsName.replaceFirst(this.origName, this.newName);
                    thisClazz.setAttributeValue("Name", newClsName);
                } else if (clsName.equals(this.origName)) {
                    thisClazz.setAttributeValue("Name", this.newName);
                }
            }
            if ((extendsClsName = thisClazz.getAttributeValue("Extends")) != null) {
                if (this.packageOnly && this.foundPackageName(extendsClsName)) {
                    String newExtendsClsName = extendsClsName.replaceFirst(this.origName, this.newName);
                    thisClazz.setAttributeValue("Extends", newExtendsClsName);
                } else if (extendsClsName.equals(this.origName)) {
                    thisClazz.setAttributeValue("Extends", this.newName);
                }
            }
            this.refactoringOneToOnes(thisClazz.getOneToOne());
            this.refactoringJoins(thisClazz.getJoin());
            this.refactoringManyToOnes(thisClazz.getManyToOne());
            this.refactoringIdBags(thisClazz.getIdbag());
            this.refactoringMaps(thisClazz.getMap());
            this.refactoringSets(thisClazz.getSet());
            this.refactoringLists(thisClazz.getList());
            this.refactoringBags(thisClazz.getBag());
            this.refactoringArrays(thisClazz.getArray());
            this.refactoringComponents(thisClazz.getComponent());
            this.refactoringDynamicComponents(thisClazz.getDynamicComponent());
        }
    }

    public void refactoringJoinedSubclasses(JoinedSubclass[] joinedSubclazz) {
        for (int ci = 0; ci < joinedSubclazz.length; ++ci) {
            String persisterClsName;
            JoinedSubclass thisClazz = joinedSubclazz[ci];
            this.refactoringJoinedSubclasses(thisClazz.getJoinedSubclass());
            String clsName = thisClazz.getAttributeValue("Name");
            if (clsName != null) {
                if (this.packageOnly && this.foundPackageName(clsName)) {
                    String newClsName = clsName.replaceFirst(this.origName, this.newName);
                    joinedSubclazz[ci].setAttributeValue("Name", newClsName);
                } else if (clsName.equals(this.origName)) {
                    joinedSubclazz[ci].setAttributeValue("Name", this.newName);
                }
            }
            this.refactoringOneToOnes(thisClazz.getOneToOne());
            String extendsClsName = thisClazz.getAttributeValue("Extends");
            if (extendsClsName != null) {
                if (this.packageOnly && this.foundPackageName(extendsClsName)) {
                    String newExtendsClsName = extendsClsName.replaceFirst(this.origName, this.newName);
                    thisClazz.setAttributeValue("Extends", newExtendsClsName);
                } else if (extendsClsName.equals(this.origName)) {
                    thisClazz.setAttributeValue("Extends", this.newName);
                }
            }
            if ((persisterClsName = thisClazz.getAttributeValue("Persister")) != null) {
                if (this.packageOnly && this.foundPackageName(persisterClsName)) {
                    String newPersisterClsName = persisterClsName.replaceFirst(this.origName, this.newName);
                    thisClazz.setAttributeValue("Persister", newPersisterClsName);
                } else if (persisterClsName.equals(this.origName)) {
                    thisClazz.setAttributeValue("Persister", this.newName);
                }
            }
            this.refactoringManyToOnes(thisClazz.getManyToOne());
            this.refactoringPropertiez(thisClazz.getProperties());
            this.refactoringIdBags(thisClazz.getIdbag());
            this.refactoringMaps(thisClazz.getMap());
            this.refactoringSets(thisClazz.getSet());
            this.refactoringLists(thisClazz.getList());
            this.refactoringBags(thisClazz.getBag());
            this.refactoringArrays(thisClazz.getArray());
            this.refactoringComponents(thisClazz.getComponent());
            this.refactoringDynamicComponents(thisClazz.getDynamicComponent());
        }
    }

    public void refactoringUnionSubclasses(UnionSubclass[] unionSubclazz) {
        for (int ci = 0; ci < unionSubclazz.length; ++ci) {
            String extendsClsName;
            UnionSubclass thisClazz = unionSubclazz[ci];
            this.refactoringUnionSubclasses(thisClazz.getUnionSubclass());
            String clsName = thisClazz.getAttributeValue("Name");
            if (clsName != null) {
                if (this.packageOnly && this.foundPackageName(clsName)) {
                    String newClsName = clsName.replaceFirst(this.origName, this.newName);
                    unionSubclazz[ci].setAttributeValue("Name", newClsName);
                } else if (clsName.equals(this.origName)) {
                    unionSubclazz[ci].setAttributeValue("Name", this.newName);
                }
            }
            if (clsName.equals(this.origName)) {
                unionSubclazz[ci].setAttributeValue("Name", this.newName);
            }
            if ((extendsClsName = thisClazz.getAttributeValue("Extends")) != null) {
                if (this.packageOnly && this.foundPackageName(extendsClsName)) {
                    String newExtendsClsName = extendsClsName.replaceFirst(this.origName, this.newName);
                    thisClazz.setAttributeValue("Extends", newExtendsClsName);
                } else if (extendsClsName.equals(this.origName)) {
                    thisClazz.setAttributeValue("Extends", this.newName);
                }
            }
            this.refactoringOneToOnes(thisClazz.getOneToOne());
            String persisterClsName = thisClazz.getAttributeValue("Persister");
            if (persisterClsName != null) {
                if (this.packageOnly && this.foundPackageName(persisterClsName)) {
                    String newPersisterClsName = persisterClsName.replaceFirst(this.origName, this.newName);
                    thisClazz.setAttributeValue("Persister", newPersisterClsName);
                } else if (persisterClsName.equals(this.origName)) {
                    thisClazz.setAttributeValue("Persister", this.newName);
                }
            }
            this.refactoringManyToOnes(thisClazz.getManyToOne());
            this.refactoringPropertiez(thisClazz.getProperties());
            this.refactoringIdBags(thisClazz.getIdbag());
            this.refactoringMaps(thisClazz.getMap());
            this.refactoringSets(thisClazz.getSet());
            this.refactoringLists(thisClazz.getList());
            this.refactoringBags(thisClazz.getBag());
            this.refactoringArrays(thisClazz.getArray());
            this.refactoringComponents(thisClazz.getComponent());
            this.refactoringDynamicComponents(thisClazz.getDynamicComponent());
        }
    }

    private void refactoringOneToOnes(OneToOne[] hbModelOneToOnes) {
        for (int i = 0; i < hbModelOneToOnes.length; ++i) {
            String clsName = hbModelOneToOnes[i].getAttributeValue("Class");
            if (clsName == null) continue;
            if (this.packageOnly && this.foundPackageName(clsName)) {
                String newClsName = clsName.replaceFirst(this.origName, this.newName);
                hbModelOneToOnes[i].setAttributeValue("Class", newClsName);
                continue;
            }
            if (!clsName.equals(this.origName)) continue;
            hbModelOneToOnes[i].setAttributeValue("Class", this.newName);
        }
    }

    private void refactoringNaturalId(NaturalId nId) {
        if (nId == null) {
            return;
        }
        this.refactoringManyToOnes(nId.getManyToOne());
        this.refactoringComponents(nId.getComponent());
    }

    private void refactoringPropertiez(Properties[] hbModelPropertiez) {
        for (int i = 0; i < hbModelPropertiez.length; ++i) {
            this.refactoringManyToOnes(hbModelPropertiez[i].getManyToOne());
            this.refactoringComponents(hbModelPropertiez[i].getComponent());
        }
    }

    private void refactoringJoins(Join[] hbModelJoins) {
        for (int i = 0; i < hbModelJoins.length; ++i) {
            Join theJoin = hbModelJoins[i];
            this.refactoringManyToOnes(theJoin.getManyToOne());
            this.refactoringComponents(theJoin.getComponent());
        }
    }

    private void refactoringComponents(Component[] hbModelComponents) {
        for (int i = 0; i < hbModelComponents.length; ++i) {
            Component thisComp = hbModelComponents[i];
            String clsName = thisComp.getAttributeValue("Class");
            if (clsName != null) {
                if (this.packageOnly && this.foundPackageName(clsName)) {
                    String newClsName = clsName.replaceFirst(this.origName, this.newName);
                    thisComp.setAttributeValue("Class", newClsName);
                } else if (clsName.equals(this.origName)) {
                    thisComp.setAttributeValue("Class", this.newName);
                }
            }
            this.refactoringManyToOnes(thisComp.getManyToOne());
            this.refactoringMaps(thisComp.getMap());
            this.refactoringSets(thisComp.getSet());
            this.refactoringLists(thisComp.getList());
            this.refactoringBags(thisComp.getBag());
            this.refactoringArrays(thisComp.getArray());
            this.refactoringOneToOnes(thisComp.getOneToOne());
        }
    }

    private void refactoringDynamicComponents(DynamicComponent[] hbModelDynComps) {
        for (int i = 0; i < hbModelDynComps.length; ++i) {
            DynamicComponent thisComp = hbModelDynComps[i];
            this.refactoringManyToOnes(thisComp.getManyToOne());
            this.refactoringMaps(thisComp.getMap());
            this.refactoringSets(thisComp.getSet());
            this.refactoringLists(thisComp.getList());
            this.refactoringBags(thisComp.getBag());
            this.refactoringArrays(thisComp.getArray());
            this.refactoringOneToOnes(thisComp.getOneToOne());
        }
    }

    private void refactoringManyToOnes(ManyToOne[] hbModelManyToOnes) {
        for (int i = 0; i < hbModelManyToOnes.length; ++i) {
            String clsName = hbModelManyToOnes[i].getAttributeValue("Class");
            if (clsName == null) continue;
            if (this.packageOnly && this.foundPackageName(clsName)) {
                String newClsName = clsName.replaceFirst(this.origName, this.newName);
                hbModelManyToOnes[i].setAttributeValue("Class", newClsName);
                continue;
            }
            if (!clsName.equals(this.origName)) continue;
            hbModelManyToOnes[i].setAttributeValue("Class", this.newName);
        }
    }

    private void refactoringMaps(Map[] hbModelMaps) {
        for (int mi = 0; mi < hbModelMaps.length; ++mi) {
            String manyToManyClsName;
            Map theMap = hbModelMaps[mi];
            if (theMap.getCompositeMapKey() != null) {
                this.refactoringKeyManyToOnes(theMap.getCompositeMapKey().getKeyManyToOne());
            }
            if (theMap.getCompositeIndex() != null) {
                this.refactoringKeyManyToOnes(theMap.getCompositeIndex().getKeyManyToOne());
            }
            this.refactoringCompositeElement(theMap.getCompositeElement());
            String oneToManyClsName = theMap.getAttributeValue("OneToMany", "Class");
            if (oneToManyClsName != null) {
                if (this.packageOnly && this.foundPackageName(oneToManyClsName)) {
                    String newOneToManyClsName = oneToManyClsName.replaceFirst(this.origName, this.newName);
                    theMap.setAttributeValue("OneToMany", "Class", newOneToManyClsName);
                } else if (oneToManyClsName.equals(this.origName)) {
                    theMap.setAttributeValue("OneToMany", "Class", this.newName);
                }
            }
            if ((manyToManyClsName = theMap.getAttributeValue("ManyToMany", "Class")) == null) continue;
            if (this.packageOnly && this.foundPackageName(manyToManyClsName)) {
                String newManyToManyClsName = manyToManyClsName.replaceFirst(this.origName, this.newName);
                theMap.setAttributeValue("ManyToMany", "Class", newManyToManyClsName);
                continue;
            }
            if (!manyToManyClsName.equals(this.origName)) continue;
            theMap.setAttributeValue("ManyToMany", "Class", this.newName);
        }
    }

    private void refactoringCompositeElement(CompositeElement compositeElement) {
        if (compositeElement == null) {
            return;
        }
        String clsName = compositeElement.getAttributeValue("Class");
        if (clsName != null) {
            if (this.packageOnly && this.foundPackageName(clsName)) {
                String newClsName = clsName.replaceFirst(this.origName, this.newName);
                compositeElement.setAttributeValue("Class", newClsName);
            } else if (clsName.equals(this.origName)) {
                compositeElement.setAttributeValue("Class", this.newName);
            }
        }
        this.refactoringNestedCompositeElements(compositeElement.getNestedCompositeElement());
    }

    private void refactoringNestedCompositeElements(NestedCompositeElement[] nestedCompElems) {
        for (int i = 0; i < nestedCompElems.length; ++i) {
            this.refactoringManyToOnes(nestedCompElems[i].getManyToOne());
        }
    }

    private void refactoringKeyManyToOnes(KeyManyToOne[] keyManyToOnes) {
        for (int i = 0; i < keyManyToOnes.length; ++i) {
            KeyManyToOne theOne = keyManyToOnes[i];
            String clsName = theOne.getAttributeValue("Class");
            if (clsName == null) continue;
            if (this.packageOnly && this.foundPackageName(clsName)) {
                String newClsName = clsName.replaceFirst(this.origName, this.newName);
                theOne.setAttributeValue("Class", newClsName);
                continue;
            }
            if (!clsName.equals(this.origName)) continue;
            theOne.setAttributeValue("Class", this.newName);
        }
    }

    private void refactoringSets(Set[] hbModelSets) {
        for (int si = 0; si < hbModelSets.length; ++si) {
            String manyToManyClsName;
            String oneToManyClsName = hbModelSets[si].getAttributeValue("OneToMany", "Class");
            if (oneToManyClsName != null) {
                if (this.packageOnly && this.foundPackageName(oneToManyClsName)) {
                    String newOneToManyClsName = oneToManyClsName.replaceFirst(this.origName, this.newName);
                    hbModelSets[si].setAttributeValue("OneToMany", "Class", newOneToManyClsName);
                } else if (oneToManyClsName.equals(this.origName)) {
                    hbModelSets[si].setAttributeValue("OneToMany", "Class", this.newName);
                }
            }
            if ((manyToManyClsName = hbModelSets[si].getAttributeValue("ManyToMany", "Class")) != null) {
                if (this.packageOnly && this.foundPackageName(manyToManyClsName)) {
                    String newManyToManyClsName = manyToManyClsName.replaceFirst(this.origName, this.newName);
                    hbModelSets[si].setAttributeValue("ManyToMany", "Class", newManyToManyClsName);
                } else if (manyToManyClsName.equals(this.origName)) {
                    hbModelSets[si].setAttributeValue("ManyToMany", "Class", this.newName);
                }
            }
            this.refactoringCompositeElement(hbModelSets[si].getCompositeElement());
        }
    }

    private void refactoringLists(List[] hbModelLists) {
        for (int li = 0; li < hbModelLists.length; ++li) {
            String manyToManyClsName;
            String oneToManyClsName = hbModelLists[li].getAttributeValue("OneToMany", "Class");
            if (oneToManyClsName != null) {
                if (this.packageOnly && this.foundPackageName(oneToManyClsName)) {
                    String newOneToManyClsName = oneToManyClsName.replaceFirst(this.origName, this.newName);
                    hbModelLists[li].setAttributeValue("OneToMany", "Class", newOneToManyClsName);
                } else if (oneToManyClsName.equals(this.origName)) {
                    hbModelLists[li].setAttributeValue("OneToMany", "Class", this.newName);
                }
            }
            if ((manyToManyClsName = hbModelLists[li].getAttributeValue("ManyToMany", "Class")) != null) {
                if (this.packageOnly && this.foundPackageName(manyToManyClsName)) {
                    String newManyToManyClsName = manyToManyClsName.replaceFirst(this.origName, this.newName);
                    hbModelLists[li].setAttributeValue("ManyToMany", "Class", newManyToManyClsName);
                } else if (manyToManyClsName.equals(this.origName)) {
                    hbModelLists[li].setAttributeValue("ManyToMany", "Class", this.newName);
                }
            }
            this.refactoringCompositeElement(hbModelLists[li].getCompositeElement());
        }
    }

    private void refactoringBags(Bag[] hbModelBags) {
        for (int bi = 0; bi < hbModelBags.length; ++bi) {
            String manyToManyClsName;
            String oneToManyClsName = hbModelBags[bi].getAttributeValue("OneToMany", "Class");
            if (oneToManyClsName != null) {
                if (this.packageOnly && this.foundPackageName(oneToManyClsName)) {
                    String newOneToManyClsName = oneToManyClsName.replaceFirst(this.origName, this.newName);
                    hbModelBags[bi].setAttributeValue("OneToMany", "Class", newOneToManyClsName);
                } else if (oneToManyClsName.equals(this.origName)) {
                    hbModelBags[bi].setAttributeValue("OneToMany", "Class", this.newName);
                }
            }
            if ((manyToManyClsName = hbModelBags[bi].getAttributeValue("ManyToMany", "Class")) != null) {
                if (this.packageOnly && this.foundPackageName(manyToManyClsName)) {
                    String newManyToManyClsName = manyToManyClsName.replaceFirst(this.origName, this.newName);
                    hbModelBags[bi].setAttributeValue("ManyToMany", "Class", newManyToManyClsName);
                } else if (manyToManyClsName.equals(this.origName)) {
                    hbModelBags[bi].setAttributeValue("ManyToMany", "Class", this.newName);
                }
            }
            this.refactoringCompositeElement(hbModelBags[bi].getCompositeElement());
        }
    }

    private void refactoringIdBags(Idbag[] hbModelIdbags) {
        for (int i = 0; i < hbModelIdbags.length; ++i) {
            this.refactoringCompositeElement(hbModelIdbags[i].getCompositeElement());
            String manyToManyClsName = hbModelIdbags[i].getAttributeValue("ManyToMany", "Class");
            if (manyToManyClsName == null) continue;
            if (this.packageOnly && this.foundPackageName(manyToManyClsName)) {
                String newManyToManyClsName = manyToManyClsName.replaceFirst(this.origName, this.newName);
                hbModelIdbags[i].setAttributeValue("ManyToMany", "Class", newManyToManyClsName);
                continue;
            }
            if (!manyToManyClsName.equals(this.origName)) continue;
            hbModelIdbags[i].setAttributeValue("ManyToMany", "Class", this.newName);
        }
    }

    private void refactoringArrays(Array[] hbModelArrays) {
        for (int ai = 0; ai < hbModelArrays.length; ++ai) {
            String manyToManyClsName;
            String oneToManyClsName = hbModelArrays[ai].getAttributeValue("OneToMany", "Class");
            if (oneToManyClsName != null) {
                if (this.packageOnly && this.foundPackageName(oneToManyClsName)) {
                    String newOneToManyClsName = oneToManyClsName.replaceFirst(this.origName, this.newName);
                    hbModelArrays[ai].setAttributeValue("OneToMany", "Class", newOneToManyClsName);
                } else if (oneToManyClsName.equals(this.origName)) {
                    hbModelArrays[ai].setAttributeValue("OneToMany", "Class", this.newName);
                }
            }
            if ((manyToManyClsName = hbModelArrays[ai].getAttributeValue("ManyToMany", "Class")) != null) {
                if (this.packageOnly && this.foundPackageName(manyToManyClsName)) {
                    String newManyToManyClsName = manyToManyClsName.replaceFirst(this.origName, this.newName);
                    hbModelArrays[ai].setAttributeValue("ManyToMany", "Class", newManyToManyClsName);
                } else if (manyToManyClsName.equals(this.origName)) {
                    hbModelArrays[ai].setAttributeValue("ManyToMany", "Class", this.newName);
                }
            }
            this.refactoringCompositeElement(hbModelArrays[ai].getCompositeElement());
        }
    }

    private void refactoringPropertiez2(Property[] property2) {
        if (property2 != null && property2.length > 0) {
            for (int i = 0; i < property2.length; ++i) {
                String clsName = property2[i].getAttributeValue("Type");
                if (clsName == null) continue;
                if (this.packageOnly && this.foundPackageName(clsName)) {
                    String newClsName = clsName.replaceFirst(this.origName, this.newName);
                    property2[i].setAttributeValue("Type", newClsName);
                    continue;
                }
                if (!clsName.equals(this.origName)) continue;
                property2[i].setAttributeValue("Type", this.newName);
            }
        }
    }
}

