/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.customizer;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.text.DateFormat;
import java.util.Date;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.ui.configurations.BooleanNodeProp;
import org.netbeans.modules.cnd.makeproject.api.ui.configurations.BooleanReverseNodeProp;
import org.netbeans.modules.cnd.makeproject.api.ui.configurations.CustomizerNode;
import org.netbeans.modules.cnd.makeproject.ui.configurations.StateCA;
import org.netbeans.modules.cnd.makeproject.ui.configurations.StateCANodeProp;
import org.netbeans.modules.cnd.makeproject.ui.customizer.AssemblerCustomizerNode;
import org.netbeans.modules.cnd.makeproject.ui.customizer.CCCompilerCustomizerNode;
import org.netbeans.modules.cnd.makeproject.ui.customizer.CCompilerCustomizerNode;
import org.netbeans.modules.cnd.makeproject.ui.customizer.CustomBuildItemCustomizerNode;
import org.netbeans.modules.cnd.makeproject.ui.customizer.FortranCompilerCustomizerNode;
import org.netbeans.modules.cnd.makeproject.ui.customizer.GeneralItemCustomizerNode;
import org.netbeans.modules.cnd.makeproject.ui.customizer.MakeContext;
import org.netbeans.modules.cnd.makeproject.ui.customizer.PropertyNode;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ItemNodeFactory {
    private static final boolean SHOW_HEADER_EXCLUDE = CndUtils.getBoolean((String)"cnd.makeproject.showHeaderExclude", (boolean)true);

    private ItemNodeFactory() {
    }

    public static Node createRootNodeItem(Lookup lookup) {
        MakeContext context = (MakeContext)lookup.lookup(MakeContext.class);
        PredefinedToolKind tool = context.getItemsTool();
        boolean procFile = context.isProc();
        int count = 1;
        if (tool != PredefinedToolKind.UnknownTool) {
            ++count;
            if (procFile) {
                ++count;
            }
        }
        CustomizerNode[] descriptions = new CustomizerNode[count];
        int index = 0;
        descriptions[index++] = ItemNodeFactory.createGeneralItemDescription(lookup);
        if (tool != PredefinedToolKind.UnknownTool) {
            if (tool == PredefinedToolKind.CCompiler) {
                descriptions[index++] = ItemNodeFactory.createCCompilerDescription(lookup);
                if (procFile) {
                    descriptions[index++] = ItemNodeFactory.createCustomBuildItemDescription(lookup);
                }
            } else if (tool == PredefinedToolKind.CCCompiler) {
                descriptions[index++] = ItemNodeFactory.createCCCompilerDescription(lookup);
                if (procFile) {
                    descriptions[index++] = ItemNodeFactory.createCustomBuildItemDescription(lookup);
                }
            } else {
                descriptions[index++] = tool == PredefinedToolKind.FortranCompiler ? ItemNodeFactory.createFortranCompilerDescription(lookup) : (tool == PredefinedToolKind.Assembler ? ItemNodeFactory.createAssemblerDescription(lookup) : (tool == PredefinedToolKind.CustomTool ? ItemNodeFactory.createCustomBuildItemDescription(lookup) : ItemNodeFactory.createCustomBuildItemDescription(lookup)));
            }
        }
        CustomizerNode rootDescription = new CustomizerNode("Configuration Properties", ItemNodeFactory.getString("CONFIGURATION_PROPERTIES"), descriptions, lookup);
        return new PropertyNode(rootDescription);
    }

    private static CustomizerNode createGeneralItemDescription(Lookup lookup) {
        return new GeneralItemCustomizerNode("GeneralItem", ItemNodeFactory.getString("LBL_Config_General"), null, lookup);
    }

    public static CustomizerNode createFortranCompilerDescription(Lookup lookup) {
        String compilerName = "fortran";
        String compilerDisplayName = PredefinedToolKind.FortranCompiler.getDisplayName();
        FortranCompilerCustomizerNode fortranCompilerCustomizerNode = new FortranCompilerCustomizerNode(compilerName, compilerDisplayName, null, lookup);
        return fortranCompilerCustomizerNode;
    }

    public static CustomizerNode createAssemblerDescription(Lookup lookup) {
        String compilerName = "as";
        String compilerDisplayName = PredefinedToolKind.Assembler.getDisplayName();
        AssemblerCustomizerNode assemblerCustomizerNode = new AssemblerCustomizerNode(compilerName, compilerDisplayName, null, lookup);
        return assemblerCustomizerNode;
    }

    public static CustomizerNode createCCCompilerDescription(Lookup lookup) {
        String compilerName = "cpp";
        String compilerDisplayName = PredefinedToolKind.CCCompiler.getDisplayName();
        CCCompilerCustomizerNode ccCompilerCustomizerNode = new CCCompilerCustomizerNode(compilerName, compilerDisplayName, null, lookup);
        return ccCompilerCustomizerNode;
    }

    public static CustomizerNode createCustomBuildItemDescription(Lookup lookup) {
        return new CustomBuildItemCustomizerNode("Custom Build Step", ItemNodeFactory.getString("LBL_Config_Custom_Build"), null, lookup);
    }

    public static CustomizerNode createCCompilerDescription(Lookup lookup) {
        String compilerName = "c";
        String compilerDisplayName = PredefinedToolKind.CCompiler.getDisplayName();
        CCompilerCustomizerNode cCompilerCustomizerNode = new CCompilerCustomizerNode(compilerName, compilerDisplayName, null, lookup);
        return cCompilerCustomizerNode;
    }

    private static String getString(String s) {
        return NbBundle.getBundle(ItemNodeFactory.class).getString(s);
    }

    public static Sheet getGeneralSheet(ItemConfiguration ic) {
        FileObject itemFO;
        String fullPath;
        String baseDir;
        FileObject baseDirFO;
        Sheet sheet = new Sheet();
        Sheet.Set set = new Sheet.Set();
        set.setName("Item");
        set.setDisplayName(ItemNodeFactory.getString("ItemTxt"));
        set.setShortDescription(ItemNodeFactory.getString("ItemHint"));
        set.put((Node.Property)new StringRONodeProp(ItemNodeFactory.getString("NameTxt"), CndPathUtilities.getBaseName((String)ic.getItem().getPath())));
        set.put((Node.Property)new StringRONodeProp(ItemNodeFactory.getString("FilePathTxt"), ic.getItem().getPath()));
        String mdate = "";
        MakeConfiguration mc = (MakeConfiguration)ic.getConfiguration();
        FileSystem sourceFS = mc.getSourceFileSystem();
        if (sourceFS == null) {
            sourceFS = CndFileUtils.getLocalFileSystem();
        }
        if ((baseDirFO = sourceFS.findResource(baseDir = mc.getBaseDir())) != null && baseDirFO.isValid()) {
            fullPath = CndPathUtilities.toAbsolutePath((FileObject)baseDirFO, (String)ic.getItem().getPath());
            itemFO = sourceFS.findResource(FileSystemProvider.normalizeAbsolutePath((String)fullPath, (FileSystem)sourceFS));
        } else {
            fullPath = CndPathUtilities.toAbsolutePath((FileSystem)sourceFS, (String)baseDir, (String)ic.getItem().getPath());
            itemFO = null;
        }
        if (itemFO != null && itemFO.isValid()) {
            Date lastModified = itemFO.lastModified();
            mdate = DateFormat.getDateInstance().format(lastModified);
            mdate = mdate + " " + DateFormat.getTimeInstance().format(lastModified);
        }
        set.put((Node.Property)new StringRONodeProp(ItemNodeFactory.getString("FullFilePathTxt"), fullPath));
        set.put((Node.Property)new StringRONodeProp(ItemNodeFactory.getString("LastModifiedTxt"), mdate));
        sheet.put(set);
        set = new Sheet.Set();
        set.setName("ItemConfiguration");
        set.setDisplayName(ItemNodeFactory.getString("ItemConfigurationTxt"));
        set.setShortDescription(ItemNodeFactory.getString("ItemConfigurationHint"));
        set.put((Node.Property)new StateCANodeProp(StateCA.getState(ic.getConfiguration(), ic.getItem(), ic), ItemNodeFactory.getString("CodeAssistanceTxt"), ItemNodeFactory.getString("CodeAssistanceHint")));
        if (SHOW_HEADER_EXCLUDE || !MIMENames.isHeader((String)ic.getItem().getMIMEType())) {
            if (ic.getConfiguration() instanceof MakeConfiguration && ((MakeConfiguration)ic.getConfiguration()).isMakefileConfiguration()) {
                set.put((Node.Property)new BooleanReverseNodeProp(ic.getExcluded(), true, "IncludedInCodeAssistance", ItemNodeFactory.getString("IncludedInCodeAssistanceTxt"), ItemNodeFactory.getString("IncludedInCodeAssistanceHint")));
            } else {
                set.put((Node.Property)new BooleanNodeProp(ic.getExcluded(), true, "ExcludedFromBuild", ItemNodeFactory.getString("ExcludedFromBuildTxt"), ItemNodeFactory.getString("ExcludedFromBuildHint")));
            }
        }
        set.put((Node.Property)new ToolNodeProp(ic));
        sheet.put(set);
        return sheet;
    }

    private static class StringRONodeProp
    extends PropertySupport<String> {
        private final String value;

        public StringRONodeProp(String name, String value) {
            super(name, String.class, name, name, true, false);
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String v) {
        }
    }

    private static class ToolEditor
    extends PropertyEditorSupport {
        private final ItemConfiguration ic;

        public ToolEditor(ItemConfiguration ic) {
            this.ic = ic;
        }

        @Override
        public String getJavaInitializationString() {
            return this.getAsText();
        }

        @Override
        public String getAsText() {
            ToolKind val = (ToolKind)this.getValue();
            return val.getDisplayName();
        }

        @Override
        public void setAsText(String text) throws IllegalArgumentException {
            this.setValue(PredefinedToolKind.getTool((String)text));
        }

        @Override
        public String[] getTags() {
            return this.ic.getToolNames();
        }
    }

    private static class ToolNodeProp
    extends Node.Property<PredefinedToolKind> {
        private final ItemConfiguration ic;

        public ToolNodeProp(ItemConfiguration ic) {
            super(PredefinedToolKind.class);
            this.ic = ic;
        }

        public String getName() {
            return ItemNodeFactory.getString("ToolTxt1");
        }

        public PredefinedToolKind getValue() {
            return this.ic.getTool();
        }

        public void setValue(PredefinedToolKind v) {
            this.ic.setTool(v);
        }

        public boolean canWrite() {
            return true;
        }

        public boolean canRead() {
            return true;
        }

        public PropertyEditor getPropertyEditor() {
            return new ToolEditor(this.ic);
        }
    }
}

