/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote;

import java.awt.Color;
import java.awt.EventQueue;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.MercurialVCS;
import org.netbeans.modules.mercurial.remote.config.HgConfigFiles;
import org.netbeans.modules.mercurial.remote.ui.repository.RepositoryConnection;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.util.KeyringSupport;
import org.netbeans.modules.versioning.util.TableSorter;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class HgModuleConfig {
    public static final String PROP_IGNORED_FILEPATTERNS = "ignoredFilePatterns";
    public static final String PROP_COMMIT_EXCLUSIONS = "commitExclusions";
    public static final String PROP_DEFAULT_VALUES = "defaultValues";
    public static final String PROP_RUN_VERSION = "runVersion";
    public static final String KEY_EXECUTABLE_BINARY = "hgExecBinary";
    public static final String KEY_EXPORT_FILENAME = "hgExportFilename";
    public static final String KEY_EXPORT_FOLDER = "hgExportFolder";
    public static final String KEY_IMPORT_FOLDER = "hgImportFolder";
    public static final String KEY_ANNOTATION_FORMAT = "annotationFormat";
    public static final String SAVE_PASSWORD = "savePassword";
    public static final String KEY_BACKUP_ON_REVERTMODS = "backupOnRevert";
    public static final String KEY_SHOW_HITORY_MERGES = "showHistoryMerges";
    private static final String KEY_SHOW_FILE_INFO = "showFileInfo";
    private static final String AUTO_OPEN_OUTPUT_WINDOW = "autoOpenOutput";
    private static final String CONFIRM_BEFORE_COMMIT_AFTER_MERGE = "confirmBeforeCommitAfterMerge";
    private static final String KEY_INTERNAL_MERGE_TOOL_ENABLED = "hgmerge.internalTool.enabled";
    private static final String PROP_EXCLUDE_NEW_FILES = "excludeNewFiles";
    private static final String PROP_DIFF_VIEW_MODE = "diffViewMode";
    private static final String KEY_QPATCH_MESSAGE = "qpatch.message.";
    private static final String PROP_RECENT_COMMIT_AUTHORS = "recentCommitAuhtors";
    private static final String RECENT_URL = "repository.recentURL";
    private static final String SHOW_CLONE_COMPLETED = "cloneCompleted.showCloneCompleted";
    private static final String URL_EXP = "annotator.urlExp";
    private static final String ANNOTATION_EXP = "annotator.annotationExp";
    public static final String TEXT_ANNOTATIONS_FORMAT_DEFAULT = "{DEFAULT}";
    private static final String DEFAULT_EXPORT_FILENAME = "%b_%r_%h";
    private static final Map<FileSystem, HgModuleConfig> INSTANCE = new HashMap<FileSystem, HgModuleConfig>();
    private static final String KEY_SEARCH_ON_BRANCH = "searchOnBranch.enabled.";
    private static final String KEY_REMOVE_NEW_FILES_ON_REVERT = "removeNewFilesOnRevert";
    private String userName;
    private final FileSystem fileSystem;
    private Set<String> exclusions;
    private final Map<String, String> lastCanceledCommitMessages = new HashMap<String, String>(5);
    private TableSorter importTableSorter;
    private TableSorter commitTableSorter;

    public static synchronized HgModuleConfig getDefault(VCSFileProxy root) {
        HgModuleConfig res;
        FileSystem fileSystem = null;
        if (root != null) {
            fileSystem = VCSFileProxySupport.getFileSystem((VCSFileProxy)root);
        }
        if ((res = INSTANCE.get(fileSystem)) == null) {
            res = new HgModuleConfig(fileSystem);
            INSTANCE.put(fileSystem, res);
        }
        return res;
    }

    private HgModuleConfig(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
        this.setDefaultPath();
        MercurialVCS mercurialVCS = Mercurial.getInstance().getMercurialVCS();
        if (mercurialVCS != null) {
            this.getPreferences().addPreferenceChangeListener(mercurialVCS);
        }
    }

    private void setDefaultPath() {
        String defaultPath;
        if (this.fileSystem != null && VCSFileProxySupport.isMac((VCSFileProxy)VCSFileProxy.createFileProxy((FileObject)this.fileSystem.getRoot())) && ((defaultPath = this.getExecutableBinaryPath()) == null || defaultPath.length() == 0)) {
            String[] pathNames = new String[]{"/Library/Frameworks/Python.framework/Versions/Current/bin", "/usr/bin", "/usr/local/bin", "/opt/local/bin/", "/sw/bin"};
            for (int i = 0; i < pathNames.length; ++i) {
                if (!this.isExecPathValid(pathNames[i]).booleanValue()) continue;
                this.setExecutableBinaryPath(pathNames[i]);
                break;
            }
        }
    }

    public final Preferences getPreferences() {
        if (this.fileSystem == null) {
            return NbPreferences.forModule(HgModuleConfig.class).node("commonRemoteMercurial");
        }
        return NbPreferences.forModule(HgModuleConfig.class).node(VCSFileProxySupport.getFileSystemKey((FileSystem)this.fileSystem));
    }

    public boolean getShowCloneCompleted() {
        return this.getPreferences().getBoolean(SHOW_CLONE_COMPLETED, true);
    }

    public Pattern[] getIgnoredFilePatterns() {
        return HgModuleConfig.getDefaultFilePatterns();
    }

    public boolean getShowFileInfo() {
        return this.getPreferences().getBoolean(KEY_SHOW_FILE_INFO, false);
    }

    public boolean isExcludedFromCommit(String path) {
        return this.getCommitExclusions().contains(path);
    }

    public void addExclusionPaths(Collection<String> paths) {
        Set<String> exclusions = this.getCommitExclusions();
        if (exclusions.addAll(paths)) {
            Utils.put((Preferences)this.getPreferences(), (String)PROP_COMMIT_EXCLUSIONS, new ArrayList<String>(exclusions));
        }
    }

    public void removeExclusionPaths(Collection<String> paths) {
        Set<String> exclusions = this.getCommitExclusions();
        if (exclusions.removeAll(paths)) {
            Utils.put((Preferences)this.getPreferences(), (String)PROP_COMMIT_EXCLUSIONS, new ArrayList<String>(exclusions));
        }
    }

    public String getExecutableBinaryPath() {
        return this.getPreferences().get(KEY_EXECUTABLE_BINARY, "");
    }

    public boolean getBackupOnRevertModifications() {
        return this.getPreferences().getBoolean(KEY_BACKUP_ON_REVERTMODS, true);
    }

    public void setBackupOnRevertModifications(boolean bBackup) {
        this.getPreferences().putBoolean(KEY_BACKUP_ON_REVERTMODS, bBackup);
    }

    public boolean getShowHistoryMerges() {
        return this.getPreferences().getBoolean(KEY_SHOW_HITORY_MERGES, true);
    }

    public void setShowHistoryMerges(boolean bShowMerges) {
        this.getPreferences().putBoolean(KEY_SHOW_HITORY_MERGES, bShowMerges);
    }

    public void setShowFileInfo(boolean info) {
        this.getPreferences().putBoolean(KEY_SHOW_FILE_INFO, info);
    }

    public void setExecutableBinaryPath(String path) {
        if (path.endsWith("hg")) {
            path = path.substring(0, path.length() - "hg".length());
        }
        this.getPreferences().put(KEY_EXECUTABLE_BINARY, path);
    }

    public String getExportFolder() {
        return this.getPreferences().get(KEY_EXPORT_FOLDER, System.getProperty("user.home"));
    }

    public void setExportFolder(String path) {
        this.getPreferences().put(KEY_EXPORT_FOLDER, path);
    }

    public String getImportFolder() {
        return this.getPreferences().get(KEY_IMPORT_FOLDER, System.getProperty("user.home"));
    }

    public void setImportFolder(String path) {
        this.getPreferences().put(KEY_IMPORT_FOLDER, path);
    }

    public String getExportFilename() {
        String str = this.getPreferences().get(KEY_EXPORT_FILENAME, "");
        if (str.trim().length() == 0) {
            str = DEFAULT_EXPORT_FILENAME;
        }
        return str;
    }

    public void setExportFilename(String path) {
        this.getPreferences().put(KEY_EXPORT_FILENAME, path);
    }

    public boolean getAutoOpenOutput() {
        return this.getPreferences().getBoolean(AUTO_OPEN_OUTPUT_WINDOW, true);
    }

    public void setAutoOpenOutput(boolean value) {
        this.getPreferences().putBoolean(AUTO_OPEN_OUTPUT_WINDOW, value);
    }

    public boolean getConfirmCommitAfterMerge() {
        return this.getPreferences().getBoolean(CONFIRM_BEFORE_COMMIT_AFTER_MERGE, false);
    }

    public void setConfirmCommitAfterMerge(boolean value) {
        this.getPreferences().putBoolean(CONFIRM_BEFORE_COMMIT_AFTER_MERGE, value);
    }

    public String getSysUserName() {
        this.userName = HgConfigFiles.getSysInstance(VCSFileProxy.createFileProxy((FileObject)this.fileSystem.getRoot())).getSysUserName();
        if (this.userName.length() == 0) {
            String hostName;
            String userId = System.getProperty("user.name");
            try {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception ex) {
                hostName = "localhost";
            }
            this.userName = userId + "@" + hostName;
        }
        return this.userName;
    }

    private String getSysPushPath(VCSFileProxy file) {
        return HgConfigFiles.getSysInstance(file).getSysPushPath();
    }

    private String getSysPullPath(VCSFileProxy file) {
        return HgConfigFiles.getSysInstance(file).getSysPullPath();
    }

    public void setUserName(String name) throws IOException {
        HgConfigFiles hcf = HgConfigFiles.getSysInstance(VCSFileProxy.createFileProxy((FileObject)this.fileSystem.getRoot()));
        if (hcf.getException() != null) {
            Mercurial.LOG.log(Level.WARNING, this.getClass().getName() + ": Cannot set username property");
            Mercurial.LOG.log(Level.INFO, null, hcf.getException());
            throw hcf.getException();
        }
        hcf.setUserName(name);
    }

    public Boolean isUserNameValid(String name) {
        if (this.userName == null) {
            this.getSysUserName();
        }
        if (name.equals(this.userName)) {
            return true;
        }
        return !name.trim().isEmpty();
    }

    public Boolean isExecPathValid(String name) {
        if (name.length() == 0) {
            return true;
        }
        VCSFileProxy file = VCSFileProxySupport.getResource((FileSystem)this.fileSystem, (String)(name + "/" + "hg"));
        if (file.exists() && file.isFile()) {
            return true;
        }
        return false;
    }

    public Properties getProperties(VCSFileProxy file) {
        Properties props = new Properties();
        HgConfigFiles hgconfig = new HgConfigFiles(file);
        if (hgconfig.getException() != null) {
            Mercurial.LOG.log(Level.WARNING, this.getClass().getName() + ": cannot load configuration file");
            Mercurial.LOG.log(Level.INFO, null, hgconfig.getException());
            HgModuleConfig.notifyParsingError();
            return null;
        }
        String name = hgconfig.getUserName(false);
        if (name.length() == 0) {
            name = this.getSysUserName();
        }
        if (name.length() > 0) {
            props.setProperty("username", name);
        } else {
            props.setProperty("username", "");
        }
        name = hgconfig.getDefaultPull(false);
        if (name.length() == 0) {
            name = this.getSysPullPath(file);
        }
        if (name.length() > 0) {
            props.setProperty("default-pull", name);
        } else {
            props.setProperty("default-pull", "");
        }
        name = hgconfig.getDefaultPush(false);
        if (name.length() == 0) {
            name = this.getSysPushPath(file);
        }
        if (name.length() > 0) {
            props.setProperty("default-push", name);
        } else {
            props.setProperty("default-push", "");
        }
        return props;
    }

    public void clearProperties(VCSFileProxy file, String section) throws IOException {
        HgConfigFiles hcf = this.getHgConfigFiles(file);
        if (hcf.getException() != null) {
            Mercurial.LOG.log(Level.WARNING, this.getClass().getName() + ": cannot clear properties for {0}", new VCSFileProxy[]{file});
            Mercurial.LOG.log(Level.INFO, null, hcf.getException());
            throw hcf.getException();
        }
        hcf.clearProperties(section);
    }

    public void removeProperty(VCSFileProxy file, String section, String name) throws IOException {
        HgConfigFiles hcf = this.getHgConfigFiles(file);
        if (hcf.getException() != null) {
            Mercurial.LOG.log(Level.WARNING, this.getClass().getName() + ": cannot remove property {0} for {1}", new Object[]{name, file});
            Mercurial.LOG.log(Level.INFO, null, hcf.getException());
            throw hcf.getException();
        }
        hcf.removeProperty(section, name);
    }

    public void setProperty(VCSFileProxy file, String name, String value) throws IOException {
        HgConfigFiles hcf = this.getHgConfigFiles(file);
        if (hcf.getException() != null) {
            Mercurial.LOG.log(Level.WARNING, this.getClass().getName() + ": cannot set property {0}:{1} for {2}", new Object[]{name, value, file});
            Mercurial.LOG.log(Level.INFO, null, hcf.getException());
            throw hcf.getException();
        }
        hcf.setProperty(name, value);
    }

    public void setProperty(VCSFileProxy file, String section, String name, String value, boolean allowEmpty) throws IOException {
        HgConfigFiles hcf = this.getHgConfigFiles(file);
        if (hcf.getException() != null) {
            Mercurial.LOG.log(Level.WARNING, this.getClass().getName() + ": cannot set property {0}:{1} for {2}", new Object[]{name, value, file});
            Mercurial.LOG.log(Level.INFO, null, hcf.getException());
            throw hcf.getException();
        }
        hcf.setProperty(section, name, value, allowEmpty);
    }

    public void setProperty(VCSFileProxy file, String section, String name, String value) throws IOException {
        HgConfigFiles hcf = this.getHgConfigFiles(file);
        if (hcf.getException() != null) {
            Mercurial.LOG.log(Level.WARNING, this.getClass().getName() + ": cannot set property {0}:{1} for {2}", new Object[]{name, value, file});
            Mercurial.LOG.log(Level.INFO, null, hcf.getException());
            throw hcf.getException();
        }
        hcf.setProperty(section, name, value);
    }

    public Properties getProperties(VCSFileProxy file, String section) {
        return this.getHgConfigFiles(file).getProperties(section);
    }

    public boolean getExludeNewFiles() {
        return this.getPreferences().getBoolean(PROP_EXCLUDE_NEW_FILES, false);
    }

    public void setExcludeNewFiles(boolean excludeNewFiles) {
        this.getPreferences().putBoolean(PROP_EXCLUDE_NEW_FILES, excludeNewFiles);
    }

    public int getDiffViewMode(int def) {
        return this.getPreferences().getInt(PROP_DIFF_VIEW_MODE, def);
    }

    public void setDiffViewMode(int value) {
        this.getPreferences().putInt(PROP_DIFF_VIEW_MODE, value);
    }

    public void putRecentCommitAuthors(String user) {
        Utils.insert((Preferences)this.getPreferences(), (String)PROP_RECENT_COMMIT_AUTHORS, (String)user, (int)10);
    }

    public List<String> getRecentCommitAuthors() {
        return Utils.getStringList((Preferences)this.getPreferences(), (String)PROP_RECENT_COMMIT_AUTHORS);
    }

    private HgConfigFiles getHgConfigFiles(VCSFileProxy file) {
        if (file == null) {
            return HgConfigFiles.getSysInstance(VCSFileProxy.createFileProxy((FileObject)this.fileSystem.getRoot()));
        }
        return new HgConfigFiles(file);
    }

    public String getAnnotationFormat() {
        return this.getPreferences().get(KEY_ANNOTATION_FORMAT, this.getDefaultAnnotationFormat());
    }

    public String getDefaultAnnotationFormat() {
        return "[{status} {folder}]";
    }

    public void setAnnotationFormat(String annotationFormat) {
        this.getPreferences().put(KEY_ANNOTATION_FORMAT, annotationFormat);
    }

    public boolean isInternalMergeToolEnabled() {
        return this.getPreferences().getBoolean(KEY_INTERNAL_MERGE_TOOL_ENABLED, true);
    }

    public void setInternalMergeToolEnabled(boolean enabled) {
        this.getPreferences().putBoolean(KEY_INTERNAL_MERGE_TOOL_ENABLED, enabled);
    }

    public boolean getSavePassword() {
        return this.getPreferences().getBoolean(SAVE_PASSWORD, true);
    }

    public void setSavePassword(boolean bl) {
        this.getPreferences().putBoolean(SAVE_PASSWORD, bl);
    }

    public void setShowCloneCompleted(boolean bl) {
        this.getPreferences().putBoolean(SHOW_CLONE_COMPLETED, bl);
    }

    public void insertRecentUrl(final RepositoryConnection rc) {
        Preferences prefs = this.getPreferences();
        for (String rcOldString : Utils.getStringList((Preferences)prefs, (String)RECENT_URL)) {
            RepositoryConnection rcOld;
            try {
                rcOld = RepositoryConnection.parse(rcOldString);
            }
            catch (URISyntaxException ex) {
                Mercurial.LOG.throwing(this.getClass().getName(), "insertRecentUrl", ex);
                continue;
            }
            if (!rcOld.equals(rc)) continue;
            Utils.removeFromArray((Preferences)prefs, (String)RECENT_URL, (String)rcOldString);
        }
        final char[] password = rc.getUrl().getPassword();
        if (password != null) {
            Runnable outOfAWT = new Runnable(){

                @Override
                public void run() {
                    KeyringSupport.save((String)"versioning.mercurial.url.", (String)rc.getUrl().toHgCommandStringWithNoPassword(), (char[])((char[])password.clone()), null);
                }
            };
            if (EventQueue.isDispatchThread()) {
                Mercurial.getInstance().getRequestProcessor().post(outOfAWT);
            } else {
                outOfAWT.run();
            }
        }
        Utils.insert((Preferences)prefs, (String)RECENT_URL, (String)RepositoryConnection.getString(rc), (int)-1);
    }

    public List<RepositoryConnection> getRecentUrls() {
        Preferences prefs = this.getPreferences();
        List urls = Utils.getStringList((Preferences)prefs, (String)RECENT_URL);
        ArrayList<RepositoryConnection> ret = new ArrayList<RepositoryConnection>(urls.size());
        LinkedList<RepositoryConnection> withPassword = new LinkedList<RepositoryConnection>();
        for (String urlString : urls) {
            try {
                RepositoryConnection conn = RepositoryConnection.parse(urlString);
                char[] password = conn.getUrl().getPassword();
                if (password != null) {
                    withPassword.add(conn);
                    continue;
                }
                ret.add(conn);
            }
            catch (URISyntaxException ex) {
                Mercurial.LOG.throwing(this.getClass().getName(), "getRecentUrls", ex);
            }
        }
        if (withPassword.size() > 0) {
            for (RepositoryConnection conn : withPassword) {
                this.insertRecentUrl(conn);
            }
            return this.getRecentUrls();
        }
        return ret;
    }

    public TableSorter getImportTableSorter() {
        return this.importTableSorter;
    }

    public void setImportTableSorter(TableSorter sorter) {
        this.importTableSorter = sorter;
    }

    public TableSorter getCommitTableSorter() {
        return this.commitTableSorter;
    }

    public void setCommitTableSorter(TableSorter sorter) {
        this.commitTableSorter = sorter;
    }

    public static void notifyParsingError() {
        NotifyDescriptor nd = new NotifyDescriptor((Object)NbBundle.getMessage(HgModuleConfig.class, (String)"MSG_ParsingError"), NbBundle.getMessage(HgModuleConfig.class, (String)"LBL_ParsingError"), -1, 0, new Object[]{NotifyDescriptor.OK_OPTION, NotifyDescriptor.CANCEL_OPTION}, NotifyDescriptor.OK_OPTION);
        if (EventQueue.isDispatchThread()) {
            DialogDisplayer.getDefault().notify(nd);
        } else {
            DialogDisplayer.getDefault().notifyLater(nd);
        }
    }

    public Color getColor(String colorName, Color defaultColor) {
        int colorRGB = this.getPreferences().getInt(colorName, defaultColor.getRGB());
        return new Color(colorRGB);
    }

    public void setColor(String colorName, Color value) {
        this.getPreferences().putInt(colorName, value.getRGB());
    }

    public String getLastCanceledCommitMessage(String key) {
        String lastCanceledCommitMessage = this.lastCanceledCommitMessages.get(key);
        return lastCanceledCommitMessage == null ? "" : lastCanceledCommitMessage;
    }

    public void setLastCanceledCommitMessage(String key, String message) {
        if (message == null || message.isEmpty()) {
            this.lastCanceledCommitMessages.remove(key);
        } else {
            this.lastCanceledCommitMessages.put(key, message);
        }
    }

    public String getLastUsedQPatchMessage(String patchName) {
        return this.getPreferences().get(KEY_QPATCH_MESSAGE + patchName, "");
    }

    public void setLastUsedQPatchMessage(String patchName, String message) {
        if (message == null) {
            this.getPreferences().remove(KEY_QPATCH_MESSAGE + patchName);
        } else {
            this.getPreferences().put(KEY_QPATCH_MESSAGE + patchName, message);
        }
    }

    public boolean isSearchOnBranchEnabled(String branchName) {
        return this.getPreferences().getBoolean(KEY_SEARCH_ON_BRANCH + branchName, true);
    }

    public void setSearchOnBranchEnabled(String branchName, boolean enabled) {
        this.getPreferences().putBoolean(KEY_SEARCH_ON_BRANCH + branchName, enabled);
    }

    public boolean isRemoveNewFilesOnRevertModifications() {
        return this.getPreferences().getBoolean(KEY_REMOVE_NEW_FILES_ON_REVERT, true);
    }

    public void setRemoveNewFilesOnRevertModifications(boolean flag) {
        this.getPreferences().putBoolean(KEY_REMOVE_NEW_FILES_ON_REVERT, flag);
    }

    synchronized Set<String> getCommitExclusions() {
        if (this.exclusions == null) {
            this.exclusions = new HashSet<String>(Utils.getStringList((Preferences)this.getPreferences(), (String)PROP_COMMIT_EXCLUSIONS));
        }
        return this.exclusions;
    }

    private static Pattern[] getDefaultFilePatterns() {
        return new Pattern[]{Pattern.compile("cvslog\\..*"), Pattern.compile("\\.make\\.state"), Pattern.compile("\\.nse_depinfo"), Pattern.compile(".*~"), Pattern.compile("#.*"), Pattern.compile("\\.#.*"), Pattern.compile(",.*"), Pattern.compile("_\\$.*"), Pattern.compile(".*\\$"), Pattern.compile(".*\\.old"), Pattern.compile(".*\\.bak"), Pattern.compile(".*\\.BAK"), Pattern.compile(".*\\.orig"), Pattern.compile(".*\\.rej"), Pattern.compile(".*\\.del-.*"), Pattern.compile(".*\\.a"), Pattern.compile(".*\\.olb"), Pattern.compile(".*\\.o"), Pattern.compile(".*\\.obj"), Pattern.compile(".*\\.so"), Pattern.compile(".*\\.exe"), Pattern.compile(".*\\.Z"), Pattern.compile(".*\\.elc"), Pattern.compile(".*\\.ln")};
    }
}

