/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.tag;

import org.netbeans.modules.mercurial.remote.HgException;
import org.netbeans.modules.mercurial.remote.HgProgressSupport;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.OutputLogger;
import org.netbeans.modules.mercurial.remote.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.remote.ui.tag.CreateTag;
import org.netbeans.modules.mercurial.remote.util.HgCommand;
import org.netbeans.modules.mercurial.remote.util.HgUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CreateTagAction
extends ContextAction {
    @Override
    protected boolean enable(Node[] nodes) {
        return HgUtils.isFromHgRepository(HgUtils.getCurrentContext(nodes));
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_CreateTag";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext ctx = HgUtils.getCurrentContext(nodes);
        VCSFileProxy[] roots = HgUtils.getActionRoots(ctx);
        if (roots == null || roots.length == 0) {
            return;
        }
        final VCSFileProxy repository = Mercurial.getInstance().getRepositoryRoot(roots[0]);
        CreateTag createTag = new CreateTag(repository);
        if (!createTag.showDialog()) {
            return;
        }
        final String tagName = createTag.getTagName();
        final String message = createTag.getMessage();
        final String revision = createTag.getRevision();
        final boolean local = createTag.isLocalTag();
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(repository);
        HgProgressSupport support = new HgProgressSupport(){

            @Override
            public void perform() {
                OutputLogger logger = this.getLogger();
                try {
                    logger.outputInRed(NbBundle.getMessage(CreateTagAction.class, (String)"MSG_CREATE_TITLE"));
                    logger.outputInRed(NbBundle.getMessage(CreateTagAction.class, (String)"MSG_CREATE_TITLE_SEP"));
                    logger.output(NbBundle.getMessage(CreateTagAction.class, (String)"MSG_CREATE_INFO_SEP", (Object)tagName, (Object)repository.getPath()));
                    HgCommand.createTag(repository, tagName, message, revision, local, logger);
                    if (!local) {
                        HgUtils.logHgLog(HgCommand.doTip(repository, logger), logger);
                    }
                }
                catch (HgException.HgCommandCanceledException hgCommandCanceledException) {
                }
                catch (HgException ex) {
                    HgUtils.notifyException(ex);
                }
                logger.outputInRed(NbBundle.getMessage(CreateTagAction.class, (String)"MSG_CREATE_DONE"));
                logger.output("");
            }
        };
        support.start(rp, repository, NbBundle.getMessage(CreateTagAction.class, (String)"MSG_CreateTag_Progress", (Object)tagName));
    }
}

