/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.netbeans.modules.maven.graph.ArtifactGraphEdge;
import org.netbeans.modules.maven.graph.ArtifactGraphNode;
import org.netbeans.modules.maven.graph.DependencyGraphScene;

class GraphConstructor
implements DependencyNodeVisitor {
    private DependencyGraphScene scene;
    private DependencyNode root;
    private Stack<DependencyNode> path;
    private Map<String, ArtifactGraphNode> cache;
    private List<ArtifactGraphEdge> edges;

    GraphConstructor(DependencyGraphScene scene) {
        this.scene = scene;
        this.path = new Stack();
        this.cache = new HashMap<String, ArtifactGraphNode>();
        this.edges = new ArrayList<ArtifactGraphEdge>();
    }

    public boolean visit(DependencyNode node) {
        if (this.root == null) {
            this.root = node;
        }
        boolean primary = false;
        ArtifactGraphNode grNode = this.cache.get(node.getArtifact().getDependencyConflictId());
        if (node.getState() == 0) {
            if (grNode == null) {
                grNode = new ArtifactGraphNode(node);
                this.cache.put(node.getArtifact().getDependencyConflictId(), grNode);
            } else {
                grNode.setArtifact(node);
            }
            grNode.setPrimaryLevel(this.path.size());
            primary = true;
        } else {
            if (grNode == null) {
                grNode = new ArtifactGraphNode(node);
                Artifact a = node.getState() == 2 ? node.getRelatedArtifact() : node.getArtifact();
                this.cache.put(a.getDependencyConflictId(), grNode);
            }
            grNode.addDuplicateOrConflict(node);
        }
        if (!this.path.empty()) {
            DependencyNode parent = this.path.peek();
            ArtifactGraphEdge ed = new ArtifactGraphEdge(parent, node);
            ed.setLevel(this.path.size() - 1);
            ed.setPrimaryPath(primary);
            this.edges.add(ed);
        }
        if (node != this.root && grNode.getArtifact() != null) {
            grNode.setManagedState(GraphConstructor.obtainManagedState(grNode.getArtifact().getArtifact(), this.scene));
        }
        this.path.push(node);
        return true;
    }

    public boolean endVisit(DependencyNode node) {
        this.path.pop();
        if (this.root == node) {
            ArtifactGraphNode rootNode = this.cache.get(node.getArtifact().getDependencyConflictId());
            this.scene.addNode(rootNode);
            for (ArtifactGraphNode nd : this.cache.values()) {
                if (nd == rootNode) continue;
                this.scene.addNode(nd);
            }
            for (ArtifactGraphEdge ed : this.edges) {
                this.scene.addEdge(ed);
                ArtifactGraphNode grNode = this.cache.get(ed.getTarget().getArtifact().getDependencyConflictId());
                if (grNode == null) {
                    grNode = this.cache.get(ed.getTarget().getRelatedArtifact().getDependencyConflictId());
                }
                this.scene.setEdgeTarget(ed, grNode);
                ArtifactGraphNode parentGrNode = this.cache.get(ed.getSource().getArtifact().getDependencyConflictId());
                this.scene.setEdgeSource(ed, parentGrNode);
            }
        }
        return true;
    }

    private static int obtainManagedState(Artifact artifact, DependencyGraphScene scene) {
        MavenProject proj = scene.getMavenProject();
        if (proj == null) {
            return 0;
        }
        DependencyManagement dm = proj.getDependencyManagement();
        if (dm == null) {
            return 0;
        }
        List deps = dm.getDependencies();
        if (deps == null) {
            return 0;
        }
        String id = artifact.getArtifactId();
        String groupId = artifact.getGroupId();
        String version = artifact.getVersion();
        for (Dependency dep : deps) {
            if (!id.equals(dep.getArtifactId()) || !groupId.equals(dep.getGroupId())) continue;
            if (!version.equals(dep.getVersion())) {
                return 2;
            }
            return 1;
        }
        return 0;
    }
}

