/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support;

import org.clank.support.Casts;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uint;
import org.clank.support.aliases.ushort;
import org.llvm.support.ConvertUTFStatics;

public final class ConvertUTFGlobals {
    public static ConversionResult ConvertUTF8toUTF16(type.ptr<char.ptr> sourceStart, char.ptr sourceEnd, type.ptr<ushort.ptr> targetStart, ushort.ptr targetEnd, ConversionFlags flags) {
        ConversionResult result = ConversionResult.conversionOK;
        char.ptr source = Native.$tryClone((char.ptr)((char.ptr)sourceStart.$star()));
        ushort.ptr target = (ushort.ptr)Native.$tryClone((NativeCloneable)((NativeCloneable)targetStart.$star()));
        while (source.$less((Object)sourceEnd)) {
            int ch = 0;
            char extraBytesToRead = (char)ConvertUTFStatics.trailingBytesForUTF8[Casts.$char((byte)source.$star())];
            if (extraBytesToRead >= sourceEnd.$sub((abstract_iterator)source)) {
                result = ConversionResult.sourceExhausted;
                break;
            }
            if (ConvertUTFStatics.isLegalUTF8(source, extraBytesToRead + '\u0001') == 0) {
                result = ConversionResult.sourceIllegal;
                break;
            }
            switch (extraBytesToRead) {
                case '\u0005': {
                    ch += source.$star();
                    source.$preInc();
                    ch <<= 6;
                }
                case '\u0004': {
                    ch += source.$star();
                    source.$preInc();
                    ch <<= 6;
                }
                case '\u0003': {
                    ch += source.$star();
                    source.$preInc();
                    ch <<= 6;
                }
                case '\u0002': {
                    ch += source.$star();
                    source.$preInc();
                    ch <<= 6;
                }
                case '\u0001': {
                    ch += source.$star();
                    source.$preInc();
                    ch <<= 6;
                }
                case '\u0000': {
                    ch += source.$star();
                    source.$preInc();
                }
            }
            ch -= ConvertUTFStatics.offsetsFromUTF8[extraBytesToRead];
            if (target.$greatereq((Object)targetEnd)) {
                source.$dec(extraBytesToRead + '\u0001');
                result = ConversionResult.targetExhausted;
                break;
            }
            if (ch <= 65535) {
                if (ch >= 55296 && ch <= 57343) {
                    if (flags == ConversionFlags.strictConversion) {
                        source.$dec(extraBytesToRead + '\u0001');
                        result = ConversionResult.sourceIllegal;
                        break;
                    }
                    target.$set('\ufffd');
                    target.$preInc();
                    continue;
                }
                target.$set((char)ch);
                target.$preInc();
                continue;
            }
            if (ch > 0x10FFFF) {
                if (flags == ConversionFlags.strictConversion) {
                    result = ConversionResult.sourceIllegal;
                    source.$dec(extraBytesToRead + '\u0001');
                    break;
                }
                target.$set('\ufffd');
                target.$preInc();
                continue;
            }
            if (((ushort.ptr)target.$add(1)).$greatereq((Object)targetEnd)) {
                source.$dec(extraBytesToRead + '\u0001');
                result = ConversionResult.targetExhausted;
                break;
            }
            target.$set((char)(((ch -= ConvertUTFStatics.halfBase) >>> ConvertUTFStatics.halfShift) + 55296));
            target.$preInc();
            target.$set((char)((ch & ConvertUTFStatics.halfMask) + 56320));
            target.$preInc();
        }
        sourceStart.$set((Object)Native.$tryClone((char.ptr)source));
        targetStart.$set((Object)Native.$tryClone((NativeCloneable)target));
        return result;
    }

    public static ConversionResult ConvertUTF8toUTF32(type.ptr<char.ptr> sourceStart, char.ptr sourceEnd, type.ptr<uint.ptr> targetStart, uint.ptr targetEnd, ConversionFlags flags) {
        ConversionResult result = ConversionResult.conversionOK;
        char.ptr source = Native.$tryClone((char.ptr)((char.ptr)sourceStart.$star()));
        uint.ptr target = (uint.ptr)Native.$tryClone((NativeCloneable)((NativeCloneable)targetStart.$star()));
        while (source.$less((Object)sourceEnd)) {
            int ch = 0;
            byte extraBytesToRead = ConvertUTFStatics.trailingBytesForUTF8[Casts.$char((byte)source.$star())];
            if (extraBytesToRead >= sourceEnd.$sub((abstract_iterator)source)) {
                result = ConversionResult.sourceExhausted;
                break;
            }
            if (ConvertUTFStatics.isLegalUTF8(source, extraBytesToRead + 1) == 0) {
                result = ConversionResult.sourceIllegal;
                break;
            }
            switch (extraBytesToRead) {
                case 5: {
                    ch += Casts.$char((byte)source.$star());
                    source.$preInc();
                    ch <<= 6;
                }
                case 4: {
                    ch += Casts.$char((byte)source.$star());
                    source.$preInc();
                    ch <<= 6;
                }
                case 3: {
                    ch += Casts.$char((byte)source.$star());
                    source.$preInc();
                    ch <<= 6;
                }
                case 2: {
                    ch += Casts.$char((byte)source.$star());
                    source.$preInc();
                    ch <<= 6;
                }
                case 1: {
                    ch += Casts.$char((byte)source.$star());
                    source.$preInc();
                    ch <<= 6;
                }
                case 0: {
                    ch += Casts.$char((byte)source.$star());
                    source.$preInc();
                }
            }
            ch -= ConvertUTFStatics.offsetsFromUTF8[extraBytesToRead];
            if (target.$greatereq((Object)targetEnd)) {
                source.$dec(extraBytesToRead + 1);
                result = ConversionResult.targetExhausted;
                break;
            }
            if (ch <= 0x10FFFF) {
                if (ch >= 55296 && ch <= 57343) {
                    if (flags == ConversionFlags.strictConversion) {
                        source.$dec(extraBytesToRead + 1);
                        result = ConversionResult.sourceIllegal;
                        break;
                    }
                    target.$set(65533);
                    target.$preInc();
                    continue;
                }
                target.$set(ch);
                target.$preInc();
                continue;
            }
            result = ConversionResult.sourceIllegal;
            target.$set(65533);
            target.$preInc();
        }
        sourceStart.$set((Object)Native.$tryClone((char.ptr)source));
        targetStart.$set((Object)Native.$tryClone((NativeCloneable)target));
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static ConversionResult ConvertUTF16toUTF8(type.ptr<ushort.ptr> sourceStart, ushort.ptr sourceEnd, type.ptr<char.ptr> targetStart, char.ptr targetEnd, ConversionFlags flags) {
        ConversionResult result = ConversionResult.conversionOK;
        ushort.ptr source = (ushort.ptr)Native.$tryClone((NativeCloneable)((NativeCloneable)sourceStart.$star()));
        char.ptr target = Native.$tryClone((char.ptr)((char.ptr)targetStart.$star()));
        while (source.$less((Object)sourceEnd)) {
            int ch;
            ushort.ptr oldSource;
            int byteMark;
            int byteMask;
            int bytesToWrite;
            block22: {
                block23: {
                    bytesToWrite = 0;
                    byteMask = 191;
                    byteMark = 128;
                    oldSource = (ushort.ptr)Native.$tryClone((NativeCloneable)source);
                    ch = Casts.$char((char)source.$star());
                    source.$preInc();
                    if (ch < 55296 || ch > 56319) break block23;
                    if (source.$less((Object)sourceEnd)) {
                        char ch2 = Casts.$char((char)source.$star());
                        if (ch2 >= '\udc00' && ch2 <= '\udfff') {
                            ch = (ch - 55296 << ConvertUTFStatics.halfShift) + (ch2 - 56320) + ConvertUTFStatics.halfBase;
                            source.$preInc();
                            break block22;
                        } else if (flags == ConversionFlags.strictConversion) {
                            source.$preDec();
                            result = ConversionResult.sourceIllegal;
                            break;
                        }
                        break block22;
                    } else {
                        source.$preDec();
                        result = ConversionResult.sourceExhausted;
                        break;
                    }
                }
                if (flags == ConversionFlags.strictConversion && ch >= 56320 && ch <= 57343) {
                    source.$preDec();
                    result = ConversionResult.sourceIllegal;
                    break;
                }
            }
            if (ch < 128) {
                bytesToWrite = 1;
            } else if (ch < 2048) {
                bytesToWrite = 2;
            } else if (ch < 65536) {
                bytesToWrite = 3;
            } else if (ch < 0x110000) {
                bytesToWrite = 4;
            } else {
                bytesToWrite = 3;
                ch = 65533;
            }
            target.$inc(bytesToWrite);
            if (target.$greater((Object)targetEnd)) {
                source = (ushort.ptr)Native.$tryClone((NativeCloneable)oldSource);
                target.$dec(bytesToWrite);
                result = ConversionResult.targetExhausted;
                break;
            }
            switch (bytesToWrite) {
                case 4: {
                    ((char.ptr)target.$preDec()).$set((byte)((ch | byteMark) & byteMask));
                    ch >>>= 6;
                }
                case 3: {
                    ((char.ptr)target.$preDec()).$set((byte)((ch | byteMark) & byteMask));
                    ch >>>= 6;
                }
                case 2: {
                    ((char.ptr)target.$preDec()).$set((byte)((ch | byteMark) & byteMask));
                    ch >>>= 6;
                }
                case 1: {
                    ((char.ptr)target.$preDec()).$set((byte)(ch | ConvertUTFStatics.firstByteMark[bytesToWrite]));
                    break;
                }
            }
            target.$inc(bytesToWrite);
        }
        sourceStart.$set((Object)Native.$tryClone((NativeCloneable)source));
        targetStart.$set((Object)Native.$tryClone((char.ptr)target));
        return result;
    }

    public static ConversionResult ConvertUTF32toUTF8(type.ptr<uint.ptr> sourceStart, uint.ptr sourceEnd, type.ptr<char.ptr> targetStart, char.ptr targetEnd, ConversionFlags flags) {
        ConversionResult result = ConversionResult.conversionOK;
        uint.ptr source = (uint.ptr)Native.$tryClone((NativeCloneable)((NativeCloneable)sourceStart.$star()));
        char.ptr target = Native.$tryClone((char.ptr)((char.ptr)targetStart.$star()));
        while (source.$less((Object)sourceEnd)) {
            int bytesToWrite = 0;
            int byteMask = 191;
            int byteMark = 128;
            int ch = Casts.$char((int)source.$star());
            source.$preInc();
            if (flags == ConversionFlags.strictConversion && ch >= 55296 && ch <= 57343) {
                source.$preDec();
                result = ConversionResult.sourceIllegal;
                break;
            }
            if (ch < 128) {
                bytesToWrite = 1;
            } else if (ch < 2048) {
                bytesToWrite = 2;
            } else if (ch < 65536) {
                bytesToWrite = 3;
            } else if (ch <= 0x10FFFF) {
                bytesToWrite = 4;
            } else {
                bytesToWrite = 3;
                ch = 65533;
                result = ConversionResult.sourceIllegal;
            }
            target.$inc(bytesToWrite);
            if (target.$greater((Object)targetEnd)) {
                source.$preDec();
                target.$dec(bytesToWrite);
                result = ConversionResult.targetExhausted;
                break;
            }
            switch (bytesToWrite) {
                case 4: {
                    ((char.ptr)target.$preDec()).$set((byte)((ch | byteMark) & byteMask));
                    ch >>>= 6;
                }
                case 3: {
                    ((char.ptr)target.$preDec()).$set((byte)((ch | byteMark) & byteMask));
                    ch >>>= 6;
                }
                case 2: {
                    ((char.ptr)target.$preDec()).$set((byte)((ch | byteMark) & byteMask));
                    ch >>>= 6;
                }
                case 1: {
                    ((char.ptr)target.$preDec()).$set((byte)(ch | ConvertUTFStatics.firstByteMark[bytesToWrite]));
                }
            }
            target.$inc(bytesToWrite);
        }
        sourceStart.$set((Object)Native.$tryClone((NativeCloneable)source));
        targetStart.$set((Object)Native.$tryClone((char.ptr)target));
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static ConversionResult ConvertUTF16toUTF32(type.ptr<ushort.ptr> sourceStart, ushort.ptr sourceEnd, type.ptr<uint.ptr> targetStart, uint.ptr targetEnd, ConversionFlags flags) {
        ConversionResult result = ConversionResult.conversionOK;
        ushort.ptr source = (ushort.ptr)Native.$tryClone((NativeCloneable)((NativeCloneable)sourceStart.$star()));
        uint.ptr target = (uint.ptr)Native.$tryClone((NativeCloneable)((NativeCloneable)targetStart.$star()));
        while (source.$less((Object)sourceEnd)) {
            int ch;
            ushort.ptr oldSource;
            block8: {
                block9: {
                    oldSource = (ushort.ptr)Native.$tryClone((NativeCloneable)source);
                    ch = Casts.$char((char)source.$star());
                    source.$preInc();
                    if (ch < 55296 || ch > 56319) break block9;
                    if (source.$less((Object)sourceEnd)) {
                        char ch2 = Casts.$char((char)source.$star());
                        if (ch2 >= '\udc00' && ch2 <= '\udfff') {
                            ch = (ch - 55296 << ConvertUTFStatics.halfShift) + (ch2 - 56320) + ConvertUTFStatics.halfBase;
                            source.$preInc();
                            break block8;
                        } else if (flags == ConversionFlags.strictConversion) {
                            source.$preDec();
                            result = ConversionResult.sourceIllegal;
                            break;
                        }
                        break block8;
                    } else {
                        source.$preDec();
                        result = ConversionResult.sourceExhausted;
                        break;
                    }
                }
                if (flags == ConversionFlags.strictConversion && ch >= 56320 && ch <= 57343) {
                    source.$preDec();
                    result = ConversionResult.sourceIllegal;
                    break;
                }
            }
            if (target.$greatereq((Object)targetEnd)) {
                source = (ushort.ptr)Native.$tryClone((NativeCloneable)oldSource);
                result = ConversionResult.targetExhausted;
                break;
            }
            target.$set(ch);
            target.$preInc();
        }
        sourceStart.$set((Object)Native.$tryClone((NativeCloneable)source));
        targetStart.$set((Object)Native.$tryClone((NativeCloneable)target));
        return result;
    }

    public static ConversionResult ConvertUTF32toUTF16(type.ptr<uint.ptr> sourceStart, uint.ptr sourceEnd, type.ptr<ushort.ptr> targetStart, ushort.ptr targetEnd, ConversionFlags flags) {
        ConversionResult result = ConversionResult.conversionOK;
        uint.ptr source = (uint.ptr)Native.$tryClone((NativeCloneable)((NativeCloneable)sourceStart.$star()));
        ushort.ptr target = (ushort.ptr)Native.$tryClone((NativeCloneable)((NativeCloneable)targetStart.$star()));
        while (source.$less((Object)sourceEnd)) {
            if (target.$greatereq((Object)targetEnd)) {
                result = ConversionResult.targetExhausted;
                break;
            }
            int ch = Casts.$char((int)source.$star());
            source.$preInc();
            if (ch <= 65535) {
                if (ch >= 55296 && ch <= 57343) {
                    if (flags == ConversionFlags.strictConversion) {
                        source.$preDec();
                        result = ConversionResult.sourceIllegal;
                        break;
                    }
                    target.$set('\ufffd');
                    target.$preInc();
                    continue;
                }
                target.$set((char)ch);
                target.$preInc();
                continue;
            }
            if (ch > 0x10FFFF) {
                if (flags == ConversionFlags.strictConversion) {
                    result = ConversionResult.sourceIllegal;
                    continue;
                }
                target.$set('\ufffd');
                target.$preInc();
                continue;
            }
            if (((ushort.ptr)target.$add(1)).$greatereq((Object)targetEnd)) {
                source.$preDec();
                result = ConversionResult.targetExhausted;
                break;
            }
            target.$set((char)(((ch -= ConvertUTFStatics.halfBase) >>> ConvertUTFStatics.halfShift) + 55296));
            target.$preInc();
            target.$set((char)((ch & ConvertUTFStatics.halfMask) + 56320));
            target.$preInc();
        }
        sourceStart.$set((Object)Native.$tryClone((NativeCloneable)source));
        targetStart.$set((Object)Native.$tryClone((NativeCloneable)target));
        return result;
    }

    public static short isLegalUTF8Sequence(char.ptr source, char.ptr sourceEnd) {
        int length = ConvertUTFStatics.trailingBytesForUTF8[Casts.$char((byte)source.$star())] + 1;
        if (length > sourceEnd.$sub((abstract_iterator)source)) {
            return 0;
        }
        return ConvertUTFStatics.isLegalUTF8(source, length);
    }

    public static short isLegalUTF8String(type.ptr<char.ptr> source, char.ptr sourceEnd) {
        while (((char.ptr)source.$star()).$noteq((Object)sourceEnd)) {
            int length = ConvertUTFStatics.trailingBytesForUTF8[Casts.$char((byte)((char.ptr)source.$star()).$star())] + 1;
            if (length > sourceEnd.$sub((abstract_iterator)source.$star()) || ConvertUTFStatics.isLegalUTF8((char.ptr)source.$star(), length) == 0) {
                return 0;
            }
            ((char.ptr)source.$star()).$inc(length);
        }
        return 1;
    }

    public static int getNumBytesForUTF8(byte first) {
        return ConvertUTFStatics.trailingBytesForUTF8[Casts.$char((byte)first)] + 1;
    }

    public static final class ConversionResult
    extends Enum<ConversionResult> {
        public static final /* enum */ ConversionResult conversionOK = new ConversionResult(0);
        public static final /* enum */ ConversionResult sourceExhausted = new ConversionResult(1);
        public static final /* enum */ ConversionResult targetExhausted = new ConversionResult(2);
        public static final /* enum */ ConversionResult sourceIllegal = new ConversionResult(3);
        private final int value;
        private static final /* synthetic */ ConversionResult[] $VALUES;

        public static ConversionResult[] values() {
            return (ConversionResult[])$VALUES.clone();
        }

        public static ConversionResult valueOf(String name) {
            return Enum.valueOf(ConversionResult.class, name);
        }

        public static ConversionResult valueOf(int val) {
            ConversionResult out;
            ConversionResult conversionResult = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private ConversionResult(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new ConversionResult[]{conversionOK, sourceExhausted, targetExhausted, sourceIllegal};
        }

        private static final class Values {
            private static final ConversionResult[] VALUES;
            private static final ConversionResult[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (ConversionResult kind : ConversionResult.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new ConversionResult[min < 0 ? 1 - min : 0];
                VALUES = new ConversionResult[max >= 0 ? 1 + max : 0];
                for (ConversionResult kind : ConversionResult.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((ConversionResult)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((ConversionResult)kind).value] = kind;
                }
            }
        }
    }

    public static final class ConversionFlags
    extends Enum<ConversionFlags> {
        public static final /* enum */ ConversionFlags strictConversion = new ConversionFlags(0);
        public static final /* enum */ ConversionFlags lenientConversion = new ConversionFlags(1);
        private final int value;
        private static final /* synthetic */ ConversionFlags[] $VALUES;

        public static ConversionFlags[] values() {
            return (ConversionFlags[])$VALUES.clone();
        }

        public static ConversionFlags valueOf(String name) {
            return Enum.valueOf(ConversionFlags.class, name);
        }

        public static ConversionFlags valueOf(int val) {
            ConversionFlags out;
            ConversionFlags conversionFlags = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private ConversionFlags(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new ConversionFlags[]{strictConversion, lenientConversion};
        }

        private static final class Values {
            private static final ConversionFlags[] VALUES;
            private static final ConversionFlags[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (ConversionFlags kind : ConversionFlags.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new ConversionFlags[min < 0 ? 1 - min : 0];
                VALUES = new ConversionFlags[max >= 0 ? 1 + max : 0];
                for (ConversionFlags kind : ConversionFlags.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((ConversionFlags)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((ConversionFlags)kind).value] = kind;
                }
            }
        }
    }
}

