/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.ir.ExportClauseNode;
import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.FromNode;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.VarNode;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import com.oracle.js.parser.ir.visitor.TranslatorNodeVisitor;

public class ExportNode
extends Node {
    private final ExportClauseNode exportClause;
    private final FromNode from;
    private final VarNode var;
    private final Expression expression;
    private final boolean isDefault;

    public ExportNode(long token, int start, int finish, ExportClauseNode exportClause) {
        this(token, start, finish, exportClause, null, null, null, false);
    }

    public ExportNode(long token, int start, int finish, FromNode from) {
        this(token, start, finish, null, from, null, null, false);
    }

    public ExportNode(long token, int start, int finish, ExportClauseNode exportClause, FromNode from) {
        this(token, start, finish, exportClause, from, null, null, false);
    }

    public ExportNode(long token, int start, int finish, Expression expression, boolean isDefault) {
        this(token, start, finish, null, null, null, expression, isDefault);
    }

    public ExportNode(long token, int start, int finish, VarNode var) {
        this(token, start, finish, null, null, var, null, false);
    }

    private ExportNode(long token, int start, int finish, ExportClauseNode exportClause, FromNode from, VarNode var, Expression expression, boolean isDefault) {
        super(token, start, finish);
        this.exportClause = exportClause;
        this.from = from;
        this.var = var;
        this.expression = expression;
        this.isDefault = isDefault;
    }

    private ExportNode(ExportNode node, ExportClauseNode exportClause, FromNode from, VarNode var, Expression expression) {
        super(node);
        this.isDefault = node.isDefault;
        this.exportClause = exportClause;
        this.from = from;
        this.var = var;
        this.expression = expression;
    }

    public ExportClauseNode getExportClause() {
        return this.exportClause;
    }

    public FromNode getFrom() {
        return this.from;
    }

    public VarNode getVar() {
        return this.var;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public ExportNode setExportClause(ExportClauseNode exportClause) {
        if (this.exportClause == exportClause) {
            return this;
        }
        return new ExportNode(this, exportClause, this.from, this.var, this.expression);
    }

    public ExportNode setFrom(FromNode from) {
        if (this.from == from) {
            return this;
        }
        return new ExportNode(this, this.exportClause, from, this.var, this.expression);
    }

    public ExportNode setVar(VarNode var) {
        if (this.var == var) {
            return this;
        }
        return new ExportNode(this, this.exportClause, this.from, var, this.expression);
    }

    public ExportNode setExpression(Expression expression) {
        if (this.expression == expression) {
            return this;
        }
        return new ExportNode(this, this.exportClause, this.from, this.var, expression);
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> visitor) {
        if (visitor.enterExportNode(this)) {
            ExportClauseNode newExportClause = this.exportClause == null ? null : (ExportClauseNode)this.exportClause.accept(visitor);
            FromNode newFrom = this.from == null ? null : (FromNode)this.from.accept(visitor);
            VarNode newVar = this.var == null ? null : (VarNode)this.var.accept(visitor);
            Expression newExpression = this.expression == null ? null : (Expression)this.expression.accept(visitor);
            return visitor.leaveExportNode(this.setExportClause(newExportClause).setFrom(newFrom).setVar(newVar).setExpression(newExpression));
        }
        return this;
    }

    @Override
    public <R> R accept(TranslatorNodeVisitor<? extends LexicalContext, R> visitor) {
        return visitor.enterExportNode(this);
    }

    @Override
    public void toString(StringBuilder sb, boolean printType) {
        sb.append("export ");
        if (this.isDefault) {
            sb.append("default ");
        }
        if (this.expression != null) {
            this.expression.toString(sb, printType);
            if (this.expression.isAssignment()) {
                sb.append(';');
            }
        } else {
            if (this.exportClause == null) {
                sb.append("* ");
            } else {
                this.exportClause.toString(sb, printType);
            }
            if (this.from != null) {
                this.from.toString(sb, printType);
            }
            sb.append(';');
        }
    }
}

